/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.core;

import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.core.SpreadViewUI;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class OutlineGroupColHeaderUI
extends SpreadViewUI {
    private static OutlineGroupColHeaderUI outlineGroupColHeaderUI = new OutlineGroupColHeaderUI();
    private SpreadView _view;
    private Graphics2D _g2d;
    private Sheet _sheet;
    private int _sizeOfCols;
    private SpreadView.ColBuffer[] _cbs;
    private int _cinx;
    private int _cinx2;

    public static ComponentUI createUI(JComponent c) {
        return outlineGroupColHeaderUI;
    }

    @Override
    protected void installDefaults(SpreadView view) {
        view.setAutoscrolls(true);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return OutlineGroupColHeaderUI.getSize((SpreadView)c);
    }

    public static Dimension getSize(SpreadView view) {
        int h;
        Book book = view.getSpread().getBook();
        boolean isShowInlined = false;
        UserObject uo = book.getUserObject("SHOW_TREE_GROUP");
        if (uo != null) {
            isShowInlined = Boolean.parseBoolean(uo.getValue().toString());
        }
        Sheet sheet = book.getActiveSheet();
        if (!isShowInlined && sheet.getUserObject("ROW_INLINED_TREE_POSITION") != null) {
            return new Dimension(0, 0);
        }
        SortedAttributeSpanArray sasa = view.getSpread().getBook().getActiveSheet().getColSpans();
        int depth = 0;
        for (int i = 0; i < sasa.size(); ++i) {
            int level = ((SortedAttributeSpanArray.AttributeSpan)sasa.get(i)).getOutlineGroupLevel();
            depth = level > depth ? level : depth;
        }
        int n = h = depth == 0 ? 0 : (depth + 1) * 15 + 8;
        if (h == 0) {
            return null;
        }
        return new Dimension(view.getPreferredWidth(), h);
    }

    @Override
    protected boolean prePaint(Graphics2D g, SpreadView view) {
        int i;
        this._g2d = g;
        this._view = view;
        this._sheet = view.getSpread().getBook().getActiveSheet();
        Rectangle clip = this._g2d.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int cCol = SheetBaseMath.colAtPoint(this._sheet, upperLeft);
        int cCol2 = SheetBaseMath.colAtPoint(this._sheet, lowerRight);
        if (cCol < 0) {
            return false;
        }
        cCol2 = SheetBaseMath.dealInvalidCol(cCol2);
        this._cbs = this._view.getColBuffers(cCol, cCol2);
        if (this._cbs == null) {
            return false;
        }
        this._sizeOfCols = this._cbs.length;
        for (i = 0; i < this._sizeOfCols; ++i) {
            if (cCol > this._cbs[i].getCol()) continue;
            this._cinx = i;
            break;
        }
        for (i = this._sizeOfCols - 1; i >= 0; --i) {
            if (cCol2 < this._cbs[i].getCol()) continue;
            this._cinx2 = i;
            break;
        }
        return true;
    }

    @Override
    protected void paintBase(Graphics2D g, SpreadView view) {
    }

    @Override
    protected void afterPaint(Graphics2D g, SpreadView view) {
        view.setPreferredSize(OutlineGroupColHeaderUI.getSize(view));
        this._view = null;
        this._g2d = null;
        this._cbs = null;
        this._sheet = null;
    }
}

