/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.ThreadLocalUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropsArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtGroup;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtGroupTreeNode;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtRow;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellPropAction;
import com.kingdee.cosmic.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetAction_InsDel;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;
import com.kingdee.cosmic.ctrl.kds.model.struct.ViewSplitInfo;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExtProps
extends ExtConst
implements Cloneable {
    private Cell _cell;
    private ExtProps _yHead;
    private ExtProps _xHead;
    private ExtProps _source = this;
    private SortedExtPropFormulasArray _formulas;
    private ExtGroup _group;
    private ExtRow _row;
    private int _extensible;
    private int _height;
    private int _width;
    private SortedExtPropsArray _exts;
    private SortedExtPropsArray _subs;
    private CellBlock _subsBound;
    private boolean _isReportingGroupRootCell;

    public ExtProps(Cell cell) {
        this._cell = cell;
        this._extensible = -1;
    }

    public Object clone() {
        ExtProps ep = null;
        try {
            ep = (ExtProps)super.clone();
            ep._subs = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return ep;
    }

    public void calcExtendProps() {
        CellBlock merge = this._cell.getMerge(false);
        if (merge != null) {
            this._height = merge.getHeight() - 1;
            this._width = merge.getWidth() - 1;
        }
        this.getHead(true, true);
        this.getHead(false, true);
        this.getExtensible(true);
    }

    public void clearSubs() {
        if (this._subs != null) {
            this._subs.clear();
        }
    }

    public ExtGroup getGroup() {
        return this._group;
    }

    public void setGroup(ExtGroup group) {
        this._group = group;
    }

    public ExtRow getExtRow() {
        return this._row;
    }

    public void setExtRow(ExtRow row) {
        this._row = row;
    }

    public SortedExtPropFormulasArray getFormulas(boolean create) {
        if (this._formulas == null && create) {
            this._formulas = new SortedExtPropFormulasArray(this.getSheet(), this._cell);
        }
        return this._formulas;
    }

    public void setFormulas(SortedExtPropFormulasArray formulas) {
        this._formulas = formulas;
    }

    public String getFormula(CellPropAction action) {
        ICalculableProps prop;
        if (this._cell != null && this._formulas != null && (prop = this._formulas.get(action)) != null) {
            return prop.getFormula(this._cell.getSheet().getDeps().getExprContext(), this._cell);
        }
        return "";
    }

    public void removeFormula(CellPropAction action) {
        if (this._formulas != null && this._formulas.remove(action) != null && this._formulas.isEmpty()) {
            this._formulas = null;
        }
    }

    public String toString() {
        String str;
        if (this._cell == null) {
            str = this._extensible == 2 ? "LEFT00" : "TOP00";
        } else {
            StringBuilder sb = new StringBuilder(this._cell.toString());
            switch (this._extensible) {
                case 2: {
                    sb.append(" V ");
                    break;
                }
                case 1: {
                    sb.append(" H ");
                    break;
                }
                case 0: {
                    sb.append(" N ");
                    break;
                }
                default: {
                    sb.append(" U ");
                }
            }
            sb.append(this._height);
            sb.append(' ');
            sb.append(this._width);
            str = sb.toString();
        }
        return str;
    }

    public Cell getCell() {
        return this._cell;
    }

    public void setCell(Cell cll) {
        this._cell = cll;
    }

    public Sheet getSheet() {
        return this._cell.getSheet();
    }

    public int getRC(boolean isRow) {
        return isRow ? this.getRow() : this.getCol();
    }

    public int getRow() {
        return this._cell == null ? 0 : this._cell.getRow();
    }

    public int getRow2() {
        return this._cell == null ? -1 : this._cell.getRow() + this._height;
    }

    public int getCol() {
        return this._cell == null ? 0 : this._cell.getCol();
    }

    public int getCol2() {
        return this._cell == null ? -1 : this._cell.getCol() + this._width;
    }

    public ExtProps getSource() {
        return this._source;
    }

    public void setSource(ExtProps src) {
        this._source = src;
    }

    public CellBlock getSubsBound() {
        if (this._subsBound == null) {
            this._subsBound = this.calcSubsBound(null);
        }
        return this._subsBound;
    }

    private CellBlock calcSubsBound(CellBlock bd) {
        int row = this.getRow();
        int col = this.getCol();
        if (bd == null) {
            bd = CellBlock.getCellBlock(row, col, row + this._height, col + this._width);
        } else {
            if (row < bd.getRow()) {
                bd.setRow(row);
            }
            if (row + this._height > bd.getRow2()) {
                bd.setRow2(row + this._height);
            }
            if (col < bd.getCol()) {
                bd.setCol(col);
            }
            if (col + this._width > bd.getCol2()) {
                bd.setCol2(col + this._width);
            }
        }
        if (this._subs != null) {
            for (int i = this._subs.size() - 1; i >= 0; --i) {
                ExtProps sub = (ExtProps)this._subs.get(i);
                sub.calcSubsBound(bd);
            }
        }
        return bd;
    }

    public int getExtIndex() {
        return this._exts == null ? 0 : this._exts.searchRowCol(this.getRow(), this.getCol());
    }

    public SortedExtPropsArray getExts() {
        return this._exts;
    }

    public void linkHead(boolean isLeft) {
        ExtProps head;
        ExtProps extProps = head = isLeft ? this._yHead : this._xHead;
        if (head != null) {
            head.addSub(this);
        }
    }

    public ExtProps getHead(boolean yDir, boolean calc) {
        SortedCellBlockArray blocks;
        MergeBlocks merge;
        ExtProps head;
        ExtProps extProps = head = yDir ? this._yHead : this._xHead;
        if (head != null || !calc) {
            return head;
        }
        if (this._cell == null) {
            return null;
        }
        int row = this._cell.getRow();
        int col = this._cell.getCol();
        Sheet sheet = this._cell.getSheet();
        boolean follow = false;
        Sheet.ICellsIterator ci = yDir ? this._cell.getRowObject().getCellsIterator(0, col - 1, true, false) : sheet.getCellsIterator(0, col, row - 1, col, true, false);
        while (ci.hasNext()) {
            ExtProps prev;
            CellBlock cb;
            Cell prevCell = ci.next();
            if (!prevCell.isFirstMergedCell() && (cb = sheet.getMergeBlock(prevCell)) != null) {
                prevCell = sheet.getFirstCell(cb, false);
            }
            if ((prev = prevCell.getExtProps(false)) == null) continue;
            boolean prevCanExtend = false;
            if (prevCell.hasFormula()) {
                prevCanExtend = prevCell.getExpr().isExtensible();
            }
            if (prevCanExtend && (yDir ? prev.containRow(this) : prev.containCol(this)) && prev.getExtensible(true) == (yDir ? 2 : 1)) {
                if (this.isHeadOf(prev, yDir)) continue;
                head = prev;
                break;
            }
            ExtProps headOfPrev = yDir ? prev._yHead : prev._xHead;
            if (headOfPrev == null || headOfPrev.isCell00() || this.isHeadOf(headOfPrev, yDir)) continue;
            follow = true;
            head = headOfPrev;
            Expr headExpr = head.getCell().getExpr();
            if (headExpr == null || !headExpr.isExtensible()) break;
            follow = false;
            break;
        }
        if ((head == null || follow) && (merge = sheet.getMerger(false)) != null && (blocks = yDir ? merge.getTouchedBlocks(row, 0, row, col - 1) : merge.getTouchedBlocks(0, col, row - 1, col)) != null) {
            for (int i = blocks.size() - 1; i >= 0; --i) {
                ExtProps headOfPrev;
                ExtProps prev;
                CellBlock cb = blocks.getBlock(i);
                if (head != null && !follow || !(yDir ? cb.containsRow(row) : cb.containsCol(col)) || (!yDir ? cb.containsRow(row) : cb.containsCol(col)) || (prev = sheet.getCell(cb.getRow(), cb.getCol(), false).getExtProps(false)) == null) continue;
                boolean prevCanExtend = false;
                Cell prevCell = prev.getCell();
                if (prevCell.hasFormula()) {
                    prevCanExtend = prevCell.getExpr().isExtensible();
                }
                if (prevCanExtend && prev.getExtensible(true) == (yDir ? 2 : 1)) {
                    head = prev;
                    break;
                }
                ExtProps extProps2 = headOfPrev = yDir ? prev._yHead : prev._xHead;
                if (headOfPrev == null || this.isHeadOf(headOfPrev, yDir)) continue;
                head = headOfPrev;
                break;
            }
        }
        if (calc) {
            this.setHead(head, yDir);
            return yDir ? this._yHead : this._xHead;
        }
        return head;
    }

    public void setHead(String headStr, boolean yDir) {
        ExtProps head = null;
        if (!StringUtil.isEmptyString((String)headStr)) {
            IExprNode node;
            Cell cll;
            Sheet sheet = this.getSheet();
            Expr expr = sheet.getExpr(cll = this.getCell(), headStr);
            if (expr.isSingleCell()) {
                CellBlockNode node2 = (CellBlockNode)expr.getExprParams().getNodes()[0];
                head = node2.getFirstCell(true).getExtProps(true);
            } else if (expr.isNamedObject() && (node = expr.getExprParams().getNodes()[0]) == NamedObjectNode.Null) {
                head = yDir ? sheet.LEFT00 : sheet.TOP00;
            }
        }
        this.setHead(head, yDir);
    }

    public boolean setHead(ExtProps head, boolean yDir) {
        if (head == null) {
            Sheet sheet = this.getSheet();
            ExtProps extProps = head = yDir ? sheet.LEFT00 : sheet.TOP00;
        }
        if (this.isHeadOf(head, yDir)) {
            return false;
        }
        if (yDir) {
            this._yHead = head;
        } else {
            this._xHead = head;
        }
        head.addSub(this);
        return true;
    }

    public void clearHead(boolean yDir) {
        ExtProps head;
        ExtProps extProps = head = yDir ? this._yHead : this._xHead;
        if (head != null) {
            SortedExtPropsArray subs = head.getSubs();
            subs.remove(this);
        }
        if (yDir) {
            this._yHead = null;
        } else {
            this._xHead = null;
        }
    }

    public ExtProps getFarthestHead(boolean yDir, int[] level) {
        ExtProps sub = this;
        ExtProps head = this;
        int i = 0;
        while (head != null) {
            if (head.isCell00()) {
                level[0] = i;
                return sub;
            }
            sub = head;
            head = sub.getHead(yDir, false);
            ++i;
        }
        return head;
    }

    private void addSub(ExtProps sub) {
        if (this._subs == null) {
            this._subs = new SortedExtPropsArray();
        }
        this._subs.insert(sub);
        this._subsBound = null;
    }

    public int getHeight() {
        return this._height;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public int getWidth() {
        return this._width;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public boolean isExtensible() {
        int ext = this.getExtensible(true);
        return ext == 1 || ext == 2;
    }

    public int getExtensible(boolean calc) {
        if (this._extensible == -1 && calc) {
            ExtProps leftHead = this.getHead(true, true);
            ExtProps topHead = this.getHead(false, true);
            Sheet sheet = this.getSheet();
            int extensible = 2;
            if (leftHead == sheet.LEFT00) {
                if (topHead != sheet.TOP00) {
                    extensible = 1;
                }
            } else if (topHead != sheet.TOP00) {
                extensible = 0;
            }
            this._extensible = extensible;
        }
        return this._extensible;
    }

    public void setExtensible(int extensible) {
        switch (extensible) {
            case 0: 
            case 1: 
            case 2: {
                this._extensible = extensible;
                break;
            }
            default: {
                this._extensible = -1;
            }
        }
    }

    public SortedExtPropsArray getSubs() {
        return this._subs;
    }

    public ExtProps getSubBySource(ExtProps source, boolean yDir) {
        ExtProps src = source._source;
        if (this._source == src) {
            return this;
        }
        if (this._subs != null) {
            if (yDir) {
                int srcCol = source.getCol();
                ExtProps sub = this._subs.getSubBySourceCol(src, this.getRow(), srcCol);
                if (sub != null) {
                    return sub;
                }
                int size = this._subs.size();
                for (int i = 0; i < size; ++i) {
                    sub = (ExtProps)this._subs.get(i);
                    if (sub._source != src || sub.getCol() != srcCol) continue;
                    return sub;
                }
            } else {
                return this._subs.getSubBySourceRow(src, source.getRow());
            }
        }
        return null;
    }

    public ExtProps getHeadBySource(ExtProps src, boolean yDir) {
        for (ExtProps head = this; head != null; head = head.getHead(yDir, false)) {
            if (head.getSource() != src) continue;
            return head;
        }
        return null;
    }

    public int getHeadIndex(ExtProps dstHead, boolean yDir) {
        ExtProps head;
        ExtProps sub = head = this.getHead(yDir, false);
        while (head != null && !head.isCell00()) {
            if (head.getSource() == dstHead) {
                return head.getExtIndex();
            }
            sub = head = sub.getHead(yDir, false);
        }
        return -1;
    }

    public boolean isCell00() {
        return this._cell == null;
    }

    public boolean containRow(ExtProps sub) {
        int subRow;
        int row = this.getRow();
        if (row <= (subRow = sub.getRow())) {
            return row + this._height >= subRow + sub._height;
        }
        return false;
    }

    public boolean containCol(ExtProps sub) {
        int subCol;
        int col = this.getCol();
        if (col <= (subCol = sub.getCol())) {
            return col + this._width >= subCol + sub._width;
        }
        return false;
    }

    public boolean isHeadOf(ExtProps sub, boolean yDir) {
        while (sub != null) {
            if (this == sub) {
                return true;
            }
            sub = yDir ? sub._yHead : sub._xHead;
        }
        return false;
    }

    public int headLevelOf(ExtProps sub, boolean yDir) {
        int level = 0;
        while (sub != null) {
            if (this == sub) {
                return level;
            }
            sub = yDir ? sub._yHead : sub._xHead;
            ++level;
        }
        return -1;
    }

    public ExtProps getLevelHead(boolean yDir, int level) {
        ExtProps head = this;
        for (int i = 0; i < level; ++i) {
            head = yDir ? head._yHead : head._xHead;
        }
        return head;
    }

    public ExtProps getKinHead(ExtProps sub, boolean yDir) {
        ExtProps head;
        for (head = this; head != null && !head.isHeadOf(sub, yDir); head = head.getHead(yDir, false)) {
        }
        return head;
    }

    public CellBlock getRelaPos(ExtProps epDst) {
        CellBlock pos = CellBlock.getCellBlock(Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.getRelaPos(epDst, true, pos);
        this.getRelaPos(epDst, false, pos);
        return pos;
    }

    private void getRelaPos(ExtProps dst, boolean yDir, CellBlock pos) {
        boolean hit = false;
        int level = 0;
        int level2 = this.headLevelOf(dst, yDir);
        if (level2 >= 0) {
            hit = true;
        } else {
            ExtProps kinHead = this.getKinHead(dst, yDir);
            if (kinHead != null) {
                level = kinHead.headLevelOf(this, yDir);
                level2 = kinHead.headLevelOf(dst, yDir);
                hit = true;
            }
        }
        if (hit) {
            if (yDir) {
                pos.setRow(level);
                pos.setRow2(level2);
            } else {
                pos.setCol(level);
                pos.setCol2(level2);
            }
        }
    }

    public ExtProps getSub(ExtProps[] path, boolean yDir) {
        ExtProps sub = this;
        if (path != null) {
            for (int i = 0; i < path.length; ++i) {
                sub = sub.getSubBySource(path[i], yDir);
            }
        }
        return sub;
    }

    public boolean sameRowTypeAs(ExtProps other) {
        return this._cell.getRowObject().getType() == other.getCell().getRowObject().getType();
    }

    private void expandSelf(int rowMergeInc, int colMergeInc) {
        if (this._cell == null) {
            return;
        }
        this._height += rowMergeInc;
        this._width += colMergeInc;
        this._cell.setExtendMerge(true);
    }

    private void expandHead(boolean yDir, int mergeInc, boolean serratExt) {
        if (mergeInc <= 0) {
            return;
        }
        ExtProps head = yDir ? this._yHead : this._xHead;
        ExtProps sub = this;
        while (head != null) {
            if (!serratExt) {
                SortedExtPropsArray headSubs = head._subs;
                int size = headSubs.size();
                for (int i = 0; i < size; ++i) {
                    ExtProps sibling = (ExtProps)headSubs.get(i);
                    if (sibling == sub) continue;
                    if (yDir) {
                        if (!sibling.containRow(this)) continue;
                        sibling.expandSelf(mergeInc, 0);
                        continue;
                    }
                    if (!sibling.containCol(this)) continue;
                    sibling.expandSelf(0, mergeInc);
                }
            }
            if (!head.isCell00()) {
                if (yDir) {
                    if (head.containRow(this)) {
                        head.expandSelf(mergeInc, 0);
                    }
                } else if (head.containCol(this)) {
                    head.expandSelf(0, mergeInc);
                }
            }
            sub = head;
            head = yDir ? head._yHead : head._xHead;
        }
    }

    private void extendBound(Sheet sheet, CellBlock bound, boolean yDir) {
        int v2;
        ExtProps sub = this;
        ExtProps head = this;
        int v = yDir ? bound.getCol() : bound.getRow();
        int n = v2 = yDir ? bound.getCol2() : bound.getRow2();
        while (head != null && !head.isCell00()) {
            if (yDir) {
                int col = head.getCol();
                if (col < v) {
                    v = bound.setCol(col);
                } else if (col > v2) {
                    v2 = bound.setCol2(col);
                }
            } else {
                int row = head.getRow();
                if (row < v) {
                    v = bound.setRow(row);
                } else if (row > v2) {
                    v2 = bound.setRow2(row);
                }
            }
            sub = head;
            head = sub.getHead(yDir, false);
        }
        MergeBlocks merger = sheet.getMerger(false);
        if (merger != null) {
            int row = bound.getRow();
            int row2 = bound.getRow2();
            int col = bound.getCol();
            int col2 = bound.getCol2();
            SortedCellBlockArray blocks = yDir ? merger.getTouchedBlocks(row, col, 1048575, col2) : merger.getTouchedBlocks(row, col, row2, 65535);
            if (blocks != null) {
                v = yDir ? col : row;
                v2 = yDir ? col2 : row2;
                int iEnd = blocks.size();
                for (int i = 0; i < iEnd; ++i) {
                    CellBlock cb = blocks.getBlock(i);
                    if (yDir) {
                        if (cb.getCol() < v) {
                            v = bound.setCol(cb.getCol());
                        }
                        if (cb.getCol2() <= v2) continue;
                        v2 = bound.setCol2(cb.getCol2());
                        continue;
                    }
                    if (cb.getRow() < v) {
                        v = bound.setRow(cb.getRow());
                    }
                    if (cb.getRow2() <= v2) continue;
                    v2 = bound.setRow2(cb.getRow2());
                }
            }
        }
    }

    public void extend(boolean yDir, int extCount) {
        CellBlock subs = this.getSubsBound();
        int blockSize = yDir ? subs.getHeight() : subs.getWidth();
        Cell thisCell = this.getCell();
        Sheet sheet = this.getSheet();
        boolean serratExt = sheet.isSerratExt();
        if (extCount > 1) {
            CellBlock cbDst;
            if (serratExt) {
                int row = subs.getRow();
                int row2 = subs.getRow2();
                int col = subs.getCol();
                int col2 = subs.getCol2();
                cbDst = yDir ? CellBlock.getCellBlock(row2 + 1, col, row + blockSize * extCount - 1, col2) : CellBlock.getCellBlock(row, col2 + 1, row2, col + blockSize * extCount - 1);
                this.extendBound(sheet, cbDst, yDir);
            } else {
                cbDst = yDir ? CellBlock.getCellBlock(subs.getRow2() + 1, 0, subs.getRow() + blockSize * extCount - 1, 65535) : CellBlock.getCellBlock(0, subs.getCol2() + 1, 1048575, subs.getCol() + blockSize * extCount - 1);
            }
            if ((yDir ? cbDst.getHeight() : cbDst.getWidth()) > (yDir ? 1048575 : 65535)) {
                return;
            }
            SheetAction_InsDel sai = new SheetAction_InsDel(sheet.getRange(cbDst), true, yDir);
            sai.actionBlock(null, sheet, cbDst);
            ViewSplitInfo vs = this.getSheet().getSheetOption().getViewSplitInfo();
            if (yDir && vs.getRowSplit() >= subs.getRow2() + 1) {
                vs.setRowSplit(vs.getRowSplit() + cbDst.getRowSpan().getExtent());
            } else if (!yDir && vs.getColSplit() >= subs.getCol2() + 1) {
                vs.setColSplit(vs.getColSplit() + cbDst.getColSpan().getExtent());
            }
        }
        this.expandHead(yDir, blockSize * (extCount - 1), serratExt);
        Sheet.ICellsIterator ci = sheet.getCellsIterator(subs, false, false);
        ExecutionContext executionContext = (ExecutionContext)ThreadLocalUtil.get((String)"executionContext");
        while (ci.hasNext()) {
            boolean changeHead;
            Cell subCell = ci.next();
            ExtProps subEP = subCell.getExtProps(false);
            if (subEP == null || !this.isHeadOf(subEP, yDir)) continue;
            int subRow = subCell.getRow();
            int subCol = subCell.getCol();
            boolean subHasFormula = subCell.hasFormula();
            ShareStyleAttributes subSSA = subCell.getSSA();
            Row rowObj = yDir ? null : sheet.getRow(subRow, true);
            boolean extSelf = this == subEP;
            boolean bGroup = false;
            boolean bTree = false;
            Variant[] aValue = null;
            ExtRow[] aRow = null;
            int rowOffset = -1;
            int valueOffset = 0;
            if (extSelf) {
                Variant var = subCell.getValue();
                if (var.isArray()) {
                    aValue = (Variant[])var.getValue();
                    Object value = aValue[0].getValue();
                    bGroup = value instanceof ExtGroup;
                    bTree = value instanceof ExtGroupTreeNode;
                } else {
                    ExtGroup group = (ExtGroup)var.getValue();
                    aValue = group.getValues();
                    valueOffset = group.getValueFrom();
                    aRow = group.getRows();
                    rowOffset = group.getFrom();
                }
            }
            ExtProps head = subEP.getHead(yDir, true);
            int headRow = 0;
            int headCol = 0;
            boolean bl = changeHead = !head.isCell00() && this.isHeadOf(head, yDir);
            if (changeHead) {
                headRow = head.getRow();
                headCol = head.getCol();
            }
            int i = 0;
            int offset = 0;
            while (i < extCount) {
                if (executionContext != null && executionContext.isUserInterrupted()) {
                    return;
                }
                Cell newCell = yDir ? sheet.getCell(subRow + offset, subCol, true) : rowObj.getCell(subCol + offset, true);
                newCell.setExtendMerge(true);
                ExtProps newProps = null;
                if (newCell == thisCell) {
                    newProps = subEP;
                    newCell.setFormula(null);
                    this._exts = new SortedExtPropsArray(extCount);
                }
                if (newCell != subCell) {
                    newProps = newCell.getExtProps(subEP);
                    if (extSelf) {
                        newProps._exts = this._exts;
                    }
                    newCell.setSSA(subSSA);
                    HyperLink link = subCell.getHyperLink();
                    if (link != null) {
                        newCell.setHyperLink(link);
                    }
                    if (changeHead) {
                        Cell newHeadCell = yDir ? sheet.getCell(headRow + offset, headCol, true) : sheet.getCell(headRow, headCol + offset, true);
                        ExtProps newHead = newHeadCell.getExtProps(head);
                        newProps.setHead(newHead, yDir);
                        newProps.linkHead(!yDir);
                    } else {
                        newProps.linkHead(yDir);
                        newProps.linkHead(!yDir);
                    }
                }
                if (extSelf) {
                    this._exts.append(newProps);
                    Variant vi = aValue[i + valueOffset];
                    if (bGroup) {
                        ExtGroup grp = null;
                        if (vi != null && newProps != null) {
                            grp = (ExtGroup)vi.getValue();
                            newProps.setGroup(grp);
                            newCell.setValue(grp.getFirstValue());
                        }
                        if (grp != null && !grp.isNullGroup()) {
                            newProps.setExtRow(grp.getFirstRow());
                            if (bTree) {
                                int v2;
                                int v;
                                SortedAttributeSpanArray attrSpans;
                                if (this._extensible == 1) {
                                    attrSpans = sheet.getColSpans();
                                    v = newCell.getCol();
                                    v2 = v + newProps.getWidth();
                                } else {
                                    attrSpans = sheet.getRowSpans();
                                    v = newCell.getRow();
                                    v2 = v + newProps.getHeight();
                                }
                                attrSpans.setSpanAttribute(new Span(v, v2), null, null, null, ((ExtGroupTreeNode)grp).getLevel(), null, null);
                            }
                        }
                    } else {
                        if (vi != null) {
                            newCell.setValue(vi);
                        }
                        if (aRow != null && newProps != null) {
                            newProps.setExtRow(aRow[i + rowOffset]);
                        }
                    }
                } else if (newCell != subCell) {
                    newCell.copyCalculableFrom(subCell);
                    if (subHasFormula) {
                        newCell.setQueued(false);
                        newCell.setCalculating(false);
                        newCell.queue();
                    }
                }
                ++i;
                offset += blockSize;
            }
        }
    }

    public void setCurrentGroup() {
        if (this._group != null) {
            this._group.getDataSet().setCurrentGroup(this._group);
        }
        if (this._row != null) {
            this._row.getDataSet().setCurrentRow(this._row);
        }
        ExtDataSet headDS = null;
        ExtProps head = this._yHead;
        while (head != null) {
            if (head._group != null && (headDS = head._group.getDataSet()).getCurrentGroup() == null) {
                headDS.setCurrentGroup(head._group);
            }
            if (head._row != null && (headDS = head._row.getDataSet()).getCurrentRow() == null) {
                headDS.setCurrentRow(head._row);
            }
            head = head._yHead;
        }
        head = this._xHead;
        while (head != null) {
            if (head._group != null) {
                headDS = head._group.getDataSet();
                ExtGroup currGroup = headDS.getCurrentGroup();
                if (currGroup != null) {
                    ExtRow currentRow = headDS.getCurrentRow();
                    if (currentRow != (currGroup = headDS.intersect(currGroup, head._group, currentRow)).getMarkRow()) {
                        headDS.setCurrentRow(currGroup.getFirstRow());
                    }
                } else {
                    currGroup = head._group;
                }
                headDS.setCurrentGroup(currGroup);
            }
            if (head._row != null && (headDS = head._row.getDataSet()).getCurrentRow() == null) {
                headDS.setCurrentRow(head._row);
            }
            head = head._xHead;
        }
    }

    public Object executeCalculableProps(ICalculableProps props) {
        if (props == null) {
            return null;
        }
        Book book = this.getSheet().getBook();
        ExprContext ctx = book.getDeps().getExprContext();
        ExtDataSetManager dm = book.getDataSetManager();
        dm.resetCurrent();
        this.setCurrentGroup();
        dm.resumeCurrent();
        Variant var = props.calc(ctx, this._cell);
        if (var != null && var.getVt() != 16) {
            boolean bGroup = false;
            Variant[] aValue = null;
            StringBuilder result = new StringBuilder();
            if (var.isArray()) {
                aValue = (Variant[])var.getValue();
                Object value = aValue[0].getValue();
                bGroup = value instanceof ExtGroup;
            } else if (var.getValue() instanceof ExtGroup) {
                ExtGroup group = (ExtGroup)var.getValue();
                aValue = group.getValues();
            } else {
                return var.getValue() == null ? "" : var.getValue();
            }
            for (Variant vi : aValue) {
                if (bGroup) {
                    ExtGroup grp = null;
                    if (vi == null) continue;
                    grp = (ExtGroup)vi.getValue();
                    result.append(grp.getFirstValue().getValue()).append(',');
                    continue;
                }
                if (vi == null) continue;
                result.append(vi.getValue()).append(',');
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            }
            return result.toString();
        }
        return null;
    }

    public void executeParams(Map params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        Book book = this.getSheet().getBook();
        ExprContext ctx = book.getDeps().getExprContext();
        ExtDataSetManager dm = book.getDataSetManager();
        dm.resetCurrent();
        this.setCurrentGroup();
        dm.resumeCurrent();
        ctx.pushExprOwner(this._cell);
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Variant[] values;
            IParameter param = (IParameter)i.next().getValue();
            Variant var = ((ICalculableProps)((Object)param)).calc(ctx, this._cell);
            if (var == null) {
                var = Variant.nullVariant;
            } else if (var.getValue() instanceof ExtGroup && (values = ((ExtGroup)var.getValue()).getValues()) != null) {
                Variant[] list = new Variant[values.length];
                for (int j = values.length - 1; j >= 0; --j) {
                    list[j] = values[j];
                }
                if (list.length > 0) {
                    param.setValue(new Variant(list, 512));
                    continue;
                }
            }
            param.setValue(var);
        }
        ctx.popExprOwner();
    }

    public List<Variant> execCalProps(ICalculableProps prop) {
        Sheet sheet = this.getSheet();
        ExprContext ctx = sheet.getDeps().getExprContext();
        ArrayList<Variant> list = new ArrayList<Variant>(8);
        Variant variant = prop.calc(ctx, this._cell);
        if (variant.isArray()) {
            Variant[] variants = (Variant[])variant.getValue();
            int length = variants.length;
            for (int i = 0; i < length; ++i) {
                Object obj = variants[i].getValue();
                if (obj instanceof CellBlockNode) {
                    list.addAll(this.splitCellBlockToValue((CellBlockNode)obj));
                    continue;
                }
                list.add(variants[i]);
            }
        } else if (variant.isObject() || variant.isReferences()) {
            Object obj = variant.getValue();
            if (obj instanceof CellBlockNode) {
                list.addAll(this.splitCellBlockToValue((CellBlockNode)obj));
            } else if (obj instanceof ExtGroup) {
                ExtGroup groups = (ExtGroup)obj;
                Variant[] values = groups.getValues();
                if (values != null) {
                    for (int i = values.length - 1; i >= 0; --i) {
                        list.add(values[i]);
                    }
                }
            } else {
                list.add(variant);
            }
        } else {
            list.add(variant);
        }
        return list;
    }

    private List<Variant> splitCellBlockToValue(CellBlock block) {
        if (block == null) {
            return null;
        }
        ArrayList<Variant> list = new ArrayList<Variant>(8);
        int row = block.getRow();
        int row2 = block.getRow2();
        int col = block.getCol();
        int col2 = block.getCol2();
        for (int r = row; r <= row2; ++r) {
            for (int c2 = col; c2 <= col2; ++c2) {
                Cell cell = this.getSheet().getCell(r, c2, false);
                if (cell == null) continue;
                list.add(cell.getValue());
            }
        }
        return list;
    }

    public void setReportingGroupRootProps(boolean isReportingGroupRootCell) {
        this._isReportingGroupRootCell = isReportingGroupRootCell;
    }

    public boolean isReportingGroupRootProps() {
        return this._isReportingGroupRootCell;
    }

    public void clearSubsBounds() {
        this._subsBound = null;
    }

    public void setSubs(SortedExtPropsArray _subs) {
        this._subs = _subs;
    }

    public void updateHead(boolean yDir) {
        Cell prevCell;
        Cell cell;
        ExtProps head;
        ExtProps extProps = head = yDir ? this._yHead : this._xHead;
        if (this._cell == null) {
            return;
        }
        int row = this._cell.getRow();
        int col = this._cell.getCol();
        Sheet sheet = this._cell.getSheet();
        int rowColIndex = 0;
        if (head != null && (cell = head.getCell()) != null) {
            rowColIndex = yDir ? cell.getCol() : cell.getRow();
        }
        if ((prevCell = yDir ? sheet.getCell(row, rowColIndex, false) : sheet.getCell(rowColIndex, col - 1, false)) != null) {
            CellBlock cb;
            if (!prevCell.isFirstMergedCell() && (cb = sheet.getMergeBlock(prevCell)) != null) {
                prevCell = sheet.getFirstCell(cb, false);
            }
            head = prevCell.getExtProps(false);
            this.setHead(head, yDir);
        }
    }
}

