/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.collection;

import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.BinaryTree;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SplayTree;
import com.kingdee.cosmic.ctrl.kds.model.util.profile.ObjectProfiler;
import java.security.SecureRandom;
import java.util.Comparator;
import java.util.Iterator;

public class SBTree
extends BinaryTree {
    private static final DefaultComparator _defaultComparator = new DefaultComparator();
    private Node _root;
    private Node _older;
    private int _ops;
    private SBTreeIterator _qi;

    public SBTree() {
        this._cmp = _defaultComparator;
        this._qi = new SBTreeIterator();
    }

    @Override
    public Iterator iterator(Object from, Object end, boolean descent) {
        this._qi.init(from, end, descent);
        return this._qi;
    }

    @Override
    public int size() {
        return this._root == null ? 0 : this._root._size;
    }

    private Node _search(Object key) {
        Node t = this._root;
        while (t != null) {
            int cmp = this._cmp.compare(t._key, key);
            if (cmp == 0) {
                return t;
            }
            t = cmp < 0 ? t._right : t._left;
        }
        return null;
    }

    @Override
    public Object search(Object key) {
        Node n = this._search(key);
        return n == null ? null : n._key;
    }

    private Node _insert(Node t, Node x) {
        if (t == null) {
            this._older = t = x;
            this._ops = x._size;
        } else {
            int cmp = this._cmp.compare(x._key, t._key);
            if (cmp != 0) {
                if (cmp < 0) {
                    t._left = this._insert(t._left, x);
                } else {
                    t._right = this._insert(t._right, x);
                }
                t._size += this._ops;
                t = this.maintain(t, cmp > 0);
            } else {
                this._older = t;
            }
        }
        return t;
    }

    Node insert(Node x) {
        this._ops = 0;
        this._root = this._insert(this._root, x);
        return this._older;
    }

    @Override
    public Object insert(Object key) {
        return this.insert((Node)new Node((Object)key))._key;
    }

    private Node delete(Node t, Object key) {
        if (t == null) {
            return null;
        }
        int cmp = this._cmp.compare(key, t._key);
        if (cmp == 0) {
            if ((t = this.deleteNode(t)) != null) {
                --t._size;
            }
            this._ops = 1;
        } else {
            if (cmp < 0) {
                t._left = this.delete(t._left, key);
            } else {
                t._right = this.delete(t._right, key);
            }
            t._size -= this._ops;
        }
        return t;
    }

    @Override
    public void delete(Object key) {
        this._ops = 0;
        this._root = this.delete(this._root, key);
    }

    public Node deleteNode(Node t) {
        Object replacementItem;
        if (t._left == null) {
            return t._right == null ? null : t._right;
        }
        if (t._right == null) {
            return t._left;
        }
        t._key = replacementItem = this.findLeftmost(t._right);
        t._right = this.deleteLeftmost(t._right);
        return t;
    }

    private Object findLeftmost(Node t) {
        if (t._left == null) {
            return t._key;
        }
        return this.findLeftmost(t._left);
    }

    private Node deleteLeftmost(Node t) {
        if (t._left == null) {
            return t._right;
        }
        t._left = this.deleteLeftmost(t._left);
        return t;
    }

    public Node prev(Node t, Object key) {
        if (t == null) {
            return null;
        }
        if (this._cmp.compare(key, t._key) <= 0) {
            return this.prev(t._left, key);
        }
        Node prev = this.prev(t._right, key);
        return prev == null ? t : prev;
    }

    public Node next(Node t, Object key) {
        if (t == null) {
            return null;
        }
        if (this._cmp.compare(key, t._key) >= 0) {
            return this.next(t._right, key);
        }
        Node next = this.next(t._left, key);
        return next == null ? t : next;
    }

    public Node select(Node t, int i) {
        if (t == null || i > t._size) {
            return null;
        }
        int r = (t._left == null ? 0 : t._left._size) + 1;
        if (i == r) {
            return t;
        }
        if (i < r) {
            return this.select(t._left, i);
        }
        return this.select(t._right, i - r);
    }

    public int rank(Node t, Object key) {
        if (t == null) {
            return 0;
        }
        int cmp = this._cmp.compare(key, t._key);
        if (cmp == 0) {
            return (t._left == null ? 0 : t._left._size) + 1;
        }
        if (cmp < 0) {
            return this.rank(t._left, key);
        }
        int r = this.rank(t._right, key);
        return r == 0 ? 0 : r + (t._left == null ? 0 : t._left._size) + 1;
    }

    @Override
    public Object max() {
        Node node = this.max(this._root);
        return node == null ? null : node._key;
    }

    public Node max(Node t) {
        if (t == null) {
            return null;
        }
        while (t._right != null) {
            t = t._right;
        }
        return t;
    }

    @Override
    public Object min() {
        Node node = this.min(this._root);
        return node == null ? null : node._key;
    }

    public Node min(Node t) {
        if (t == null) {
            return null;
        }
        while (t._left != null) {
            t = t._left;
        }
        return t;
    }

    public Object selectMax(Node t, int num) {
        if (t == null) {
            return null;
        }
        Node right = t._right;
        if (right != null) {
            if (right._size + 1 == num) {
                return t._key;
            }
            if (right._size + 1 > num) {
                return this.selectMax(right, num);
            }
            return this.selectMax(t._left, num - right._size - 1);
        }
        if (num == 1) {
            return t._key;
        }
        if (t._left != null) {
            return this.selectMax(t._left, num - 1);
        }
        return null;
    }

    public Object selectMin(Node t, int num) {
        if (t == null) {
            return null;
        }
        Node left = t._left;
        if (left != null) {
            if (left._size + 1 == num) {
                return t._key;
            }
            if (left._size + 1 > num) {
                return this.selectMin(left, num);
            }
            return this.selectMin(t._right, num - left._size - 1);
        }
        if (num == 1) {
            return t._key;
        }
        if (t._right != null) {
            return this.selectMin(t._right, num - 1);
        }
        return null;
    }

    public int computeRank(Node t, Object key, int rank) {
        if (t == null) {
            return 0;
        }
        Node right = t._right;
        int cmp = this._cmp.compare(key, t._key);
        if (cmp < 0) {
            ++rank;
            if (right != null) {
                rank += right._size;
            }
            return this.computeRank(t._left, key, rank);
        }
        if (cmp > 0) {
            return this.computeRank(right, key, rank);
        }
        if (right != null) {
            rank += right._size;
        }
        return rank + 1;
    }

    @Override
    public boolean isEmpty() {
        return this._root == null;
    }

    public void makeEmpty() {
        this._root = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node maintain(Node t, boolean flag) {
        if (t == null) {
            return t;
        }
        Node left = t._left;
        Node right = t._right;
        if (!flag) {
            if (left == null) {
                return t;
            }
            if (left._left != null && (right == null || left._left._size > right._size)) {
                t = this.rightRotate(t);
            } else {
                if (left._right == null || right != null && left._right._size <= right._size) return t;
                t._left = this.leftRotate(left);
                t = this.rightRotate(t);
            }
        } else {
            if (right == null) {
                return t;
            }
            if (right._right != null && (left == null || right._right._size > left._size)) {
                t = this.leftRotate(t);
            } else {
                if (right._left == null || left != null && right._left._size <= left._size) return t;
                t._right = this.rightRotate(right);
                t = this.leftRotate(t);
            }
        }
        t._left = this.maintain(t._left, false);
        t._right = this.maintain(t._right, true);
        t = this.maintain(t, false);
        return this.maintain(t, true);
    }

    private Node leftRotate(Node x) {
        Node y = x._right;
        x._right = y._left;
        y._left = x;
        y._size = x._size;
        x._size = (x._left == null ? 0 : x._left._size) + (x._right == null ? 0 : x._right._size) + 1;
        return y;
    }

    private Node rightRotate(Node x) {
        Node y = x._left;
        x._left = y._right;
        y._right = x;
        y._size = x._size;
        x._size = (x._left == null ? 0 : x._left._size) + (x._right == null ? 0 : x._right._size) + 1;
        return y;
    }

    void inorder(Node treeNode) {
        if (treeNode != null) {
            this.inorder(treeNode._left);
            this.inorder(treeNode._right);
        }
    }

    public static void main(String[] args) {
        int i;
        Object obj;
        int i2;
        int c2;
        int count = 25000;
        SecureRandom r = new SecureRandom();
        Integer[] a = new Integer[count];
        for (int i3 = 0; i3 < count; ++i3) {
            a[i3] = Math.abs(r.nextInt(Integer.MAX_VALUE));
        }
        SortedObjectArray sa = null;
        SBTree qt = null;
        SplayTree sp = null;
        long t = System.currentTimeMillis();
        sa = new SortedObjectArray();
        for (int i4 = 0; i4 < count; ++i4) {
            sa.insert(a[i4]);
        }
        long tsa = System.currentTimeMillis();
        qt = new SBTree();
        for (int i5 = 0; i5 < count; ++i5) {
            qt.insert(new Node(a[i5]));
        }
        long tqt = System.currentTimeMillis();
        sp = new SplayTree();
        for (int i6 = 0; i6 < count; ++i6) {
            sp.insert(a[i6]);
        }
        long tsp = System.currentTimeMillis();
        System.out.println("SA Init: " + (tsa - t) + "  QT Init: " + (tqt - tsa) + " Splay: " + (tsp - tqt));
        t = System.currentTimeMillis();
        for (c2 = 0; c2 < 10; ++c2) {
            for (i2 = 0; i2 < count; ++i2) {
                int pos = sa.search(a[i2]);
                obj = sa.get(pos);
            }
        }
        tsa = System.currentTimeMillis();
        for (c2 = 0; c2 < 10; ++c2) {
            for (i2 = 0; i2 < count; i2 += 2) {
                obj = qt._search(a[i2]);
            }
        }
        tqt = System.currentTimeMillis();
        for (c2 = 0; c2 < 10; ++c2) {
            for (i2 = 0; i2 < count; i2 += 2) {
                obj = sp.search(a[i2]);
            }
        }
        tsp = System.currentTimeMillis();
        System.out.println("SA Access: " + (tsa - t) + "  QT Access: " + (tqt - tsa) + " Splay Access: " + (tsp - tqt));
        for (i = 0; i < count; i += 2) {
            Iterator ai = sa.iterator(a[i], a[i + 1], false);
            Iterator qi = qt.iterator(a[i], a[i + 1], false);
            Iterator si = sp.iterator(a[i], a[i + 1], false);
            while (ai.hasNext()) {
                obj = ai.next();
                Object qo = qi.next();
                Object so = si.next();
                if (obj == qo && obj == so) continue;
                System.out.println("SA != QT Access != Splay");
            }
        }
        System.out.println("Equals OK");
        t = System.currentTimeMillis();
        for (i = 0; i < count; i += 2) {
            int end = sa.search(a[i + 1]);
            for (int start = sa.search(a[i]); start <= end; ++start) {
                obj = sa.get(start);
            }
        }
        tsa = System.currentTimeMillis();
        for (i = 0; i < count; i += 2) {
            Iterator ii = qt.iterator(a[i], a[i + 1], false);
            while (ii.hasNext()) {
                obj = ii.next();
            }
        }
        tqt = System.currentTimeMillis();
        for (i = 0; i < count; i += 2) {
            Iterator ii = sp.iterator(a[i], a[i + 1], false);
            while (ii.hasNext()) {
                obj = ii.next();
            }
        }
        tsp = System.currentTimeMillis();
        System.out.println("SA Through: " + (tsa - t) + "  QT Through: " + (tqt - tsa) + " Splay: " + (tsp - tqt));
        tsa = System.currentTimeMillis();
        for (i = 0; i < count; i += 2) {
            qt.inorder(qt._root);
        }
        tqt = System.currentTimeMillis();
        System.out.println("QT Inorder: " + (tqt - tsa));
        System.out.println("SA Size: " + (double)ObjectProfiler.sizeof(sa) / 1024.0 + "  QT Size: " + (double)ObjectProfiler.sizeof(qt) / 1024.0 + "  Splay Size: " + (double)ObjectProfiler.sizeof(sp) / 1024.0);
        t = System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            sa.remove(a[i]);
        }
        tsa = System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            qt.delete(a[i]);
        }
        tqt = System.currentTimeMillis();
        for (i = 0; i < count; ++i) {
            sp.delete(a[i]);
        }
        tsp = System.currentTimeMillis();
        System.out.println("SA Delete: " + (tsa - t) + "  QT Delete: " + (tqt - tsa) + " Splay: " + (tsp - tqt));
    }

    public static class Node {
        Node _left;
        Node _right;
        Node _next;
        int _size;
        Object _key;

        private Node(Object key) {
            this._key = key;
            this._size = 1;
        }

        private Node(Object key, Node left, Node right) {
            this._key = key;
            this._left = left;
            this._right = right;
        }

        public String toString() {
            return this._key.toString();
        }

        public Object getData() {
            return this._key;
        }
    }

    private static class DefaultComparator
    implements Comparator {
        private DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    }

    public class SBTreeIterator
    implements Iterator {
        private boolean _descent;
        private Node _current;
        private Node _start;
        private Node _end;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Node t = this._current;
            while (t != null) {
                sb.append(t);
                sb.append(',');
                t = t._next;
            }
            return sb.toString();
        }

        void init(Object from, Object to, boolean descent) {
            int cmpCheck;
            if (from == null) {
                cmpCheck = to == null ? 0 : -1;
            } else {
                int n = cmpCheck = to == null ? -1 : SBTree.this._cmp.compare(from, to);
            }
            if (cmpCheck > 0) {
                this._current = null;
                return;
            }
            this._descent = descent;
            this._end = null;
            this._start = null;
            this._current = null;
            Node root = SBTree.this._root;
            if (from == null) {
                this._start = SBTree.this.min(root);
            } else {
                this._start = SBTree.this._search(from);
                if (this._start == null) {
                    this._start = SBTree.this.next(root, from);
                }
            }
            if (this._start != null) {
                if (to == null) {
                    this._end = SBTree.this.max(root);
                } else {
                    this._end = SBTree.this._search(to);
                    if (this._end == null) {
                        this._end = SBTree.this.prev(root, to);
                    }
                }
            }
            if (this._start != null && this._end != null && SBTree.this._cmp.compare(this._start._key, this._end._key) <= 0) {
                if (this._start == this._end) {
                    this._current = this._start;
                    this._current._next = null;
                } else {
                    this._current = descent ? this._end : this._start;
                    this.order(root);
                    this._current = descent ? this._end : this._start;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this._current != null;
        }

        public Object next() {
            Object obj = null;
            if (this._current != null) {
                obj = this._current._key;
                this._current = this._current._next;
            }
            return obj;
        }

        public Node nextNode() {
            Node n = null;
            if (this._current != null) {
                n = this._current;
                this._current = this._current._next;
            }
            return n;
        }

        @Override
        public void remove() {
            if (this._current != null) {
                Node curr = this._current;
                this._current = this._current._next;
                SBTree.this.deleteNode(curr);
            }
        }

        public void clear() {
            Node t = this._start;
            while (t != null) {
                Node tmp = t._next;
                t._next = null;
                t = tmp;
            }
        }

        private void order(Node t) {
            if (t == null) {
                return;
            }
            Node left = t._left;
            Node right = t._right;
            Comparator cmp = SBTree.this._cmp;
            if (!this._descent) {
                if (left != null && cmp.compare(this._start._key, t._key) < 0) {
                    this.order(left);
                }
                if (cmp.compare(t._key, this._end._key) <= 0) {
                    if (this._current != t) {
                        this._current._next = t;
                    }
                    this._current = t;
                    t._next = null;
                }
                if (right != null && cmp.compare(this._end._key, t._key) > 0) {
                    this.order(t._right);
                }
            } else {
                if (right != null && cmp.compare(this._end._key, t._key) > 0) {
                    this.order(right);
                }
                if (cmp.compare(t._key, this._start._key) >= 0) {
                    if (this._current != t) {
                        this._current._next = t;
                    }
                    this._current = t;
                    t._next = null;
                }
                if (left != null && cmp.compare(this._start._key, t._key) < 0) {
                    this.order(t._left);
                }
            }
        }
    }
}

