/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data;

import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprBuffer;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellPropAction;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.util.ObjectStack;

public class CommonCalculableProps
implements ICalculableProps {
    private CellPropAction _action;
    protected Expr _expr;

    public CommonCalculableProps(CellPropAction action, Expr expr) {
        this._action = action;
        this._expr = expr;
    }

    @Override
    public Object clone() {
        CommonCalculableProps c2 = null;
        try {
            c2 = (CommonCalculableProps)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c2;
    }

    public int compareTo(Object o) {
        return this._action.getIntKey() - ((ICalculableProps)o).getAction().getIntKey();
    }

    @Override
    public CellPropAction getAction() {
        return this._action;
    }

    @Override
    public String getFormula(ExprContext ctx, ICalculable owner) {
        return this._expr == null ? "" : this._expr.decode(ctx, owner);
    }

    @Override
    public Variant calc(ExprContext ctx, ICalculable owner) {
        Variant ret;
        if (this._expr != null) {
            boolean traceMode = ctx.isTraceMode();
            ctx.setTraceMode(false);
            if (ctx.isCalcLastMode()) {
                ctx.setCalcLastMode(false);
                ret = this._expr.execute(ctx, owner).getVariant();
                ctx.setCalcLastMode(true);
            } else {
                ret = this._expr.execute(ctx, owner).getVariant();
            }
            ctx.setTraceMode(traceMode);
        } else {
            ret = Variant.nullVariant;
        }
        return ret;
    }

    @Override
    public void setExpr(Expr expr) {
        this._expr = expr;
    }

    @Override
    public void buildExtExpr(IExprBuffer buffer, ICalculable exprOwner) {
        Expr newExpr;
        if (this._expr != null && (newExpr = exprOwner.getSheet().getExtExpr(buffer, this._expr, exprOwner)) != null) {
            this._expr = newExpr;
        }
    }

    @Override
    public void buildDSExpr(IExprBuffer buffer, ICalculable owner, NamedObjectNode no, ExtDataSet ds) {
        Expr newExpr;
        if (this._expr != null && (newExpr = owner.getSheet().getBook().getDataSetManager().replaceDS(buffer, owner, this._expr, no, ds)) != null) {
            this._expr = newExpr;
        }
    }

    @Override
    public void buildFieldExpr(IExprBuffer buffer, ObjectStack stack, ICalculable owner, ExtDataSet ds) {
        if (this._expr != null) {
            Expr newExpr = owner.getSheet().getBook().getDataSetManager().replaceField(buffer, stack, owner, this._expr, ds);
            if (newExpr != null) {
                this._expr = newExpr;
            }
            stack.clear();
        }
    }
}

