/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectCache;
import com.kingdee.cosmic.ctrl.extcommon.variant.IVarReferences;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtRow;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.expr.TraceVariant;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import java.util.Locale;

public class ExtColumn
implements Comparable,
IExprNode,
IVarReferences,
Cloneable {
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int DOUBLE = 4;
    public static final int DECIMAL = 5;
    public static final int DATE = 6;
    public static final int TIME = 7;
    public static final int BOOLEAN = 8;
    public static final int OBJECT = 9;
    public static final int STRING = 10;
    public static final int FLOAT = 11;
    public static final int TYPE_COUNT = 12;
    private ExtDataSet _ds;
    private String _name;
    private String _alias;
    private String _upperAlias;
    private Variant _varIndex;
    private Variant _varThis;
    private int _dataType;
    private int _origType;

    public ExtColumn(ExtDataSet ds, String colName, int oriIndex, int dataType) {
        this._ds = ds;
        this._alias = colName == null ? null : colName.trim();
        this._name = this._alias;
        this._upperAlias = this._alias == null ? null : this._alias.toUpperCase(Locale.ENGLISH);
        this._varIndex = new Variant(ObjectCache.getInteger(oriIndex), 3);
        this._varThis = new Variant(this, 18);
        this._origType = dataType;
        switch (dataType) {
            case 2: 
            case 3: {
                this._dataType = 5;
                break;
            }
            case 91: {
                this._dataType = 6;
                break;
            }
            case 92: 
            case 93: {
                this._dataType = 7;
                break;
            }
            case 16: {
                this._dataType = 8;
                break;
            }
            case 6: 
            case 7: {
                this._dataType = 11;
                break;
            }
            case 8: {
                this._dataType = 4;
                break;
            }
            case 4: 
            case 5: {
                this._dataType = 2;
                break;
            }
            case -5: {
                this._dataType = 3;
                break;
            }
            case -6: {
                this._dataType = 0;
                break;
            }
            case -9: 
            case -1: 
            case 1: 
            case 9: 
            case 12: {
                this._dataType = 10;
                break;
            }
            default: {
                this._dataType = 9;
            }
        }
    }

    public Object clone() {
        ExtColumn col = null;
        try {
            col = (ExtColumn)super.clone();
            col._varThis = new Variant(col, 18);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return col;
    }

    public int compareTo(Object obj) {
        if (obj instanceof String) {
            return this._upperAlias.compareTo((String)obj);
        }
        return this._upperAlias.compareTo(((ExtColumn)obj)._upperAlias);
    }

    public String toString() {
        return this._name + "[" + this._varIndex + "]";
    }

    public String getName() {
        return this._name;
    }

    public void setColumnName(String colName) {
        this._name = colName;
    }

    public boolean hasAlias() {
        return this._alias != null;
    }

    public String getAlias() {
        if (StringUtil.isEmptyString((String)this._alias)) {
            return this._name;
        }
        return this._alias;
    }

    public void setAlias(String alias) {
        if (StringUtil.isEmptyString((String)alias)) {
            alias = this._name;
        }
        this._alias = alias;
        this._upperAlias = this._alias.toUpperCase(Locale.ENGLISH);
    }

    public String getUpperAlias() {
        return this._upperAlias;
    }

    public ExtDataSet getDataSet() {
        return this._ds;
    }

    public void setDataSet(ExtDataSet ds) {
        this._ds = ds;
    }

    public Variant getIndex() {
        return this._varIndex;
    }

    public void setIndex(Variant index) {
        this._varIndex = index;
    }

    public int getDataType() {
        return this._dataType;
    }

    public void setDataType(int dataType) {
        this._dataType = dataType;
    }

    public int getOrigType() {
        return this._origType;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        Variant var = ctx.isTraceMode() ? new TraceVariant(this._varThis, ctx) : this._varThis;
        ctx.getCurrentExprStack().push(var);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return this.getAlias();
    }

    @Override
    public int getExprType() {
        return 0x100000;
    }

    @Override
    public Variant getActualValue() {
        ExtRow row = this._ds.getCurrentRow();
        return row == null || row.isNullRow() ? Variant.nullVariant : this._ds.field(row, (int)((Integer)this._varIndex.getValue()));
    }
}

