/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data;

import com.kingdee.cosmic.ctrl.common.KDToolkit;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.cosmic.ctrl.ext.immit.IRptRuntimeCallback;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.ExprErr;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropsArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtRowIndexArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtRowValuesArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDynamicDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtGroup;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtRow;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtendFuncProvider;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.io.kds.AuthorizationFailedException;
import com.kingdee.cosmic.ctrl.kds.io.kds.HighVersionException;
import com.kingdee.cosmic.ctrl.kds.io.kds.InvalidCouponException;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExcelFuncProvider;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprExtPos;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprBuffer;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.expr.IInnerFuncProvider;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.collection.CellBlockMatrix;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.DynamicAccessImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.IImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ImageFullPath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredImageResult;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredPathImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.WebsiteImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlock3DNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.cosmic.ctrl.kds.model.util.Base64Encoder;
import com.kingdee.cosmic.ctrl.kds.model.util.ExtURL;
import com.kingdee.cosmic.ctrl.kds.model.util.IntArray;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.cosmic.ctrl.kds.model.util.url.UnknownImageURLProtocolException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ExtFuncProvider
implements IInnerFuncProvider {
    private static char[] _hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private Logger log = LogUtil.getLogger(ExtFuncProvider.class);

    public Variant MACRO(String micro) throws SyntaxErrorException {
        ExprErr.goError(64L, micro);
        return null;
    }

    public Variant $CROSS(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        SortedCellBlockArray blocks;
        MergeBlocks merger;
        ExcelFuncProvider.validParamCount(args, 2, 3);
        ExtProps epDst = null;
        Object value = ((Variant)args[0]).getValue();
        if (!(value instanceof CellBlockNode)) {
            ExprErr.goError(16L, CtrlEXTMessages.getMLS("parameter1NotCell", "\u53c2\u65701\u975e\u5355\u5143\u683c"));
        }
        CellBlockNode cbSrc = (CellBlockNode)value;
        ExtProps epSrc = cbSrc.getFirstCell(false).getExtProps(false).getSource();
        Object value2 = ((Variant)args[1]).getValue();
        if (!(value2 instanceof CellBlockNode)) {
            ExprErr.goError(16L, CtrlEXTMessages.getMLS("parameter2NotCell", "\u53c2\u65702\u975e\u5355\u5143\u683c"));
        }
        CellBlockNode cbRange = (CellBlockNode)value2;
        Sheet sheet = cbRange.getSheet();
        int row = cbRange.getRow();
        int col = cbRange.getCol();
        boolean yDir = true;
        if (args.length == 3) {
            yDir = ((Variant)args[2]).booleanValue();
        }
        CellBlock cbSearch = yDir ? CellBlock.getCellBlock(row, 0, row, 65535) : CellBlock.getCellBlock(0, col, 1048575, col);
        Sheet.ICellsIterator i = sheet.getCellsIterator(cbSearch, false, false);
        while (i.hasNext()) {
            ExtProps ep = i.next().getExtProps(false);
            if (ep.getSource() != epSrc) continue;
            epDst = ep;
            break;
        }
        if (epDst == null && (merger = sheet.getMerger(false)) != null && (blocks = merger.getTouchedBlocks(cbSearch)) != null) {
            int jEnd = blocks.size();
            for (int j = 0; j < jEnd; ++j) {
                ExtProps ep = sheet.getFirstCell((CellBlock)blocks.get(j), false).getExtProps(false);
                if (ep.getSource() != epSrc) continue;
                epDst = ep;
                break;
            }
        }
        if (epDst == null) {
            ExprErr.goError(16L, CtrlEXTMessages.getMLS("invalidParameter2", "\u975e\u6709\u6548\u53c2\u6570"));
        }
        CellBlockNode cb = null;
        if (null != epDst) {
            int row2 = epDst.getRow();
            int col2 = epDst.getCol();
            cb = CellBlockNode.getCellBlockNode(sheet, row2, col2, row2, col2, 0);
        }
        return new Variant(cb, 17);
    }

    public Variant SUBS(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExtProps epHead;
        SortedExtPropsArray subs;
        CellBlockNode cbHead;
        Cell cll;
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant[] av = null;
        Object value = ((Variant)args[0]).getValue();
        if (!(value instanceof CellBlockNode)) {
            ExprErr.goError(16L, CtrlEXTMessages.getMLS("parameter1NotCell", "\u53c2\u65701\u975e\u5355\u5143\u683c"));
        }
        if ((cll = (cbHead = (CellBlockNode)value).getFirstCell(false)) != null && (subs = (epHead = cll.getExtProps(false)).getSubs()) != null) {
            if (args.length == 2) {
                CellBlockNode cbSrc;
                Cell cll2;
                Object value2 = ((Variant)args[1]).getValue();
                if (!(value2 instanceof CellBlockNode)) {
                    ExprErr.goError(16L, CtrlEXTMessages.getMLS("parameter2NotCell", "\u53c2\u65702\u975e\u5355\u5143\u683c"));
                }
                if ((cll2 = (cbSrc = (CellBlockNode)value2).getFirstCell(false)) != null) {
                    ExtProps epSrc = cll2.getExtProps(false).getSource();
                    SortedExtPropsArray subSubs = new SortedExtPropsArray(subs.size());
                    int iEnd = subs.size();
                    for (int i = 0; i < iEnd; ++i) {
                        ExtProps ep = (ExtProps)subs.get(i);
                        if (ep.getSource() != epSrc) continue;
                        subSubs.append(ep);
                    }
                    subs = subSubs;
                }
            }
            av = new Variant[subs.size()];
            for (int i = 0; i < av.length; ++i) {
                av[i] = ((ExtProps)subs.get(i)).getCell().getValue();
            }
        }
        if (av == null) {
            av = new Variant[]{};
        }
        return new Variant(av, 527);
    }

    public Variant NULL(ExprContext ctx, Variant arg) throws SyntaxErrorException {
        return this.ENABLE(ctx, new Object[]{arg, Variant.falseVariant});
    }

    public Variant ENABLE(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        boolean enable;
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant varDS = (Variant)args[0];
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, varDS, false);
        boolean bl = enable = args.length == 2 ? ((Variant)args[1]).booleanValue() : true;
        if (enable) {
            ds.setManualNullGroup(false);
            ds = ExtFuncProvider.getValidDataSet(ctx, varDS, true);
        } else {
            ds.setCurrentGroup(ds.getNullGroup());
            ds.setManualNullGroup(true);
        }
        return ds.getVarThis();
    }

    public Variant QUERY(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 2);
        ExtDataSet srcDS = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0], false);
        Variant varParams = (Variant)args[1];
        if (!varParams.isArray()) {
            ExprErr.goError(16L, "Params");
        }
        HashMap<String, ParameterImpl> params = new HashMap<String, ParameterImpl>();
        Variant[] a = (Variant[])varParams.getValue();
        if (a.length % 2 != 0) {
            ExprErr.goError(16L, "Params Count");
        }
        for (int i = 0; i < a.length; i += 2) {
            String key = a[i].getVariant().toString();
            ParameterImpl param = new ParameterImpl(key, key, 0, a[i + 1].getVariant(), false);
            params.put(key, param);
        }
        ExtDataSetManager dsm = srcDS.getBook().getDataSetManager();
        ExtDynamicDataSet dds = dsm.addDynamicDataSet(ExtDynamicDataSet.getExtDynamicDataSet(srcDS, params));
        return dds.getVarThis();
    }

    private void _getMergeGroupFromVars(ObjectArray array, Variant[] varGroups) throws SyntaxErrorException {
        for (int i = 0; i < varGroups.length; ++i) {
            int j;
            int size = array.size();
            this._getGroupFromVars(array, varGroups[i]);
            int newSize = array.size();
            if (newSize - size <= 1) continue;
            ExtGroup group = (ExtGroup)array.get(size);
            int records = group.size();
            for (j = size + 1; j < newSize; ++j) {
                records += ((ExtGroup)array.get(j)).size();
            }
            Object[] rows = new ExtRow[records];
            int r = 0;
            for (j = size; j < newSize; ++j) {
                ExtGroup grp = (ExtGroup)array.get(j);
                int grpSize = grp.size();
                KDToolkit.arraycopy((Object[])grp.getRows(), (int)grp.getFrom(), (Object[])rows, (int)r, (int)grpSize);
                r += grpSize;
            }
            group.setRows((ExtRow[])rows);
            array.removeByPos(size, newSize - 1, false);
        }
    }

    private void _getGroupFromVars(ObjectArray array, Variant var) throws SyntaxErrorException {
        Object obj = var.getValue();
        if (var.isReferences() && obj instanceof CellBlockNode) {
            CellBlockNode cb = (CellBlockNode)obj;
            if (cb.isSingleCell()) {
                Cell cll = cb.getFirstCell(false);
                ExtGroup group = this._getGroupFromCell(cll, false);
                if (group == null) {
                    ExprErr.goError(16L, "No Group: " + cll.getName(false, true));
                }
                array.append(group);
            } else {
                Sheet.ICellsIterator i = cb.getCellsIterator(false, true);
                while (i.hasNext()) {
                    Cell cll = i.next();
                    ExtGroup group = this._getGroupFromCell(cll, false);
                    if (group == null) {
                        ExprErr.goError(16L, "No Group: " + cll.getName(false, true));
                    }
                    array.append(group);
                }
            }
        } else if (ExtGroup.isGroup(var)) {
            array.append(var.getValue());
        } else if (var.isArray()) {
            Variant[] vars = (Variant[])var.getValue();
            for (int i = 0; i < vars.length; ++i) {
                this._getGroupFromVars(array, vars[i]);
            }
        } else if (ExtGroup.isDataset(var)) {
            ExtGroup group;
            ExtDataSet ds = (ExtDataSet)var.getValue();
            if (ds.isEmpty() && !ds.isManualNullGroup()) {
                ds.getBook().getDataSetManager().updateDataSet(ds);
            }
            if ((group = ds.getDefaultGroup()) != null && array.getLast() != group) {
                array.append(group);
            }
        } else {
            ExprErr.goError(16L, "No Group: " + var);
        }
    }

    private ExtGroup _getGroupFromCell(Cell cll, boolean checkNull) throws SyntaxErrorException {
        ExtProps ep = null;
        if (cll == null || (ep = cll.getExtProps(false)) == null) {
            ExprErr.goError(16L, "Pos Null");
        }
        ExtGroup group = null;
        if (null != ep) {
            group = ep.getGroup();
        }
        if (group == null && checkNull) {
            if (null != cll && cll.getValue().isCalcLast()) {
                throw SyntaxErrorException.CALC_LAST;
            }
            ExprErr.goError(16L, "DS Null");
        }
        return group;
    }

    public Variant POSJOIN(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, Integer.MAX_VALUE);
        ICalculable exprOwner = ExcelFuncProvider.calcLast(ctx);
        boolean noExternalKey = false;
        int grpCount = args.length;
        Object[] allFieldNames = null;
        String[] keyFieldNames = null;
        Variant[] grps = new Variant[grpCount];
        Variant[] externalKeys = new Variant[grpCount];
        Variant[] joinFields = new Variant[grpCount];
        Variant[] fieldNames = new Variant[grpCount];
        for (int i = 0; i < args.length; ++i) {
            Variant var = (Variant)args[i];
            if (!var.isArray()) {
                ExprErr.goError(16L, "Not Array");
            }
            Variant[] dsParam = (Variant[])var.getValue();
            grps[i] = dsParam[0];
            externalKeys[i] = dsParam[1];
            if (externalKeys[i].isNull()) {
                noExternalKey = true;
            }
            fieldNames[i] = joinFields[i] = dsParam[2];
            if (dsParam.length <= 3 || (var = dsParam[3]).isNull()) continue;
            fieldNames[i] = var;
        }
        ObjectArray aGroups = new ObjectArray(grpCount);
        this._getMergeGroupFromVars(aGroups, grps);
        Object[] groups = new ExtGroup[aGroups.size()];
        aGroups.toArray(groups, 0);
        int[][] keyFields = new int[grpCount][];
        int[][] valueFields = new int[grpCount][];
        int[] keyType = null;
        for (int i = 0; i < grpCount; ++i) {
            int[] valueField;
            Variant var;
            ExtColumn col;
            SortedObjectArray cols = ((ExtGroup)groups[i]).getDataSet().getColumns();
            if (noExternalKey) {
                keyFields[i] = new int[]{-1};
                if (keyFieldNames == null) {
                    keyFieldNames = new String[]{"$AutoID"};
                }
            } else {
                Variant varKey = externalKeys[i];
                if (keyType == null) {
                    if (varKey.isArray()) {
                        Variant[] keys = (Variant[])varKey.getValue();
                        keyType = new int[keys.length];
                        Arrays.fill(keyType, -1);
                        keyFieldNames = new String[keys.length];
                        for (int k = 0; k < keys.length; ++k) {
                            Variant v = keys[k];
                            keyFieldNames[k] = v.isNull() ? "$AutoID" + k : (v.isString() ? v.toString() : ((ExtColumn)v.getValue()).getName());
                        }
                    } else {
                        keyType = new int[]{-1};
                        keyFieldNames = new String[]{varKey.isNull() ? "$AutoID" : (varKey.isString() ? varKey.toString() : ((ExtColumn)varKey.getValue()).getName())};
                    }
                }
                if (varKey.isArray()) {
                    Variant[] array = (Variant[])varKey.getValue();
                    if (array.length != keyType.length) {
                        ExprErr.goError(64L, "Prime Key Count");
                    }
                    int[] keyField = new int[keyType.length];
                    for (int k = 0; k < array.length; ++k) {
                        col = this._getTypedColumn(cols, array[k], keyType[k]);
                        keyType[k] = col.getDataType();
                        keyField[k] = col.getIndex().intValue();
                    }
                    keyFields[i] = keyField;
                } else {
                    if (keyType.length != 1) {
                        ExprErr.goError(64L, "Prime Key Count");
                    }
                    col = this._getTypedColumn(cols, varKey, keyType[0]);
                    keyType[0] = col.getDataType();
                    keyFields[i] = new int[]{col.getIndex().intValue()};
                }
            }
            if ((var = joinFields[i]).isArray()) {
                Variant[] varFields = (Variant[])var.getValue();
                valueField = new int[varFields.length];
                valueFields[i] = valueField;
                for (int j = 0; j < varFields.length; ++j) {
                    col = this._getTypedColumn(cols, varFields[i], -1);
                    valueField[j] = col.getIndex().intValue();
                }
                continue;
            }
            col = this._getTypedColumn(cols, var, -1);
            valueField = new int[]{col.getIndex().intValue()};
            valueFields[i] = valueField;
        }
        ObjectArray array = new ObjectArray(grpCount);
        for (int i = 0; i < fieldNames.length; ++i) {
            this._getColNames(array, fieldNames[i]);
        }
        if (null != keyFieldNames) {
            int keyCount = keyFieldNames.length;
            allFieldNames = new String[array.size() + keyCount];
            System.arraycopy(keyFieldNames, 0, allFieldNames, 0, keyCount);
            array.toArray(allFieldNames, keyCount);
            for (int i = allFieldNames.length - 1; i > 0; --i) {
                Object src = allFieldNames[i];
                for (int j = i - 1; j != 0; --j) {
                    if (((String)src).compareTo((String)allFieldNames[j]) != 0) continue;
                    ExprErr.goError(64L, "Dup ColName");
                }
            }
        }
        SortedRecords joinRecords = null;
        if (null != keyFieldNames) {
            joinRecords = new SortedRecords(((ExtGroup)groups[0]).size(), keyFieldNames.length);
        }
        Book book = ctx.getBook();
        int cols = 0;
        if (null != allFieldNames) {
            cols = allFieldNames.length;
        }
        int keyCount = 0;
        if (null != keyFieldNames) {
            keyCount = keyFieldNames.length;
        }
        int groupPos = keyCount;
        Object[] tmpKey = new Variant[cols];
        Arrays.fill(tmpKey, keyCount, cols, Variant.emptyVariant);
        for (int g = 0; g < grpCount; ++g) {
            Object grp = groups[g];
            ExtRow[] rows = ((ExtGroup)grp).getRows();
            ExtDataSet ds = ((ExtGroup)grp).getDataSet();
            int autoKeyID = 0;
            int[] keyField = keyFields[g];
            int[] valueField = valueFields[g];
            int jEnd = ((ExtGroup)grp).getTo();
            for (int r = ((ExtGroup)grp).getFrom(); r < jEnd; ++r) {
                Object[] dstRowData;
                Variant[] srcRowData = ds.getRowData(rows[r].index());
                if (noExternalKey) {
                    tmpKey[0] = book.getBufferedVariant(new Variant(autoKeyID++));
                } else {
                    for (int k = 0; k < keyField.length; ++k) {
                        tmpKey[k] = srcRowData[keyField[k]];
                    }
                }
                int pos = joinRecords.search(tmpKey);
                if (pos < 0) {
                    dstRowData = tmpKey;
                    tmpKey = new Variant[cols];
                    Arrays.fill(tmpKey, keyCount, cols, Variant.emptyVariant);
                    joinRecords.insert(pos, dstRowData);
                } else {
                    dstRowData = (Variant[])joinRecords.get(pos);
                }
                for (int v = 0; v < valueField.length; ++v) {
                    dstRowData[groupPos + v] = srcRowData[valueField[v]];
                }
            }
            groupPos += valueField.length;
        }
        book = exprOwner.getSheet().getBook();
        ExtDynamicDataSet dds = ExtDynamicDataSet.getExtDynamicDataSet(book, "Join", "", ExtDataSetType.TXT, null);
        if (null != allFieldNames) {
            SortedObjectArray cols2 = new SortedObjectArray(allFieldNames.length);
            for (int i = 0; i < allFieldNames.length; ++i) {
                ExtColumn col = new ExtColumn(dds, (String)allFieldNames[i], i, 0);
                cols2.insert(col);
            }
            dds.setColumns(cols2);
        }
        if (null != joinRecords) {
            Variant[][] data = new Variant[joinRecords.size()][];
            joinRecords.toArray((Object[])data, 0);
            dds.setData(data);
        }
        dds = book.getDataSetManager().addDynamicDataSet(dds);
        return dds.getVarThis();
    }

    private void _getColNames(ObjectArray array, Variant var) throws SyntaxErrorException {
        Object obj = var.getValue();
        if (var.isReferences() && obj instanceof ExtColumn) {
            array.append(((ExtColumn)obj).getUpperAlias());
        } else if (var.isString()) {
            array.append(((String)obj).toUpperCase());
        } else if (var.isArray()) {
            Variant[] a = (Variant[])var.getValue();
            for (int i = 0; i < a.length; ++i) {
                this._getColNames(array, a[i]);
            }
        } else {
            ExprErr.goError(16L, "Invalid ColName");
        }
    }

    private ExtColumn _getTypedColumn(SortedObjectArray cols, Variant key, int keyType) throws SyntaxErrorException {
        ExtColumn col;
        Object obj = key.getValue();
        if (key.isReferences() && obj instanceof ExtColumn) {
            col = (ExtColumn)obj;
        } else {
            int pos = cols.search(key.toString().toUpperCase());
            if (pos < 0) {
                ExprErr.goError(16L, "Invalid Key: " + key);
            }
            col = (ExtColumn)cols.get(pos);
        }
        if (col.getDataType() != keyType && keyType > -1) {
            ExprErr.goError(16L, "Invalid Key Type: " + key);
        }
        return col;
    }

    public Variant UNION(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExtDataSet dds;
        ExcelFuncProvider.validParamCount(args, 2, Integer.MAX_VALUE);
        ExcelFuncProvider.calcLast(ctx);
        ObjectArray aGroups = new ObjectArray(args.length);
        for (int i = 1; i < args.length; ++i) {
            this._getGroupFromVars(aGroups, (Variant)args[i]);
        }
        Object[] groups = new ExtGroup[aGroups.size()];
        aGroups.toArray(groups, 0);
        int groupCount = groups.length;
        if (groupCount < 1) {
            dds = ExtDataSet.EMPTY_DATASET;
        } else {
            Variant[][] data;
            int j;
            Object group = groups[0];
            int rowCount = ((ExtGroup)group).size();
            ExtDataSet baseDS = ((ExtGroup)group).getDataSet();
            boolean isDynamic = baseDS instanceof ExtDynamicDataSet;
            boolean sameDS = true;
            ExtColumn[] baseCols = baseDS.getColumnsArray();
            for (int i = 1; i < groupCount; ++i) {
                boolean equalCols;
                group = groups[i];
                ExtDataSet ds = ((ExtGroup)group).getDataSet();
                ExtColumn[] cols = ds.getColumnsArray();
                if (cols.length != baseCols.length) {
                    equalCols = false;
                } else {
                    isDynamic |= ds instanceof ExtDynamicDataSet;
                    if (baseDS != ds) {
                        sameDS = false;
                    }
                    rowCount += ((ExtGroup)group).size();
                    equalCols = true;
                    for (j = 0; j < baseCols.length; ++j) {
                        if (cols[j].getDataType() == baseCols[j].getDataType()) continue;
                        equalCols = false;
                        break;
                    }
                }
                if (equalCols) continue;
                ExprErr.goError(16L, "Not Same Columns: " + i);
            }
            boolean unionAll = ((Variant)args[0]).booleanValue();
            if (unionAll) {
                data = new Variant[rowCount][];
                int d2 = 0;
                for (int i = 0; i < groupCount; ++i) {
                    group = groups[i];
                    ExtRow[] rows = ((ExtGroup)group).getRows();
                    ExtDataSet ds = ((ExtGroup)group).getDataSet();
                    int j2 = ((ExtGroup)group).getFrom();
                    int jEnd = ((ExtGroup)group).getTo();
                    while (j2 < jEnd) {
                        ExtRow row = rows[j2];
                        data[d2] = ds.getRowData(row.index());
                        ++j2;
                        ++d2;
                    }
                }
            } else {
                int i;
                SortedObjectArray sa = sameDS && !isDynamic ? new SortedExtRowIndexArray(rowCount) : new SortedExtRowValuesArray(rowCount);
                for (i = 0; i < groupCount; ++i) {
                    group = groups[i];
                    ExtRow[] rows = ((ExtGroup)group).getRows();
                    int jEnd = ((ExtGroup)group).getTo();
                    for (j = ((ExtGroup)group).getFrom(); j < jEnd; ++j) {
                        sa.insert(rows[j]);
                    }
                }
                rowCount = sa.size();
                data = new Variant[rowCount][];
                for (i = 0; i < rowCount; ++i) {
                    ExtRow row = (ExtRow)sa.get(i);
                    data[i] = row.getDataSet().getRowData(row.index());
                }
            }
            ExtDynamicDataSet key = ExtDynamicDataSet.getExtDynamicDataSet(baseDS, null);
            key.setColumns(baseDS.getColumns());
            key.setData(data);
            ExtDataSetManager dsm = baseDS.getBook().getDataSetManager();
            dds = dsm.addDynamicDataSet(key);
        }
        return dds.getVarThis();
    }

    public Variant DS(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, Integer.MAX_VALUE);
        Variant var = (Variant)args[0];
        Variant varRet = null;
        if (args.length == 1 && !var.isArray()) {
            Cell cll;
            ExtGroup group;
            Object obj = var.getValue();
            if (!(var.isReferences() && obj instanceof CellBlockNode && ((CellBlockNode)obj).isSingleCell())) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("nonCellPosition", "\u975e\u5355\u5143\u683c\u5b9a\u4f4d"));
            }
            if (null != (group = this._getGroupFromCell(cll = ((CellBlockNode)obj).getFirstCell(false), true))) {
                varRet = group.getDataSet().getVarThis();
            }
        } else {
            ICalculable exprOwner = ExcelFuncProvider.calcLast(ctx);
            Object[][] dataRanges = new Object[args.length][5];
            Variant[] array = null;
            for (int i = 0; i < args.length; ++i) {
                var = (Variant)args[i];
                if (!var.isArray() || (array = (Variant[])var.getValue()).length < 2) {
                    ExprErr.goError(16L, CtrlEXTMessages.getMLS("dataDescription", "\u6570\u636e\u63cf\u8ff0"));
                }
                dataRanges[i] = this._getDataBlocks(array);
            }
            ObjectArray fieldNames = ctx.getBuffer().getObjectArray(dataRanges.length);
            int[] size = new int[1];
            this._checkDataRanges(dataRanges, fieldNames, size);
            int rows = size[0];
            int fields = fieldNames.size();
            Variant[][] dataArray = new Variant[rows][fields];
            int xPos = 0;
            for (int i = 0; i < dataRanges.length; ++i) {
                xPos = this._getDataFromCBs(dataRanges[i], dataArray, xPos);
            }
            Book book = exprOwner.getSheet().getBook();
            ExtDynamicDataSet dds = ExtDynamicDataSet.getExtDynamicDataSet(book, "Inner", "", ExtDataSetType.TXT, null);
            SortedObjectArray cols = new SortedObjectArray(fields);
            for (int i = 0; i < fields; ++i) {
                ExtColumn col = new ExtColumn(dds, (String)fieldNames.get(i), i, 0);
                cols.insert(col);
            }
            dds.setColumns(cols);
            ctx.getBuffer().recycleArray(fieldNames);
            dds.setData(dataArray);
            dds = book.getDataSetManager().addDynamicDataSet(dds);
            varRet = dds.getVarThis();
        }
        return varRet;
    }

    private Object[] _getDataBlocks(Variant[] array) throws SyntaxErrorException {
        boolean[] xDirs;
        int dataFields;
        CellBlockNode[] dataCBs;
        Variant varXDir;
        String[] fieldNames = this._getFieldNames(array[1]);
        Variant varRange = array[0];
        Variant variant = varXDir = array.length > 2 ? array[2].getVariant() : Variant.nullVariant;
        if (varRange.isReferences()) {
            CellBlockNode cb;
            Object obj = varRange.getValue();
            if (!(obj instanceof CellBlockNode)) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("dataPositionNotNonCellArea", "\u6570\u636e\u5b9a\u4f4d\u975e\u5355\u5143\u533a\u57df") + varRange);
            }
            if (obj instanceof CellBlock3DNode) {
                CellBlock3DNode cb3 = (CellBlock3DNode)obj;
                Sheet sheet = cb3.getSheet();
                Book book = sheet.getBook();
                dataCBs = new CellBlockNode[cb3.getSheetCount()];
                int i = 0;
                int sh = sheet.getIndex();
                while (i < dataCBs.length) {
                    dataCBs[i] = CellBlockNode.getCellBlockNode(book.getSheet(sh), cb3, 0);
                    ++i;
                    ++sh;
                }
                cb = cb3;
            } else {
                cb = (CellBlockNode)obj;
                dataCBs = new CellBlockNode[]{cb};
            }
            boolean xDir = varXDir.booleanValue();
            int n = dataFields = xDir ? cb.getHeight() : cb.getWidth();
            if (fieldNames.length != dataFields) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("dataAreaFieldNameMismatch", "\u6570\u636e\u533a\u57df\u4e0e\u5b57\u6bb5\u540d\u4e0d\u5339\u914d:") + " Data=" + dataFields + ", Fields=" + fieldNames.length);
            }
            xDirs = new boolean[]{xDir};
        } else {
            int i;
            if (!varRange.isArray()) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("dataPositionNotNonCellArray", "\u6570\u636e\u5b9a\u4f4d\u975e\u5355\u5143\u533a\u57df\u6570\u7ec4") + varRange);
            }
            Variant[] varBlocks = (Variant[])varRange.getValue();
            dataCBs = new CellBlockNode[varBlocks.length];
            xDirs = new boolean[varBlocks.length];
            if (varXDir.isArray()) {
                Variant[] dirs = (Variant[])varXDir.getValue();
                int iEnd = Math.min(xDirs.length, dirs.length);
                for (i = 0; i < iEnd; ++i) {
                    xDirs[i] = dirs[i].booleanValue();
                }
            } else if (varXDir.booleanValue()) {
                Arrays.fill(xDirs, true);
            }
            Object obj = null;
            dataFields = -1;
            for (i = 0; i < varBlocks.length; ++i) {
                Variant var = varBlocks[i];
                if (!var.isReferences() || !((obj = var.getValue()) instanceof CellBlockNode)) {
                    ExprErr.goError(16L, CtrlEXTMessages.getMLS("nonCellArea", "\u975e\u5355\u5143\u533a\u57df") + var);
                }
                CellBlockNode cb = (CellBlockNode)obj;
                if (dataFields < 0) {
                    dataFields = xDirs[i] ? cb.getHeight() : cb.getWidth();
                } else if ((xDirs[i] ? cb.getHeight() : cb.getWidth()) != dataFields) {
                    ExprErr.goError(16L, CtrlEXTMessages.getMLS("cellFieldSizeMismatch", "\u5355\u5143\u57df\u5c3a\u5bf8\u6709\u5dee\u5f02\uff1a") + cb);
                }
                dataCBs[i] = cb;
            }
        }
        if (fieldNames.length != dataFields) {
            ExprErr.goError(16L, CtrlEXTMessages.getMLS("dataAreaFieldNameMismatch", "\u6570\u636e\u533a\u57df\u4e0e\u5b57\u6bb5\u540d\u4e0d\u5339\u914d:") + " Data=" + dataFields + ", Fields=" + fieldNames.length);
        }
        Object[] blockValues = null;
        String blockValueName = null;
        if (array.length > 3) {
            Variant varBlockValue;
            if (array.length != 5) {
                ExprErr.goError(8L, CtrlEXTMessages.getMLS("additionalDataField", "\u9644\u52a0\u6570\u636e\u5b57\u6bb5"));
            }
            if (!(varBlockValue = array[3].getVariant()).isNull()) {
                if (varBlockValue.isArray()) {
                    blockValues = (Variant[])varBlockValue.getValue();
                    if (blockValues.length != dataCBs.length) {
                        ExprErr.goError(8L, CtrlEXTMessages.getMLS("additionalDataMismatchSourceDataBlock", "\u9644\u52a0\u6570\u636e\u4e0e\u6e90\u6570\u636e\u5757\u4e0d\u5339\u914d"));
                    }
                } else {
                    blockValues = new Variant[dataCBs.length];
                    Arrays.fill(blockValues, varBlockValue);
                }
                blockValueName = array[4].getVariant().toString();
            }
        }
        return new Object[]{dataCBs, fieldNames, xDirs, blockValues, blockValueName};
    }

    private String[] _getFieldNames(Variant varFields) throws SyntaxErrorException {
        String[] fieldNames;
        if (varFields.isReferences()) {
            int height;
            Object obj = varFields.getValue();
            if (!(obj instanceof CellBlockNode)) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("fieldNameNonCellAreaPosition", "\u5b57\u6bb5\u540d\u975e\u5355\u5143\u533a\u57df\u5b9a\u4f4d"));
            }
            CellBlockNode cbFields = (CellBlockNode)obj;
            Sheet sheet = cbFields.getSheet();
            int width = cbFields.getWidth();
            if (width > (height = cbFields.getHeight())) {
                fieldNames = new String[width];
                Row rowObj = sheet.getRow(cbFields.getRow(), false);
                int i = 0;
                int col = cbFields.getCol();
                while (i < fieldNames.length) {
                    Cell cll = sheet.getCell(rowObj, col, false);
                    fieldNames[i] = cll == null ? String.valueOf(i + 1) : cll.getValue().toString();
                    ++i;
                    ++col;
                }
            } else {
                fieldNames = new String[height];
                int col = cbFields.getCol();
                int i = 0;
                int row = cbFields.getRow();
                while (i < fieldNames.length) {
                    Cell cll = sheet.getCell(row, col, false);
                    fieldNames[i] = cll == null ? String.valueOf(i + 1) : cll.getValue().toString();
                    ++i;
                    ++row;
                }
            }
        } else {
            if (!(varFields = varFields.getVariant()).isArray()) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("fieldNameNonArrayDefinition", "\u5b57\u6bb5\u540d\u975e\u6570\u7ec4\u5b9a\u4e49"));
            }
            Variant[] vars = (Variant[])varFields.getValue();
            fieldNames = new String[vars.length];
            for (int i = 0; i < vars.length; ++i) {
                fieldNames[i] = vars[i].toString();
            }
        }
        return fieldNames;
    }

    private void _checkDataRanges(Object[][] dataRanges, ObjectArray filedNames, int[] size) throws SyntaxErrorException {
        int rows = -1;
        for (int i = 0; i < dataRanges.length; ++i) {
            Object[] array = dataRanges[i];
            int thisRows = 0;
            CellBlockNode[] blocks = (CellBlockNode[])array[0];
            boolean[] xDirs = (boolean[])array[2];
            for (int j = 0; j < blocks.length; ++j) {
                CellBlockNode block = blocks[j];
                thisRows += xDirs[j] ? block.getWidth() : block.getHeight();
            }
            if (rows < 0) {
                rows = thisRows;
            } else if (thisRows != rows) {
                ExprErr.goError(512L, CtrlEXTMessages.getMLS("dataAreaSizeMismatch", "\u6570\u636e\u533a\u57df\u5c3a\u5bf8\u4e0d\u5339\u914d"));
            }
            filedNames.appendAll((String[])array[1]);
            if (array[4] == null) continue;
            filedNames.append(array[4]);
        }
        size[0] = rows;
    }

    private int _getDataFromCBs(Object[] array, Variant[][] dataArray, int xPos) {
        CellBlockNode[] blocks = (CellBlockNode[])array[0];
        boolean[] xDirs = (boolean[])array[2];
        Variant[] blockValues = (Variant[])array[3];
        Book book = blocks[0].getSheet().getBook();
        int yPos = 0;
        int xOffset = 0;
        for (int b2 = 0; b2 < blocks.length; ++b2) {
            int extWidth;
            int extHeight;
            Object[] rowData;
            Variant attachedValue;
            CellBlockNode block = blocks[b2];
            Sheet sheet = block.getSheet();
            SortedCellBlockArray merges = sheet.getTouchedMergeBlocks(block);
            Variant variant = attachedValue = blockValues == null ? null : blockValues[b2];
            if (!xDirs[b2]) {
                int col = block.getCol();
                int col2 = block.getCol2() + 1;
                int rEnd = block.getRow2() + 1;
                for (int r = block.getRow(); r < rEnd; ++r) {
                    rowData = dataArray[yPos++];
                    Row rowObj = sheet.getRow(r, false);
                    if (rowObj == null) {
                        Arrays.fill(rowData, Variant.nullVariant);
                        continue;
                    }
                    int i = xPos;
                    int c2 = col;
                    while (c2 < col2) {
                        int len;
                        Variant value = null;
                        CellBlock mergeBlock = null;
                        Cell cll = sheet.getCell(rowObj, c2, false);
                        if (cll == null) {
                            if (merges != null) {
                                mergeBlock = merges.searchBlock(r, c2);
                                if (mergeBlock != null) {
                                    value = sheet.getFirstCell(mergeBlock, false).getValue();
                                    mergeBlock = null;
                                } else {
                                    value = Variant.nullVariant;
                                }
                            }
                        } else {
                            value = cll.getValue();
                            ExtProps ep = cll.getExtProps(false);
                            if (ep != null) {
                                extHeight = ep.getHeight();
                                extWidth = ep.getWidth();
                                if (extHeight != 0 || extWidth != 0) {
                                    mergeBlock = CellBlock.getCellBlock(r, c2, r + extHeight, c2 + extWidth);
                                }
                            } else {
                                mergeBlock = cll.getMerge(false);
                            }
                        }
                        if (value != null && rowData[i] == null) {
                            rowData[i] = book.getBufferedVariant(value);
                        }
                        if (mergeBlock != null && (len = Math.min(mergeBlock.getCol2() + 1, col2) - c2) > 0) {
                            int jEnd = mergeBlock.getHeight();
                            for (int j = 0; j < jEnd; ++j) {
                                Object[] rData = dataArray[yPos - 1 + j];
                                Arrays.fill(rData, i, i + len, value);
                            }
                            c2 += --len;
                            i += len;
                        }
                        ++c2;
                        ++i;
                    }
                    if (attachedValue == null) continue;
                    rowData[i] = attachedValue;
                }
                xOffset = col2 - col;
                continue;
            }
            int row = block.getRow();
            int row2 = block.getRow2() + 1;
            int cEnd = block.getCol2() + 1;
            for (int c3 = block.getCol(); c3 < cEnd; ++c3) {
                rowData = dataArray[yPos++];
                int i = xPos;
                int r = row;
                while (r < row2) {
                    int len;
                    Variant value = null;
                    CellBlock mergeBlock = null;
                    Cell cll = sheet.getCell(r, c3, false);
                    if (cll == null) {
                        if (merges != null) {
                            mergeBlock = merges.searchBlock(r, c3);
                            if (mergeBlock != null) {
                                value = sheet.getFirstCell(mergeBlock, false).getValue();
                                mergeBlock = null;
                            } else {
                                value = Variant.nullVariant;
                            }
                        }
                    } else {
                        value = cll.getValue();
                        ExtProps ep = cll.getExtProps(false);
                        if (ep != null) {
                            extHeight = ep.getHeight();
                            extWidth = ep.getWidth();
                            if (extHeight != 0 || extWidth != 0) {
                                mergeBlock = CellBlock.getCellBlock(r, c3, r + extHeight, c3 + extWidth);
                            }
                        } else {
                            mergeBlock = cll.getMerge(false);
                        }
                    }
                    if (value != null && rowData[i] == null) {
                        rowData[i] = book.getBufferedVariant(value);
                    }
                    if (mergeBlock != null && (len = Math.min(mergeBlock.getRow2() + 1, row2) - r) > 0) {
                        int jEnd = mergeBlock.getWidth();
                        for (int j = 0; j < jEnd; ++j) {
                            Object[] rData = dataArray[yPos - 1 + j];
                            Arrays.fill(rData, i, i + len, value);
                        }
                        r += --len;
                        i += len;
                    }
                    ++r;
                    ++i;
                }
                if (attachedValue == null) continue;
                rowData[i] = attachedValue;
            }
            xOffset = row2 - row;
        }
        return xPos + xOffset + (blockValues == null ? 0 : 1);
    }

    public Variant V(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant varRet;
        ExcelFuncProvider.validParamCount(args, 1, 2);
        int index = 0;
        Variant var = (Variant)args[0];
        if (!var.isNumeric(var) || (index = var.intValue() - 1) < 0 || index > 7) {
            ExprErr.goError(16L, "Invalid Index");
        }
        Variant[] vars = ctx.getVars();
        if (args.length == 1) {
            varRet = vars[index];
        } else {
            vars[index] = varRet = (Variant)args[1];
        }
        return varRet;
    }

    public Variant DISP(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant ret;
        ExcelFuncProvider.validParamCount(args, 0, 1);
        if (args.length == 0) {
            ICalculable owner = ctx.getExprOwner();
            ret = owner instanceof Cell ? new Variant(((Cell)owner).getText(), 11) : owner.getValue();
        } else {
            Object obj;
            Variant var = (Variant)args[0];
            if (var.isReferences() && (obj = var.getValue()) instanceof CellBlockNode) {
                CellBlockNode cb = (CellBlockNode)obj;
                Cell cll = cb.getFirstCell(false);
                ret = Variant.nullVariant;
                if (cll != null) {
                    ICalculable owner = ctx.getExprOwner();
                    if (owner == cll) {
                        ret = new Variant(((Cell)owner).getText(), 11);
                    } else {
                        int pos;
                        SortedExtPropFormulasArray formulas = cll.getExtProps(false).getFormulas(false);
                        if (formulas != null && (pos = formulas.search(ExtConst.FORMULA_DISP_VALUE)) >= 0) {
                            ICalculableProps node = (ICalculableProps)formulas.get(pos);
                            Variant value = node.calc(ctx, cll);
                            node.getAction().action(cll, value);
                        }
                        ret = new Variant(cll.getText(), 11);
                    }
                }
            } else {
                ret = var.isPending() ? var : new Variant(var.toString(), 11);
            }
        }
        return ret;
    }

    public Variant CELL(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        int col;
        int row;
        Sheet sheet;
        Cell dstCell;
        Cell srcCell;
        ExcelFuncProvider.validParamCount(args, 0, 3);
        ICalculable owner = ctx.getExprOwner();
        Object varCll = args[0];
        if (varCll instanceof Variant && ((Variant)varCll).isNull()) {
            if (!(owner instanceof Cell)) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("parameterNotCell", "\u53c2\u6570\u975e\u5355\u5143\u683c:") + owner);
            }
            srcCell = (Cell)owner;
        } else {
            srcCell = this.getValidExtProps(ctx, varCll).getCell();
        }
        int rowOffset = 0;
        int colOffset = 0;
        if (args.length > 1) {
            rowOffset = this.getValidCoorOffset(ctx, args[1], true);
            if (args.length > 2) {
                colOffset = this.getValidCoorOffset(ctx, args[2], true);
            }
        }
        if ((dstCell = (sheet = srcCell.getSheet()).getCell(row = srcCell.getRow() + rowOffset, col = srcCell.getCol() + colOffset, false)) != null) {
            sheet.getDeps().calcReferTo(owner, dstCell);
        }
        CellBlockNode cb = CellBlockNode.getCellBlockNode(sheet, row, col, row, col, 0);
        cb = sheet.setDependent(owner, cb);
        return new Variant(cb, 18);
    }

    public Variant ARRANGE(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant varSrc = (Variant)args[0];
        if (!varSrc.isArray()) {
            ExprErr.goError(16L, "Not Array");
        }
        Variant ret = varSrc;
        Variant[] srcVarArray = (Variant[])varSrc.getValue();
        if (srcVarArray.length >= 2) {
            Variant first;
            boolean toMatrix = true;
            if (args.length > 1) {
                boolean bl = toMatrix = args[1].toString().compareToIgnoreCase("Matrix") == 0;
            }
            if ((first = srcVarArray[0]).isArray()) {
                if (toMatrix) {
                    // empty if block
                }
            } else if (toMatrix) {
                int i;
                if (!first.isReferences() && !(first.getValue() instanceof CellBlockNode)) {
                    ExprErr.goError(16L, "Not CellBlock");
                }
                CellBlockMatrix matrix = new CellBlockMatrix();
                for (i = 0; i < srcVarArray.length; ++i) {
                    CellBlock cb = (CellBlock)srcVarArray[i].getValue();
                    if (matrix.addBlock(cb)) continue;
                    ExprErr.goError(16L, "Invalid CellBlock");
                }
                CellBlock[][] aaBlocks = matrix.getMatrix();
                Variant[] varArray2D = new Variant[aaBlocks.length];
                for (i = 0; i < varArray2D.length; ++i) {
                    CellBlock[] src = aaBlocks[i];
                    Variant[] dst = new Variant[src.length];
                    for (int j = 0; j < dst.length; ++j) {
                        CellBlock obj = src[j];
                        dst[j] = obj == null ? Variant.nullVariant : ((CellBlockNode)obj).getVarThis();
                    }
                    varArray2D[i] = new Variant(dst, 527);
                }
                ret = new Variant(varArray2D, 527);
            }
        }
        return ret;
    }

    public Variant EXINDEX(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        int count;
        boolean isLeft;
        ExcelFuncProvider.validParamCount(args, 0, 2);
        ICalculable owner = ctx.getExprOwner();
        if (!(owner instanceof Cell)) {
            ExprErr.goError(2048L, CtrlEXTMessages.getMLS("cellFormulaOnlyContainsThisFunction", "\u5355\u5143\u683c\u516c\u5f0f\u624d\u53ef\u5305\u542b\u672c\u51fd\u6570"));
        }
        Cell exprOwner = (Cell)owner;
        ExtProps epDst = exprOwner.getExtProps(false);
        ExtProps epDim = args.length == 0 || ((Variant)args[0]).isNull() ? epDst : this.getValidExtProps(ctx, args[0]);
        boolean bl = isLeft = epDim.getExtensible(true) == 2;
        if (!epDim.isHeadOf(epDst, isLeft)) {
            ExprErr.goError(262144L, CtrlEXTMessages.getMLS("notParentDimension", "#1\u975e#2\u7236\u7ef4").replace("#1", this.getCellName(epDim)).replace("#2", this.getCellName(epDst)));
        }
        if (args.length < 2) {
            if (epDim == epDst) {
                epDim = epDim.getHead(isLeft, false);
            }
            return new Variant(epDim.getExtIndex() + 1);
        }
        Variant var = (Variant)args[1];
        ExtProps epRange = var.isNull() ? epDim : this.getValidExtProps(ctx, var);
        if (epRange == epDim) {
            count = 1;
        } else {
            int headLevels = epRange.headLevelOf(epDim, isLeft);
            if (headLevels < 0) {
                ExprErr.goError(262144L, CtrlEXTMessages.getMLS("notParentDimension", "#1\u975e#2\u7236\u7ef4").replace("#1", this.getCellName(epRange)).replace("#2", this.getCellName(epDim)));
            }
            ExtProps[] dims = new ExtProps[headLevels];
            ExtProps epHead = epDim;
            while (headLevels != 0) {
                dims[--headLevels] = epHead;
                epHead = epHead.getHead(isLeft, true);
            }
            int[] aCount = new int[1];
            try {
                this._occurs(dims[0], epDim.getHead(isLeft, true), dims, 0, isLeft, aCount);
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
            count = aCount[0];
        }
        return new Variant(count);
    }

    private void _occurs(ExtProps epFrom, ExtProps epDstHead, ExtProps[] dims, int from, boolean yDir, int[] count) throws SyntaxErrorException {
        if (from == dims.length - 1) {
            if (epFrom.getHead(yDir, true) == epDstHead) {
                count[0] = count[0] + (dims[from].getExtIndex() + 1);
                throw SyntaxErrorException.BAD_QUERY;
            }
            SortedExtPropsArray exts = epFrom.getExts();
            count[0] = count[0] + (exts == null ? 1 : exts.size());
        } else {
            ExtProps epChild = dims[from + 1];
            SortedExtPropsArray exts = epFrom.getExts();
            if (exts == null) {
                epFrom = epFrom.getSubBySource(epChild, yDir);
                this._occurs(epFrom, epDstHead, dims, from + 1, yDir, count);
            } else {
                int iEnd = exts.size();
                for (int i = 0; i < iEnd; ++i) {
                    epFrom = (ExtProps)exts.get(i);
                    epFrom = epFrom.getSubBySource(epChild, yDir);
                    this._occurs(epFrom, epDstHead, dims, from + 1, yDir, count);
                }
            }
        }
    }

    public Variant EX(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        return this._ex(ctx, args, false);
    }

    public Variant EXS(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        return this._ex(ctx, args, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Variant _ex(ExprContext ctx, Object[] args, boolean returnRange) throws SyntaxErrorException {
        ExtProps epDst;
        ExcelFuncProvider.validParamCount(args, 1, returnRange ? 4 : 3);
        Variant varRet = Variant.nullVariant;
        ObjectArray yDims = null;
        ObjectArray xDims = null;
        IExprBuffer buffer = ctx.getBuffer();
        ICalculable exprOwner = ExcelFuncProvider.calcLast(ctx);
        Expr filterExpr = null;
        if (returnRange && args.length == 4) {
            Variant value = (Variant)args[3];
            if (value.getValue() instanceof Expr) {
                filterExpr = (Expr)value.getValue();
            } else {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("filterExpression", "\u8fc7\u6ee4\u8868\u8fbe\u5f0f"));
            }
        }
        ExtProps epOwner = exprOwner instanceof Cell ? ((Cell)exprOwner).getExtProps(false) : exprOwner.getSheet().LEFT00;
        Variant varY = Variant.nullVariant;
        Variant varX = Variant.nullVariant;
        boolean all = false;
        Variant varDst = (Variant)args[0];
        boolean referSelf = varDst.isArray();
        int dimIndex = 1;
        if (referSelf || varDst.isNull()) {
            epDst = epOwner;
            if (referSelf) {
                dimIndex = 0;
            }
        } else {
            epDst = this.getValidExtProps(ctx, varDst);
        }
        Sheet dstSheet = epDst.getSheet();
        if (args.length > dimIndex) {
            varY = this.checkDimVar(ctx, dstSheet, (Variant)args[dimIndex++]);
            if (args.length > dimIndex) {
                varX = this.checkDimVar(ctx, dstSheet, (Variant)args[dimIndex]);
            }
        }
        if (varY.isNull() && varX.isNull()) {
            if (epDst == epOwner) {
                ExprErr.goError(32768L, null);
            } else {
                all = true;
            }
        }
        if (!varX.isNull()) {
            xDims = this.getDimsFromVar(buffer, epDst, varX, false, returnRange);
        } else if (returnRange) {
            xDims = this.createDefaultDims(buffer, epOwner, epDst, false, all);
        }
        if (!varY.isNull()) {
            yDims = this.getDimsFromVar(buffer, epDst, varY, true, returnRange);
        } else if (returnRange) {
            yDims = this.createDefaultDims(buffer, epOwner, epDst, true, all);
        }
        if (returnRange) {
            IExprNode[] extPosParams = null;
            if (filterExpr != null && (extPosParams = filterExpr.getAllExprExtPosNodes()) != null) {
                for (int i = 0; i < extPosParams.length; ++i) {
                    ((ExprExtPos)extPosParams[i]).setExprOwner(epOwner);
                }
            }
            IntArray xCoors = this.getCoors(buffer, xDims, epDst, false);
            IntArray yCoors = this.getCoors(buffer, yDims, epDst, true);
            IntArray xSpans = this.getCoorSpans(buffer, xCoors);
            IntArray ySpans = this.getCoorSpans(buffer, yCoors);
            buffer.recycleArray(yCoors);
            buffer.recycleArray(xCoors);
            ObjectArray blocks = buffer.getObjectArray(xSpans.size() * ySpans.size() / 4);
            try {
                boolean traceMode = ctx.isTraceMode();
                ctx.setTraceMode(false);
                int yEnd = ySpans.size();
                for (int y = 0; y < yEnd; y += 2) {
                    int row = ySpans.get(y);
                    int row2 = ySpans.get(y + 1);
                    int xEnd = xSpans.size();
                    for (int x = 0; x < xEnd; x += 2) {
                        CellBlockNode cb = CellBlockNode.getCellBlockNode(dstSheet, row, xSpans.get(x), row2, xSpans.get(x + 1), 0);
                        if (filterExpr == null) {
                            cb = dstSheet.setDependent(exprOwner, cb);
                            blocks.append(new Variant(cb, 18));
                            continue;
                        }
                        if (cb.isSingleCell()) {
                            Cell cll = cb.getFirstCell(false);
                            if (cll == null || !filterExpr.execute(ctx, cll).booleanValue()) continue;
                            cb = dstSheet.setDependent(exprOwner, cb);
                            blocks.append(new Variant(cb, 18));
                            continue;
                        }
                        Sheet.ICellsIterator ci = dstSheet.getCellsIterator(cb, false, false);
                        while (ci.hasNext()) {
                            Cell cll = ci.next();
                            if (!filterExpr.execute(ctx, cll).booleanValue()) continue;
                            int cllRow = cll.getRow();
                            int cllCol = cll.getCol();
                            cb = CellBlockNode.getCellBlockNode(dstSheet, cllRow, cllCol, cllRow, cllCol, 0);
                            cb = dstSheet.setDependent(exprOwner, cb);
                            blocks.append(new Variant(cb, 18));
                        }
                    }
                }
                ctx.setTraceMode(traceMode);
                int size = blocks.size();
                if (size == 1) {
                    varRet = ((CellBlockNode)((Variant)blocks.get(0)).getValue()).getVarThis();
                }
                Object[] a = new Variant[blocks.size()];
                blocks.toArray(a, 0);
                varRet = new Variant(a, 527);
            }
            finally {
                if (extPosParams != null) {
                    for (int i = 0; i < extPosParams.length; ++i) {
                        ((ExprExtPos)extPosParams[i]).setExprOwner(null);
                    }
                }
                buffer.recycleArray(xSpans);
                buffer.recycleArray(ySpans);
                buffer.recycleArray(blocks);
            }
        } else {
            ExtProps yCoor = epDst;
            ExtProps xCoor = epDst;
            if (!(xDims != null && (xCoor = this.getFirstDim(ctx, xDims, epDst, false)) == null || yDims != null && (yCoor = this.getFirstDim(ctx, yDims, epDst, true)) == null)) {
                int row = yCoor.getRow();
                int col = xCoor.getCol();
                CellBlockNode cbDst = CellBlockNode.getCellBlockNode(dstSheet, row, col, row, col, 0);
                Cell referTo = (cbDst = dstSheet.setDependent(exprOwner, cbDst)).getFirstCell(false);
                if (referTo != null) {
                    ctx.getDeps().calcReferTo(exprOwner, referTo);
                }
                varRet = cbDst.getVarThis();
            }
        }
        if (yDims != null) {
            buffer.recycleArray(yDims);
        }
        if (xDims != null) {
            buffer.recycleArray(xDims);
        }
        return varRet;
    }

    private Variant checkDimVar(ExprContext ctx, Sheet dstSheet, Variant var) throws SyntaxErrorException {
        block4: {
            block5: {
                Object value;
                block7: {
                    block6: {
                        if (var.isNull()) break block4;
                        if (var.isArray()) break block5;
                        if (var.getValue() instanceof Expr) {
                            var = Expr.execute(ctx, var);
                        }
                        if (!var.isArray()) break block6;
                        this.checkDimVar(ctx, dstSheet, var);
                        break block4;
                    }
                    value = var.getValue();
                    if (value instanceof Level) break block7;
                    ExprErr.goError(16L, CtrlEXTMessages.getMLS("dimensionParameter", "\u7ef4\u5ea6\u53c2\u6570"));
                    break block4;
                }
                ExtProps ep = ((Level)value).dim;
                if (ep.isCell00() || ep.getSheet() == dstSheet) break block4;
                ExprErr.goError(16L, "Different Sheet");
                break block4;
            }
            Variant[] levels = (Variant[])var.getValue();
            if (levels.length == 0) {
                var.setVariant(Variant.nullVariant);
            } else {
                for (int i = 0; i < levels.length; ++i) {
                    this.checkDimVar(ctx, dstSheet, levels[i]);
                }
            }
        }
        return var;
    }

    private IntArray getCoorSpans(IExprBuffer buffer, IntArray coors) {
        IntArray spans = buffer.getIntArray();
        int size = coors.size();
        if (size > 0) {
            int top = coors.get(0);
            spans.add(top);
            spans.add(top);
            for (int i = 1; i < size; ++i) {
                int next = coors.get(i);
                if (next == top + 1) {
                    spans.set(spans.size() - 1, next);
                } else {
                    spans.add(next);
                    spans.add(next);
                }
                top = next;
            }
        }
        return spans;
    }

    private ObjectArray createDefaultDims(IExprBuffer buffer, ExtProps epOwner, ExtProps epDst, boolean vDir, boolean all) {
        ObjectArray aDims = buffer.getObjectArray(-1);
        if (all) {
            int dims;
            ExtProps epFrom = epOwner.getHead(vDir, true);
            if (epFrom == null) {
                Sheet sheet = epDst.getSheet();
                ExtProps extProps = epFrom = vDir ? sheet.LEFT00 : sheet.TOP00;
            }
            if ((dims = epFrom.headLevelOf(epDst, vDir)) < 0) {
                Sheet sheet = epDst.getSheet();
                dims = (vDir ? sheet.LEFT00 : sheet.TOP00).headLevelOf(epDst, vDir);
            }
            if (dims > 0) {
                aDims.ensureCapacity(dims);
                for (ExtProps epHead = epDst; epHead != epFrom && !epHead.isCell00(); epHead = epHead.getHead(vDir, true)) {
                    aDims.set(--dims, new Level(epHead, Integer.MAX_VALUE, false));
                }
            } else {
                aDims.append(new Level(epDst, Integer.MAX_VALUE, false));
            }
        } else {
            aDims.append(new Level(epDst, 0, false));
        }
        return aDims;
    }

    private ExtProps getFirstDim(ExprContext ctx, ObjectArray aDims, ExtProps epDst, boolean isLeft) throws SyntaxErrorException {
        Dependents deps = ctx.getDeps();
        ICalculable owner = ctx.getExprOwner();
        ExtProps dim = null;
        int size = aDims.size();
        for (int i = 0; i < size; ++i) {
            SortedExtPropsArray nextExts;
            Level lvl = (Level)aDims.get(i);
            dim = lvl.dim;
            Cell cll = dim.getCell();
            if (cll != null) {
                deps.calcReferTo(owner, cll);
            }
            SortedExtPropsArray exts = dim.getExts();
            while (exts == null && (dim = dim.getHead(isLeft, false)) != null && !dim.isCell00()) {
                exts = dim.getExts();
            }
            int pos = lvl.pos;
            if (pos == Integer.MIN_VALUE) {
                if (null != dim && !dim.isHeadOf(epDst, isLeft) && exts != null) {
                    int fEnd = exts.size();
                    for (int f = 0; f < fEnd; ++f) {
                        ExtProps ep = (ExtProps)exts.get(f);
                        if (!ep.isHeadOf(epDst, isLeft)) continue;
                        dim = ep;
                        break;
                    }
                }
            } else {
                if (pos == Integer.MAX_VALUE) {
                    pos = 0;
                } else if (lvl.relative && null != dim) {
                    int base = dim.getExtIndex();
                    pos += base;
                }
                if (pos < 0 || exts != null && pos >= exts.size()) {
                    return null;
                }
                if (exts != null) {
                    dim = (ExtProps)exts.get(pos);
                }
            }
            if (i >= size - 1) continue;
            Level lvlNext = (Level)aDims.get(i + 1);
            ExtProps nextDim = lvlNext.dim;
            if (null == dim || dim.isHeadOf(nextDim, isLeft)) continue;
            int p = nextDim.getExtIndex();
            int headPos = dim.getExtIndex();
            ExtProps sub = dim.getSubBySource(nextDim, isLeft);
            SortedExtPropsArray sortedExtPropsArray = nextExts = sub == null ? null : sub.getExts();
            if (nextExts != null) {
                dim = (ExtProps)nextExts.get(p);
            } else if (lvlNext.pos == Integer.MAX_VALUE) {
                lvlNext.pos = headPos;
            }
            lvlNext.dim = dim;
        }
        if (dim == null) {
            return null;
        }
        ExtProps ret = dim.getSubBySource(epDst, isLeft);
        while (ret == null && (epDst = epDst.getHead(isLeft, false)) != null) {
            ret = dim.getSubBySource(epDst, isLeft);
        }
        return ret;
    }

    private IntArray getCoors(IExprBuffer buffer, ObjectArray aDims, ExtProps epDst, boolean vDir) throws SyntaxErrorException {
        IntArray spans = buffer.getIntArray();
        this.getCoors(buffer, aDims, 0, vDir, spans, epDst);
        return spans;
    }

    private void getCoors(IExprBuffer buffer, ObjectArray aDims, int start, boolean vDir, IntArray spans, ExtProps epDst) throws SyntaxErrorException {
        boolean endRecursion = start >= aDims.size() - 1;
        Level lvl = (Level)aDims.get(start);
        ExtProps dim = lvl.dim;
        SortedExtPropsArray exts = dim.getExts();
        if (exts != null && lvl.pos != Integer.MIN_VALUE && dim.getExtensible(true) == (vDir ? 2 : 1)) {
            if (lvl.pos == Integer.MAX_VALUE) {
                int eEnd = exts.size();
                for (int e = 0; e < eEnd; ++e) {
                    if (endRecursion) {
                        spans.add(((ExtProps)exts.get(e)).getRC(vDir));
                        continue;
                    }
                    this.getSubCoors(buffer, aDims, start + 1, vDir, spans, (ExtProps)exts.get(e), epDst);
                }
            } else {
                int pos = lvl.pos;
                if (lvl.relative) {
                    int base = dim.getExtIndex();
                    pos += base;
                }
                if (pos < 0 || pos >= exts.size()) {
                    return;
                }
                if (endRecursion) {
                    spans.add(((ExtProps)exts.get(pos)).getRC(vDir));
                } else {
                    this.getSubCoors(buffer, aDims, start + 1, vDir, spans, (ExtProps)exts.get(pos), epDst);
                }
            }
        } else if (endRecursion) {
            spans.add(dim.getRC(vDir));
        } else {
            this.getSubCoors(buffer, aDims, start + 1, vDir, spans, dim, epDst);
        }
    }

    private void getSubCoors(IExprBuffer buffer, ObjectArray aDims, int start, boolean vDir, IntArray spans, ExtProps epHead, ExtProps epDst) throws SyntaxErrorException {
        Level lvl = (Level)aDims.get(start);
        lvl.dim = epHead.getSubBySource(lvl.dim, vDir);
        this.getCoors(buffer, aDims, start, vDir, spans, epDst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectArray getDimsFromVar(IExprBuffer buffer, ExtProps epDst, Variant varDim, boolean yDir, boolean returnRange) throws SyntaxErrorException {
        String msg = yDir ? CtrlEXTMessages.getMLS("verticalParentDimension", "\u7eb5\u5411\u7236\u7ef4") : CtrlEXTMessages.getMLS("horizontalParentDimension", "\u6a2a\u5411\u7236\u7ef4");
        boolean isArray = varDim.isArray();
        Variant[] args = isArray ? (Variant[])varDim.getValue() : buffer.getOneVariantArray(varDim);
        ObjectArray aDims = buffer.getObjectArray(args.length);
        try {
            ExtProps head;
            ExtProps prev = null;
            for (int i = 0; i < args.length; ++i) {
                Level lvl = (Level)args[i].getValue();
                ExtProps dim = lvl.dim;
                if (!dim.isHeadOf(epDst, yDir)) {
                    ExprErr.goError(262144L, this.getCellName(dim) + CtrlEXTMessages.getMLS("not", "\u975e") + this.getCellName(epDst) + msg);
                } else if (prev != null) {
                    ExtProps head2;
                    if (!prev.isHeadOf(dim, yDir)) {
                        ExprErr.goError(262144L, this.getCellName(prev) + CtrlEXTMessages.getMLS("not", "\u975e") + this.getCellName(dim) + msg);
                    }
                    if ((head2 = dim.getHead(yDir, true)) != prev) {
                        int pos = aDims.size();
                        while (head2 != prev) {
                            aDims.insert(pos, new Level(head2, Integer.MAX_VALUE, false));
                            head2 = head2.getHead(yDir, true);
                        }
                    }
                }
                aDims.append(lvl);
                prev = dim;
            }
            ExtProps extProps = head = returnRange ? epDst : epDst.getHead(yDir, true);
            if (prev != null && head != prev && prev.isHeadOf(head, yDir)) {
                int pos = aDims.size();
                while (head != prev) {
                    aDims.insert(pos, new Level(head, Integer.MAX_VALUE, false));
                    head = head.getHead(yDir, true);
                }
            }
        }
        finally {
            if (!isArray) {
                buffer.recycleArray(args);
            }
        }
        return aDims;
    }

    private ExtProps getValidExtProps(ExprContext ctx, Object obj) throws SyntaxErrorException {
        CellBlockNode cb;
        Object value = ((Variant)obj).getValue();
        if (!(value instanceof CellBlockNode)) {
            ICalculable exprOwner;
            if (value instanceof Expr ? (value = ((Expr)value).execute(ctx, exprOwner = ctx.getExprOwner()).getValue()) instanceof ExtProps : value instanceof ExtProps) {
                return (ExtProps)value;
            }
            if (!(value instanceof CellBlockNode)) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("parameterNotCell", "\u53c2\u6570\u975e\u5355\u5143\u683c:") + value);
            }
        }
        if (!(cb = (CellBlockNode)value).isSingleCell()) {
            ExprErr.goError(16L, CtrlEXTMessages.getMLS("parameterNotSingleCell", "\u53c2\u6570\u975e\u5355\u4e2a\u5355\u5143\u683c:") + cb);
        }
        ExtProps ep = null;
        Cell cll = cb.getFirstCell(true);
        if (cll != null) {
            ep = cll.getExtProps(true);
        }
        if (ep == null) {
            ExprErr.goError(262144L, cb.toString());
        }
        return ep;
    }

    private int getValidCoorOffset(ExprContext ctx, Object obj, boolean relative) throws SyntaxErrorException {
        Variant vPos = ctx.getBuffer().getVariant();
        if (!((Variant)obj).isNumeric(vPos)) {
            ExprErr.goError(16L, CtrlEXTMessages.getMLS("offsetNotNumeric", "Offset\u975e\u6570\u503c"));
        }
        int pos = vPos.intValue();
        if (!relative && --pos < 0) {
            ExprErr.goError(16L, CtrlEXTMessages.getMLS("coordinateLessThanOne", "\u5750\u6807\u5c0f\u4e8e1"));
        }
        ctx.getBuffer().recycleVariant(vPos);
        return pos;
    }

    private String getCellName(ExtProps ep) {
        if (ep.isCell00()) {
            return ep.toString();
        }
        Cell cll = ep.getCell();
        return SheetBaseMath.getBlockName(cll.getRow(), cll.getCol(), true, false, false);
    }

    public Variant V0(ExprContext ctx) {
        return new Variant(new Level(ctx.getExprOwner().getSheet().LEFT00, Integer.MAX_VALUE, false), 17);
    }

    public Variant H0(ExprContext ctx) {
        return new Variant(new Level(ctx.getExprOwner().getSheet().TOP00, Integer.MAX_VALUE, false), 17);
    }

    public Variant A(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        return this._ar(ctx, args, false);
    }

    public Variant R(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        return this._ar(ctx, args, true);
    }

    private Variant _ar(ExprContext ctx, Object[] args, boolean relative) throws SyntaxErrorException {
        ExtProps dim;
        ExcelFuncProvider.validParamCount(args, 1, 2);
        int pos = args.length == 2 ? this.getValidCoorOffset(ctx, args[1], relative) : Integer.MIN_VALUE;
        Variant var = (Variant)args[0];
        if (var.isNull()) {
            Sheet sheet = ctx.getExprOwner().getSheet();
            dim = pos == Integer.MIN_VALUE || pos == 0 ? sheet.LEFT00 : sheet.TOP00;
        } else {
            dim = this.getValidExtProps(ctx, var);
        }
        return new Variant(new Level(dim, pos, relative), 17);
    }

    static ExtDataSet getValidDataSet(ExprContext ctx, Variant dataSet, boolean updateData) throws SyntaxErrorException {
        Object value = dataSet.getValue();
        if (!(value instanceof ExtDataSet)) {
            if (value instanceof Expr) {
                boolean traceMode = ctx.isTraceMode();
                ctx.setTraceMode(false);
                dataSet = Expr.execute(ctx, dataSet);
                ctx.setTraceMode(traceMode);
                value = dataSet.getValue();
            } else {
                ExtDataSet ds = ctx.getBook().getDataSetManager().getDataSetByAlias(dataSet.toString());
                if (ds != null) {
                    value = ds;
                }
            }
            if (!(value instanceof ExtDataSet)) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("invalidDataset", "\u975e\u6709\u6548\u6570\u636e\u96c6:") + value);
            }
        }
        ExtDataSet ds = (ExtDataSet)value;
        if (updateData && ds.isEmpty() && !ds.isManualNullGroup()) {
            ds.getBook().getDataSetManager().updateDataSet(ds);
        }
        return ds;
    }

    static Variant getValidExp(ExprContext ctx, ExtDataSet ds, Object var, String errMsg, boolean getFieldExp) throws SyntaxErrorException {
        Variant field = (Variant)var;
        Object value = field.getValue();
        if (value instanceof ExtColumn) {
            return ((ExtColumn)value).getIndex();
        }
        if (value instanceof Expr) {
            Expr expr = (Expr)value;
            Variant varExpr = null;
            if (expr.hasExtField() || expr.hasUndefinedNamedObject()) {
                varExpr = ExtGroup.getDynamicFieldExpr(ctx, ds, field);
                if (!expr.hasUndefinedNamedObject() || varExpr != field) {
                    return varExpr;
                }
                field = expr.execute(ctx, null);
            } else {
                field = expr.execute(ctx, null);
            }
        } else if (value == null) {
            return field;
        }
        field = field.getVariant();
        if (getFieldExp) {
            value = field.getValue();
            Variant varIndex = Variant.intMinValue;
            boolean isString = field.isString();
            if (isString || field.isError(131072L)) {
                String fieldName = isString ? ((String)value).toUpperCase(Locale.ENGLISH) : (String)((SyntaxErrorException)value).getExtData();
                varIndex = ds.getColumnIndex(fieldName);
                if (varIndex == Variant.intMinValue) {
                    ExprErr.goError(16L, ds.getName() + CtrlEXTMessages.getMLS("missingColumnLabel", " \u5217\u6807\u7f3a\u5931: ") + fieldName);
                }
            } else if (field.isNumber()) {
                int index = field.intValue();
                if (index < 0 || index >= ds.getDataColumns()) {
                    ExprErr.goError(16L, CtrlEXTMessages.getMLS("columnLabelOutOfRange", "\u5217\u6807\u8d85\u9650: ") + index);
                }
                varIndex = new Variant(index);
            } else {
                ExprErr.goError(16L, errMsg);
            }
            return varIndex;
        }
        return field;
    }

    public Variant RCOUNT(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        int rowCount;
        ExcelFuncProvider.validParamCount(args, 1, 2);
        if (args.length == 1) {
            ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0], true);
            rowCount = ds.getCurrentGroup().size();
        } else {
            Object obj = ((Variant)args[1]).getValue();
            if (!(obj instanceof ExtGroup)) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("nonResultSet", "\u975e\u7ed3\u679c\u96c6"));
            }
            rowCount = ((ExtGroup)obj).size();
        }
        return new Variant(new BigDecimal(String.valueOf(rowCount)), 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variant FIELD(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object obj;
        ExcelFuncProvider.validParamCount(args, 2, 3);
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0], true);
        Variant selExp = ExtFuncProvider.getValidExp(ctx, ds, args[1], CtrlEXTMessages.getMLS("invalidColumnLabel", "\u975e\u6709\u6548\u5217\u6807"), true);
        if (args.length < 3) {
            return ds.calc(ctx, selExp);
        }
        ExtRow row = null;
        Variant varRow = (Variant)args[2];
        if (!varRow.isReferences()) {
            ExprErr.goError(16L, "row");
        }
        if ((obj = varRow.getValue()) instanceof ExtRow) {
            row = (ExtRow)obj;
        } else if (obj instanceof CellBlockNode) {
            ExtProps ep;
            if (ctx.isCalcLastMode()) {
                throw SyntaxErrorException.CALC_LAST;
            }
            Cell cll = ((CellBlockNode)obj).getFirstCell(false);
            if (cll != null && (ep = cll.getExtProps(false)) != null) {
                row = ep.getExtRow();
            }
        }
        if (row == null) {
            ExprErr.goError(16L, "not row");
        } else if (row.getDataSet() != ds) {
            ExprErr.goError(16L, "row.ds != ds");
        }
        ExtRow oldRow = ds.getCurrentRow();
        try {
            ds.setCurrentRow(row);
            Variant variant = ds.calc(ctx, selExp);
            return variant;
        }
        finally {
            ds.setCurrentRow(oldRow);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Variant FIELDS(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] av;
        Expr expr;
        ExcelFuncProvider.validParamCount(args, 2, 3);
        ExtDataSet ds = ExtFuncProvider.getValidDataSet(ctx, (Variant)args[0], true);
        Variant selExp = ExtFuncProvider.getValidExp(ctx, ds, args[1], CtrlEXTMessages.getMLS("invalidColumnLabel", "\u975e\u6709\u6548\u5217\u6807"), true);
        Object obj = selExp.getValue();
        if (obj instanceof Expr && (expr = (Expr)obj).isArray()) {
            selExp = ds.calc(ctx, selExp);
        }
        if (selExp.isArray()) {
            av = (Variant[])selExp.getValue();
            if (args.length > 2) {
                Variant filterExp = ExtFuncProvider.getValidExp(ctx, ds, args[2], CtrlEXTMessages.getMLS("filterExpression", "\u8fc7\u6ee4\u8868\u8fbe\u5f0f"), false);
                ExtRow row = ds.getCurrentGroup().filterFirstRow(ctx, filterExp);
                if (row == null) {
                    Arrays.fill(av, Variant.nullVariant);
                    return new Variant(av, 527);
                }
                ds.setCurrentRow(row);
            }
            int i = 0;
            while (i < av.length) {
                Variant fieldExp = ExtFuncProvider.getValidExp(ctx, ds, av[i], CtrlEXTMessages.getMLS("invalidColumnLabel", "\u975e\u6709\u6548\u5217\u6807"), true);
                av[i] = ds.calc(ctx, fieldExp);
                ++i;
            }
            return new Variant(av, 527);
        }
        selExp = ExtFuncProvider.getValidExp(ctx, ds, selExp, CtrlEXTMessages.getMLS("invalidColumnLabel", "\u975e\u6709\u6548\u5217\u6807"), true);
        ExtGroup group = ds.getCurrentGroup();
        if (args.length > 2) {
            group = (ExtGroup)group.clone();
            Variant filterExp = ExtFuncProvider.getValidExp(ctx, ds, args[2], CtrlEXTMessages.getMLS("filterExpression", "\u8fc7\u6ee4\u8868\u8fbe\u5f0f"), false);
            group.filterRow(ctx, filterExp, group);
        }
        av = ds.select(group, ctx, selExp);
        return new Variant(av, 527);
    }

    public Variant FIRST(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExtRow row;
        ExcelFuncProvider.validParamCount(args, 2, 5);
        Variant[] aRet = ctx.getBuffer().getOneVariantArray(null);
        ExtGroup group = ExtendFuncProvider.inst.filter(ctx, args, aRet);
        ExtDataSet ds = group.getDataSet();
        if (group.isNullGroup()) {
            row = ds.getNullRow();
        } else {
            row = group.getFirstRow();
            row.setValue(ds.field(ctx, aRet[0], row));
        }
        ctx.getBuffer().recycleArray(aRet);
        return new Variant(row, 18);
    }

    public Variant LAST(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExtRow row;
        ExcelFuncProvider.validParamCount(args, 2, 5);
        Variant[] aRet = ctx.getBuffer().getOneVariantArray(null);
        ExtGroup group = ExtendFuncProvider.inst.filter(ctx, args, aRet);
        ExtDataSet ds = group.getDataSet();
        if (group.isNullGroup()) {
            row = ds.getNullRow();
        } else {
            row = group.getLastRow();
            row.setValue(ds.field(ctx, aRet[0], row));
        }
        ctx.getBuffer().recycleArray(aRet);
        return new Variant(row, 18);
    }

    private String toHexString(long x, int chars) {
        char[] buf = new char[chars];
        int charPos = chars;
        while (--charPos >= 0) {
            buf[charPos] = _hex[(int)(x & 0xFL)];
            x >>>= 4;
        }
        return new String(buf);
    }

    public Variant KD_BOSTYPE(Variant varID) {
        String id = varID.getVariant().toString();
        if (StringUtil.isEmptyString((String)id)) {
            return Variant.nullVariant;
        }
        String strType = null;
        int intType = 0;
        int length = id.length();
        if (length == 44 || length == 40) {
            String type = id.substring(36);
            if (type != null) {
                if ((type = type.trim()).length() == 4) {
                    intType = 0;
                    strType = type;
                } else {
                    long parsedLong = 0L;
                    try {
                        parsedLong = Long.parseLong(type, 16);
                        if (parsedLong > Integer.MAX_VALUE) {
                            parsedLong = Integer.MIN_VALUE + (parsedLong - Integer.MAX_VALUE - 1L);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    intType = (int)parsedLong;
                    strType = parsedLong == 0L ? type : null;
                }
            }
        } else if (length == 28) {
            byte[] array = Base64Encoder.base64ToByteArray(id);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(array));
            try {
                in.readLong();
                in.readLong();
                intType = in.readInt();
                if (intType == 0) {
                    strType = in.readUTF();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (strType == null) {
            strType = this.toHexString(intType, 8);
        }
        return new Variant(strType, 11);
    }

    public Variant IMG(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        IImageModel img = this.getImageModel((Variant)args[0], ctx);
        if (img == null) {
            ExprErr.goError(16L, "Not IMG");
        } else {
            Cell cll = (Cell)ctx.getExprOwner();
            Sheet sheet = cll.getSheet();
            EmbedImage ei = new EmbedImage(sheet, img);
            sheet.getEmbedments(true).addEmbed(ei);
            ei._placeImageAt(cll);
        }
        return new Variant(img, 17);
    }

    private IImageModel getImageModel(Variant var, ExprContext ctx) throws SyntaxErrorException {
        Book book;
        Object obj;
        IImageModel img = null;
        if (var.isObject()) {
            obj = var.getVariant().getValue();
            if (obj instanceof IImageModel) {
                img = (IImageModel)obj;
            } else if (obj instanceof byte[]) {
                img = new DynamicAccessImageModel((byte[])obj);
            }
        } else if (var.isReferences()) {
            obj = var.getValue();
            if (obj instanceof ExtRow) {
                var = ((ExtRow)obj).getActualValue();
                img = this.getImageModel(var, ctx);
            }
        } else if (var.isString()) {
            try {
                img = ExtURL.parseModel(var.toString());
            }
            catch (UnknownImageURLProtocolException e) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("unsupportedImageProtocol", "\u4e0d\u652f\u6301\u7684\u56fe\u7247\u534f\u8bae\u3002"));
            }
            catch (MalformedURLException e) {
                ExprErr.goError(16L, "URL:" + var + CtrlEXTMessages.getMLS("illegal", "\u4e0d\u5408\u6cd5\u3002"));
            }
        }
        if (img instanceof ReferredPathImageModel) {
            Variant variant;
            IParameter parameter;
            book = ctx.getBook();
            ExtDataSetManager dataSetManager = book.getDataSetManager();
            ExecutionContext executionContext = dataSetManager.getExecutionContext();
            IRptRuntimeCallback rptRuntimeCallback = executionContext.getRptRuntimeCallback();
            ImageFullPath imageFullPath = ((ReferredPathImageModel)img).getImageFullPath();
            if ("@ExtRptCurrentUserInfoName".equals(imageFullPath.getUserName()) && (parameter = executionContext.getDataSetParameter("ExtRptCurrentUserInfoName")) != null && (variant = parameter.getValue()) != null) {
                imageFullPath.setUserName((String)variant.getValue());
            }
            ReferredImageResult referredImageResult = rptRuntimeCallback.loadReferredImage(imageFullPath);
            ((ReferredPathImageModel)img).setImageData(referredImageResult != null ? referredImageResult.getImageData() : null);
        } else if (img instanceof WebsiteImageModel) {
            book = ctx.getBook();
            ExtDataSetManager dataSetManager = book.getDataSetManager();
            ExecutionContext executionContext = dataSetManager.getExecutionContext();
            IRptRuntimeCallback rptRuntimeCallback = executionContext.getRptRuntimeCallback();
            String serviceGateway = rptRuntimeCallback.getServiceGateway();
            String sessionId = rptRuntimeCallback.getSessionId();
            try {
                img = ((WebsiteImageModel)img).toStaticURLImageModel(serviceGateway, sessionId);
            }
            catch (MalformedURLException e) {
                ExprErr.goError(16L, "URL:" + var + CtrlEXTMessages.getMLS("illegal", "\u4e0d\u5408\u6cd5\u3002"));
            }
        }
        return img;
    }

    public Variant BASE64(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 2);
        boolean encode = true;
        if (args.length == 2) {
            encode = ((Variant)args[1]).getVariant().booleanValue();
        }
        Variant var = (Variant)args[0];
        Object obj = var.getVariant().getValue();
        if (encode) {
            if (!(obj instanceof byte[])) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("nonByteSourceData", "\u975ebyte[]\u6e90\u6570\u636e"));
            }
            byte[] bytes = (byte[])obj;
            var = new Variant(Base64Encoder.byteArrayToBase64(bytes), 11);
        } else {
            boolean bError = true;
            if (obj instanceof String) {
                bError = false;
                try {
                    String str = (String)obj;
                    var = new Variant(Base64Encoder.base64ToByteArray(str), 17);
                }
                catch (IllegalArgumentException e) {
                    bError = true;
                }
            }
            if (bError) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("nonBase64SourceData", "\u975eBase64\u6e90\u6570\u636e"));
            }
        }
        return var;
    }

    public Variant SNAPSHOT(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant variant;
        String temp;
        String intString;
        ExcelFuncProvider.validParamCount(args, 4, 7);
        Integer dstSheetIndex = 0;
        boolean getDstSheetByName = false;
        String sheetName = null;
        byte[][] snaps = null;
        Book srcBook = ctx.getBook();
        ExtDataSetManager dataSetManager = srcBook.getDataSetManager();
        ExecutionContext executionContext = dataSetManager.getExecutionContext();
        IRptRuntimeCallback rptRuntimeCallback = executionContext.getRptRuntimeCallback();
        Variant variant0 = (Variant)args[0];
        Variant variant1 = (Variant)args[1];
        Variant variant2 = (Variant)args[2];
        Variant variant3 = (Variant)args[3];
        String reportGroupName = "";
        String reportName = "";
        String snapGroupName = "";
        String snapName = "";
        if (variant0 != null) {
            if (StringUtil.isEmptyString((String)variant0.toString())) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("pleaseSpecifyReportDirectory", "\u8bf7\u6307\u5b9a\u62a5\u8868\u76ee\u5f55"));
            }
            reportGroupName = variant0.toString();
        }
        if (variant1 != null) {
            if (StringUtil.isEmptyString((String)variant1.toString())) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("pleaseSpecifyReportName", "\u8bf7\u6307\u5b9a\u62a5\u8868\u540d\u79f0"));
            }
            reportName = variant1.toString();
        }
        if (variant2 != null) {
            if (StringUtil.isEmptyString((String)variant2.toString())) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("pleaseSpecifySnapshotDirectory", "\u8bf7\u6307\u5b9a\u5feb\u7167\u76ee\u5f55"));
            }
            snapGroupName = variant2.toString();
        }
        if (variant3 != null) {
            String patten;
            if (StringUtil.isEmptyString((String)variant3.toString())) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("pleaseSpecifySnapshotName", "\u8bf7\u6307\u5b9a\u5feb\u7167\u540d\u79f0"));
            }
            if (!Pattern.matches(patten = "^([\u4e00-\u9fa5a-zA-Z_*])[\u4e00-\u9fa5a-zA-Z0-9_*]*$", snapName = variant3.toString())) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("snapshotNameIllegalInput", "\u5feb\u7167\u540d\u79f0\u975e\u6cd5\u8f93\u5165"));
            }
        }
        String snapType = ExtGuiExecutor.SnapshotAction.ExtReportSnapGroupType.PUBLIC.getValue();
        boolean isSingle = false;
        if (args.length > 4) {
            Variant variant4 = (Variant)args[4];
            if (variant4.isNumber()) {
                Integer type = 0;
                intString = variant4.toString();
                try {
                    if (!StringUtil.isEmptyString((String)intString)) {
                        type = Integer.parseInt(intString);
                    }
                }
                catch (NumberFormatException e) {
                    ExprErr.goError(16L, CtrlEXTMessages.getMLS("snapshotCategoryMustBe0Or1", "\u5feb\u7167\u6240\u5c5e\u5206\u7c7b\u53ea\u80fd\u586b0\u62161"));
                }
                if (type == 1) {
                    snapType = ExtGuiExecutor.SnapshotAction.ExtReportSnapGroupType.PERSONAL.getValue();
                } else if (type == 0) {
                    snapType = ExtGuiExecutor.SnapshotAction.ExtReportSnapGroupType.PUBLIC.getValue();
                } else {
                    ExprErr.goError(16L, CtrlEXTMessages.getMLS("snapshotCategoryMustBe0Or1", "\u5feb\u7167\u6240\u5c5e\u5206\u7c7b\u53ea\u80fd\u586b0\u62161"));
                }
            } else {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("snapshotCategoryMustBeInteger", "\u5feb\u7167\u6240\u5c5e\u5206\u7c7b\u53ea\u80fd\u586b\u6574\u6570"));
            }
        }
        if (args.length > 5 && !StringUtil.isEmptyString((String)(temp = (variant = (Variant)args[5]).toString()))) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(temp)) {
                isSingle = true;
            } else if (Boolean.FALSE.toString().equalsIgnoreCase(temp)) {
                isSingle = false;
            } else {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("sixthParameterMustBeBoolean", "\u7b2c\u516d\u4e2a\u53c2\u6570\u53ea\u80fd\u586b\u5e03\u5c14\u503ctrue\u6216false"));
            }
        }
        if (args.length > 6) {
            variant = (Variant)args[6];
            if (variant.isNumber()) {
                Integer index = 0;
                intString = variant.toString();
                try {
                    if (!StringUtil.isEmptyString((String)intString)) {
                        index = Integer.parseInt(intString);
                    }
                }
                catch (NumberFormatException e) {
                    ExprErr.goError(16L, CtrlEXTMessages.getMLS("pageIndexMustBeInteger", "\u9875\u7d22\u5f15\u53ea\u80fd\u4e3a\u6574\u6570:") + variant);
                }
                if (index <= 0) {
                    ExprErr.goError(16L, CtrlEXTMessages.getMLS("pageIndexMustBeGreaterThanZero", "\u9875\u7d22\u5f15\u5fc5\u987b\u5927\u4e8e0:") + variant);
                }
                dstSheetIndex = index - 1;
            } else if (variant.isString()) {
                getDstSheetByName = true;
                sheetName = (String)variant.getValue();
            } else {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("pageIndexMustBeIntegerOrString", "\u9875\u7d22\u5f15\u53ea\u80fd\u4e3a\u6574\u6570\u6216\u8005\u5b57\u7b26\u4e32"));
            }
        }
        snaps = rptRuntimeCallback.loadSnapContent(reportGroupName, reportName, snapType, snapGroupName, snapName, isSingle);
        return this.getSnapVariant(snaps, getDstSheetByName, sheetName, dstSheetIndex);
    }

    private Variant getSnapVariant(byte[][] snaps, boolean getDstSheetByName, String sheetName, int dstSheetIndex) throws SyntaxErrorException {
        CellBlock3DNode cb = null;
        if (snaps.length > 0) {
            int i = 0;
            try {
                Book book = Book.Manager.getNewBook(null, 0);
                Sheet sheet1 = null;
                Sheet sheetn = null;
                for (i = 0; i < snaps.length; ++i) {
                    if (snaps[i] == null || snaps[i].length <= 0) continue;
                    Book b2 = MiscUtil.unpack(snaps[i]);
                    book.setAutoCalculate(false);
                    SortedNamedObjectNodeArray namesObjectNodeArray = b2.getNames();
                    int size = b2.getSheetCount();
                    for (int index = 0; index < size; ++index) {
                        Sheet sheet = b2.getSheet(index);
                        Sheet.ICellsIterator ii = sheet.getCellsIterator(null, false, true);
                        while (ii.hasNext()) {
                            Cell cll = ii.next();
                            Variant v = cll.getValue();
                            if (v != null && v.isCalcLast()) {
                                cll.setValue(Variant.badValueVariant);
                            }
                            cll.setNeedRecalc(false);
                        }
                        SortedNamedObjectNodeArray sheetNamesObjectNodeArray = sheet.getNames();
                        int nameSize = namesObjectNodeArray.size();
                        for (int nameIndex = 0; nameIndex < nameSize; ++nameIndex) {
                            NamedObjectNode name = namesObjectNodeArray.getObjectNode(nameIndex);
                            if (sheetNamesObjectNodeArray.searchByName(name.getName()) != null) continue;
                            sheetNamesObjectNodeArray.insert(name);
                        }
                        if ((!getDstSheetByName || !sheet.getSheetName().equals(sheetName)) && index != dstSheetIndex) continue;
                        sheetn = sheet;
                    }
                    if (sheetn == null) {
                        ExprErr.goError(16L, CtrlEXTMessages.getMLS("specifiedSnapshotTabNotFound", "\u6307\u5b9a\u7684\u5feb\u7167\u9875\u7b7e\u4e0d\u5b58\u5728"));
                    } else if (sheet1 == null) {
                        sheet1 = sheetn;
                    }
                    book.insertSheet(Integer.MAX_VALUE, sheetn, false);
                }
                cb = CellBlock3DNode.getCellBlock3DNode(null, sheet1, sheetn, 0, 0, 0, 0, 0);
            }
            catch (SyntaxErrorException e) {
                throw e;
            }
            catch (HighVersionException e) {
                this.log.error((Object)"\u5feb\u7167\u6570\u636eunpack\u5f02\u5e38", (Throwable)e);
                ExprErr.goError(1L, e.getMessage());
            }
            catch (InvalidCouponException e) {
                this.log.error((Object)"\u5feb\u7167\u6570\u636eunpack\u5f02\u5e38", (Throwable)e);
                ExprErr.goError(1L, e.getMessage());
            }
            catch (AuthorizationFailedException e) {
                this.log.error((Object)"\u5feb\u7167\u6570\u636eunpack\u5f02\u5e38", (Throwable)e);
                ExprErr.goError(1L, CtrlEXTMessages.getMLS("reportTemplateCopyrightVerificationFailed", "\u62a5\u8868\u6a21\u677f\u7248\u6743\u6240\u6709\u4eba\u9a8c\u8bc1\u5931\u8d25"));
            }
        }
        return cb == null ? Variant.nullVariant : new Variant(cb, 18);
    }

    public Variant INFLATE(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 5);
        boolean bChange = false;
        int t = 0;
        int r = 0;
        int b2 = 0;
        Variant varTemp = Variant.getNewEmptyVariant();
        String msgNumber = CtrlEXTMessages.getMLS("nonNumericOffset", "\u975e\u6570\u503c\u504f\u79fb\u91cf");
        int l = ExcelFuncProvider.numberValue(ctx, (Variant)args[1], varTemp, msgNumber).intValue();
        if (args.length > 2) {
            t = ExcelFuncProvider.numberValue(ctx, (Variant)args[2], varTemp, msgNumber).intValue();
            if (args.length > 3) {
                r = ExcelFuncProvider.numberValue(ctx, (Variant)args[3], varTemp, msgNumber).intValue();
                if (args.length > 4) {
                    b2 = ExcelFuncProvider.numberValue(ctx, (Variant)args[4], varTemp, msgNumber).intValue();
                }
            }
        }
        bChange = l != 0 || t != 0 || r != 0 || b2 != 0;
        Variant var = (Variant)args[0];
        Variant varRet = null;
        if (!bChange) {
            varRet = var;
        } else {
            String msgCellBlock = CtrlEXTMessages.getMLS("nonCellAreaReference", "\u975e\u5355\u5143\u533a\u57df\u5f15\u7528");
            Object obj = null;
            if (var.isReferences()) {
                obj = var.getValue();
                if (!(obj instanceof CellBlockNode)) {
                    ExprErr.goError(16L, msgCellBlock);
                }
                CellBlockNode cb = (CellBlockNode)((CellBlockNode)obj).clone();
                cb.offset(-l, -t, r, b2);
                varRet = cb.getVarThis();
            } else if (var.isArray()) {
                Variant[] src = (Variant[])var.getValue();
                Variant[] varCBs = new Variant[src.length];
                for (int i = 0; i < src.length; ++i) {
                    var = src[i];
                    if (!var.isReferences() || !((obj = var.getValue()) instanceof CellBlockNode)) {
                        ExprErr.goError(16L, msgCellBlock);
                    }
                    if (null == obj) continue;
                    CellBlockNode cb = (CellBlockNode)((CellBlockNode)obj).clone();
                    cb.offset(-l, -t, r, b2);
                    varCBs[i] = cb.getVarThis();
                }
                varRet = new Variant(varCBs, 527);
            } else {
                ExprErr.goError(16L, msgCellBlock);
            }
        }
        return varRet;
    }

    private static class Level {
        public ExtProps dim;
        public int pos;
        public boolean relative;

        public Level(ExtProps dim, int pos, boolean relative) {
            this.dim = dim;
            this.pos = pos;
            this.relative = relative;
        }

        public String toString() {
            return this.dim.toString() + ", " + CtrlEXTMessages.getMLS("position", "\u4f4d\u7f6e:") + this.pos + ", " + (this.relative ? CtrlEXTMessages.getMLS("relative", "\u76f8\u5bf9") : CtrlEXTMessages.getMLS("absolute", "\u7edd\u5bf9"));
        }
    }

    static class SortedRecords
    extends SortedObjectArray {
        private static final long serialVersionUID = -3177634511854748822L;
        private int _keyCount;

        SortedRecords(int size, int keyCount) {
            super(size);
            this.setComparator(new DefaultComparator());
            this._keyCount = keyCount;
        }

        class DefaultComparator
        implements Comparator {
            DefaultComparator() {
            }

            public int compare(Object o1, Object o2) {
                Variant[] data = (Variant[])o1;
                Object[] other = (Object[])o2;
                int cmp = 0;
                for (int i = 0; i < SortedRecords.this._keyCount && (cmp = data[i].compareTo(other[i])) == 0; ++i) {
                }
                return cmp;
            }
        }
    }

    static class KeyRecords
    implements Comparable {
        private final Variant _key;
        private final ObjectArray[] _data;

        KeyRecords(Variant key, ObjectArray[] data) {
            this._key = key;
            this._data = data;
        }

        public int compareTo(Object obj) {
            Object cmp = obj instanceof KeyRecords ? ((KeyRecords)obj)._key : obj;
            return this._key.compareTo(cmp);
        }

        public Variant[][] getRecords(boolean keepBlank) {
            int i;
            int rows = 0;
            for (int i2 = 0; i2 < this._data.length; ++i2) {
                ObjectArray array = this._data[i2];
                if (array == null) {
                    if (keepBlank) continue;
                    return null;
                }
                rows = Math.max(rows, array.size());
            }
            Variant[][] records = new Variant[rows][this._data.length + 1];
            for (i = 0; i < rows; ++i) {
                records[i][0] = this._key;
            }
            i = 0;
            int col = 1;
            while (i < this._data.length) {
                int j;
                ObjectArray array = this._data[i];
                if (array != null) {
                    int jEnd = array.size();
                    for (j = 0; j < jEnd; ++j) {
                        records[j][col] = (Variant)array.get(j);
                    }
                }
                while (j < rows) {
                    records[j][col] = Variant.nullVariant;
                    ++j;
                }
                ++i;
                ++col;
            }
            return records;
        }
    }
}

