/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.ExtFileWriterWraper;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFile;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFileWriter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.AbstractExtFileType;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.log4j.Logger;

public abstract class AbstractExtFile
implements IExtFile {
    private static Logger log = LogUtil.getPackageLogger(AbstractExtFile.class);
    protected AbstractExtFileType _fileType;
    private String _name;

    public AbstractExtFile(AbstractExtFileType fileType) {
        this._fileType = fileType;
        this._name = UUID.randomUUID().toString();
    }

    protected AbstractExtFile(AbstractExtFileType fileType, String name) {
        this._fileType = fileType;
        this._name = name;
    }

    protected final String getPath() {
        return this.getPath(this._fileType, this._name);
    }

    protected final String getPath(String name) {
        return this.getPath(this._fileType, name);
    }

    protected final String getPath(AbstractExtFileType fileType, String name) {
        return fileType.getSubFolder() + File.separator + name;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final AbstractExtFileType getFileType() {
        return this._fileType;
    }

    public final int getFileTypeIndex() {
        return this._fileType.getTypeIndex();
    }

    @Override
    public final IExtFileWriter createWriter() {
        return new ExtFileWriterWraper(this.doCreateWriter());
    }

    @Override
    public final boolean createNewFile() throws IOException {
        return this.doCreateNewFile();
    }

    @Override
    public final boolean delete() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("delete file :" + this.getPath()));
        }
        return this.doDelete();
    }

    protected abstract IExtFileWriter doCreateWriter();

    protected abstract boolean doCreateNewFile() throws IOException;

    protected abstract boolean doDelete();
}

