/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.AbstractExtFile;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFile;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFileUpdater;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFileVisitor;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.AbstractExtFileType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtTempFileType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.stream.ExtInputStream;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.util.IOUtil;
import com.kingdee.cosmic.ctrl.kds.util.CloseUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import org.apache.log4j.Logger;

public class FileFactory {
    private static Logger log = LogUtil.getPackageLogger(FileFactory.class);
    private static Constructor<AbstractExtFile> TEMP_FILE_CONSTRUCTOR = null;

    static Constructor<AbstractExtFile> getTempFileConstructor() {
        if (TEMP_FILE_CONSTRUCTOR != null) {
            return TEMP_FILE_CONSTRUCTOR;
        }
        Class<FileFactory> clazz = FileFactory.class;
        synchronized (FileFactory.class) {
            if (TEMP_FILE_CONSTRUCTOR != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return TEMP_FILE_CONSTRUCTOR;
            }
            String specifiedClass = System.getProperty("ext.tempfile.impl");
            if (specifiedClass != null && !"".equals(specifiedClass.trim())) {
                try {
                    Class<?> clazz2 = Class.forName(specifiedClass);
                    if (clazz2 != null) {
                        TEMP_FILE_CONSTRUCTOR = clazz2.getConstructor(ExtTempFileType.class);
                        log.info((Object)("Qing Temp File switch to " + clazz2.getName()));
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return TEMP_FILE_CONSTRUCTOR;
                    }
                    throw new IllegalArgumentException("Class " + specifiedClass + " cannot be loaded!");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Class " + specifiedClass + " cannot be loaded!", e);
                }
            }
            throw new IllegalArgumentException("ext.tempfile.impl should not be null!");
        }
    }

    public static IExtFile newTempFile(ExtTempFileType fileType) {
        Constructor<AbstractExtFile> constructor = FileFactory.getTempFileConstructor();
        try {
            return constructor.newInstance(fileType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("qing.tempfile.impl newInstance failed!", e);
        }
    }

    public static IExtFileVisitor newFileVisitor(AbstractExtFileType fileType, String name) {
        if (fileType instanceof ExtTempFileType) {
            return FileFactory.newTempFile((ExtTempFileType)fileType).findFile(fileType, name);
        }
        throw new RuntimeException("do something here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileContent(AbstractExtFileType fileType, String name) throws IOException {
        byte[] byArray;
        IExtFileVisitor file = FileFactory.newFileVisitor(fileType, name);
        ExtInputStream sis = null;
        try {
            sis = file.getInputStream();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOUtil.copy(sis, outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            CloseUtil.close(sis);
            throw throwable;
        }
        CloseUtil.close(sis);
        return byArray;
    }

    public static void clearFile(Collection<IExtFile> fileList) {
        if (fileList != null && !fileList.isEmpty()) {
            for (IExtFile qingFile : fileList) {
                FileFactory.clearFile(qingFile);
            }
        }
    }

    public static void clearDsTemp(ExtDataSet ds) {
        String[] qsFiles;
        if (!ds.isUseQS() || ds.isEmpty()) {
            return;
        }
        for (String file : qsFiles = ds.getQsFileNames()) {
            FileFactory.clearTempFile(ExtTempFileType.TEMP_QS, file);
        }
    }

    public static void clearFile(IExtFile qingFile) {
        if (qingFile != null) {
            qingFile.delete();
        }
    }

    public static void clearTempFile(ExtTempFileType qingTempFileType, String fileName) {
        IExtFile tempFile = FileFactory.newTempFile(qingTempFileType);
        IExtFileUpdater qingFileUpdater = tempFile.findFile(qingTempFileType, fileName);
        if (qingFileUpdater != null) {
            qingFileUpdater.delete();
        }
    }
}

