/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.stream;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.exception.ExtFileStorageNoSpaceException;
import java.io.IOException;
import java.io.OutputStream;

public class ExtOutputStream
extends OutputStream {
    private long _fileSize = 0L;
    private OutputStream _fileOutStream;

    public ExtOutputStream(OutputStream outputStream) {
        this._fileOutStream = outputStream;
    }

    private void doWrite(int b) throws IOException {
        if (this._fileOutStream != null) {
            try {
                this._fileOutStream.write(b);
            }
            catch (IOException e) {
                this.changeIOException(e);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.doWrite(b);
        ++this._fileSize;
    }

    @Override
    public void close() throws IOException {
        if (this._fileOutStream != null) {
            try {
                this._fileOutStream.close();
            }
            catch (IOException e) {
                this.changeIOException(e);
            }
            finally {
                this._fileOutStream = null;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._fileOutStream != null) {
            try {
                this._fileOutStream.flush();
            }
            catch (IOException e) {
                this.changeIOException(e);
            }
        }
    }

    @Override
    public void write(byte[] paramArrayOfByte) throws IOException {
        this._fileOutStream.write(paramArrayOfByte);
    }

    @Override
    public void write(byte[] paramArrayOfByte, int paramInt1, int paramInt2) throws IOException {
        this._fileOutStream.write(paramArrayOfByte, paramInt1, paramInt2);
    }

    public long getFileSize() {
        return this._fileSize;
    }

    private void changeIOException(IOException e) throws IOException {
        String message = e.getMessage();
        if (CtrlEXTMessages.getMLS("insufficientDiskSpace", "\u78c1\u76d8\u7a7a\u95f4\u4e0d\u8db3\u3002").equals(message) || "No space left on device".equals(message)) {
            throw new ExtFileStorageNoSpaceException();
        }
        throw e;
    }
}

