/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qs;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFile;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFileWriter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtMetaInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.stream.ExtOutputStream;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.exception.AbstractExtDataException;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.exception.ExtDataPersistenceException;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qs.QSOutputstream;
import com.kingdee.cosmic.ctrl.kds.util.CloseUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.xerial.snappy.OSInfo;
import q.datasource.io.AbstractOutputStream;
import q.storage.columnar.CodecFactory;
import q.storage.columnar.QingStorageFileWriter;
import q.storage.columnar.QingStorageRecordWriter;
import q.storage.columnar.a.c;
import q.storage.columnar.api.d;
import q.storage.columnar.api.impl.QingStorageRecord;
import q.storage.columnar.api.impl.QingStorageWriteSupport;
import q.storage.columnar.codec.GzipCodec;
import q.storage.columnar.codec.SnappyCodec;
import q.storage.columnar.metadata.CompressionCodecName;
import shaded.org.apache.parquet.column.ParquetProperties;
import shaded.org.apache.parquet.schema.MessageType;

public class ExtStorageWriterWraper {
    private static Logger log = LogUtil.getPackageLogger(ExtStorageWriterWraper.class);
    private static boolean suppourtSnappy = true;
    private static final int DEFAULT_BLOCK_SIZE = 0xA00000;
    private static final int DEFAULT_PAGE_SIZE = 0x100000;
    private static final boolean DEFAULT_IS_DICTIONARY_ENABLED = true;
    private static final boolean DEFAULT_IS_VALIDATING_ENABLED = false;
    private static final ParquetProperties.WriterVersion DEFAULT_WRITER_VERSION = ParquetProperties.WriterVersion.PARQUET_2_0;
    private QingStorageRecordWriter _recordWriter;
    private IExtFileWriter _extFileWriter;
    private boolean closed = false;

    public ExtStorageWriterWraper(IExtFile dataFile, MessageType messageType, ExtMetaInfo extMetaInfo) throws ExtDataPersistenceException {
        this._extFileWriter = dataFile.createWriter();
        ExtOutputStream outputStream = null;
        QingStorageFileWriter fileWriter = null;
        try {
            outputStream = this._extFileWriter.getOutputStream();
            fileWriter = new QingStorageFileWriter(messageType, (AbstractOutputStream)new QSOutputstream(outputStream), 0xA00000L);
            fileWriter.start();
        }
        catch (IOException e) {
            CloseUtil.close(outputStream);
            AbstractExtDataException.persistenceExcetpion(e);
        }
        QingStorageWriteSupport writeSupport = new QingStorageWriteSupport();
        writeSupport.setSchema(messageType);
        HashMap<String, String> extraMetaData = new HashMap<String, String>();
        extraMetaData.put(".metadata.", JsonUtil.encodeToString(extMetaInfo));
        CodecFactory.BytesCompressor bytesCompressor = null;
        bytesCompressor = suppourtSnappy ? new CodecFactory.BytesCompressor(CompressionCodecName.SNAPPY, (c)new SnappyCodec(), 0x100000) : new CodecFactory.BytesCompressor(CompressionCodecName.GZIP, (c)new GzipCodec(), 0x100000);
        this._recordWriter = new QingStorageRecordWriter(fileWriter, (d)writeSupport, messageType, extraMetaData, 0xA00000L, 0x100000, bytesCompressor, 0x100000, true, false, DEFAULT_WRITER_VERSION);
    }

    public void write(QingStorageRecord record) throws AbstractExtDataException, InterruptedException {
        try {
            this._recordWriter.write((Object)record);
        }
        catch (IOException e) {
            AbstractExtDataException.persistenceExcetpion(e);
        }
    }

    public void finishWriteData() throws ExtDataPersistenceException {
        if (this._recordWriter != null) {
            try {
                this._recordWriter.close();
            }
            catch (Exception e) {
                AbstractExtDataException.persistenceExcetpion(e);
            }
            finally {
                this._recordWriter = null;
            }
        }
    }

    public void close(Exception exception) {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this._extFileWriter != null) {
            this._extFileWriter.close(exception);
            this._extFileWriter = null;
        }
    }

    static {
        try {
            Class.forName("org.xerial.snappy.Snappy");
            suppourtSnappy = true;
        }
        catch (Throwable e) {
            suppourtSnappy = false;
            log.warn((Object)String.format("init snappy faile on OS:%s ARCH:%s, failback to GIZP.", OSInfo.getOSName(), OSInfo.getArchName()));
        }
    }
}

