/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qs;

import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFileVisitor;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtMetaInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.stream.ExtInputStream;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.AbstractExtDataVisitor;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.IExtDataCountable;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.api.IExtDataIterator;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.exception.AbstractExtDataException;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.exception.ExtDataNoDataException;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qs.QSDataIterator;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qs.QSInputstream;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qsdatahandler.DefaultDataHandlerFactory;
import com.kingdee.cosmic.ctrl.kds.util.CloseUtil;
import com.kingdee.cosmic.ctrl.kds.util.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import q.datasource.io.AbstractInputStream;
import q.storage.columnar.metadata.FileMetaData;
import q.storage.columnar.util.QingStorageUtils;
import shaded.org.apache.parquet.schema.PrimitiveType;
import shaded.org.apache.parquet.schema.Type;

public class QSDataSourceVisitor
extends AbstractExtDataVisitor
implements IExtDataCountable {
    private long _rowCount = -1L;
    private ExtMetaInfo _extMetaInfo;
    private IExtFileVisitor _dataFile;
    private ArrayList<PrimitiveType> _qsFieldPrimTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QSDataSourceVisitor(IExtFileVisitor dataFile) throws AbstractExtDataException {
        this._dataFile = dataFile;
        ExtInputStream inputstream = null;
        try {
            inputstream = dataFile.getInputStream();
            FileMetaData fileMetaData = QingStorageUtils.readQingStorageMetaData((AbstractInputStream)new QSInputstream(inputstream), (boolean)true);
            this._rowCount = fileMetaData.getRowCount();
            String metaInfoString = (String)fileMetaData.getKeyValueMetaData().get(".metadata.");
            List qsFieldTypes = fileMetaData.getSchema().getFields();
            this._qsFieldPrimTypes = new ArrayList(qsFieldTypes.size());
            for (Type qsFieldType : qsFieldTypes) {
                this._qsFieldPrimTypes.add(qsFieldType.asPrimitiveType());
            }
            this._extMetaInfo = JsonUtil.decodeFromString(metaInfoString, ExtMetaInfo.class);
        }
        catch (IOException e) {
            try {
                AbstractExtDataException.accessExcetpion(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close(inputstream);
                throw throwable;
            }
            CloseUtil.close(inputstream);
        }
        CloseUtil.close(inputstream);
    }

    @Override
    public boolean hasData() {
        return this._rowCount != 0L;
    }

    @Override
    public long getRowCount() {
        return this._rowCount;
    }

    @Override
    public IExtDataIterator iterator() throws AbstractExtDataException {
        if (!this.hasData()) {
            throw new ExtDataNoDataException("no data in datasource");
        }
        return new QSDataIterator(this._dataFile, this._extMetaInfo, this._rowCount, this._qsFieldPrimTypes, new DefaultDataHandlerFactory(false));
    }

    @Override
    public ExtMetaInfo getMetaInfo() {
        return this._extMetaInfo;
    }
}

