/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.innerlink;

import chrriis.dj.nativeswing.common.Utils;
import chrriis.dj.nativeswing.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.WebBrowserObject;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.ResovlerHelper;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.exec.ChartInnerLinkExec;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.ChartDataItemInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.action.SpreadAction;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ChartLinkRequestHandler
extends WebBrowserObject {
    public static final String DATAITMEINFO = "DataItemInfo";
    public static final String CHART_ID = "chartId";

    public ChartLinkRequestHandler(JWebBrowser webBrowser) {
        super(webBrowser);
    }

    protected WebBrowserObject.ObjectHTMLConfiguration getObjectHtmlConfiguration() {
        return null;
    }

    protected static WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest httpRequest) {
        ChartInnerLinkExec innerLinkExec;
        Map paramMap = httpRequest.getQueryParameterMap();
        ChartDataItemInfo dataItemInfo = new ChartDataItemInfo();
        dataItemInfo.setCategoryName((String)paramMap.get("@categoryName"));
        dataItemInfo.setSeriesName((String)paramMap.get("@seriesName"));
        dataItemInfo.setSeriesValue((String)paramMap.get("@seriesValue"));
        dataItemInfo = ChartLinkRequestHandler.decodeChartParams(dataItemInfo);
        SpreadContext context = ResovlerHelper.getCurrentSpreadContext();
        Book book = context.getBook();
        Sheet sheet = book.getActiveSheet();
        EmbedhLayer layer = sheet.getEmbedments(false);
        if (layer == null) {
            return null;
        }
        EmbedObject embed = sheet.getEmbedments(false).getActiveSelectedEmbed();
        if (!(embed instanceof FlashChart)) {
            return null;
        }
        FlashChart fChart = (FlashChart)embed;
        FlashChartModel chartModel = fChart.getModel();
        JPopupMenu popMenu = ChartLinkRequestHandler.getChartLinkPopMenu(fChart, context, dataItemInfo);
        if (popMenu != null) {
            int count = popMenu.getComponentCount();
            if (count == 1) {
                ((KDMenuItem)popMenu.getComponent(0)).doClick();
            } else if (count > 1) {
                popMenu.setVisible(!popMenu.isVisible());
            }
        }
        if ((innerLinkExec = (ChartInnerLinkExec)context.getHyperLinkHandler().getLinkExec("fsChartInner:")) != null) {
            innerLinkExec.setDataItemInfo(dataItemInfo);
            innerLinkExec.setChartModel(chartModel);
            innerLinkExec.execute(null);
        }
        return null;
    }

    public static ChartDataItemInfo decodeChartParams(ChartDataItemInfo itemInfo) {
        String NULL_STR = "null";
        String categoryName = itemInfo.getCategoryName();
        if (NULL_STR.equals(categoryName)) {
            categoryName = null;
        } else if (!StringUtil.isEmptyString((String)categoryName)) {
            categoryName = Utils.decodeBase64((String)categoryName);
        }
        itemInfo.setCategoryName(categoryName);
        String seriesName = itemInfo.getSeriesName();
        if (NULL_STR.equals(seriesName)) {
            seriesName = null;
        } else if (!StringUtil.isEmptyString((String)seriesName)) {
            seriesName = Utils.decodeBase64((String)seriesName);
        }
        itemInfo.setSeriesName(seriesName);
        String seriesValue = itemInfo.getSeriesValue();
        if (NULL_STR.equals(seriesValue)) {
            seriesValue = null;
        } else if (!StringUtil.isEmptyString((String)seriesValue)) {
            seriesValue = Utils.decodeBase64((String)seriesValue);
        }
        itemInfo.setSeriesValue(seriesValue);
        return itemInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JPopupMenu getChartLinkPopMenu(final ChartRectEmbedment fChart, final SpreadContext context, final ChartDataItemInfo dataItemInfo) {
        if (context.getBook().getUserObjectValue("EXT_EXECUTED") == null) {
            return null;
        }
        ETTargets etTargets = fChart.getModel().getExtTargets();
        InnerLinkTargets innerTargets = fChart.getModel().getInnerTargets();
        if (etTargets == null) {
            return null;
        }
        List listExtTarget = etTargets.getTargets();
        List<InnerLinkTransitionTarget> listInnerTarget = null;
        if (innerTargets != null) {
            listInnerTarget = ChartLinkRequestHandler.filterInnerTarget(innerTargets.getTargets(), context, fChart.getModel());
        }
        if (listExtTarget == null || listExtTarget.isEmpty()) {
            return null;
        }
        SpreadAction action = context.getActionManager().getAction("HyperLink_Flashchart");
        action.putValue(DATAITMEINFO, dataItemInfo);
        action.putValue(CHART_ID, fChart.getEmbedId());
        Sheet activeSheet = context.getBook().getActiveSheet();
        Cell activeCell = activeSheet.getActiveCell();
        boolean isCreateLastCell = false;
        if (activeCell == null) {
            isCreateLastCell = true;
            activeCell = activeSheet.getCell(1048574, 65534, true);
        }
        JPopupMenu popMenu = context.getPopMenuManager().getChartLinkPopMenu();
        try {
            ExtProps ep = activeCell.getExtProps(true);
            if (listInnerTarget != null && !listInnerTarget.isEmpty()) {
                KDMenuItem innerItem = new KDMenuItem();
                innerItem.setText(CtrlEXTMessages.getMLS("innerLinkage", "\u8054\u52a8"));
                innerItem.setBounds(0, 0, 100, 0);
                innerItem.setPreferredSize(new Dimension(100, innerItem.getPreferredSize().height));
                final JPopupMenu innerPopMenu = popMenu;
                innerItem.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        super.mousePressed(e);
                        ChartInnerLinkExec innerLinkExec = (ChartInnerLinkExec)context.getHyperLinkHandler().getLinkExec("fsChartInner:");
                        if (innerLinkExec != null) {
                            innerLinkExec.setDataItemInfo(dataItemInfo);
                            innerLinkExec.setChartModel(fChart.getModel());
                            innerLinkExec.execute(null);
                        }
                        innerPopMenu.setVisible(false);
                    }
                });
                popMenu = innerPopMenu;
                popMenu.add((JMenuItem)innerItem);
            }
            for (ExtTransitionTarget extTarget : listExtTarget) {
                ReportProperties extProps = extTarget.getReportProps();
                String extAlias = extProps.getAlias();
                if (ep != null) {
                    ICalculableProps calculableProps = extProps.getCalculableProps();
                    Object obj = ep.executeCalculableProps(calculableProps);
                    String string = extAlias = obj == null ? extAlias : obj.toString();
                }
                if (extAlias != null && extAlias.length() > 20) {
                    extAlias = extAlias.substring(0, 20) + "...";
                }
                KDMenuItem extItem = new KDMenuItem((Action)action);
                if (extAlias == null) {
                    extAlias = "";
                }
                extItem.setText(CtrlEXTMessages.getMLS("linkedTo", "\u8054\u67e5\u5230\"#1\"").replace("#1", extAlias));
                extItem.setUserObject((Object)extProps.getId());
                popMenu.add((JMenuItem)extItem);
            }
        }
        finally {
            if (isCreateLastCell) {
                activeSheet.getRows().remove(1048574);
                activeSheet.getCols().remove(65534);
            }
        }
        return popMenu;
    }

    public static List<InnerLinkTransitionTarget> filterInnerTarget(List<InnerLinkTransitionTarget> targets, SpreadContext context, FlashChartModel model) {
        return targets.stream().filter(target -> ChartLinkRequestHandler.existTargetInTable(target, context, model)).collect(Collectors.toList());
    }

    private static boolean existTargetInTable(InnerLinkTransitionTarget target, SpreadContext context, FlashChartModel model) {
        block4: {
            Sheet sheet;
            block3: {
                sheet = context.getBook().getActiveSheet();
                if (!"fusionChart".equals(target.getTargetType())) break block3;
                EmbedhLayer layers = sheet.getEmbedments(false);
                if (layers == null) break block4;
                int size = layers.size();
                String targetName = target.getTargetProps().getName();
                for (int i = 0; i < size; ++i) {
                    EmbedObject embed = layers.getEmbed(i);
                    if (!(embed instanceof ChartRectEmbedment) || !targetName.equals("'" + sheet.getSheetName() + "'!" + embed.getName())) continue;
                    return true;
                }
                break block4;
            }
            List<Cell> subReportCells = sheet.getSubReportCells();
            if (subReportCells == null || subReportCells.isEmpty()) {
                return false;
            }
            for (Cell cell : subReportCells) {
                SubReportInfo subReportInfo = cell.getSubReportInfo();
                if (subReportInfo == null || !target.getTargetProps().getId(model.getDataNode()).equals(cell.getName(false, true))) continue;
                return true;
            }
        }
        return false;
    }
}

