/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.exec;

import com.kingdee.cosmic.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.ThreadLocalUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.cosmic.ctrl.ext.fulfil.IShowLinkage;
import com.kingdee.cosmic.ctrl.ext.fulfil.TransitionException;
import com.kingdee.cosmic.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.cosmic.ctrl.ext.immit.IRptRuntimeCallback;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.swing.MessageDialog;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class AbstractHyperLinkExec
implements IHyperLinkExec {
    private static final Logger logger = LogUtil.getPackageLogger(AbstractHyperLinkExec.class);
    public static String ACTIONS = "actions";
    public static final String OriginalDefaultValue = "@OriginalDefaultValue";
    public static final String ParseParamDefaultValue = "ParseParamDefaultValue";
    public static String CELLID = "cellid";
    public static String PARAMS = "params";
    public static String TITLE = "title";
    public static String EXECUTOR = "executor";
    public static String REPORTID = "reportId";
    public static String PARENT_PERMISSION = "parentPermission";
    protected ExtGuiExecutor _oriExecutor;
    protected IShowLinkage _linkage;
    protected Book _book;
    protected SpreadContext _context;
    protected IExtRuntimeDataProvider _dataProvider;
    protected boolean _limit;

    public AbstractHyperLinkExec(ExtGuiExecutor executor, SpreadContext context, IExtRuntimeDataProvider dataProvider, boolean limit) {
        if (executor != null) {
            this._oriExecutor = executor;
            this._context = executor.getSpreadContext();
            this._book = executor.getBook();
            this._dataProvider = executor.getDataProvider();
            this._limit = executor.getLimit();
        } else if (context != null) {
            this._context = context;
            this._book = this._context.getBook();
            this._dataProvider = dataProvider;
            this._limit = limit;
        }
    }

    public void execute(final String id) {
        if (this._oriExecutor != null) {
            this._oriExecutor.setProgressPaneVisible(true);
        }
        final Object alias = ThreadLocalUtil.get((String)"alias");
        ThreadLocalUtil.remove((String)"alias");
        new Thread(new Runnable(){

            @Override
            public void run() {
                Book book = AbstractHyperLinkExec.this._oriExecutor != null ? AbstractHyperLinkExec.this._oriExecutor.getBook() : AbstractHyperLinkExec.this._context.getBook();
                Cell activeCell = book.getActiveSheet().getActiveCell();
                if (activeCell == null) {
                    activeCell = book.getActiveSheet().getCell(0, 0, true);
                }
                String celID = activeCell.getName(false, false);
                ExtProps ep = activeCell.getExtProps(true);
                ETTargets ett = AbstractHyperLinkExec.this.getETTargets(activeCell);
                if (ett == null) {
                    return;
                }
                List targets = ett.getTargets();
                ExtTransitionTarget target = null;
                for (ExtTransitionTarget temp : targets) {
                    ReportProperties rptProps = temp.getReportProps();
                    if (!rptProps.getId().equals(id) || alias != null && !AbstractHyperLinkExec.this.trimAliasDot(rptProps.getAlias()).equals(AbstractHyperLinkExec.this.trimAliasDot(alias.toString()))) continue;
                    target = temp;
                    break;
                }
                if (target == null) {
                    if (MiscUtil.shouldLog()) {
                        MiscUtil.log(4, CtrlEXTMessages.getMLS("linkTargetEmpty", "\u8054\u67e5\u76ee\u6807\u4e3a\u7a7a\uff0c\u76f4\u63a5\u8fd4\u56de"));
                    }
                    return;
                }
                ReportProperties fullName = target.getReportProps();
                Object alias2 = ep.executeCalculableProps(fullName.getCalculableProps());
                if (alias2 != null) {
                    fullName.setAlias(alias2.toString());
                }
                Map<String, IParameter> params = target.getParameters();
                String title = CtrlEXTMessages.getMLS("reportLinkage", "\u62a5\u8868\u8054\u67e5 - ") + (StringUtil.isEmptyString((String)fullName.getName()) ? fullName.getName() : fullName.getAlias());
                ExecutionContext currentCtx = book.getDataSetManager().getExecutionContext();
                IExtRuntimeDataProvider dataProvider = (IExtRuntimeDataProvider)AbstractHyperLinkExec.this._dataProvider.clone(fullName);
                ReportProperties properties = AbstractHyperLinkExec.this._dataProvider.fetchCurrentReportProperties();
                currentCtx.registerDataSetCacheObject("hyperLinkSourceReportId", properties.getId() == null ? "null" : properties.getId());
                byte[] data = dataProvider.getTransitionTargetData(fullName, currentCtx);
                currentCtx.unRegisterDataSetCacheObject("hyperLinkSourceReportId");
                if (data == null) {
                    if (AbstractHyperLinkExec.this._oriExecutor != null) {
                        AbstractHyperLinkExec.this._oriExecutor.setProgressPaneVisible(false);
                    }
                    String tip = CtrlEXTMessages.getMLS("targetReportNotFound", "\u8054\u67e5\u7684\u76ee\u6807\u62a5\u8868\u627e\u4e0d\u5230\uff0c\u8bf7\u4fee\u6539\u62a5\u8868\u6a21\u677f\uff0c\u91cd\u65b0\u8bbe\u7f6e\u8054\u67e5\u3002");
                    if (fullName.getPathAlias().contains(CtrlEXTMessages.getMLS("presetDirectory", "\u9884\u7f6e\u76ee\u5f55"))) {
                        tip = CtrlEXTMessages.getMLS("noPermissionForPresetReport2", "\u60a8\u6ca1\u6709\u8be5\u9884\u7f6e\u62a5\u8868\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u201c\u7ba1\u7406\u5458\u201d\u8fdb\u884c\u6388\u6743\u3002");
                    }
                    MessageDialog.show((Component)SwingUtilities.getWindowAncestor((Component)((Object)AbstractHyperLinkExec.this._context)), (Object)tip, (String)CtrlEXTMessages.getMLS("msgTitle", "\u4fe1\u606f\u63d0\u793a"), (int)-1, (int)1);
                    return;
                }
                boolean limit = AbstractHyperLinkExec.this._limit;
                if (!limit) {
                    try {
                        dataProvider.beforeTransition(fullName);
                    }
                    catch (TransitionException e) {
                        MessageDialog.show((Component)SwingUtilities.getWindowAncestor((Component)((Object)AbstractHyperLinkExec.this._context)), (Object)e.getMessage(), (String)CtrlEXTMessages.getMLS("msgTitle", "\u4fe1\u606f\u63d0\u793a"), (int)-1, (int)1);
                        if (AbstractHyperLinkExec.this._oriExecutor != null) {
                            AbstractHyperLinkExec.this._oriExecutor.setProgressPaneVisible(false);
                        }
                        return;
                    }
                }
                if (params != null && params.size() > 0) {
                    ep.executeParams(params);
                    AbstractHyperLinkExec.executeParamsDefaultValue(dataProvider, params, target, data);
                    AbstractHyperLinkExec.this.executeChartParams(params);
                    if (MiscUtil.shouldLog()) {
                        StringBuilder sb = new StringBuilder(CtrlEXTMessages.getMLS("receivedParameters", CtrlEXTMessages.getMLS("receivedParameters", "\u8054\u67e5\u76ee\u6807 #1 \u63a5\u6536\u5230\u5982\u4e0b\u53c2\u6570\uff1a<br>").replace("#1", StringUtil.isEmptyString((String)fullName.getName()) ? fullName.getName() : fullName.getAlias())));
                        Iterator<Map.Entry<String, IParameter>> i = params.entrySet().iterator();
                        while (i.hasNext()) {
                            IParameter param = i.next().getValue();
                            sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                            sb.append(param.getAlias());
                            sb.append(" \uff1a ");
                            sb.append(param.getValue());
                            sb.append("<br>");
                        }
                        MiscUtil.log(4, sb.toString());
                    }
                } else if (MiscUtil.shouldLog()) {
                    MiscUtil.log(4, CtrlEXTMessages.getMLS("noParametersReceived", CtrlEXTMessages.getMLS("noParametersReceived", "\u8054\u67e5\u76ee\u6807  #1  \u6ca1\u6709\u63a5\u6536\u5230\u4efb\u4f55\u53c2\u6570").replace("#1", StringUtil.isEmptyString((String)fullName.getName()) ? fullName.getName() : fullName.getAlias())));
                }
                ExtGuiExecutor exec = new ExtGuiExecutor(data, dataProvider, limit);
                IRptRuntimeCallback rptRuntimeCallback = dataProvider.getRptRuntimeCallback(null);
                exec.loadImageWithContext(exec.getBook(), rptRuntimeCallback);
                exec.copyCacheObjectFrom(currentCtx);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(ACTIONS, exec.getToolBarActions());
                HashMap<String, IParameter> cloneParams = new HashMap<String, IParameter>();
                cloneParams.putAll(params);
                map.put(PARAMS, cloneParams);
                map.put(TITLE, title);
                map.put(EXECUTOR, exec);
                map.put(REPORTID, id);
                if (properties != null) {
                    StringBuilder permission = new StringBuilder();
                    permission.append(properties.isExportPermitted() ? (char)'1' : '0').append(';');
                    permission.append(properties.isPrintPermitted() ? "1" : "0");
                    map.put(PARENT_PERMISSION, permission.toString());
                }
                AbstractHyperLinkExec.this.getLinkage().show(map, title + celID, SwingUtilities.getWindowAncestor((Component)((Object)AbstractHyperLinkExec.this._context)));
                if (AbstractHyperLinkExec.this._oriExecutor != null) {
                    AbstractHyperLinkExec.this._oriExecutor.setProgressPaneVisible(false);
                }
            }
        }).start();
    }

    private String trimAliasDot(String alias) {
        if (alias != null) {
            if (alias.startsWith("\u201c") && alias.endsWith("\u201c")) {
                alias = alias.replaceFirst("\u201c", "");
                alias = alias.substring(0, alias.length() - 1);
            } else if (alias.startsWith("\"") && alias.endsWith("\"")) {
                alias = alias.replaceFirst("\"", "");
                alias = alias.substring(0, alias.indexOf("\""));
            }
        } else {
            return "";
        }
        return alias;
    }

    protected abstract ETTargets getETTargets(Cell var1);

    protected void executeChartParams(Map params) {
    }

    public static void executeParamsDefaultValue(IExtRuntimeDataProvider dataProvider, Map params, CommonCalculableProps props, byte[] bookData) {
        if (params == null || params.isEmpty()) {
            return;
        }
        ReportProperties fullName = null;
        ExecutionContext ctx = new ExecutionContext(null);
        ctx.setDataSetParameters(params);
        if (props instanceof ExtTransitionTarget) {
            fullName = ((ExtTransitionTarget)props).getReportProps();
            if (null != bookData) {
                try {
                    Book targetBook = BookIOUtil.unpack(bookData);
                    ExtDataSet[] dataSets = MiscUtil.collectExtDataSets(targetBook);
                    ctx.registerDataSetCacheObject("targetRptDataset", dataSets);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else if (props instanceof SubReportInfo) {
            SubReportInfo subReportInfo = (SubReportInfo)props;
            fullName = subReportInfo.getReportProps();
            try {
                Book subBook;
                if (null != bookData) {
                    subBook = BookIOUtil.unpack(bookData);
                } else {
                    subBook = subReportInfo.getBook();
                    if (null == subBook) {
                        subBook = BookIOUtil.unpack(subReportInfo.getBookData());
                    }
                }
                ExtDataSet[] dataSets = MiscUtil.collectExtDataSets(subBook);
                ctx.registerDataSetCacheObject("targetRptDataset", dataSets);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        dataProvider.linkParamsDefaultValue(fullName, ctx);
    }

    public void setShowLinkage(IShowLinkage linkage) {
        this._linkage = linkage;
    }

    private IShowLinkage getLinkage() {
        if (this._linkage == null) {
            this._linkage = new IShowLinkage(){

                @Override
                public void show(Map params, String cellTemplateID, Component owner) {
                    ExtGuiExecutor executor = (ExtGuiExecutor)params.get(EXECUTOR);
                    executor.executeWithinWindow((Map)params.get(PARAMS), (String)params.get(TITLE));
                }
            };
        }
        return this._linkage;
    }
}

