/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.exec;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.cosmic.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.exec.AbstractInnerLinkExec;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.ChartDataItemInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargetProperties;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ChartInnerLinkExec
extends AbstractInnerLinkExec {
    private FlashChartModel _chartModel;
    private ChartDataItemInfo _dataItemInfo;

    public ChartInnerLinkExec(ExtGuiExecutor guiExecutor, SpreadContext context, IExtRuntimeDataProvider dataProvider) {
        super(guiExecutor, context, dataProvider);
    }

    @Override
    public void execute(String linkTo) {
        InnerLinkTargets targets = this._chartModel.getInnerTargets();
        if (targets == null) {
            return;
        }
        List<InnerLinkTransitionTarget> listTarget = targets.getTargets();
        if (listTarget == null || listTarget.isEmpty()) {
            return;
        }
        super.execute(linkTo);
        Book book = this._book;
        Cell cell = book.getActiveSheet().getActiveCell();
        if (cell == null) {
            cell = book.getActiveSheet().getCell(0, 0, true);
        }
        ExtProps ep = cell.getExtProps(true);
        InnerLinkTransitionTarget target2 = null;
        for (InnerLinkTransitionTarget target2 : listTarget) {
            InnerLinkTargetProperties props;
            String linkName;
            if (target2 == null) continue;
            String targetType = target2.getTargetType();
            Map<String, IParameter> params = target2.getParams();
            if (params != null && params.size() > 0) {
                ep.executeParams(params);
                ChartInnerLinkExec.executeChartParams(params, this._dataItemInfo);
            }
            if (StringUtil.isEmptyString((String)(linkName = (props = target2.getTargetProps()).getId(this._chartModel.getDataNode())))) continue;
            this.execute(targetType, linkName, params);
        }
    }

    public static void executeChartParams(Map params, ChartDataItemInfo dataItemInfo) {
        if (dataItemInfo == null) {
            return;
        }
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            IParameter param = (IParameter)i.next().getValue();
            Variant var = param.getValue();
            if (var == null || var == Variant.nullVariant) continue;
            Object value = var.getValue();
            if (!var.isError()) continue;
            Object errorData = ((SyntaxErrorException)value).getExtData();
            if (errorData instanceof String) {
                if ("@categoryName".equalsIgnoreCase((String)errorData)) {
                    String categoryName = dataItemInfo.getCategoryName();
                    if (dataItemInfo.isMultiCategory() && categoryName != null) {
                        categoryName = categoryName.replace("[", "").replace("]", "");
                        String[] names = categoryName.split(",");
                        Variant[] values = (Variant[])Arrays.stream(names).map(name -> new Variant(name, 11)).toArray(Variant[]::new);
                        var = new Variant(values, 512);
                    } else {
                        var = new Variant(categoryName, 11);
                    }
                } else if ("@seriesName".equalsIgnoreCase((String)errorData)) {
                    var = new Variant(dataItemInfo.getSeriesName(), 11);
                } else if ("@seriesValue".equalsIgnoreCase((String)errorData) && dataItemInfo.getSeriesValue() != null) {
                    var = new Variant(new BigDecimal(dataItemInfo.getSeriesValue()), 10);
                }
            }
            param.setValue(var);
        }
    }

    public void setChartModel(FlashChartModel chartModel) {
        this._chartModel = chartModel;
    }

    public void setDataItemInfo(ChartDataItemInfo dataItemInfo) {
        this._dataItemInfo = dataItemInfo;
    }
}

