/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.resultset;

import com.kingdee.cosmic.ctrl.kds.expans.model.data.AbstractExtDataSetPage;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetColPage;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtMetaInfo;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

public abstract class AbstractResultSetStub
implements InvocationHandler {
    protected int rowIndex = -1;
    protected ResultSetMetaData resultSetMetaData;
    protected ExtMetaInfo metaInfo;
    protected int totalRows;

    protected ResultSet createStub() {
        return (ResultSet)Proxy.newProxyInstance(AbstractResultSetStub.class.getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().contains("next")) {
            return this.rowIndex++ < this.totalRows - 1;
        }
        if (method.getName().contains("getMetaData")) {
            return this.resultSetMetaData;
        }
        if (method.getName().contains("getObject")) {
            int colIndex = (Integer)args[0] < 1 ? -1 : (Integer)args[0] - 1;
            Object data = null;
            AbstractExtDataSetPage page = this.searchNextPage(this.rowIndex, colIndex);
            if (page != null) {
                data = colIndex == -1 ? page.getObjArr(this.rowIndex) : (page instanceof ExtDataSetColPage ? page.getObjArr(this.rowIndex)[0] : page.getObjArr(this.rowIndex)[colIndex]);
            }
            if (this.resultSetMetaData.getColumnType(colIndex + 1) != 3) {
                return data;
            }
            if (data != null) {
                return new BigDecimal(data.toString());
            }
            return null;
        }
        if (method.getName().contains("absolute")) {
            int row = (Integer)args[0];
            if (row <= this.totalRows && row > 0) {
                this.rowIndex = row - 1;
                return Boolean.TRUE;
            }
            if (row < 0 && this.totalRows + row >= 0) {
                this.rowIndex = this.totalRows + row;
                return Boolean.TRUE;
            }
            if (row == 0) {
                this.rowIndex = -1;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (method.getName().contains("last")) {
            this.rowIndex = this.totalRows - 1;
            return Boolean.TRUE;
        }
        if (method.getName().contains("first")) {
            this.rowIndex = 0;
        } else if (method.getName().contains("beforeFirst")) {
            this.rowIndex = -1;
        } else if (method.getName().contains("close")) {
            this.close();
        } else {
            if (method.getName().contains("getRow")) {
                return this.rowIndex + 1;
            }
            if (method.getName().contains("isLast")) {
                return this.rowIndex == this.totalRows - 1;
            }
            if (method.getName().contains("isBeforeFirst")) {
                return this.rowIndex == -1;
            }
            throw new Exception("unsurported method in ResultSetStub\uff0cmethod:" + method.getName());
        }
        return null;
    }

    protected abstract AbstractExtDataSetPage searchNextPage(int var1, int var2);

    protected abstract void close();

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public ExtMetaInfo getMetaInfo() {
        return this.metaInfo;
    }
}

