/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.frame;

import com.kingdee.cosmic.ctrl.kds.frame.LayoutCell;
import com.kingdee.cosmic.ctrl.kds.frame.MultiViewPane;
import com.kingdee.cosmic.ctrl.kds.frame.MvpLayoutInfoManager;
import com.kingdee.cosmic.ctrl.kds.frame.MvpScrollBarManager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class MultiViewPaneUI
extends ComponentUI {
    protected MouseInputListener mouseInputListener;
    public static Color[] colors = new Color[]{new Color(162, 162, 162), new Color(255, 255, 255), new Color(234, 234, 227), new Color(234, 234, 227), new Color(214, 213, 201), new Color(162, 162, 162)};
    int lastVSplitShadowBarPosition = -1;

    public static void drawSplitBar(Graphics g, Rectangle r, int type, Color[] colors) {
        int y1 = r.y;
        int x1 = r.x;
        int x2 = x1 + r.width - 1;
        int y2 = y1 + r.height - 1;
        int xOrY = 0;
        xOrY = type == 0 ? y1 : x1;
        int i = 0;
        while (i < colors.length) {
            g.setColor(colors[i]);
            if (type == 0) {
                g.drawLine(x1, xOrY, x2, xOrY);
            } else {
                g.drawLine(xOrY, y1, xOrY, y2);
            }
            ++i;
            ++xOrY;
        }
    }

    public static void drawSplitBarWidthBorder(Graphics g, Rectangle r, int type, Color[] colors) {
        if (r.isEmpty()) {
            return;
        }
        int y1 = r.y;
        int x1 = r.x;
        int x2 = x1 + r.width - 1;
        int bottom = y1 + r.height - 1;
        int right = x1 + r.width - 1;
        int y2 = y1 + r.height - 1;
        g.setColor(colors[0]);
        if (type == 1) {
            g.drawLine(x1, y1, right, y1);
            g.drawLine(x1, y2, right, y2);
        } else {
            g.drawLine(x1, y1, x1, bottom);
            g.drawLine(x2, y1, x2, bottom);
        }
        Rectangle barR = new Rectangle(r);
        if (type == 1) {
            ++barR.y;
            barR.height -= 2;
        } else {
            ++barR.x;
            barR.width -= 2;
        }
        MultiViewPaneUI.drawSplitBar(g, barR, type, colors);
    }

    public static int antiDirection(int direction) {
        if (direction == 0) {
            return 1;
        }
        return 0;
    }

    public static ComponentUI createUI(JComponent c) {
        return new MultiViewPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        MultiViewPane mvp = (MultiViewPane)c;
        this.installDefaults(mvp);
        this.installListeners(mvp);
        this.installKeyboardActions(mvp);
    }

    @Override
    public void uninstallUI(JComponent c) {
        MultiViewPane mvp = (MultiViewPane)c;
        this.uninstallDefaults(mvp);
        this.uninstallListeners(mvp);
        this.uninstallKeyboardActions(mvp);
    }

    protected void installDefaults(MultiViewPane mvp) {
    }

    protected void installListeners(MultiViewPane mvp) {
        this.mouseInputListener = new MouseHandle();
        mvp.addMouseListener(this.mouseInputListener);
        mvp.addMouseMotionListener(this.mouseInputListener);
    }

    protected void installKeyboardActions(MultiViewPane mvp) {
    }

    protected void uninstallDefaults(MultiViewPane mvp) {
    }

    protected void uninstallListeners(MultiViewPane mvp) {
        mvp.removeMouseListener(this.mouseInputListener);
        mvp.removeMouseMotionListener(this.mouseInputListener);
        this.mouseInputListener = null;
    }

    protected void uninstallKeyboardActions(MultiViewPane mvp) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        MultiViewPane mvp = (MultiViewPane)c;
        MvpLayoutInfoManager lim = mvp.getLayoutInfoManager();
        if (lim.isVSplitButtonVisible()) {
            this.drawSplitBarWidthBorder(g, lim.getVSplitButtonRect(), 0);
        }
        if (lim.isHSplitButtonVisible()) {
            this.drawSplitBarWidthBorder(g, lim.getHSplitButtonRect(), 1);
        }
        this.drawSplit(g, mvp);
    }

    void drawSplit(Graphics g, MultiViewPane mvp) {
        this.drawSplit(g, mvp, 0);
        this.drawSplit(g, mvp, 1);
    }

    private void drawSplit(Graphics g, MultiViewPane mvp, int orientation) {
        int count2;
        MvpLayoutInfoManager lim = mvp.getLayoutInfoManager();
        MvpScrollBarManager spm = mvp.getScrollBarManager();
        int vCount = mvp.getVerticalCount();
        int hCount = mvp.getHorizonCount();
        Rectangle rect2 = new Rectangle();
        Rectangle rect = new Rectangle();
        int count1 = 0;
        if (orientation == 0) {
            count1 = vCount;
            count2 = hCount;
        } else {
            count1 = hCount;
            count2 = vCount;
        }
        block5: for (int i = 0; i < count1; ++i) {
            LayoutCell cell = lim.getLayoutCell(MultiViewPaneUI.antiDirection(orientation), i);
            switch (cell.getSplitType()) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    for (int j = 0; j < count2; ++j) {
                        LayoutCell cell2 = lim.getLayoutCell(orientation, j);
                        if (orientation == 0) {
                            rect.x = cell2.getStart();
                            rect.y = cell.getStart() + cell.getSpan();
                            rect.height = 6;
                            rect.width = cell2.getSpan();
                            if (j == hCount - 1) {
                                rect.width += mvp.getScrollBarManager().getVScrollPanelWidth();
                            }
                        } else {
                            rect.y = cell2.getStart();
                            rect.x = cell.getStart() + cell.getSpan();
                            rect.width = 6;
                            rect.height = cell2.getSpan();
                            if (j == vCount - 1) {
                                rect.height += mvp.getScrollBarManager().getHScrollPanelHeightWhenHasScrollBar();
                            }
                        }
                        if (j == 0) {
                            rect2.setBounds(rect);
                            continue;
                        }
                        rect2.add(rect);
                    }
                    if (rect2.width == 0) continue block5;
                    this.drawSplitBarWidthBorder(g, rect2, orientation);
                    continue block5;
                }
                case 2: {
                    if (orientation == 0) {
                        rect.y = cell.getStart() + cell.getSpan();
                        rect.height = 1;
                        rect.x = mvp.getInsets().left;
                        rect.width = mvp.getWidth() - mvp.getInsets().left - mvp.getInsets().right - spm.getVScrollPanelWidth();
                        this.drawSplitLine(g, rect);
                        continue block5;
                    }
                    rect.x = cell.getStart() + cell.getSpan();
                    rect.width = 1;
                    rect.y = mvp.getInsets().top;
                    rect.height = mvp.getHeight() - mvp.getInsets().top - mvp.getInsets().bottom - spm.getHScrollPanelHeight();
                    this.drawSplitLine(g, rect);
                    continue block5;
                }
            }
        }
    }

    void drawSplitBarWidthBorder(Graphics g, Rectangle r, int type) {
        MultiViewPaneUI.drawSplitBarWidthBorder(g, r, type, colors);
    }

    private void drawSplitLine(Graphics g, Rectangle r) {
        int top = r.y;
        int left = r.x;
        int right = left + r.width - 1;
        int bottom = top + r.height - 1;
        g.setColor(Color.BLACK);
        g.drawLine(left, top, right, bottom);
    }

    private void drawMoveSplitShadowBar(MultiViewPane mvp, int xORy, int direction) {
        this.drawSplitShadowBar(mvp, this.lastVSplitShadowBarPosition, direction);
        this.drawSplitShadowBar(mvp, xORy, direction);
        this.lastVSplitShadowBarPosition = xORy;
    }

    private void drawSplitShadowBarAndClearLast(MultiViewPane mvp, int xORy, int direction) {
        this.drawSplitShadowBar(mvp, xORy, direction);
        this.lastVSplitShadowBarPosition = -1;
    }

    private void drawSplitShadowBar(MultiViewPane mvp, int xORy, int direction) {
        if (xORy >= 0) {
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            int max = mvp.getLayoutInfoManager().getMaxCanSplitRange(direction);
            int min = mvp.getLayoutInfoManager().getMinCanSplitRange(direction);
            if (direction == 0) {
                if (xORy > max) {
                    xORy = max;
                } else if (xORy < min) {
                    xORy = min;
                }
                x = xORy;
                y = mvp.getInsets().top;
                width = 6;
                height = mvp.getHeight() - mvp.getScrollBarManager().getVScrollPanelWidth() - mvp.getInsets().top - mvp.getInsets().bottom;
            } else {
                x = mvp.getInsets().left;
                if (xORy > max) {
                    xORy = max;
                } else if (xORy < min) {
                    xORy = min;
                }
                y = xORy;
                width = mvp.getWidth() - mvp.getScrollBarManager().getVScrollPanelWidth() - mvp.getInsets().left - mvp.getInsets().right;
                height = 6;
            }
            Graphics2D g = (Graphics2D)mvp.getGraphics();
            g.setXORMode(g.getBackground());
            g.setColor(Color.GRAY);
            g.fillRect(x, y, width, height);
            g.setPaintMode();
        }
    }

    class MouseHandle
    implements MouseInputListener {
        private int vCurrentSplitBar = -1;
        private int hCurrentSplitBar = -1;
        protected int status = 0;
        public static final int ACTION_NORMAL = 0;
        public static final int ACTION_ABOVE_VSPLITBUTTON = 1;
        public static final int ACTION_MOVE_VSPLITBUTTON = 2;
        public static final int ACTION_ABOVE_HSPLITBUTTON = 3;
        public static final int ACTION_MOVE_HSPLITBUTTON = 4;
        public static final int ACTION_ABOVE_VSPLITBAR = 5;
        public static final int ACTION_MOVE_VSPLITBAR = 6;
        public static final int ACTION_ABOVE_HSPLITBAR = 7;
        public static final int ACTION_MOVE_HSPLITBAR = 8;

        MouseHandle() {
        }

        protected void setStatus(int status, MultiViewPane mvp) {
            switch (status) {
                case 0: {
                    mvp.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 1: {
                    mvp.setCursor(Cursor.getPredefinedCursor(8));
                    break;
                }
                case 3: {
                    mvp.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 5: {
                    mvp.setCursor(Cursor.getPredefinedCursor(8));
                    break;
                }
                case 7: {
                    mvp.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
                case 6: {
                    break;
                }
                case 8: {
                    break;
                }
            }
            this.status = status;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            MultiViewPane mvp = (MultiViewPane)e.getSource();
            Point p = e.getPoint();
            if (e.getClickCount() == 2) {
                if (this.isAboveVSplitButton(p, mvp)) {
                    mvp.split(1);
                } else if (this.isAboveHSplitButton(p, mvp)) {
                    mvp.split(0);
                } else if (this.isAboveHSplitBar()) {
                    mvp.mergeSplit(0);
                } else if (this.isAboveVSplitBar()) {
                    mvp.mergeSplit(1);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MultiViewPane mvp = (MultiViewPane)e.getSource();
            if (e.getClickCount() == 2) {
                return;
            }
            switch (this.status) {
                case 0: {
                    break;
                }
                case 1: {
                    this.setStatus(2, mvp);
                    break;
                }
                case 3: {
                    this.setStatus(4, mvp);
                    break;
                }
                case 5: {
                    this.setStatus(6, mvp);
                    break;
                }
                case 7: {
                    this.setStatus(8, mvp);
                    break;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MultiViewPane mvp = (MultiViewPane)e.getSource();
            if (e.getClickCount() == 2) {
                return;
            }
            switch (this.status) {
                case 2: {
                    MultiViewPaneUI.this.drawSplitShadowBarAndClearLast(mvp, MultiViewPaneUI.this.lastVSplitShadowBarPosition, 1);
                    this.setStatus(0, mvp);
                    mvp.splitByPosition(1, e.getY());
                    break;
                }
                case 4: {
                    MultiViewPaneUI.this.drawSplitShadowBarAndClearLast(mvp, MultiViewPaneUI.this.lastVSplitShadowBarPosition, 0);
                    this.setStatus(0, mvp);
                    mvp.splitByPosition(0, e.getX());
                    break;
                }
                case 6: {
                    MultiViewPaneUI.this.drawSplitShadowBarAndClearLast(mvp, MultiViewPaneUI.this.lastVSplitShadowBarPosition, 1);
                    this.setStatus(0, mvp);
                    mvp.setSplitPosition(1, e.getY());
                    break;
                }
                case 8: {
                    MultiViewPaneUI.this.drawSplitShadowBarAndClearLast(mvp, MultiViewPaneUI.this.lastVSplitShadowBarPosition, 0);
                    this.setStatus(0, mvp);
                    mvp.setSplitPosition(0, e.getX());
                    break;
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MultiViewPane mvp = (MultiViewPane)e.getSource();
            switch (this.status) {
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    this.setStatus(0, mvp);
                    break;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MultiViewPane mvp = (MultiViewPane)e.getSource();
            switch (this.status) {
                case 2: {
                    MultiViewPaneUI.this.drawMoveSplitShadowBar(mvp, e.getY(), 1);
                    break;
                }
                case 6: {
                    MultiViewPaneUI.this.drawMoveSplitShadowBar(mvp, e.getY(), 1);
                    break;
                }
                case 4: {
                    MultiViewPaneUI.this.drawMoveSplitShadowBar(mvp, e.getX(), 0);
                    break;
                }
                case 8: {
                    MultiViewPaneUI.this.drawMoveSplitShadowBar(mvp, e.getX(), 0);
                    break;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            MultiViewPane mvp = (MultiViewPane)e.getSource();
            Point p = e.getPoint();
            switch (this.status) {
                case 0: {
                    if (this.isAboveVSplitButton(p, mvp)) {
                        this.setStatus(1, mvp);
                    } else if (this.isAboveHSplitButton(p, mvp)) {
                        this.setStatus(3, mvp);
                    }
                    int a = this.isAboveSplitBar(p, mvp);
                    if (a == 1) {
                        this.setStatus(5, mvp);
                        break;
                    }
                    if (a != 2) break;
                    this.setStatus(7, mvp);
                    break;
                }
                case 1: {
                    if (this.isAboveVSplitButton(p, mvp)) break;
                    this.setStatus(0, mvp);
                    break;
                }
                case 3: {
                    if (this.isAboveHSplitButton(p, mvp)) break;
                    this.setStatus(0, mvp);
                    break;
                }
                case 5: {
                    if (1 == this.isAboveSplitBar(p, mvp)) break;
                    this.setStatus(0, mvp);
                    break;
                }
                case 7: {
                    if (2 == this.isAboveSplitBar(p, mvp)) break;
                    this.setStatus(0, mvp);
                    break;
                }
            }
        }

        boolean isAboveVSplitButton(Point p, MultiViewPane mvp) {
            return mvp.getLayoutInfoManager().getVSplitButtonRect().contains(p);
        }

        boolean isAboveHSplitButton(Point p, MultiViewPane mvp) {
            return mvp.getLayoutInfoManager().getHSplitButtonRect().contains(p);
        }

        boolean isAboveVSplitBar() {
            return this.hCurrentSplitBar == -1 && this.vCurrentSplitBar != -1;
        }

        boolean isAboveHSplitBar() {
            return this.vCurrentSplitBar == -1 && this.hCurrentSplitBar != -1;
        }

        int isAboveSplitBar(Point p, MultiViewPane mvp) {
            LayoutCell info;
            int i;
            this.vCurrentSplitBar = -1;
            this.hCurrentSplitBar = -1;
            MvpLayoutInfoManager lim = mvp.getLayoutInfoManager();
            int vCount = mvp.getVerticalCount();
            int hCount = mvp.getHorizonCount();
            int x = p.x;
            int y = p.y;
            for (i = 0; i < vCount; ++i) {
                info = lim.getVertical(i);
                if (info.getSpan() <= 0) continue;
                if (y < info.getStart()) {
                    this.vCurrentSplitBar = i - 1;
                    if (this.vCurrentSplitBar <= 0 || lim.getVertical(this.vCurrentSplitBar).getSplitType() == 1) break;
                    this.vCurrentSplitBar = -1;
                    break;
                }
                if (y >= info.getStart() + info.getSpan()) continue;
                this.vCurrentSplitBar = -1;
                break;
            }
            for (i = 0; i < hCount; ++i) {
                info = lim.getHorizon(i);
                if (info.getSpan() <= 0) continue;
                if (x < info.getStart()) {
                    this.hCurrentSplitBar = i - 1;
                    if (this.hCurrentSplitBar <= 0 || lim.getHorizon(this.hCurrentSplitBar).getSplitType() == 1) break;
                    this.hCurrentSplitBar = -1;
                    break;
                }
                if (x >= info.getStart() + info.getSpan()) continue;
                this.hCurrentSplitBar = -1;
                break;
            }
            if (this.isAboveVSplitBar()) {
                return 1;
            }
            if (this.isAboveHSplitBar()) {
                return 2;
            }
            return 0;
        }
    }
}

