/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl;

import com.kingdee.cosmic.ctrl.common.CtrlUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.action.SpreadAction;
import com.kingdee.cosmic.ctrl.kds.impl.action.SpreadActionFactory;
import com.kingdee.cosmic.ctrl.kds.model.struct.BookProtection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.BookChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.BookChangeListener;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.BookPropertyChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.BookPropertyChangeListener;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetPropertyChangeListener;
import java.util.HashMap;

public final class ActionManager
implements BookChangeListener,
SheetPropertyChangeListener,
BookPropertyChangeListener {
    private HashMap _actionMap;
    private SpreadContext _context;

    ActionManager(SpreadContext context) {
        this._context = context;
    }

    public SpreadAction getAction(String name, boolean create) {
        SpreadAction action = null;
        if (this._actionMap != null) {
            action = (SpreadAction)this._actionMap.get(name);
        }
        if (!(action instanceof SpreadAction) && create) {
            boolean enable = action != null ? (Boolean)((Object)action) : true;
            action = SpreadActionFactory.createAction(name, this._context);
            if (action != null) {
                this.putAction(name, action);
                action.setEnabled(enable);
            }
        }
        return action instanceof SpreadAction ? (SpreadAction)action : null;
    }

    public SpreadAction getAction(String name) {
        return this.getAction(name, true);
    }

    public void putAction(String name, SpreadAction action) {
        if (this._actionMap == null) {
            this._actionMap = new HashMap();
        }
        this._actionMap.put(name, action);
    }

    @Override
    public void changed(BookChangeEvent e) {
        if (!e.isGroup() && e.isSheetActive()) {
            this.sync(this._context.getBook().getActiveSheet().getSheetOption().getProtection(false));
        }
    }

    @Override
    public void changed(SheetPropertyChangeEvent e) {
        if (e.isSheetProtectionChanged() && e.getSheet() == this._context.getBook().getActiveSheet()) {
            this.sync(e.getSheet().getSheetOption().getProtection(false));
        }
    }

    @Override
    public void changed(BookPropertyChangeEvent e) {
        BookProtection pro = e.getBook().getProtection();
        boolean enable = !pro.isProtected();
        this.setActionEnable("Sheet_Insert", enable);
        this.setActionEnable("Sheet_Delete", enable);
        this.setActionEnable("Sheet_Rename", enable);
        this.setActionEnable("Sheet_MoveAndCopy", enable);
        this.setActionEnable("Sheet_SetTabColor", enable);
    }

    private void sync(Protection pro) {
        boolean enable = pro == null || !pro.isProtected();
        boolean rowstyleEnable = enable || pro.hasOperation(16);
        this.setActionEnable("Resize_Row", rowstyleEnable);
        this.setActionEnable("Hide_Row", rowstyleEnable);
        this.setActionEnable("Show_Row", rowstyleEnable);
        this.setActionEnable("Insert_Row", enable || pro.hasOperation(64));
        this.setActionEnable("Delete_Row", enable || pro.hasOperation(512));
        boolean colstyleEnable = enable || pro.hasOperation(8);
        this.setActionEnable("Resize_Col", colstyleEnable);
        this.setActionEnable("Hide_Col", colstyleEnable);
        this.setActionEnable("Show_Col", colstyleEnable);
        this.setActionEnable("Insert_Col", enable || pro.hasOperation(32));
        this.setActionEnable("Delete_Col", enable || pro.hasOperation(256));
        this.setActionEnable("Insert_Cell", enable);
        this.setActionEnable("Delete_Cell", enable);
        this.setActionEnable("Show_ClassifiedStatistics_Wizzard", enable);
        this.setActionEnable("AutoFilter", enable);
        this.setActionEnable("UnFilter", enable);
        this.setActionEnable("Show_AdvancedFilter_Wizzard", enable);
        this.setActionEnable("Show_CreateGroup_Wizzard", enable);
        this.setActionEnable("Show_DelGroup_Wizzard", enable);
        this.setActionEnable("Show_ConfigGroup_Wizzard", enable);
        this.setActionEnable("Clear_Group", enable);
        this.setActionEnable("Hide_Group", enable);
        this.setActionEnable("Show_Group", enable);
        this.setActionEnable("Show_ConditionalFormat_Wizzard", enable);
        this.setActionEnable("Show_NameDefine_Wizzard", enable);
        boolean sortEnable = enable || pro.hasOperation(1024);
        this.setActionEnable("Sort_Ascending", sortEnable);
        this.setActionEnable("Sort_Descending", sortEnable);
        this.setActionEnable("Show_DataValidation_Wizzard", enable);
        boolean styleEnable = enable || pro.hasOperation(4);
        this.setActionEnable("Show_Style_Wizzard", styleEnable);
        this.setActionEnable("Font_Bold", styleEnable);
        this.setActionEnable("Font_Italic", styleEnable);
        this.setActionEnable("Font_UnderLine", styleEnable);
        this.setActionEnable("Alignment_Left", styleEnable);
        this.setActionEnable("Alignment_Center", styleEnable);
        this.setActionEnable("Alignment_Right", styleEnable);
        this.setActionEnable("NumberFormat_Currency", styleEnable);
        this.setActionEnable("NumberFormat_Precent", styleEnable);
        this.setActionEnable("NumberFormat_KilloSeparator", styleEnable);
        this.setActionEnable("NumberFormat_DecimalIns", styleEnable);
        this.setActionEnable("NumberFormat_DecimalDec", styleEnable);
        this.setActionEnable("Cell_Locked", enable);
        this.setActionEnable("Merge", enable);
        this.setActionEnable("Show_NameDefine_Wizzard", enable);
        this.setActionEnable("Show_DataValidation_Wizzard", enable);
        this.setActionEnable("Show_Hyperlink_Wizzard", enable || pro.hasOperation(128));
        this.setActionEnable("Show_DiagonalHeader_Wizzard", enable);
        this.setActionEnable("Show_Comment_Wizzard", enable || pro.hasOperation(32768));
        this.setActionEnable("Show_FlashChart_Wizzard", !CtrlUtil.isWinOS() && (enable || pro.hasOperation(8192)));
    }

    private void setActionEnable(String actionName, boolean enable) {
        SpreadAction a = this.getAction(actionName, false);
        if (a != null) {
            a.setEnabled(enable);
        } else {
            if (this._actionMap == null) {
                this._actionMap = new HashMap();
            }
            this._actionMap.put(actionName, enable);
        }
    }
}

