/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl;

import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprMethod;
import com.kingdee.cosmic.ctrl.kds.model.expr.IErrorProvider;
import com.kingdee.cosmic.ctrl.kds.model.expr.IErrorResultProvider;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import com.kingdee.cosmic.ctrl.kds.model.struct.FunctionManager;
import com.kingdee.cosmic.ctrl.kds.model.struct.IPackageQuery;
import java.util.ArrayList;

public final class FunctionRegister {
    private SpreadContext _context;
    private ArrayList _customProvs;
    private ArrayList _funcProvs;
    private ArrayList _funcLocalProvs;
    private IPackageQuery _packageListener;
    private ArrayList _errorProviderKeys;
    private ArrayList _errorProviderValues;
    private IErrorResultProvider _errorResultProvider;

    FunctionRegister(SpreadContext context) {
        this._context = context;
        this._funcProvs = new ArrayList();
        this._funcLocalProvs = new ArrayList();
        this._errorProviderKeys = new ArrayList();
        this._errorProviderValues = new ArrayList();
        this._customProvs = new ArrayList();
    }

    void unRegister() {
        Dependents deps = this._context.getBook().getDeps();
        deps.getQueryManager().setPackageListener(null);
        FunctionManager fm = deps.getFunctionManager();
        int size = this._customProvs.size();
        for (int i = 0; i < size; ++i) {
            CustomProvider cp = (CustomProvider)this._customProvs.get(i);
            ExprMethod em = fm.getExprMethod(cp.param, cp.paramCount);
            if (em == null) continue;
            em.setFillParameter(false);
        }
        fm.setErrorResultProvider(null);
        fm.removeAllFunctionProvider();
    }

    void register() {
        int i;
        Dependents deps = this._context.getBook().getDeps();
        deps.getQueryManager().setPackageListener(this._packageListener);
        FunctionManager fm = deps.getFunctionManager();
        int size = this._errorProviderKeys.size();
        for (i = 0; i < size; ++i) {
            fm.setErrorProvider((Class)this._errorProviderKeys.get(i), (IErrorProvider)this._errorProviderValues.get(i));
        }
        fm.setErrorResultProvider(this._errorResultProvider);
        size = this._funcProvs.size();
        for (i = 0; i < size; ++i) {
            fm.addFunctionProvider(this._funcProvs.get(i), false);
        }
        size = this._funcLocalProvs.size();
        for (i = 0; i < size; ++i) {
            fm.addFunctionProvider(this._funcLocalProvs.get(i), true);
        }
        size = this._customProvs.size();
        for (i = 0; i < size; ++i) {
            CustomProvider cp = (CustomProvider)this._customProvs.get(i);
            ExprMethod em = fm.getExprMethod(cp.param, cp.paramCount);
            if (em == null) continue;
            em.setFillParameter(true);
        }
    }

    public FunctionManager getFunctionManager() {
        Dependents deps = this._context.getBook().getDeps();
        return deps.getFunctionManager();
    }

    public void addFillParameter(String param, int paramCount) {
        this._customProvs.add(new CustomProvider(param, paramCount));
        ExprMethod em = this.getFunctionManager().getExprMethod(param, paramCount);
        if (em != null) {
            em.setFillParameter(true);
        }
    }

    public void addFunctionProvider(Object provider, boolean local) {
        if (provider == null) {
            return;
        }
        if (local) {
            this._funcLocalProvs.add(provider);
        } else {
            this._funcProvs.add(provider);
        }
        this.getFunctionManager().addFunctionProvider(provider, local);
    }

    public void addFunctionErrorProvider(Class exception, IErrorProvider ep) {
        this._errorProviderKeys.add(exception);
        this._errorProviderValues.add(ep);
        this.getFunctionManager().setErrorProvider(exception, ep);
    }

    public void setPackageListener(IPackageQuery packageListener) {
        this._packageListener = packageListener;
        Dependents deps = this._context.getBook().getDeps();
        deps.getQueryManager().setPackageListener(packageListener);
    }

    public void setErrorResultProvider(IErrorResultProvider pvd) {
        this._errorResultProvider = pvd;
        Dependents deps = this._context.getBook().getDeps();
        deps.getFunctionManager().setErrorResultProvider(pvd);
    }

    public void removeFunctionProvider(Object provider, boolean local) {
        if (provider == null) {
            return;
        }
        if (local) {
            this._funcLocalProvs.remove(provider);
        } else {
            this._funcProvs.remove(provider);
        }
        Dependents deps = this._context.getBook().getDeps();
        deps.getFunctionManager().removeFunctionProvider(provider.getClass());
    }

    private static class CustomProvider {
        String param;
        int paramCount;

        CustomProvider(String param, int paramCount) {
            this.param = param;
            this.paramCount = paramCount;
        }
    }
}

