/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.action;

import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.action.BasicSheetAction;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetAction_AutoFilter_Close;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetAction_AutoFilter_Open;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import java.awt.Component;
import java.awt.event.ActionEvent;

class AutoFilter
extends BasicSheetAction {
    public AutoFilter(SpreadContext context) {
        super(context);
    }

    private CellBlock calcAutoFilterArea(Sheet sheet) {
        Range range = sheet.getSelectionRange();
        if (range.size() > 1) {
            MessageUtil.msgboxInfo((Component)((Object)this._context), MultiLanguageKeys.getLocalText("KEY_GROUP_DELETE_MSG", "\u4e0d\u80fd\u5bf9\u591a\u91cd\u9009\u5b9a\u533a\u57df\u4f7f\u7528\u6b64\u547d\u4ee4\u3002"));
            return null;
        }
        CellBlock cb = range.getBlock(0);
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        if (cb.getRow() > maxRow || cb.getCol() > maxCol) {
            MessageUtil.msgboxInfo((Component)((Object)this._context), MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_MSG3", "\u4f7f\u7528\u6307\u5b9a\u7684\u533a\u57df\u65e0\u6cd5\u5b8c\u6210\u8be5\u547d\u4ee4\u3002\u8bf7\u5728\u533a\u57df\u5185\u9009\u62e9\u67d0\u4e2a\u5355\u5143\u683c\uff0c\u7136\u540e\u518d\u6b21\u5c1d\u8bd5\u8be5\u547d\u4ee4\u3002"));
            return null;
        }
        if (cb.getRow2() > maxRow) {
            cb.setRow2(maxRow);
        }
        if (cb.getCol2() > maxCol) {
            cb.setCol2(maxCol);
        }
        SheetBaseMath.cancerizeCellBlock(sheet, cb, false, true, false);
        if (cb.getRow() == cb.getRow2()) {
            MessageUtil.msgboxInfo((Component)((Object)this._context), MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics_MSG3", "\u4f7f\u7528\u6307\u5b9a\u7684\u533a\u57df\u65e0\u6cd5\u5b8c\u6210\u8be5\u547d\u4ee4\u3002\u8bf7\u5728\u533a\u57df\u5185\u9009\u62e9\u67d0\u4e2a\u5355\u5143\u683c\uff0c\u7136\u540e\u518d\u6b21\u5c1d\u8bd5\u8be5\u547d\u4ee4\u3002"));
            return null;
        }
        int detectedStatus = SheetBaseMath.detectRangeTitle(this._context);
        if (detectedStatus < 0) {
            int oldRow = cb.getRow();
            cb.setRow(oldRow + 1);
            detectedStatus = SheetBaseMath.detectRangeTitle(this._context);
            if (detectedStatus != 0) {
                cb.setRow(oldRow);
            }
        }
        return CellBlock.getCellBlock(cb);
    }

    @Override
    protected void doAction(ActionEvent e) {
        Sheet sheet = this._context.getSpread().getBook().getActiveSheet();
        if (sheet.getAutoFilterArea() != null) {
            new SheetAction_AutoFilter_Close(new Range(sheet.getBook(), sheet, sheet.getAutoFilterArea())).run();
            return;
        }
        CellBlock autoFilterArea = this.calcAutoFilterArea(sheet);
        if (autoFilterArea != null) {
            new SheetAction_AutoFilter_Open(new Range(sheet.getBook(), sheet, autoFilterArea)).run();
            this._context.getSpread().repaint();
        }
    }
}

