/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.action;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.IExtCallback;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.action.SpreadAction;
import com.kingdee.cosmic.ctrl.kds.impl.state.CutState;
import com.kingdee.cosmic.ctrl.kds.impl.state.SpreadStateManager;
import com.kingdee.cosmic.ctrl.kds.impl.state.util.IState;
import com.kingdee.cosmic.ctrl.kds.io.clipboard.ClipboardTransferHandler;
import com.kingdee.cosmic.ctrl.kds.model.struct.PasteMode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataInputStream;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PasteAction
extends SpreadAction {
    private static final Logger logger = LogUtil.getPackageLogger(PasteAction.class);
    private PasteMode pasteMode = PasteMode.ALL;

    public PasteAction(SpreadContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAction(ActionEvent ee) {
        if (this._context.getStateManager().stopEditing()) {
            byte[] str = ClipboardTransferHandler.importGraphsDataFromClipboard();
            if (null != str && str.length > 0) {
                int dy;
                int dx;
                ArrayList<EmbedObject> al = new ArrayList<EmbedObject>();
                int i = 0;
                Window window = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
                IExtCallback extCallback = null;
                if (window instanceof KDExt) {
                    extCallback = ((KDExt)((Object)window)).getExtCallback();
                    KDExt.threadExtCallback.set(extCallback);
                }
                KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
                try {
                    while (is.available() > 0) {
                        String className = is.readString();
                        byte[] data = is.readLengthBytes();
                        EmbedObject graph = null;
                        try {
                            Class<?> clazz = Class.forName(className);
                            Constructor<?> con = null;
                            try {
                                con = clazz.getConstructor(Sheet.class);
                            }
                            catch (NoSuchMethodException e) {
                                con = null;
                            }
                            if (con == null) {
                                throw new IllegalArgumentException("Can not find a constructor with a single sheet instance argument.");
                            }
                            graph = (EmbedObject)con.newInstance(this._context.getBook().getActiveSheet());
                            if (graph != null) {
                                graph.load(data, true);
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)"err", (Throwable)e);
                        }
                        if (graph == null) continue;
                        al.add(graph);
                    }
                }
                catch (IOException ioe) {
                    logger.error((Object)"err", (Throwable)ioe);
                }
                finally {
                    if (null != is) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            logger.error((Object)"err", (Throwable)e);
                        }
                    }
                }
                EmbedObject[] graphs = al.toArray(new EmbedObject[0]);
                Sheet sheet = this._context.getBook().getActiveSheet();
                EmbedhLayer gl = sheet.getEmbedments(true);
                Point upLeft = EmbedMath.getUpLeftCorner(graphs);
                if (gl.hasSelection()) {
                    Point selUpLeft = gl.getSelectionRange().getUpLeftCorner();
                    dx = selUpLeft.x - upLeft.x + 20;
                    dy = selUpLeft.y - upLeft.y + 20;
                } else {
                    int selX = SheetBaseMath.getColX(sheet, sheet.getActiveCol());
                    int selY = SheetBaseMath.getRowY(sheet, sheet.getActiveRow());
                    dx = selX - upLeft.x;
                    dy = selY - upLeft.y;
                }
                for (i = 0; i < graphs.length; ++i) {
                    EmbedObject graph = graphs[i];
                    graph.setLocation(graph.getX() + dx, graph.getY() + dy);
                    if (graph instanceof ChartRectEmbedment) {
                        graph.setName(((ChartRectEmbedment)graph).nameNext(i + 1));
                        continue;
                    }
                    if (graph instanceof EmbedImage) {
                        graph.setName(CtrlEXTMessages.getMLS("image", "\u56fe\u7247") + (gl.size() + i + 1));
                        continue;
                    }
                    graph.setName(CtrlEXTMessages.getMLS("chart", "\u56fe\u8868") + (gl.size() + i + 1));
                }
                sheet.getEmbedments(true).addEmbeds(graphs);
            } else {
                boolean b = false;
                try {
                    Range r;
                    Sheet srcSheet;
                    this._context.getBook().getUndoManager().startGroup();
                    IState s = this._context.getStateManager().getCurrentState();
                    if (s != null && s.getKey() == SpreadStateManager.Key_Cut && (srcSheet = ((CutState)s).getSrcSheet()) != null) {
                        Range range = this._context.getRangeManager().getRange(srcSheet, ((CutState)s).getSrcBlocks());
                        range.clear(true, true, true, true, new String[0]);
                        Protection pro = srcSheet.getSheetOption().getProtection(false);
                        if (pro != null && pro.isProtected()) {
                            StyleAttributes sa = Styles.getEmptySA();
                            sa.setLocked(false);
                            range.setStyle(sa, Styles.getEmptySA());
                        }
                    }
                    boolean bl = b = (r = this._context.getRangeManager().getSelectionRangeInBook()).paste(this.pasteMode, null) && r.isSingleBlock();
                    if (b) {
                        SpreadStateManager sm = this._context.getStateManager();
                        sm.addState(sm.createPastedState(r));
                        this._context.getFacadeManager().showPasteMessageBox();
                    }
                }
                finally {
                    if (b) {
                        this._context.getBook().getUndoManager().endGroup();
                    } else {
                        this._context.getBook().getUndoManager().cancelGroup();
                    }
                }
            }
        }
    }

    public PasteMode getPasteMode() {
        return this.pasteMode;
    }

    public void setPasteMode(PasteMode pasteMode) {
        this.pasteMode = pasteMode;
    }
}

