/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.editor;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.impl.facade.editor.CellTextEditor;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class NumberCellTextEditor
extends CellTextEditor {
    private static final Logger logger = LogUtil.getPackageLogger(NumberCellTextEditor.class);

    @Override
    public String getText() {
        String text = super.getText();
        if (!StringUtil.isEmptyString((String)text)) {
            BigDecimal bd = null;
            try {
                bd = new BigDecimal(text);
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
            if (bd != null) {
                double value = bd.doubleValue() * 100.0;
                text = String.valueOf(value);
            }
        }
        return text;
    }

    @Override
    public String getCellText(Cell cell) {
        String text = super.getCellText(cell);
        if (!StringUtil.isEmptyString((String)text)) {
            double value;
            BigDecimal bd = null;
            try {
                bd = new BigDecimal(text);
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
            if (bd != null && (text = String.valueOf(value = bd.doubleValue() / 100.0)).lastIndexOf(".0") == text.length() - 2) {
                text = text.substring(0, text.length() - 2);
            }
        }
        return text;
    }
}

