/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.rangesel;

import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.facade.rangesel.AbsRangeSelector;
import com.kingdee.cosmic.ctrl.kds.impl.facade.rangesel.IRangeSelector;
import com.kingdee.cosmic.ctrl.kds.impl.facade.rangesel.RangeSelectorShield;
import com.kingdee.cosmic.ctrl.kds.impl.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Selection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.BookChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.BookChangeListener;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeListener;
import com.kingdee.cosmic.ctrl.print.config.extendui.ITextUI;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RangeSelector
extends AbsRangeSelector
implements ITextUI,
IRangeSelector {
    private static final char[] operators = new char[]{'+', '-', '*', '/', '(', '='};
    private SpreadContext _context;
    private Inner _inner;
    private ITextSync _sync;
    private boolean _bAbs;
    private boolean _bWithSheetName = true;
    private boolean _bWithEqual;
    private Selection _sel;
    private RangeSelectorShield _sheild;

    public RangeSelector(SpreadContext context, String title) {
        this._btnFetcher.setIcon((Icon)ResourceManager.getImageIcon("select_zoomin.gif"));
        this._context = context;
        this._inner = new Inner(this, title);
    }

    public RangeSelector(SpreadContext context) {
        this(context, MultiLanguageKeys.getLocalText("KEY_REFPOSITION"));
    }

    public void setSelectorIcon(Icon icon) {
        this._btnFetcher.setIcon(icon);
    }

    public void setContext(SpreadContext context) {
        this._context = context;
    }

    public void setTextComponent(JComponent comp, ITextSync sync) {
        this.remove(this._editor);
        this._editor = comp;
        this.add(comp);
        this.doLayout();
        this._sync = sync;
    }

    public void setTextComponentVisible(boolean visible) {
        this._editor.setVisible(visible);
    }

    @Override
    public void setSelectMode(int mode) {
        this.getSelection().setSelectMode(mode);
    }

    @Override
    public String getText() {
        if (this._sync != null) {
            return this._sync.getText(this._editor);
        }
        return ((KDTextField)this._editor).getText();
    }

    @Override
    public void setToolTipText(String text) {
        this._btnFetcher.setToolTipText(text);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Selection getSelection() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        if (this._sel == null) {
            this._sel = new Selection(sheet);
        } else {
            this._sel.setSheet(sheet);
        }
        return this._sel;
    }

    @Override
    public void setText(String text) {
        if (this._sync != null) {
            this._sync.setText(this._editor, text);
        } else {
            ((KDTextField)this._editor).setText(text);
        }
    }

    public void prepare() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        Selection sel = this.getSelection();
        sel.copyFrom(sheet.getSheetOption().getSelection());
        StringBuilder sb = new StringBuilder();
        if (this._bWithSheetName) {
            sb.append(sheet.getSyntaxName()).append('!');
        }
        sb.append(Sheet.getBlocksA1Name(sel.toSelectionBlocks(), this._bAbs));
        this.setText(sb.toString());
    }

    public void setAbsRangeName(boolean b) {
        this._bAbs = b;
    }

    public void setWithSheetName(boolean b) {
        this._bWithSheetName = b;
    }

    public void setWithOpreatorEqual(boolean b) {
        this._inner.setWithOpreatorEqual(b);
    }

    @Override
    public void showOpposite() {
        if (this._context.getStateManager().addState(this._context.getStateManager().createRangeSelectState(this))) {
            Window owner = this.getOwner();
            owner.setVisible(false);
            KDDialog iowner = this._inner.getOwner();
            iowner.setAlwaysOnTop(true);
            iowner.getContentPane().setLayout(null);
            iowner.getContentPane().add(this._inner);
            Insets insets = owner.getInsets();
            int l = insets.left;
            int r = insets.right;
            int w = owner.getWidth() - l - r;
            this._inner.setBounds(2, 2, w, this.getHeight());
            iowner.setResizable(false);
            iowner.setLocation(owner.getLocation());
            iowner.setSize(owner.getWidth() + 5, this.getHeight() + 30);
            iowner.setVisible(true);
            this._context.addSheetChangeListener(this._inner);
            this._context.addBookChangeListener(this._inner);
            this._inner.setText("");
            this.setText("");
            this._inner.requestFocus();
            this.addGlassPane();
        }
    }

    Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private void addGlassPane() {
        final KDExt ext = this.getExt();
        if (ext != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RangeSelector.this._sheild = new RangeSelectorShield(ext);
                }
            });
        }
    }

    private void removeGlassPane() {
        if (this._sheild != null) {
            this._sheild.revert();
            this._sheild = null;
        }
    }

    private KDExt getExt() {
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof KDExt)) continue;
            return (KDExt)((Object)c);
        }
        return null;
    }

    public static interface ITextSync {
        public String getText(JComponent var1);

        public void setText(JComponent var1, String var2);
    }

    private class Inner
    extends AbsRangeSelector
    implements SheetChangeListener,
    BookChangeListener {
        private RangeSelector _outter;
        private KDDialog _innerDialog;
        private String _innerTitle;
        private String _keepText = "";

        public Inner(RangeSelector outter, String title) {
            this._outter = outter;
            this._innerTitle = title;
            this._btnFetcher.setIcon((Icon)ResourceManager.getImageIcon("select_zoomout.gif"));
        }

        @Override
        public void requestFocus() {
            super.requestFocus();
            KDTextField tf = (KDTextField)this._editor;
            tf.setSelectAllOnFocus(false);
            tf.setCaretPosition(tf.getText().length());
        }

        private boolean isAllSelect(ArrayList list) {
            CellBlock block;
            return list.size() == 1 && (RangeSelector.this.getSelection().getSelectMode() == 1 ? (block = (CellBlock)list.get(0)).isCol() : RangeSelector.this.getSelection().getSelectMode() == 2 && (block = (CellBlock)list.get(0)).isRow());
        }

        @Override
        public void changed(SheetChangeEvent e) {
            if (e.hasState(SheetChangeEvent.Changed_Selection)) {
                this.generateKeepText();
                ArrayList list = RangeSelector.this.getSelection().toSelectionBlocks();
                if (this.isAllSelect(list)) {
                    return;
                }
                String str = Sheet.getBlocksA1Name(RangeSelector.this.getSelection().toSelectionBlocks(), RangeSelector.this._bAbs);
                Sheet sheet = this._outter._context.getBook().getActiveSheet();
                StringBuilder sb = new StringBuilder(this._keepText);
                if (RangeSelector.this._bWithSheetName) {
                    sb.append(sheet.getSyntaxName()).append('!');
                }
                sb.append(str);
                this.setText(sb.toString());
            }
            this.requestFocus();
        }

        @Override
        public void changed(BookChangeEvent e) {
            String text;
            if (e.isSheetActive() && (text = this.getText()).indexOf(33) != -1) {
                text = text.split("!")[1];
                Sheet sheet = this._outter._context.getBook().getActiveSheet();
                StringBuilder sb = new StringBuilder(sheet.getSyntaxName());
                sb.append('!').append(text);
                this.setText(sb.toString());
            }
            this.requestFocus();
        }

        KDDialog getOwner() {
            if (this._innerDialog == null) {
                Window w = SwingUtilities.getWindowAncestor(this._outter);
                if (w == null) {
                    w = SwingUtilities.getWindowAncestor((Component)((Object)this._outter._context));
                }
                this._innerDialog = w instanceof Dialog ? new KDDialog((Dialog)w, this._innerTitle) : (w instanceof Frame ? new KDDialog((Frame)w, this._innerTitle) : new KDDialog((Frame)null, this._innerTitle));
                this._innerDialog.setDefaultCloseOperation(0);
                this._innerDialog.addWindowListener((WindowListener)new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        Inner.this.showOpposite();
                    }
                });
                this._innerDialog.setModal(false);
            }
            return this._innerDialog;
        }

        @Override
        protected void showOpposite() {
            RangeSelector.this.removeGlassPane();
            if (this._outter._context.getStateManager().cancel()) {
                this.getOwner().setVisible(false);
                String oldValue = this._outter.getText();
                this._outter.setText(this.getText());
                this._outter._context.removeSheetChangeListener(this);
                this._outter._context.removeBookChangeListener(this);
                RangeSelector.this.firePropertyChange("RangeSelected", oldValue, this._outter.getText());
                this._outter.getOwner().setVisible(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Inner.this._outter.requestFocus();
                    }
                });
            }
        }

        void generateKeepText() {
            String curText = this.getText();
            int len = curText.length();
            if (len > 0) {
                char c = curText.charAt(len - 1);
                int size = operators.length;
                for (int i = 0; i < size; ++i) {
                    if (c != operators[i]) continue;
                    this._keepText = curText;
                    return;
                }
            }
        }

        void setWithOpreatorEqual(boolean b) {
            RangeSelector.this._bWithEqual = b;
            if (RangeSelector.this._bWithEqual) {
                if (!this._keepText.startsWith("=")) {
                    this._keepText = "=" + this._keepText;
                }
            } else if (this._keepText.startsWith("=")) {
                this._keepText = this._keepText.substring(1);
            }
        }
    }
}

