/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard;

import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class WizzardConfigGroup
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private KDLabel label;
    private KDSeparator separator;
    private KDCheckBox IsBelowToGroup;
    private KDCheckBox IsRightOfGroup;
    private KDButton submit;
    private KDButton cancel;

    public WizzardConfigGroup(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    public WizzardConfigGroup(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    private void initComps() {
        this.label = new KDLabel(MultiLanguageKeys.getLocalText("KEY_GROUP_CONFIG_DIRECTION", "\u65b9\u5411"));
        this.separator = new KDSeparator();
        this.IsBelowToGroup = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_GROUP_BELOW", "\u660e\u7ec6\u6570\u636e\u7684\u4e0b\u65b9") + "(B)");
        this.IsBelowToGroup.setSelected(true);
        this.IsRightOfGroup = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_GROUP_RIGHT", "\u660e\u7ec6\u6570\u636e\u7684\u53f3\u4fa7") + "(R)");
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.IsBelowToGroup);
        bg.add((AbstractButton)this.IsRightOfGroup);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.IsBelowToGroup, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        CtrlSwingUtilities.removeManagingFocusBackwardTraversalKeys((JComponent)this.IsBelowToGroup, (KeyStroke)KeyStroke.getKeyStroke(10, 1));
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.IsRightOfGroup, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        CtrlSwingUtilities.removeManagingFocusBackwardTraversalKeys((JComponent)this.IsRightOfGroup, (KeyStroke)KeyStroke.getKeyStroke(10, 1));
        this.submit = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK", "\u786e\u5b9a"));
        this.cancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL", "\u53d6\u6d88"));
    }

    private void layoutComps() {
        Container c = this.getContentPane();
        c.setLayout(null);
        this.setSize(180, 130);
        this.label.setBounds(5, 5, 30, 15);
        this.separator.setBounds(40, 15, 110, 5);
        this.IsBelowToGroup.setBounds(15, 25, 140, 15);
        this.IsRightOfGroup.setBounds(15, 45, 140, 15);
        this.submit.setBounds(5, 65, 55, 20);
        this.cancel.setBounds(85, 65, 55, 20);
        c.add((Component)this.label);
        c.add((Component)this.separator);
        c.add((Component)this.IsBelowToGroup);
        c.add((Component)this.IsRightOfGroup);
        c.add((Component)this.submit);
        c.add((Component)this.cancel);
    }

    private void initListeners() {
        this.submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sheet sheet = WizzardConfigGroup.this._context.getSpread().getBook().getActiveSheet();
                sheet.setAboveOfOutlineGroup(!WizzardConfigGroup.this.IsBelowToGroup.isSelected());
                sheet.setLeftToOutlineGroup(!WizzardConfigGroup.this.IsRightOfGroup.isSelected());
                WizzardConfigGroup.this._context.getSpread().getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_GroupLevel);
                WizzardConfigGroup.this.setVisible(false);
                WizzardConfigGroup.this.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardConfigGroup.this.setVisible(false);
                WizzardConfigGroup.this.dispose();
            }
        });
        JRootPane rootPane = this.getRootPane();
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(66, 8), "belowToGroup");
        rootPane.getActionMap().put("belowToGroup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardConfigGroup.this.IsBelowToGroup.requestFocusInWindow();
                WizzardConfigGroup.this.IsBelowToGroup.setSelected(!WizzardConfigGroup.this.IsBelowToGroup.isSelected());
            }
        });
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(82, 8), "rightOfGroup");
        rootPane.getActionMap().put("rightOfGroup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardConfigGroup.this.IsRightOfGroup.requestFocusInWindow();
                WizzardConfigGroup.this.IsRightOfGroup.setSelected(!WizzardConfigGroup.this.IsRightOfGroup.isSelected());
            }
        });
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "submit");
        rootPane.getActionMap().put("submit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardConfigGroup.this.submit.doClick();
            }
        });
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        Sheet sheet = this._context.getSpread().getBook().getActiveSheet();
        this.IsBelowToGroup.setSelected(!sheet.isAboveOfOutlineGroup());
        this.IsRightOfGroup.setSelected(!sheet.isLeftToOutlineGroup());
        return true;
    }
}

