/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.ConfirmPasswordDialog;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDOptionPane;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDPasswordField;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.border.TextFieldBorder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.border.Border;

public final class WizzardProSheet
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private KDCheckBox _mustProItem;
    private KDPasswordField _pwField;
    private KDLabelContainer _pwLC;
    private KDSeparator _separ1;
    private KDLabelContainer _proItemLC;
    private KDCheckBox[] _proItems;
    private KDSeparator _separ2;
    private KDButton _btnOk;
    private KDButton _btnCancel;
    private ActionListener _eventHandle;
    private String _newPassword;
    private int _newOpers;
    private boolean _isChanged;

    public WizzardProSheet(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.setSize(300, 340);
        this.setResizable(false);
        this.init();
    }

    public WizzardProSheet(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.setSize(300, 340);
        this.setResizable(false);
        this.init();
    }

    @Override
    public void commit() {
        if (this.isChanged()) {
            Sheet sheet = this._context.getBook().getActiveSheet();
            Protection pro = sheet.getSheetOption().getProtection(true);
            pro.setOperations(this.getNewOperations());
            pro.start(this.getNewPassword());
        }
    }

    @Override
    public boolean prepare() {
        this._isChanged = false;
        Sheet sheet = this._context.getBook().getActiveSheet();
        Protection pro = sheet.getSheetOption().getProtection(false);
        this.setProtection(pro);
        return pro == null || !pro.isProtected();
    }

    private void init() {
        this._eventHandle = new BtnActionHandler();
        this._mustProItem = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_PROTECT_SHEET_CONTENTS"), true);
        this._mustProItem.setSelected(true);
        this._mustProItem.addActionListener(this._eventHandle);
        this.initPassWordField();
        this._separ1 = new KDSeparator();
        this.initProItems();
        this._separ2 = new KDSeparator();
        this.initButtons();
        this.layoutComponents();
    }

    private void initPassWordField() {
        this._pwField = new KDPasswordField();
        this._pwLC = new KDLabelContainer((JComponent)this._pwField);
        String str = MultiLanguageKeys.getLocalText("KEY_PASSWORD");
        this._pwLC.setBoundLabelText(str);
        this._pwLC.setBoundLabelAlignment(8);
    }

    private void initProItems() {
        this._proItems = new KDCheckBox[16];
        String str = MultiLanguageKeys.getLocalText("KEY_SELECT_LOCKED");
        this._proItems[0] = new KDCheckBox(str, true);
        this._proItems[0].addActionListener(this._eventHandle);
        this._proItems[0].setSelected(true);
        str = MultiLanguageKeys.getLocalText("KEY_SELECT_UNLOCKED");
        this._proItems[1] = new KDCheckBox(str, true);
        this._proItems[1].addActionListener(this._eventHandle);
        this._proItems[1].setSelected(true);
        str = MultiLanguageKeys.getLocalText("KEY_SET_CELL_STYLE");
        this._proItems[2] = new KDCheckBox(str, false);
        this._proItems[2].setSelected(true);
        str = MultiLanguageKeys.getLocalText("KEY_SET_COL");
        this._proItems[3] = new KDCheckBox(str, false);
        this._proItems[3].setSelected(true);
        str = MultiLanguageKeys.getLocalText("KEY_SET_ROW");
        this._proItems[4] = new KDCheckBox(str, false);
        this._proItems[4].setSelected(true);
        str = MultiLanguageKeys.getLocalText("KEY_INSERT_COL");
        this._proItems[5] = new KDCheckBox(str, false);
        str = MultiLanguageKeys.getLocalText("KEY_INSERT_ROW");
        this._proItems[6] = new KDCheckBox(str, false);
        str = MultiLanguageKeys.getLocalText("KEY_INSERT_HYPERLINK");
        this._proItems[7] = new KDCheckBox(str, false);
        str = MultiLanguageKeys.getLocalText("KEY_DELETE_COL");
        this._proItems[8] = new KDCheckBox(str, false);
        str = MultiLanguageKeys.getLocalText("KEY_DELETE_ROW");
        this._proItems[9] = new KDCheckBox(str, false);
        str = MultiLanguageKeys.getLocalText("KEY_SORT");
        this._proItems[10] = new KDCheckBox(str, false);
        str = MultiLanguageKeys.getLocalText("KEY_AUTO_FILTER");
        this._proItems[11] = new KDCheckBox(str, false);
        str = MultiLanguageKeys.getLocalText("KEY_DATA_PERSPECTIVE");
        this._proItems[12] = new KDCheckBox(str, false);
        str = MultiLanguageKeys.getLocalText("KEY_EDIT_OBJECT");
        this._proItems[13] = new KDCheckBox(str, false);
        str = MultiLanguageKeys.getLocalText("KEY_EDIT_SCHEME");
        this._proItems[14] = new KDCheckBox(str, false);
        str = MultiLanguageKeys.getLocalText("KEY_PRO_COMMENT");
        this._proItems[15] = new KDCheckBox(str, false);
        this._proItems[11].setEnabled(false);
        this._proItems[12].setEnabled(false);
        this._proItems[13].setEnabled(false);
        this._proItems[14].setEnabled(false);
        KDScrollPane scrollPane = new KDScrollPane();
        KDPanel itemsPanel = new KDPanel();
        itemsPanel.setLayout((LayoutManager)new GridLayout(16, 1, 5, 0));
        for (int i = 0; i < 16; ++i) {
            itemsPanel.add((Component)this._proItems[i]);
            this._proItems[i].setLocation(0, i * 40);
        }
        scrollPane.setViewportView((Component)itemsPanel);
        scrollPane.setBorder((Border)new TextFieldBorder());
        scrollPane.getVerticalScrollBar().setUnitIncrement(this._proItems[0].getPreferredSize().height);
        this._proItemLC = new KDLabelContainer((JComponent)scrollPane);
        this._proItemLC.setBoundLabelText(MultiLanguageKeys.getLocalText("KEY_ALLOW_OPERS"));
        this._proItemLC.setBoundLabelAlignment(8);
    }

    private void initButtons() {
        this._btnOk = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
        this._btnOk.addActionListener(this._eventHandle);
        this._btnCancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL"));
        this._btnCancel.addActionListener(this._eventHandle);
    }

    private void layoutComponents() {
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.add((Component)this._mustProItem);
        cp.add((Component)this._pwLC);
        cp.add((Component)this._separ1);
        cp.add((Component)this._proItemLC);
        cp.add((Component)this._separ2);
        cp.add((Component)this._btnOk);
        cp.add((Component)this._btnCancel);
        this._mustProItem.setBounds(6, 8, 220, 20);
        this._pwLC.setBounds(8, 30, 280, 40);
        this._pwLC.setBoundLabelLength(19);
        this._separ1.setBounds(8, 78, 280, 2);
        this._proItemLC.setBounds(8, 88, 280, 160);
        this._proItemLC.setBoundLabelLength(19);
        this._separ2.setBounds(8, 256, 280, 2);
        this._btnOk.setBounds(108, 260, 30, 20);
        this._btnCancel.setBounds(200, 260, 30, 20);
    }

    private void setProtection(Protection pro) {
        if (pro != null) {
            int opers = pro.getOperations();
            for (int i = 0; i < 16; ++i) {
                this._proItems[i].setSelected((opers & 1 << i) != 0);
            }
            this._proItemLC.repaint();
        }
        this._pwField.setText("");
    }

    private String getNewPassword() {
        return this._newPassword;
    }

    private int getNewOperations() {
        return this._newOpers;
    }

    private boolean isChanged() {
        return this._isChanged;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void genOperations() {
        this._newOpers = 0;
        for (int i = 0; i < 16; ++i) {
            int oper = 0;
            if (this._proItems[i].isSelected()) {
                oper = 1;
            }
            this._newOpers += oper << i;
        }
    }

    private boolean genPassword() {
        if (this._pwField.getPassword().length > 0) {
            ConfirmPasswordDialog cpd = new ConfirmPasswordDialog((Dialog)((Object)this));
            cpd.setLocationRelativeTo((Component)((Object)this));
            cpd.setVisible(true);
            if (cpd.isCanceled()) {
                return false;
            }
            char[] cs = this._pwField.getPassword();
            StringBuilder sb = new StringBuilder();
            for (char c : cs) {
                sb.append(c);
            }
            Arrays.fill(cs, ' ');
            if (!StringUtil.equals((String)sb.toString(), (String)cpd.getPassword())) {
                String title = MultiLanguageKeys.getLocalText("KEY_SPREAD_TITLE");
                KDOptionPane.showMessageDialog(null, (Object)MultiLanguageKeys.getLocalText("KEY_NOSAMEPASSWORD"), (String)title, (int)0);
                return false;
            }
            this._newPassword = cpd.getPassword();
        } else {
            this._newPassword = "";
        }
        return true;
    }

    private class BtnActionHandler
    implements ActionListener {
        private BtnActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == WizzardProSheet.this._btnOk) {
                if (WizzardProSheet.this.genPassword()) {
                    WizzardProSheet.this.genOperations();
                    WizzardProSheet.this._isChanged = true;
                    WizzardProSheet.this.closeDialog();
                }
            } else if (e.getSource() == WizzardProSheet.this._btnCancel) {
                WizzardProSheet.this._isChanged = false;
                WizzardProSheet.this.closeDialog();
            } else if (e.getSource() == WizzardProSheet.this._mustProItem) {
                WizzardProSheet.this._btnOk.setEnabled(WizzardProSheet.this._mustProItem.isSelected());
            } else if (e.getSource() == WizzardProSheet.this._proItems[0] && WizzardProSheet.this._proItems[0].isSelected()) {
                WizzardProSheet.this._proItems[1].setSelected(true);
            } else if (e.getSource() == WizzardProSheet.this._proItems[1] && !WizzardProSheet.this._proItems[1].isSelected()) {
                WizzardProSheet.this._proItems[0].setSelected(false);
            }
        }
    }
}

