/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard;

import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDButtonGroup;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import javax.swing.AbstractButton;

public final class WizzardScale
extends KDDialog
implements ISpreadWizzard {
    private static final BigDecimal i400 = new BigDecimal("400");
    private static final BigDecimal i200 = new BigDecimal("200");
    private static final BigDecimal i100 = new BigDecimal("100");
    private static final BigDecimal i75 = new BigDecimal("75");
    private static final BigDecimal i50 = new BigDecimal("50");
    private static final BigDecimal i25 = new BigDecimal("25");
    private static final BigDecimal i10 = new BigDecimal("10");
    private KDRadioButton _btn400;
    private KDRadioButton _btn200;
    private KDRadioButton _btn100;
    private KDRadioButton _btn75;
    private KDRadioButton _btn50;
    private KDRadioButton _btn25;
    private KDRadioButton _btnCustom;
    private KDTextField _tfScale;
    private KDLabel _lbScale;
    private KDButtonGroup _btnGroup;
    private KDButton _okBtn;
    private KDButton _cancelBtn;
    private boolean _tfBeForced;
    private SpreadContext _context;

    public WizzardScale(Frame f, SpreadContext context) {
        super(f, true);
        this._context = context;
        this.initDialog();
        this.initComponents();
        this.initPanel();
    }

    public WizzardScale(Dialog d, SpreadContext context) {
        super(d, true);
        this._context = context;
        this.initDialog();
        this.initComponents();
        this.initPanel();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        int scale = sheet.getSheetOption().getScale();
        BigDecimal obj = BigDecimal.valueOf((double)scale);
        if (i400.compareTo(obj) == 0) {
            this._btn400.setSelected(true);
        } else if (i200.compareTo(obj) == 0) {
            this._btn200.setSelected(true);
        } else if (i100.compareTo(obj) == 0) {
            this._btn100.setSelected(true);
        } else if (i75.compareTo(obj) == 0) {
            this._btn75.setSelected(true);
        } else if (i50.compareTo(obj) == 0) {
            this._btn50.setSelected(true);
        } else if (i25.compareTo(obj) == 0) {
            this._btn25.setSelected(true);
        } else {
            this._tfScale.setText(String.valueOf(scale));
        }
        return true;
    }

    private void initDialog() {
        this.setSize(210, 230);
        this.setTitle(MultiLanguageKeys.getLocalText("KEY_SCALE"));
        this.setResizable(false);
    }

    private void initComponents() {
        ItemChangeHandler il = new ItemChangeHandler();
        ActionHandler al = new ActionHandler();
        this._btn400 = new KDRadioButton("400%");
        this._btn200 = new KDRadioButton("200%");
        this._btn100 = new KDRadioButton("100%");
        this._btn75 = new KDRadioButton("75%");
        this._btn50 = new KDRadioButton("50%");
        this._btn25 = new KDRadioButton("25%");
        this._btnCustom = new KDRadioButton(MultiLanguageKeys.getLocalText("KEY_CUSTOM") + ":");
        this._btnGroup = new KDButtonGroup();
        this._btnGroup.add((AbstractButton)this._btn400);
        this._btnGroup.add((AbstractButton)this._btn200);
        this._btnGroup.add((AbstractButton)this._btn100);
        this._btnGroup.add((AbstractButton)this._btn75);
        this._btnGroup.add((AbstractButton)this._btn50);
        this._btnGroup.add((AbstractButton)this._btn25);
        this._btnGroup.add((AbstractButton)this._btnCustom);
        this._btn400.addItemListener((ItemListener)il);
        this._btn200.addItemListener((ItemListener)il);
        this._btn100.addItemListener((ItemListener)il);
        this._btn75.addItemListener((ItemListener)il);
        this._btn50.addItemListener((ItemListener)il);
        this._btn25.addItemListener((ItemListener)il);
        this._btnCustom.addItemListener((ItemListener)il);
        this._tfScale = new KDTextField();
        this._tfScale.addPropertyChangeListener((PropertyChangeListener)new ProperChangeHandler());
        this._lbScale = new KDLabel("%");
        this._okBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
        this._cancelBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL"));
        this._okBtn.setLimitedSize(false);
        this._cancelBtn.setLimitedSize(false);
        this._okBtn.addActionListener((ActionListener)al);
        this._cancelBtn.addActionListener((ActionListener)al);
    }

    private void initPanel() {
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.add((Component)this._btn400);
        cp.add((Component)this._btn200);
        cp.add((Component)this._btn100);
        cp.add((Component)this._btn75);
        cp.add((Component)this._btn50);
        cp.add((Component)this._btn25);
        cp.add((Component)this._btnCustom);
        cp.add((Component)this._tfScale);
        cp.add((Component)this._lbScale);
        cp.add((Component)this._okBtn);
        cp.add((Component)this._cancelBtn);
        this._btn400.setBounds(15, 5, 90, 20);
        this._btn200.setBounds(15, 28, 90, 20);
        this._btn100.setBounds(15, 51, 90, 20);
        this._btn75.setBounds(15, 74, 90, 20);
        this._btn50.setBounds(15, 97, 90, 20);
        this._btn25.setBounds(15, 120, 90, 20);
        this._btnCustom.setBounds(15, 143, 90, 20);
        this._tfScale.setBounds(120, 143, 60, 20);
        this._lbScale.setBounds(182, 143, 13, 20);
        this._okBtn.setBounds(5, 170, 80, 20);
        this._cancelBtn.setBounds(115, 170, 80, 20);
    }

    private class ItemChangeHandler
    implements ItemListener {
        private ItemChangeHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            WizzardScale.this._tfBeForced = true;
            KDRadioButton o = (KDRadioButton)e.getSource();
            if (o.isSelected()) {
                if (o == WizzardScale.this._btn400) {
                    WizzardScale.this._tfScale.setText("400");
                } else if (o == WizzardScale.this._btn200) {
                    WizzardScale.this._tfScale.setText("200");
                } else if (o == WizzardScale.this._btn100) {
                    WizzardScale.this._tfScale.setText("100");
                } else if (o == WizzardScale.this._btn75) {
                    WizzardScale.this._tfScale.setText("75");
                } else if (o == WizzardScale.this._btn50) {
                    WizzardScale.this._tfScale.setText("50");
                } else if (o == WizzardScale.this._btn25) {
                    WizzardScale.this._tfScale.setText("25");
                }
            }
            WizzardScale.this._tfBeForced = false;
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == WizzardScale.this._okBtn) {
                String text = WizzardScale.this._tfScale.getText();
                try {
                    BigDecimal bg = new BigDecimal(text);
                    if (bg.compareTo(i400) > 0 || bg.compareTo(i10) < 0) {
                        WizzardScale.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_SCALE_OUT"), 2);
                        return;
                    }
                    WizzardScale.this._context.getRangeManager().getActiveCellRange().setScale(bg.intValue());
                }
                catch (Exception ee) {
                    WizzardScale.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_SCALE_NEED_NUMBER"), 2);
                    return;
                }
            }
            WizzardScale.this.dispose();
        }
    }

    private class ProperChangeHandler
    implements PropertyChangeListener {
        private ProperChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!WizzardScale.this._tfBeForced) {
                WizzardScale.this._btnCustom.setSelected(true);
            }
        }
    }
}

