/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard;

import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.util.BooleanArray;
import com.kingdee.cosmic.ctrl.kds.model.util.IntArray;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDButtonGroup;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;

public class WizzardSort
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private OptionPanel _pnlOption;
    private ConditionPanel _pnlCondition;

    public WizzardSort(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComponents();
        this.pack();
        this.setResizable(false);
    }

    public WizzardSort(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComponents();
        this.pack();
        this.setResizable(false);
    }

    private void initComponents() {
        this._pnlOption = new OptionPanel();
        this._pnlCondition = new ConditionPanel();
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)((Object)this._pnlOption), "East");
        cp.add((Component)((Object)this._pnlCondition), "Center");
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void commit() {
        if (!this._pnlOption._isCancel) {
            boolean bByRow = this._pnlOption.isSortedByRow();
            boolean bIgnoreCase = this._pnlOption.isIgnoreCase();
            Object[] o = this._pnlCondition.getKeysAndOrders();
            this._context.getRangeManager().getSelectionRange().sort((int[])o[0], (boolean[])o[1], !bByRow, !bIgnoreCase);
        }
    }

    @Override
    public boolean prepare() {
        this._pnlOption._isCancel = false;
        if (this._context.getRangeManager().getSelectionRange().getSortProtectState() == null) {
            this._pnlOption._listenersFlag = true;
            this._pnlOption._cbIncludeTitle.setSelected(false);
            this._pnlOption._listenersFlag = false;
            this._pnlCondition.prepare();
            return true;
        }
        MessageUtil.msgboxInfo((Component)((Object)this), MultiLanguageKeys.getLocalText("Key_Sort_PrepareDialogContent", "\u4e0d\u80fd\u5bf9\u591a\u91cd\u9009\u5b9a\u533a\u57df\u6216\u53d7\u4fdd\u62a4\u7684\u5de5\u4f5c\u8868\u533a\u57df\u4f7f\u7528\u6b64\u547d\u4ee4\u3002"));
        return false;
    }

    private class ConditionPanel
    extends KDPanel {
        private Dimension _size = new Dimension(400, 180);
        private KDComboBox[] _keys;
        private KDComboBox[] _orders;
        private int _baseIndex;

        ConditionPanel() {
            int i;
            this.setLayout(null);
            this._keys = new KDComboBox[3];
            this._orders = new KDComboBox[3];
            KDLabel first = new KDLabel(MultiLanguageKeys.getLocalText("Key_Sort_FirstKey", "\u4e3b\u8981\u5173\u952e\u5b57"));
            KDLabel second = new KDLabel(MultiLanguageKeys.getLocalText("Key_Sort_SecondKey", "\u6b21\u8981\u5173\u952e\u5b57"));
            KDLabel third = new KDLabel(MultiLanguageKeys.getLocalText("Key_Sort_ThirdKey", "\u7b2c\u4e09\u5173\u952e\u5b57"));
            for (int i2 = 0; i2 < this._keys.length; ++i2) {
                this._keys[i2] = new KDComboBox();
                this._orders[i2] = new KDComboBox();
            }
            Object[] orderNames = new String[]{MultiLanguageKeys.getLocalText("KEY_SORTASCEND"), MultiLanguageKeys.getLocalText("KEY_SORTDESCEND")};
            for (i = 0; i < this._orders.length; ++i) {
                this._orders[i].addItems(orderNames);
            }
            first.setBounds(10, 10, 80, 20);
            second.setBounds(10, 50, 80, 20);
            third.setBounds(10, 90, 80, 20);
            this.add((Component)first);
            this.add((Component)second);
            this.add((Component)third);
            for (i = 0; i < this._keys.length; ++i) {
                this.add((Component)this._keys[i]);
                this.add((Component)this._orders[i]);
                this._keys[i].setLocation(110, 10 + i * 40);
                this._orders[i].setLocation(230, 10 + i * 40);
                this._keys[i].setSize(100, 20);
                this._orders[i].setSize(100, 20);
            }
        }

        boolean isLegal() {
            boolean thirdBlank;
            boolean firstBlank = this._keys[0].getSelectedIndex() == -1 || MultiLanguageKeys.getLocalText("Key_Sort_ClearCondition", "\u65e0").equals(this._keys[0].getSelectedItem());
            boolean secondBlank = this._keys[1].getSelectedIndex() == -1 || MultiLanguageKeys.getLocalText("Key_Sort_ClearCondition", "\u65e0").equals(this._keys[1].getSelectedItem());
            boolean bl = thirdBlank = this._keys[2].getSelectedIndex() == -1 || MultiLanguageKeys.getLocalText("Key_Sort_ClearCondition", "\u65e0").equals(this._keys[2].getSelectedItem());
            if (firstBlank) {
                return false;
            }
            return !(!secondBlank && thirdBlank ? this._keys[0].getSelectedIndex() == this._keys[1].getSelectedIndex() : (secondBlank && !thirdBlank ? this._keys[0].getSelectedIndex() == this._keys[2].getSelectedIndex() : !secondBlank && !thirdBlank && (this._keys[0].getSelectedIndex() == this._keys[1].getSelectedIndex() || this._keys[0].getSelectedIndex() == this._keys[2].getSelectedIndex() || this._keys[1].getSelectedIndex() == this._keys[2].getSelectedIndex())));
        }

        void prepare() {
            int i;
            Object[] keys;
            CellBlock cb = WizzardSort.this._context.getBook().getActiveSheet().getSheetOption().getSelection().getActiveBlock();
            if (!WizzardSort.this._pnlOption.isSortedByRow()) {
                this._baseIndex = cb.getCol();
                int w = cb.getWidth();
                keys = new String[w + 1];
                keys[0] = MultiLanguageKeys.getLocalText("Key_Sort_ClearCondition", "\u65e0");
                for (i = 1; i < w + 1; ++i) {
                    keys[i] = MultiLanguageKeys.getLocalText("Key_Col") + " " + Sheet.getColumnName(this._baseIndex + i - 1, 0, true, false);
                }
            } else {
                this._baseIndex = cb.getRow();
                int h = cb.getHeight();
                if (h > 1000) {
                    h = 1000;
                }
                keys = new String[h + 1];
                keys[0] = MultiLanguageKeys.getLocalText("Key_Sort_ClearCondition", "\u65e0");
                for (i = 1; i < h + 1; ++i) {
                    keys[i] = MultiLanguageKeys.getLocalText("Key_Row") + " " + Sheet.getRowName(this._baseIndex + i - 1, 0, true, false);
                }
            }
            for (int i2 = 0; i2 < this._keys.length; ++i2) {
                this._keys[i2].removeAllItems();
                this._keys[i2].addItems(keys);
                this._keys[i2].setSelectedIndex(-1);
            }
            this._keys[0].setSelectedIndex(1);
        }

        Object[] getKeysAndOrders() {
            IntArray ia = new IntArray();
            BooleanArray ba = new BooleanArray();
            for (int i = 0; i < this._keys.length; ++i) {
                int sindex = this._keys[i].getSelectedIndex();
                if (sindex < 0 || MultiLanguageKeys.getLocalText("Key_Sort_ClearCondition", "\u65e0").equals(this._keys[i].getSelectedItem())) continue;
                ia.add(this._baseIndex + sindex - 1);
                ba.insert(this._orders[i].getSelectedIndex() == 0);
            }
            return new Object[]{ia.toArray(), ba.toBooleanArray()};
        }

        public Dimension getPreferredSize() {
            return this._size;
        }
    }

    private class OptionPanel
    extends KDPanel {
        private KDButton _btnOk;
        private KDButton _btnCancel;
        private KDCheckBox _cbNotIgnoreCase;
        private KDCheckBox _cbIncludeTitle;
        private KDRadioButton _rbSortByRow;
        private KDRadioButton _rbSortByCol;
        private Dimension _size = new Dimension(110, 180);
        private boolean _isCancel;
        private boolean _listenersFlag;

        OptionPanel() {
            this.initComponents();
            this.initListeners();
        }

        public Dimension getPreferredSize() {
            return this._size;
        }

        private void initComponents() {
            this._cbNotIgnoreCase = new KDCheckBox(MultiLanguageKeys.getLocalText("Key_Ignorecase", "\u533a\u5206\u5927\u5c0f\u5199"), false);
            this._cbIncludeTitle = new KDCheckBox(MultiLanguageKeys.getLocalText("Key_Sort_IncludeTitle", "\u6570\u636e\u5305\u542b\u6807\u9898"), false);
            CellBlock cb = WizzardSort.this._context.getRangeManager().getSelectionRange().getBlock(0);
            if (cb.getRow2() == cb.getRow()) {
                this._cbIncludeTitle.setEnabled(false);
            }
            this._rbSortByRow = new KDRadioButton(MultiLanguageKeys.getLocalText("Key_Sort_SortByRow", "\u6309\u884c\u6392\u5e8f"));
            this._rbSortByCol = new KDRadioButton(MultiLanguageKeys.getLocalText("Key_Sort_SortByCol", "\u6309\u5217\u6392\u5e8f"));
            KDButtonGroup group = new KDButtonGroup();
            group.add((AbstractButton)this._rbSortByRow);
            group.add((AbstractButton)this._rbSortByCol);
            this._rbSortByCol.setSelected(true);
            this._btnOk = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
            this._btnCancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL"));
            this.setLayout(new GridLayout(6, 1, 5, 9));
            this.add((Component)this._cbIncludeTitle);
            this.add((Component)this._cbNotIgnoreCase);
            this.add((Component)this._rbSortByRow);
            this.add((Component)this._rbSortByCol);
            this.add((Component)this._btnOk);
            this.add((Component)this._btnCancel);
        }

        public void addNotify() {
            if (this._rbSortByRow.isSelected()) {
                CellBlock cb = WizzardSort.this._context.getRangeManager().getSelectionRange().getBlock(0);
                if (cb.getCol2() == cb.getCol()) {
                    this._cbIncludeTitle.setEnabled(false);
                } else {
                    this._cbIncludeTitle.setEnabled(true);
                }
            } else {
                CellBlock cb = WizzardSort.this._context.getRangeManager().getSelectionRange().getBlock(0);
                if (cb.getRow2() == cb.getRow()) {
                    this._cbIncludeTitle.setEnabled(false);
                } else {
                    this._cbIncludeTitle.setEnabled(true);
                }
            }
            super.addNotify();
        }

        private void initListeners() {
            this._cbIncludeTitle.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (OptionPanel.this._listenersFlag) {
                        return;
                    }
                    CellBlock cb = WizzardSort.this._context.getRangeManager().getSelectionRange().getBlock(0);
                    if (OptionPanel.this._cbIncludeTitle.isSelected()) {
                        if (OptionPanel.this._rbSortByCol.isSelected()) {
                            cb = CellBlock.getCellBlock(cb);
                            cb.setRow(cb.getRow() + 1);
                            WizzardSort.this._context.getSelection().changeSelection(cb, 2);
                        } else {
                            cb = CellBlock.getCellBlock(cb);
                            cb.setCol(cb.getCol() + 1);
                            WizzardSort.this._context.getSelection().changeSelection(cb, 2);
                        }
                    } else if (OptionPanel.this._rbSortByCol.isSelected()) {
                        cb = CellBlock.getCellBlock(cb);
                        cb.setRow(cb.getRow() - 1);
                        WizzardSort.this._context.getSelection().changeSelection(cb, 2);
                    } else {
                        cb = CellBlock.getCellBlock(cb);
                        cb.setCol(cb.getCol() - 1);
                        WizzardSort.this._context.getSelection().changeSelection(cb, 2);
                    }
                    WizzardSort.this._pnlCondition.prepare();
                }
            });
            this._rbSortByRow.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    CellBlock cb = WizzardSort.this._context.getRangeManager().getSelectionRange().getBlock(0);
                    if (cb.getCol2() == cb.getCol()) {
                        OptionPanel.this._cbIncludeTitle.setEnabled(false);
                    } else {
                        OptionPanel.this._cbIncludeTitle.setEnabled(true);
                    }
                    WizzardSort.this._pnlCondition.prepare();
                }
            });
            this._rbSortByCol.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    CellBlock cb = WizzardSort.this._context.getRangeManager().getSelectionRange().getBlock(0);
                    if (cb.getRow2() == cb.getRow()) {
                        OptionPanel.this._cbIncludeTitle.setEnabled(false);
                    } else {
                        OptionPanel.this._cbIncludeTitle.setEnabled(true);
                    }
                    WizzardSort.this._pnlCondition.prepare();
                }
            });
            this._btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!WizzardSort.this._pnlCondition.isLegal()) {
                        MessageUtil.msgboxInfo((Component)((Object)WizzardSort.this), MultiLanguageKeys.getLocalText("Key_Sort_DialogContent", "\u6392\u5e8f\u5f15\u7528\u65e0\u6548\u3002\u8bf7\u786e\u4fdd\u5b83\u5728\u6240\u8981\u6392\u5e8f\u7684\u6570\u636e\u5185\uff0c\u5e76\u4e14\u7b2c\u4e00\u4e2a\u201c\u6392\u5e8f\u4f9d\u636e\u201d\u6846\u4e0d\u76f8\u540c\u4e14\u4e0d\u4e3a\u7a7a\u3002"));
                        return;
                    }
                    OptionPanel.this._isCancel = false;
                    WizzardSort.this.closeDialog();
                }
            });
            this._btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionPanel.this._isCancel = true;
                    WizzardSort.this.closeDialog();
                }
            });
        }

        boolean isIgnoreCase() {
            return !this._cbNotIgnoreCase.isSelected();
        }

        boolean isSortedByRow() {
            return this._rbSortByRow.isSelected();
        }
    }
}

