/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.state;

import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.rangesel.IRangeSelector;
import com.kingdee.cosmic.ctrl.kds.impl.state.CopyState;
import com.kingdee.cosmic.ctrl.kds.impl.state.CutState;
import com.kingdee.cosmic.ctrl.kds.impl.state.DefaultState;
import com.kingdee.cosmic.ctrl.kds.impl.state.EditingState;
import com.kingdee.cosmic.ctrl.kds.impl.state.FilledState;
import com.kingdee.cosmic.ctrl.kds.impl.state.InsertState;
import com.kingdee.cosmic.ctrl.kds.impl.state.PasteState;
import com.kingdee.cosmic.ctrl.kds.impl.state.RangeSelectState;
import com.kingdee.cosmic.ctrl.kds.impl.state.StyleBrushState;
import com.kingdee.cosmic.ctrl.kds.impl.state.StyleFetchState;
import com.kingdee.cosmic.ctrl.kds.impl.state.util.IState;
import com.kingdee.cosmic.ctrl.kds.impl.state.util.StateManager;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.FillType;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.BookChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.BookChangeListener;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeListener;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetPropertyChangeListener;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;

public final class SpreadStateManager
extends StateManager
implements SheetChangeListener,
BookChangeListener,
SheetPropertyChangeListener {
    private static int base = 1;
    public static final int Key_Style_Fetch = 1 << base++;
    public static final int Key_Copy = 1 << base++;
    public static final int Key_Cut = 1 << base++;
    public static final int Key_Style_Brush = 1 << base++;
    public static final int Key_Filled = 1 << base++;
    public static final int Key_Insert = 1 << base++;
    public static final int Key_Pasted = 1 << base++;
    public static final int Key_Edit = 1 << base++;
    public static final int Key_Range_Select = 1 << base++;
    private IState _editState;
    private IState _styleBrushState;
    private IState _copyState;
    private IState _cutState;
    private IState _filledState;
    private IState _styleFetchState;
    private IState _insertState;
    private IState _pastedState;
    private IState _rangeSelState;
    private SpreadContext _context;

    public SpreadStateManager(SpreadContext context) {
        this._context = context;
        this.addRule(Key_Style_Fetch, Key_Copy, 4);
        this.addRule(Key_Style_Fetch, Key_Cut, 4);
        this.addRule(Key_Style_Fetch, Key_Style_Brush, 4);
        this.addRule(Key_Style_Fetch, Key_Pasted, 4);
        this.addRule(Key_Style_Fetch, Key_Range_Select, 4);
        this.addRule(Key_Copy, Key_Copy, 4);
        this.addRule(Key_Copy, Key_Cut, 4);
        this.addRule(Key_Copy, Key_Style_Brush, 0);
        this.addRule(Key_Copy, Key_Pasted, 1);
        this.addRule(Key_Cut, Key_Copy, 4);
        this.addRule(Key_Cut, Key_Cut, 4);
        this.addRule(Key_Cut, Key_Style_Brush, 4);
        this.addRule(Key_Cut, Key_Pasted, 5);
        this.addRule(Key_Style_Brush, Key_Copy, 4);
        this.addRule(Key_Style_Brush, Key_Cut, 4);
        this.addRule(Key_Style_Brush, Key_Style_Brush, 4);
        this.addRule(Key_Style_Brush, Key_Pasted, 5);
        this.addRule(Key_Edit, Key_Copy, 3);
        this.addRule(Key_Edit, Key_Cut, 3);
        this.addRule(Key_Edit, Key_Style_Brush, 3);
        this.addRule(Key_Edit, Key_Filled, 3);
        this.addRule(Key_Edit, Key_Insert, 3);
        this.addRule(Key_Edit, Key_Pasted, 3);
        this.addRule(Key_Edit, Key_Range_Select, 1);
        this.addRule(Key_Edit, Key_Edit, 3);
        this.addRule(Key_Range_Select, Key_Style_Fetch, 3);
        this.addRule(Key_Range_Select, Key_Copy, 3);
        this.addRule(Key_Range_Select, Key_Cut, 3);
        this.addRule(Key_Range_Select, Key_Style_Brush, 3);
        this.addRule(Key_Range_Select, Key_Filled, 3);
        this.addRule(Key_Range_Select, Key_Insert, 3);
        this.addRule(Key_Range_Select, Key_Pasted, 3);
        this.addRule(Key_Range_Select, Key_Edit, 3);
        this.addRule(Key_Range_Select, Key_Range_Select, 3);
    }

    public void popEditState() {
        this._states.pop();
    }

    public IState createStyleFetchState() {
        if (this._styleFetchState == null) {
            this._styleFetchState = new StyleFetchState(this._context);
        }
        return this._styleFetchState;
    }

    public IState createCopyState(SortedCellBlockArray blocks) {
        if (this._copyState == null) {
            this._copyState = new CopyState(this._context, blocks);
        } else {
            ((CopyState)this._copyState).init(blocks);
        }
        return this._copyState;
    }

    public IState createCutState(SortedCellBlockArray blocks) {
        if (this._cutState == null) {
            this._cutState = new CutState(this._context, blocks);
        } else {
            ((CutState)this._cutState).init(blocks);
        }
        return this._cutState;
    }

    public IState createStyleBrushState(SortedCellBlockArray blocks) {
        if (this._styleBrushState == null) {
            this._styleBrushState = new StyleBrushState(this._context, blocks);
        } else {
            ((StyleBrushState)this._styleBrushState).init(blocks);
        }
        return this._styleBrushState;
    }

    public IState createFilledState(CellBlock dstBlock, Range srcRange, FillType resultType) {
        if (this._filledState == null) {
            this._filledState = new FilledState(this._context, dstBlock, srcRange, resultType);
        } else {
            ((FilledState)this._filledState).init(dstBlock, srcRange, resultType);
        }
        return this._filledState;
    }

    public IState createInsertState(boolean bRow) {
        if (this._insertState == null) {
            this._insertState = new InsertState(this._context, bRow);
        } else {
            ((InsertState)this._insertState).init(bRow);
        }
        return this._insertState;
    }

    public IState createPastedState(Range dstRange) {
        if (this._pastedState == null) {
            this._pastedState = new PasteState(this._context, dstRange);
        } else {
            ((PasteState)this._pastedState).init(dstRange);
        }
        return this._pastedState;
    }

    public IState createEditState(Object condition) {
        if (this._editState == null) {
            this._editState = new EditingState(this._context, condition);
        } else {
            ((EditingState)this._editState).init(condition);
        }
        return this._editState;
    }

    public IState createRangeSelectState(IRangeSelector rs) {
        if (this._rangeSelState == null) {
            this._rangeSelState = new RangeSelectState(this._context, rs);
        } else {
            ((RangeSelectState)this._rangeSelState).init(rs);
        }
        return this._rangeSelState;
    }

    @Override
    public boolean stop() {
        return super.stop();
    }

    @Override
    public boolean cancel() {
        return super.cancel();
    }

    public boolean cancelByKey(int key) {
        int index;
        if (this._states.size() == 0) {
            return true;
        }
        for (index = 0; index < this._states.size(); ++index) {
            IState state = (IState)this._states.get(index);
            if (state.getKey() != Key_Range_Select) continue;
            boolean b = state.cancel(-1);
            if (b) break;
            return b;
        }
        if (index != this._states.size()) {
            this._states.remove(index);
        }
        return true;
    }

    public boolean isState2(int key) {
        for (int i = this._states.size() - 1; i >= 0; --i) {
            IState state = (IState)this._states.get(i);
            if (state.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public IState getCurrentState2(int key) {
        for (int i = this._states.size() - 1; i >= 0; --i) {
            IState state = (IState)this._states.get(i);
            if (state.getKey() != key) continue;
            return state;
        }
        return null;
    }

    public boolean stopEditing() {
        boolean bt = this._context.getSpread().getTabbedBar().stopEditing();
        if (!bt) {
            return bt;
        }
        if (this.isState2(Key_Range_Select)) {
            this.cancelByKey(Key_Range_Select);
        }
        if (this.isState(Key_Edit)) {
            boolean b = this.stop();
            return b;
        }
        return true;
    }

    @Override
    public void changed(SheetChangeEvent e) {
        for (int i = this._states.size() - 1; i >= 0; --i) {
            DefaultState ds = (DefaultState)this._states.get(i);
            if (ds == null) continue;
            ds.changed(e);
        }
    }

    @Override
    public void changed(BookChangeEvent e) {
        if (e.isSheetRemove() || e.isSheetHide()) {
            this.stopAll();
            return;
        }
        for (int i = this._states.size() - 1; i >= 0 && !this._states.empty(); --i) {
            IState ds = (IState)this._states.get(i);
            if (!(ds instanceof DefaultState) || ds == null) continue;
            ((DefaultState)ds).changed(e);
        }
    }

    @Override
    public void changed(SheetPropertyChangeEvent e) {
    }
}

