/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.clipboard;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedRowArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;

public class KDSTransferable
implements Transferable {
    private DataFlavor[] flavors;
    private String text;

    public KDSTransferable(Sheet sheet) {
        this.text = KDSTransferable.getClipboardString(sheet, sheet.getSheetOption().getSelection().toSortedBlocks());
    }

    public KDSTransferable(Sheet sheet, boolean securityFilter) {
        boolean bfilter = sheet.getAutoFilterArea() != null || sheet.getAdvancedFilterArea() != null;
        this.text = securityFilter || bfilter ? this.getClipboardStringSecurity(sheet, sheet.getSheetOption().getSelection().toSortedBlocks(), securityFilter, bfilter) : KDSTransferable.getClipboardString(sheet, sheet.getSheetOption().getSelection().toSortedBlocks());
    }

    public static String getClipboardString(Sheet sheet, SortedCellBlockArray sa) {
        CellBlock bounds = sa.getBounds();
        int iCells = Math.min(Math.max(1, sheet.getMaxColIndex()), bounds.getWidth());
        int iRows = Math.min(Math.max(1, sheet.getMaxRowIndex()), bounds.getHeight());
        char[] emptyCells = new char[iCells];
        char[] emptyRows = new char[iRows];
        Arrays.fill(emptyCells, '\t');
        Arrays.fill(emptyRows, '\n');
        StringBuilder buf = new StringBuilder(iRows);
        SortedRowArray rows = sheet.getRows();
        int blockColNum = sa.getBlocksColumnNum();
        int blockRowNum = sa.size() / blockColNum;
        int lastRow = bounds.getRow();
        for (int rBlock = 0; rBlock < blockRowNum; ++rBlock) {
            int rPos;
            int leftBlockIndex = rBlock * blockColNum;
            CellBlock leftB = sa.getBlock(leftBlockIndex);
            int rowStart = leftB.getRow();
            int rowEnd = leftB.getRow2();
            if (lastRow < rowStart) {
                buf.append(emptyRows, 0, Math.min(emptyRows.length, rowStart - lastRow));
            }
            lastRow = rowEnd + 1;
            int rPos2 = rows.getProperPos(rowEnd, true);
            if (rPos2 < rPos) {
                buf.append(emptyRows, 0, Math.min(emptyRows.length, rowEnd - rowStart + 1));
                continue;
            }
            for (rPos = rows.getProperPos(rowStart, false); rPos <= rPos2; ++rPos) {
                Row rowObj = rows.getAt(rPos);
                int row = rowObj.getRow();
                if (rowStart < row) {
                    buf.append(emptyRows, 0, Math.min(emptyRows.length, row - rowStart));
                }
                rowStart = row + 1;
                int lastCol = bounds.getCol();
                for (int cBlock = 0; cBlock < blockColNum; ++cBlock) {
                    int cPos;
                    CellBlock block = sa.getBlock(leftBlockIndex + cBlock);
                    int colStart = block.getCol();
                    int colEnd = block.getCol2();
                    if (lastCol < colStart) {
                        buf.append(emptyCells, 0, Math.min(emptyCells.length, colStart - lastCol));
                    }
                    lastCol = colEnd + 1;
                    int cPos2 = rowObj.getProperPos(colEnd, true);
                    if (cPos2 < cPos) {
                        buf.append(emptyCells, 0, Math.min(emptyCells.length, 1));
                        continue;
                    }
                    for (cPos = rowObj.getProperPos(colStart, false); cPos <= cPos2; ++cPos) {
                        Cell cll = rowObj.getAt(cPos);
                        int col = cll.getCol();
                        if (colStart < col) {
                            buf.append(emptyCells, 0, Math.min(emptyCells.length, col - colStart));
                        }
                        buf.append(KDSTransferable.makeClipboardString(cll.getText()));
                        buf.append('\t');
                        colStart = col + 1;
                    }
                }
                buf.setCharAt(buf.length() - 1, '\n');
            }
            if (rowStart >= rowEnd) continue;
            buf.append(emptyRows, 0, Math.min(emptyRows.length, rowEnd - rowStart));
        }
        return buf.toString();
    }

    public String getClipboardStringSecurity(Sheet sheet, SortedCellBlockArray sa, boolean bsecurity, boolean bfilter) {
        int pos;
        CellBlock bounds = sa.getBounds();
        int iCells = Math.min(Math.max(1, sheet.getMaxColIndex()), bounds.getWidth());
        int iRows = Math.min(Math.max(1, sheet.getMaxRowIndex()), bounds.getHeight());
        int[] hidedRows = sheet.getSecHidedRows();
        int[] hidedCols = sheet.getSecHidedCols();
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        int start = bounds.getRow();
        int end = bounds.getRow2();
        int count = 0;
        for (int i = start; i <= end; ++i) {
            if (bsecurity && !bfilter && AlgorithmUtil.contain(hidedRows, i)) {
                ++count;
            }
            if (!bfilter || (pos = rowSpans.searchSpan(i)) < 0 || rowSpans.getAttributeSpan(pos).isVisible()) continue;
            ++count;
        }
        iRows -= count;
        count = 0;
        start = bounds.getCol();
        end = bounds.getCol2();
        for (int j = start; j <= end; ++j) {
            if (bsecurity && !bfilter && AlgorithmUtil.contain(hidedCols, j)) {
                ++count;
            }
            if (!bfilter || (pos = colSpans.searchSpan(j)) < 0 || colSpans.getAttributeSpan(pos).isVisible()) continue;
            ++count;
        }
        char[] emptyCells = new char[iCells -= count];
        char[] emptyRows = new char[iRows];
        Arrays.fill(emptyCells, '\t');
        Arrays.fill(emptyRows, '\n');
        StringBuilder buf = new StringBuilder(iRows);
        SortedRowArray rows = sheet.getRows();
        int blockColNum = sa.getBlocksColumnNum();
        int blockRowNum = sa.size() / blockColNum;
        int lastRow = bounds.getRow();
        for (int rBlock = 0; rBlock < blockRowNum; ++rBlock) {
            int rPos;
            int leftBlockIndex = rBlock * blockColNum;
            CellBlock leftB = sa.getBlock(leftBlockIndex);
            int rowStart = leftB.getRow();
            int rowEnd = leftB.getRow2();
            if (lastRow < rowStart) {
                buf.append(emptyRows, 0, Math.min(emptyRows.length, rowStart - lastRow));
            }
            lastRow = rowEnd + 1;
            int rPos2 = rows.getProperPos(rowEnd, true);
            if (rPos2 < rPos) {
                buf.append(emptyRows, 0, Math.min(emptyRows.length, rowEnd - rowStart + 1));
                continue;
            }
            for (rPos = rows.getProperPos(rowStart, false); rPos <= rPos2; ++rPos) {
                int pos2;
                Row rowObj = rows.getAt(rPos);
                int row = rowObj.getRow();
                if (bsecurity && !bfilter && AlgorithmUtil.contain(hidedRows, row)) {
                    rowStart = row + 1;
                    continue;
                }
                if (bfilter && (pos2 = rowSpans.searchSpan(row)) >= 0 && !rowSpans.getAttributeSpan(pos2).isVisible()) {
                    rowStart = row + 1;
                    continue;
                }
                if (rowStart < row) {
                    buf.append(emptyRows, 0, Math.min(emptyRows.length, row - rowStart));
                }
                rowStart = row + 1;
                int lastCol = bounds.getCol();
                for (int cBlock = 0; cBlock < blockColNum; ++cBlock) {
                    int cPos;
                    CellBlock block = sa.getBlock(leftBlockIndex + cBlock);
                    int colStart = block.getCol();
                    int colEnd = block.getCol2();
                    if (lastCol < colStart) {
                        buf.append(emptyCells, 0, Math.min(emptyCells.length, colStart - lastCol));
                    }
                    lastCol = colEnd + 1;
                    int cPos2 = rowObj.getProperPos(colEnd, true);
                    if (cPos2 < cPos) {
                        buf.append(emptyCells, 0, Math.min(emptyCells.length, 1));
                        continue;
                    }
                    for (cPos = rowObj.getProperPos(colStart, false); cPos <= cPos2; ++cPos) {
                        int pos3;
                        Cell cll = rowObj.getAt(cPos);
                        int col = cll.getCol();
                        if (bsecurity && !bfilter && AlgorithmUtil.contain(hidedCols, col)) {
                            colStart = col + 1;
                            continue;
                        }
                        if (bfilter && (pos3 = colSpans.searchSpan(row)) >= 0 && !colSpans.getAttributeSpan(pos3).isVisible()) {
                            colStart = col + 1;
                            continue;
                        }
                        if (colStart < col) {
                            buf.append(emptyCells, 0, Math.min(emptyCells.length, col - colStart));
                        }
                        buf.append(KDSTransferable.makeClipboardString(cll.getText()));
                        buf.append('\t');
                        colStart = col + 1;
                    }
                }
                int len = buf.length() - 1;
                if (len < 0) continue;
                buf.setCharAt(len, '\n');
            }
            if (rowStart >= rowEnd) continue;
            buf.append(emptyRows, 0, Math.min(emptyRows.length, rowEnd - rowStart));
        }
        return buf.toString();
    }

    private static String makeClipboardString(String text) {
        if (!StringUtil.isEmptyString((String)text) && text.indexOf(10) != -1) {
            StringBuilder buf = new StringBuilder(text.length() + 16);
            buf.append('\"');
            buf.append(text);
            int index = buf.indexOf("\"", 1);
            while (index != -1) {
                buf.insert(index, '\"');
                index = buf.indexOf("\"", index + 2);
            }
            buf.append('\"');
            text = buf.toString();
        }
        return text;
    }

    DataFlavor[] getDataFlavors() {
        if (this.flavors == null) {
            this.flavors = new DataFlavor[1];
            this.flavors[0] = DataFlavor.stringFlavor;
        }
        return this.flavors;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            return this.text;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.getDataFlavors();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == DataFlavor.stringFlavor;
    }
}

