/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.clipboard;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class StringWalker {
    private static final Logger logger = LogUtil.getPackageLogger(StringWalker.class);
    private char[] stringValue;
    private int lastPos;
    private int curPos;
    private int len;
    private boolean isAdvancedMod;

    public StringWalker(String target) {
        this.cleanup();
        this.stringValue = target.toCharArray();
        this.len = this.stringValue.length;
    }

    public void cleanup() {
        this.stringValue = null;
        this.lastPos = 0;
        this.curPos = 0;
        this.len = 0;
        this.isAdvancedMod = false;
    }

    public void setAdvancedMod(boolean isAdvance) {
        this.isAdvancedMod = isAdvance;
    }

    public boolean hasNext() {
        return this.curPos < this.len;
    }

    public boolean isEnd() {
        return this.curPos == this.len;
    }

    public char nextChar() {
        return this.stringValue[this.curPos++];
    }

    public char previousChar() {
        return this.stringValue[--this.curPos];
    }

    public String separate(boolean isIncludeTail) {
        int endPos;
        String res = null;
        int n = endPos = isIncludeTail ? this.curPos : this.curPos - 1;
        if (this.isAdvancedMod && this.stringValue[this.lastPos] == '\"' && this.stringValue[endPos - 1] == '\"') {
            ++this.lastPos;
            StringBuilder buf = new StringBuilder(--endPos - this.lastPos);
            while (this.lastPos < endPos) {
                char ch;
                if ((ch = this.stringValue[this.lastPos++]) == '\"' && this.lastPos < endPos && this.stringValue[this.lastPos++] != '\"') {
                    --this.lastPos;
                }
                if (ch == '\t') continue;
                buf.append(ch);
            }
            res = buf.toString();
        } else {
            res = new String(this.stringValue, this.lastPos, endPos - this.lastPos);
        }
        this.lastPos = this.curPos;
        this.isAdvancedMod = false;
        res = StringWalker.parserNumberString(res);
        return res;
    }

    private static String parserNumberString(String source) {
        if (StringUtil.isEmptyString((String)source)) {
            return source;
        }
        String number = source.trim();
        if (StringUtil.isEmptyString((String)number)) {
            return source;
        }
        if (number.charAt(0) == '(' && number.charAt(number.length() - 1) == ')') {
            if ((number = number.substring(1, number.length() - 1)).length() > 1 && number.charAt(0) != '-') {
                number = "-" + number;
            } else {
                return source;
            }
        }
        if ((number = number.trim()).lastIndexOf(44) == -1) {
            try {
                new BigDecimal(number);
            }
            catch (NumberFormatException e) {
                return source;
            }
            return number;
        }
        number = number.replaceAll(",", "");
        try {
            new BigDecimal(number);
        }
        catch (NumberFormatException e) {
            return source;
        }
        int pos0 = number.lastIndexOf(46);
        String sub = number;
        if (pos0 == -1) {
            pos0 = 0;
        } else {
            sub = number.substring(0, pos0);
        }
        char[] chars = sub.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c2 = chars[chars.length - i - 1];
            if (c2 != ',' || (i + 1) % 4 == 0) continue;
            return source;
        }
        return number;
    }

    public static String parserKilobitSeparator(String res) {
        if (res.lastIndexOf(44) == -1) {
            String number = res.trim();
            try {
                new BigDecimal(number);
            }
            catch (NumberFormatException e) {
                return res;
            }
            return number;
        }
        String number = res.replaceAll(",", "").trim();
        try {
            new BigDecimal(number);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"err", (Throwable)e);
            return res;
        }
        int pos0 = res.lastIndexOf(46);
        String sub = res;
        if (pos0 == -1) {
            pos0 = 0;
        } else {
            sub = res.substring(0, pos0);
        }
        char[] chars = sub.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c2 = chars[chars.length - i - 1];
            if (c2 != ',' || (i + 1) % 4 == 0) continue;
            return res;
        }
        return number;
    }

    public static SeperateResult separate2Array(String str) {
        SeperateResult result = new SeperateResult();
        StringWalker sw = new StringWalker(str);
        boolean isInBracket = false;
        int startCol = 0;
        int row = 0;
        int col = startCol;
        while (sw.hasNext()) {
            char ch = sw.nextChar();
            if (ch == '\t') {
                if (!isInBracket) {
                    isInBracket = false;
                    result.setValueAt(row, col++, sw.separate(false));
                    continue;
                }
                sw.setAdvancedMod(true);
                continue;
            }
            if (ch == '\n') {
                if (!isInBracket) {
                    result.setValueAt(row++, col, sw.separate(false));
                    col = startCol;
                    continue;
                }
                sw.setAdvancedMod(true);
                continue;
            }
            if (sw.isEnd()) {
                result.setValueAt(row, col, sw.separate(true));
                continue;
            }
            if (ch != '\"') continue;
            isInBracket = !isInBracket;
        }
        sw.cleanup();
        return result;
    }

    public static SeperateResult separate2Array(String str, char[] separators) {
        SeperateResult result = new SeperateResult();
        StringWalker sw = new StringWalker(str);
        boolean isInBracket = false;
        int startCol = 0;
        int row = 0;
        int col = startCol;
        while (sw.hasNext()) {
            char ch = sw.nextChar();
            boolean isSeparator = false;
            for (int i = 0; i < separators.length; ++i) {
                if (ch != separators[i]) continue;
                isSeparator = true;
            }
            if (isSeparator) {
                if (!isInBracket) {
                    isInBracket = false;
                    result.setValueAt(row, col++, sw.separate(false));
                    continue;
                }
                sw.setAdvancedMod(true);
                continue;
            }
            if (ch == '\n') {
                if (!isInBracket) {
                    result.setValueAt(row++, col, sw.separate(false));
                    col = startCol;
                    continue;
                }
                sw.setAdvancedMod(true);
                continue;
            }
            if (sw.isEnd()) {
                result.setValueAt(row, col, sw.separate(true));
                continue;
            }
            if (ch != '\"') continue;
            isInBracket = !isInBracket;
        }
        sw.cleanup();
        return result;
    }

    public static class SeperateResult {
        private int rowCount = 0;
        private int colCount = 0;
        private ArrayList list = new ArrayList();

        public void setValueAt(int row, int col, String text) {
            if (row > this.list.size()) {
                return;
            }
            if (row == this.list.size()) {
                this.list.add(new ArrayList());
            }
            ArrayList rowList = (ArrayList)this.list.get(row);
            if (row >= this.rowCount) {
                this.rowCount = row + 1;
            }
            if (col != rowList.size()) {
                return;
            }
            if (col >= this.colCount) {
                this.colCount = col + 1;
            }
            rowList.add(text);
        }

        public String getValueAt(int row, int col) {
            if (row >= this.list.size()) {
                return null;
            }
            ArrayList rowList = (ArrayList)this.list.get(row);
            if (col >= rowList.size()) {
                return null;
            }
            return (String)rowList.get(col);
        }

        public int getColCount() {
            return this.colCount;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public ArrayList getList() {
            return this.list;
        }
    }
}

