/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.htm;

import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.io.htm.serial.Variant2String;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SheetHyperLinksProps {
    private Map _cell2TargetIdx;
    private Map _idx2ReportProps;
    private Map _idx2ParamsValues;
    private Map _idx2TargetParams;
    private Set _hyperLinkCells;
    private String _idx2ReportPropsJson;
    private String _idx2ParamsValueJson;

    private SheetHyperLinksProps(Sheet sheet, int row1, int row2) {
        this.init(sheet, row1, row2);
    }

    public static SheetHyperLinksProps getInst(Sheet sheet, int row1, int row2) {
        return new SheetHyperLinksProps(sheet, row1, row2);
    }

    private void init(Sheet sheet, int row1, int row2) {
        Sheet.ICellsIterator iter = sheet.getCellsIterator(row1, 0, row2, sheet.getMaxColIndex(), false, false);
        this._hyperLinkCells = new TreeSet();
        this._cell2TargetIdx = new TreeMap();
        this._idx2ParamsValues = new TreeMap();
        this._idx2ReportProps = new TreeMap();
        this._idx2TargetParams = new TreeMap();
        TreeMap paramsValues = new TreeMap();
        TreeMap reportProps2Idxs = new TreeMap();
        int paramIdx = 0;
        int reportPropsIdx = 0;
        while (iter.hasNext()) {
            Map<String, Object> tars;
            ETTargets ett;
            ICalculableProps prop;
            SortedExtPropFormulasArray formulas;
            Cell cell = iter.next();
            ExtProps ep = cell.getExtProps(false);
            if (ep == null || (formulas = ep.getFormulas(false)) == null || (prop = formulas.get(ExtConst.FORMULA_HYPERLINK)) == null || (ett = (ETTargets)(tars = ((HyperlinkCalculableProps)prop).getTargets()).get("EXTRPT")) == null) continue;
            this._hyperLinkCells.add(cell);
            List targets = ett.getTargets();
            Iterator itor = targets.iterator();
            LinkedList idxList = new LinkedList();
            ArrayList targetsParams = new ArrayList(targets.size());
            while (itor.hasNext()) {
                Object obj;
                ExtTransitionTarget target = (ExtTransitionTarget)itor.next();
                ReportProperties props = target.getReportProps();
                Object alias = ep.executeCalculableProps(props.getCalculableProps());
                if (alias != null) {
                    props.setAlias(alias.toString());
                }
                if ((obj = reportProps2Idxs.get(props)) == null) {
                    obj = reportPropsIdx++;
                    reportProps2Idxs.put(props, obj);
                    this._idx2ReportProps.put(obj, props.toJsonMap());
                }
                idxList.add(obj);
                Map<String, IParameter> params = target.getParameters();
                TreeMap<String, Map<String, Object>> paramJsonMap = new TreeMap<String, Map<String, Object>>();
                if (params == null) {
                    targetsParams.add(paramJsonMap);
                    continue;
                }
                ep.executeParams(params);
                Iterator<Map.Entry<String, IParameter>> i = params.entrySet().iterator();
                while (i.hasNext()) {
                    ParameterImpl param = (ParameterImpl)i.next().getValue();
                    Variant vt = param.getValue();
                    if (vt != Variant.nullVariant) {
                        Object pV = paramsValues.get(vt);
                        if (pV == null) {
                            pV = paramIdx++;
                            paramsValues.put(vt, pV);
                            this._idx2ParamsValues.put(pV, Variant2String.toString(vt));
                        }
                        param.setValue(new Variant(pV, 3));
                    }
                    paramJsonMap.put(param.getName(), param.toJsonFormMap());
                }
                targetsParams.add(paramJsonMap);
            }
            this._cell2TargetIdx.put(cell, idxList);
            this._idx2TargetParams.put(cell, targetsParams);
        }
    }

    public Map getCell2TargetIdx() {
        return this._cell2TargetIdx;
    }

    public Map getIdx2ReportProps() {
        return this._idx2ReportProps;
    }

    public Map getIdx2ParamsValues() {
        return this._idx2ParamsValues;
    }

    public Set getHyperLinkCells() {
        return this._hyperLinkCells;
    }

    public void clear() {
        Map[] maps = new Map[]{this._cell2TargetIdx, this._idx2ReportProps, this._idx2ParamsValues};
        for (int i = 0; i < maps.length; ++i) {
            if (maps[i] == null) continue;
            maps[i].clear();
            maps[i] = null;
        }
        if (this._hyperLinkCells != null) {
            this._hyperLinkCells.clear();
            this._hyperLinkCells = null;
        }
    }

    public String getIdx2ReportPropsJson() {
        StringBuilder strBuf = new StringBuilder(1024);
        strBuf.append("<SPAN sue = \"report_data\"> ");
        strBuf.append(this._idx2ReportPropsJson);
        strBuf.append("</SPAN>");
        return strBuf.toString();
    }

    public void setIdx2ReportPropsJson(String idx2ReportPropsJson) {
        this._idx2ReportPropsJson = idx2ReportPropsJson;
    }

    public String getIdx2ParamsValueJson() {
        StringBuilder strBuf = new StringBuilder(1024);
        strBuf.append("<SPAN sue = \"param_data\"> ");
        strBuf.append(this._idx2ParamsValueJson);
        strBuf.append("</SPAN>");
        return strBuf.toString();
    }

    public void setIdx2ParamsValueJson(String idx2ParamsValueJson) {
        this._idx2ParamsValueJson = idx2ParamsValueJson;
    }

    public Map getIdx2TargetParams() {
        return this._idx2TargetParams;
    }
}

