/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.htm;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.io.htm.IXslHtmConstants;
import com.kingdee.cosmic.ctrl.kds.io.htm.XslHtmUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class XslHtmStyleParser
implements IXslHtmConstants {
    private static final String[] kmlPatternNames = new String[]{null, "Solid", "Gray-75", "Gray-50", "Gray-25", "Gray-125", "Gray-0625", "HorzStripe", "VertStripe", "ReverseDiagStripe", "DiagStripe", "DiagCross", "ThickDiagCross", "ThinHorzStripe", "ThinVertStripe", "ThinReverseDiagStripe", "ThinDiagStripe", "ThinHorzCross", "ThinDiagCross"};
    private static final String Continuous = "solid";
    private static final String Dot = "dotted";
    private static final String DashDotDot = "dot-dot-dash";
    private static final String DashDot = "dot-dash";
    private static final String SlantDashDot = "dot-dash-slanted";
    private static final String Double = "double";
    private static final String Dash = "dashed";
    private static final String Weight0 = "0";
    private static final String Weight1 = "1";
    private static final String Weight2 = "2";
    private static final String Weight3 = "3";
    private static final String DefaultStyleIDString = "Default";
    private static final String DefaultStyleID = "1";
    private static final String StyleIDPrefix = "x";
    private static final String KmlVeriAlignCenterValue = "Center";
    private static final String SaVeriAlignCenterValue = "Middle";
    private static final String KmlUnderlineValue = "single";
    private static final String KmlUnderlineNoValue = "NoUnderline";

    public static String buildStyleID(ShareStyleAttributes ssa) {
        String styleID = String.valueOf(ssa.getUID());
        styleID = "1".equals(styleID) ? DefaultStyleIDString : StyleIDPrefix + styleID;
        return styleID;
    }

    static List buildStylesElement(Iterator iterStyles) {
        ArrayList stylesElement = new ArrayList();
        while (iterStyles.hasNext()) {
            Map.Entry e = (Map.Entry)iterStyles.next();
            ShareStyleAttributes ssa = (ShareStyleAttributes)e.getValue();
            HashMap styleElement = new HashMap();
            ArrayList PropertyList = new ArrayList();
            String styleId = XslHtmStyleParser.buildStyleID(ssa);
            styleElement.put(styleId, PropertyList);
            XslHtmStyleParser.buildStyleElement(ssa, PropertyList);
            stylesElement.add(styleElement);
        }
        return stylesElement;
    }

    private static void buildStyleElement(ShareStyleAttributes ssa, List styleElement) {
        XslHtmStyleParser.buildAlignmentElement(ssa, styleElement);
        XslHtmStyleParser.buildBordersElement(ssa, styleElement);
        XslHtmStyleParser.buildFontElement(ssa, styleElement);
        XslHtmStyleParser.buildInteriorElement(ssa, styleElement);
        XslHtmStyleParser.buildNumberFormatElement(ssa, styleElement);
        XslHtmStyleParser.buildProtectionElement(ssa, styleElement);
    }

    static List getStyleElement(ShareStyleAttributes ssa) {
        ArrayList styleElements = new ArrayList();
        XslHtmStyleParser.buildStyleElement(ssa, styleElements);
        return styleElements;
    }

    private static void buildNumberFormatElement(ShareStyleAttributes ssa, List styleElement) {
        String nf;
        if (ssa.hasAttributes(ShareStyleAttributes.NUMBER_FORMAT) && !StringUtil.isEmptyString((String)(nf = ssa.getNumberFormat()))) {
            HashMap<String, String> nfElement = new HashMap<String, String>();
            styleElement.add(nfElement);
            nfElement.put("mso-number-format", XslHtmUtil.toXmlString(nf));
        }
    }

    private static void buildFontElement(ShareStyleAttributes ssa, List styleElement) {
        if (ssa.hasFontAttributes()) {
            HashMap<String, String> fontElement = new HashMap<String, String>();
            boolean b2 = XslHtmStyleParser.setStyleAttribute(ssa, ShareStyleAttributes.FONT_NAME, "font-family", fontElement);
            if (XslHtmStyleParser.setStyleAttribute(ssa, ShareStyleAttributes.FONT_SIZE, "font-size", fontElement)) {
                fontElement.put("font-size", fontElement.get("font-size").toString() + "pt");
                b2 = true;
            }
            b2 |= XslHtmStyleParser.setStyleColorAttribute(ssa, ShareStyleAttributes.FONT_COLOR, "color", fontElement);
            if (ssa.hasAttributes(ShareStyleAttributes.FONT_BOLD)) {
                b2 = true;
                if (ssa.isBold()) {
                    fontElement.put("font-weight", "bold");
                }
            }
            if (ssa.hasAttributes(ShareStyleAttributes.FONT_UNDERLINE)) {
                b2 = true;
                if (ssa.isUnderline()) {
                    fontElement.put("text-decoration", "underline");
                    fontElement.put("text-underline-style", KmlUnderlineValue);
                }
            }
            if (ssa.hasAttributes(ShareStyleAttributes.FONT_ITALIC)) {
                b2 = true;
                if (ssa.isItalic()) {
                    fontElement.put("font-style", "italic");
                }
            }
            if (b2 |= XslHtmStyleParser.setStyleBooleanAttribute(ssa, ShareStyleAttributes.FONT_STRIKETHROUGH, "StrikeThrough", fontElement)) {
                styleElement.add(fontElement);
            }
        }
    }

    private static void buildBordersElement(ShareStyleAttributes ssa, List styleElement) {
        if (ssa.hasBordersAttributes()) {
            HashMap bordersElement = new HashMap();
            boolean b2 = false;
            b2 = XslHtmStyleParser.buildBorderElement(ssa, Styles.Position.LEFT, bordersElement);
            b2 |= XslHtmStyleParser.buildBorderElement(ssa, Styles.Position.TOP, bordersElement);
            b2 |= XslHtmStyleParser.buildBorderElement(ssa, Styles.Position.RIGHT, bordersElement);
            b2 |= XslHtmStyleParser.buildBorderElement(ssa, Styles.Position.BOTTOM, bordersElement);
            b2 |= XslHtmStyleParser.buildBorderElement(ssa, Styles.Position.DIAGONALLEFT, bordersElement);
            if (b2 |= XslHtmStyleParser.buildBorderElement(ssa, Styles.Position.DIAGONALRIGHT, bordersElement)) {
                styleElement.add(bordersElement);
            }
        }
    }

    private static boolean buildBorderElement(ShareStyleAttributes ssa, Styles.Position pos, Map bordersElement) {
        LineStyle lineStyle;
        if (ssa.hasBorderAttributes(pos) && (lineStyle = ssa.getBorderLineStyle(pos)) != null && lineStyle != LineStyle.NULL_LINE) {
            PenStyle penStyle = ssa.getBorderPenStyle(pos);
            if (penStyle == null) {
                penStyle = Styles.getDefaultSSA().getBorderPenStyle(pos);
            }
            KmlBorder kmlBorder = XslHtmStyleParser.toKmlBorder(lineStyle, penStyle);
            String borderName = pos.getName();
            StringBuilder sb = new StringBuilder(20);
            sb.append(kmlBorder.getWeight()).append("pt").append(' ');
            sb.append(kmlBorder.getLineStyle()).append(' ');
            sb.append(XslHtmStyleParser.getStyleColorByIndex(ssa, ShareStyleAttributes.getBorderColorIndex((Styles.Position)pos), "color", bordersElement));
            if (borderName.equals("mso-diagonal-down")) {
                bordersElement.put(pos.getName(), sb.toString());
            } else {
                bordersElement.put("border-" + pos.getName(), sb.toString());
            }
            return true;
        }
        return false;
    }

    private static void buildInteriorElement(ShareStyleAttributes ssa, List styleElement) {
        if (ssa.hasInteriorAttributes()) {
            HashMap<String, String> interiorElement = new HashMap<String, String>();
            Pattern pa = ssa.getPattern();
            if (!Pattern.None.equals(pa)) {
                String pattern;
                if (pa == null) {
                    pa = Pattern.Solid;
                }
                if ((pattern = XslHtmStyleParser.toKmlPatternName(pa)) != null) {
                    XslHtmStyleParser.setStyleColorAttribute(ssa, ShareStyleAttributes.BACKGROUND_COLOR, "background", interiorElement);
                    if (ssa.hasAttributes(ShareStyleAttributes.PATTERN_COLOR)) {
                        String patternColor = XslHtmStyleParser.getStyleColor(ssa, ShareStyleAttributes.PATTERN_COLOR);
                        interiorElement.put("mso-pattern", patternColor + " " + pattern);
                    } else {
                        interiorElement.put("mso-pattern", "auto none");
                    }
                    styleElement.add(interiorElement);
                }
            }
        }
    }

    private static void buildAlignmentElement(ShareStyleAttributes ssa, List styleElement) {
        if (ssa.hasAlignmentAttributes()) {
            HashMap<String, String> alignElement = new HashMap<String, String>();
            boolean b2 = false;
            int index = ShareStyleAttributes.VERTICAL_ALIGN;
            if (ssa.hasAttributes(index)) {
                b2 = true;
                Styles.VerticalAlignment va = ssa.getVerticalAlign();
                String strVa = KmlVeriAlignCenterValue;
                strVa = Styles.VerticalAlignment.MIDDLE.equals(va) ? KmlVeriAlignCenterValue : XslHtmStyleParser.firstCharToUpper(va.toString());
                alignElement.put("vertical-align", strVa);
            }
            if (ssa.hasAttributes(index = ShareStyleAttributes.HORIZONTAL_ALIGN)) {
                b2 |= true;
                if (ssa.getHorizontalAlign().getValue() != 0) {
                    alignElement.put("text-align", XslHtmStyleParser.firstCharToUpper(ssa.getHorizontalAlign().toString()));
                }
            }
            if (ssa.hasAttributes(index = ShareStyleAttributes.WRAP_TEXT)) {
                Object obj = ssa.get(index);
                if (Boolean.TRUE.equals(obj)) {
                    alignElement.put("white-space", "normal");
                }
                b2 = true;
            }
            if (ssa.hasAttributes(index = StyleAttributes.ROTATION)) {
                b2 = true;
                alignElement.put("mso-rotate", ssa.get(index).toString());
            }
            if (ssa.hasAttributes(index = ShareStyleAttributes.SHRINK_TEXT)) {
                alignElement.put("mso-text-control", "shrinktofit");
                b2 = true;
            }
            if (b2) {
                styleElement.add(alignElement);
            }
        }
    }

    private static void buildProtectionElement(ShareStyleAttributes ssa, List styleElement) {
        if (ssa.hasProtectionAttributes()) {
            Object obj;
            HashMap<String, String> element = new HashMap<String, String>();
            boolean b2 = false;
            int index = ShareStyleAttributes.PROTECTION_LOCKED;
            String pro = "";
            if (ssa.hasAttributes(index)) {
                obj = ssa.get(index);
                pro = Boolean.TRUE.equals(obj) ? "locked" : "unlocked";
                b2 = true;
            }
            if (ssa.hasAttributes(index = ShareStyleAttributes.PROTECTION_HIDDED)) {
                obj = ssa.get(index);
                if (Boolean.TRUE.equals(obj)) {
                    if (b2) {
                        pro = pro + " ";
                    }
                    pro = pro + "hidden";
                }
                b2 = true;
            }
            element.put("mso-protection", pro);
            if (b2) {
                styleElement.add(element);
            }
        }
    }

    private static String getStyleColorByIndex(ShareStyleAttributes ssa, int index, String attriName, Map element) {
        boolean b2 = ssa.hasAttributes(index);
        String color = "";
        if (b2) {
            Object obj = ssa.get(index);
            color = StyleParser.colorToHex((Color)((Color)obj));
        }
        return color;
    }

    private static String firstCharToUpper(String str) {
        if (str.length() > 1) {
            return (char)(str.charAt(0) - 32) + str.substring(1);
        }
        return str;
    }

    private static boolean getSaBooleanAttribute(String str) {
        return "1".equals(str);
    }

    private static boolean setStyleAttribute(ShareStyleAttributes ssa, int index, String attriName, Map element) {
        boolean b2 = ssa.hasAttributes(index);
        if (b2) {
            Object obj = ssa.get(index);
            element.put(attriName, obj.toString());
        }
        return b2;
    }

    private static boolean setStyleBooleanAttribute(ShareStyleAttributes ssa, int index, String attriName, Map styleElement) {
        if (ssa.hasAttributes(index)) {
            Object obj = ssa.get(index);
            if (Boolean.TRUE.equals(obj)) {
                styleElement.put(attriName, "1");
            } else {
                styleElement.put(attriName, Weight0);
            }
            return true;
        }
        return false;
    }

    private static boolean setStyleColorAttribute(ShareStyleAttributes ssa, int index, String attriName, Map element) {
        boolean b2 = ssa.hasAttributes(index);
        if (b2) {
            Object obj = ssa.get(index);
            element.put(attriName, StyleParser.colorToHex((Color)((Color)obj)));
        }
        return b2;
    }

    private static String getStyleColor(ShareStyleAttributes ssa, int index) {
        boolean b2 = ssa.hasAttributes(index);
        if (b2) {
            Object obj = ssa.get(index);
            return StyleParser.colorToHex((Color)((Color)obj));
        }
        return null;
    }

    static List parseChartType(String type) {
        ArrayList<String> chartType = new ArrayList<String>(8);
        if (type.startsWith("Column")) {
            chartType.add("Column");
            if (type.indexOf("Clustered") != -1) {
                chartType.add("Clustered");
            }
            if (type.indexOf("Stacked") != -1) {
                chartType.add("Stacked");
            }
            if (type.indexOf("3D") != -1) {
                chartType.add("3D");
            }
        }
        if (type.startsWith("Pie")) {
            chartType.add("pie");
            if ("pie".equals(type)) {
                chartType.add("Standard");
            }
            if (type.indexOf("Exploded") != -1) {
                chartType.add("Exploded");
            }
            if (type.indexOf("3D") != -1) {
                chartType.add("3D");
            }
        }
        if (type.startsWith("Bar")) {
            chartType.add("Bar");
            if (type.indexOf("Clustered") != -1) {
                chartType.add("Clustered");
            }
            if (type.indexOf("Stacked") != -1) {
                chartType.add("Stacked");
            }
            if (type.indexOf("3D") != -1) {
                chartType.add("3D");
            }
        }
        if (type.startsWith("Line")) {
            chartType.add("Line");
            if ("Line".equals(type)) {
                chartType.add("Standard");
            }
            if ("LineStacked".equals(type)) {
                chartType.add("Stacked");
            }
            if ("LineMarkers".equals(type)) {
                chartType.add("Standard");
                chartType.add("Marker");
            }
            if ("LineMarkersStacked".equals(type)) {
                chartType.add("Stacked");
                chartType.add("Marker");
            }
        }
        if (type.startsWith("XYScatter")) {
            chartType.add("Scatter");
            if ("XYScatter".equals(type)) {
                chartType.add("Marker");
            }
            if ("XYScatterLines".equals(type)) {
                chartType.add("Line");
            }
            chartType.add("Marker");
            if ("XYScatterLinesNoMarkers".equals(type)) {
                chartType.add("Line");
            }
        }
        if (type.startsWith("Area")) {
            chartType.add("Area");
            if ("Area".equals(type)) {
                chartType.add("Standard");
            }
            if ("AreaStacked".equals(type)) {
                chartType.add("Stacked");
            }
        }
        return chartType;
    }

    private static String toKmlPatternName(Pattern p) {
        String n;
        int id = p.getID();
        switch (id) {
            default: {
                n = kmlPatternNames[0];
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 39: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n = kmlPatternNames[1];
                break;
            }
            case 3: {
                n = kmlPatternNames[2];
                break;
            }
            case 19: {
                n = kmlPatternNames[3];
                break;
            }
            case 18: 
            case 26: 
            case 27: {
                n = kmlPatternNames[4];
                break;
            }
            case 24: 
            case 35: 
            case 38: {
                n = kmlPatternNames[5];
                break;
            }
            case 2: 
            case 10: 
            case 43: 
            case 44: {
                n = kmlPatternNames[6];
                break;
            }
            case 45: {
                n = kmlPatternNames[7];
                break;
            }
            case 21: 
            case 37: {
                n = kmlPatternNames[8];
                break;
            }
            case 20: 
            case 36: {
                n = kmlPatternNames[9];
                break;
            }
            case 28: {
                n = kmlPatternNames[10];
                break;
            }
            case 34: {
                n = kmlPatternNames[11];
                break;
            }
            case 11: 
            case 25: 
            case 40: {
                n = kmlPatternNames[12];
                break;
            }
            case 13: 
            case 29: {
                n = kmlPatternNames[13];
                break;
            }
            case 5: {
                n = kmlPatternNames[14];
                break;
            }
            case 4: {
                n = kmlPatternNames[15];
                break;
            }
            case 12: {
                n = kmlPatternNames[16];
                break;
            }
            case 6: 
            case 9: 
            case 16: 
            case 17: {
                n = kmlPatternNames[17];
                break;
            }
            case 41: {
                n = kmlPatternNames[18];
            }
        }
        return n;
    }

    private static KmlBorder toKmlBorder(LineStyle lineStyle, PenStyle penStyle) {
        String weight = "1";
        String strLineStyle = Continuous;
        if (PenStyle.PS_SOLID.equals(penStyle)) {
            int w = lineStyle.getWidth();
            if (w >= 3) {
                weight = Weight3;
                if (!lineStyle.isFillCenterLine()) {
                    strLineStyle = Double;
                }
            } else if (w == 2) {
                weight = Weight2;
            }
        } else if (PenStyle.PS_CONTINUOUS.equals(penStyle)) {
            if (lineStyle.getWidth() == 1) {
                weight = Weight0;
            }
        } else if (PenStyle.PS_DOT.equals(penStyle)) {
            strLineStyle = Dot;
        } else if (PenStyle.PS_DASHDOTDOT.equals(penStyle)) {
            strLineStyle = DashDotDot;
            if (lineStyle.getWidth() >= 2) {
                weight = Weight2;
            }
        } else if (PenStyle.PS_DASHDOT.equals(penStyle)) {
            strLineStyle = DashDot;
            if (lineStyle.getWidth() >= 2) {
                weight = Weight2;
            }
        } else if (PenStyle.PS_DASH.equals(penStyle)) {
            strLineStyle = Dash;
            if (lineStyle.getWidth() >= 2) {
                weight = Weight2;
            }
        }
        KmlBorder kmlBorder = new KmlBorder();
        kmlBorder.setLineStyle(strLineStyle);
        kmlBorder.setWeight(weight);
        return kmlBorder;
    }

    private static class KmlBorder {
        private String _lineStyle;
        private String _weight;

        private KmlBorder() {
        }

        void setLineStyle(String lineStyle) {
            this._lineStyle = lineStyle;
        }

        String getLineStyle() {
            return this._lineStyle;
        }

        void setWeight(String weight) {
            this._weight = weight;
        }

        String getWeight() {
            return this._weight;
        }
    }
}

