/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kds;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.common.util.UnitConverter;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSCell;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;
import java.math.BigDecimal;

public class KDSBookToBook {
    public static Book traslate(KDSBook kdsbook) {
        Book book = Book.Manager.getNewBook(null, 0);
        KDSBookToBook.traslate(kdsbook, book, false);
        return book;
    }

    public static Book traslate(KDSBook kdsbook, boolean b4Mobile) {
        Book book = Book.Manager.getNewBook(null, 0);
        KDSBookToBook.traslate(kdsbook, book, b4Mobile);
        return book;
    }

    public static void traslate(KDSBook kdsbook, Book book, boolean b4Mobile) {
        if (book == null) {
            book = Book.Manager.getNewBook("", 0);
        }
        book.setAutoCalculate(false);
        book.getUndoManager().enable(false);
        book.setSkipListeners(true);
        book.getDeps().setExtendMode(true);
        int count = kdsbook.getSheetCount();
        for (int i = 0; i < count; ++i) {
            KDSSheet kdssheet = kdsbook.getSheet((Object)i);
            if (kdssheet == null) continue;
            Sheet sheet = new Sheet(book, kdssheet.getName());
            book.addSheet(sheet, i == 0);
            sheet.setSSA(kdssheet.getSSA());
            KDSBookToBook.traslateSheet(kdssheet, sheet);
        }
        book.updatePendingSheet();
        book.clearEmptyCells();
        book.setAutoCalculate(false);
        for (int sh = book.getSheetCount() - 1; sh >= 0; --sh) {
            Sheet sheet = book.getSheet(sh);
            if (b4Mobile) {
                sheet.setOriginalDefRowHeight(30);
                sheet.setOriginalDefColWidth(79);
            }
            if (sheet.getSheetType() != 1) continue;
            sheet.getSheetOption().setCellDisplayMode(1);
        }
        book.getUndoManager().enable(true);
        book.setSkipListeners(false);
    }

    private static void traslateSheet(KDSSheet kdssheet, Sheet sheet) {
        KDSBookToBook.translateColumns(kdssheet, sheet);
        KDSBookToBook.translateRows(kdssheet, sheet);
        KDSBookToBook.translateCells(kdssheet, sheet);
        KDSBookToBook.translateMerger(kdssheet, sheet);
    }

    private static void translateColumns(KDSSheet kdssheet, Sheet sheet) {
        int size = kdssheet.getExpandedColumns() + 1;
        for (int i = 0; i < size; ++i) {
            double colWidth = UnitConverter.mmToPx((double)kdssheet.getColumnWidth(i));
            sheet.getColSpans().setSpanAttribute(new Span(i, i), kdssheet.getColumnShareStyleAttributes(i), colWidth <= 0.0 ? null : Integer.valueOf((int)colWidth), null, null, null, false);
        }
    }

    private static void translateRows(KDSSheet kdssheet, Sheet sheet) {
        int size = kdssheet.getExpandedRows() + 1;
        for (int i = 0; i < size; ++i) {
            double rowHeight = UnitConverter.mmToPx((double)kdssheet.getRowHeight(i));
            sheet.getRowSpans().setSpanAttribute(new Span(i, i), kdssheet.getRowShareStyleAttributes(i), rowHeight <= 0.0 ? null : Integer.valueOf((int)rowHeight), null, null, null, false);
        }
    }

    private static void translateCells(KDSSheet kdssheet, Sheet sheet) {
        int colCount = kdssheet.getExpandedColumns() + 1;
        int rowCount = kdssheet.getExpandedRows() + 1;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                KDSCell kdscell = kdssheet.getCell(i, j, false);
                if (kdscell == null) continue;
                KDSMergeBlock smb = kdssheet.getMerges().getMergeBlock(i, j);
                if (smb == KDSMergeBlock.NULL_MERGE || smb.row == i && smb.col == j) {
                    Object value;
                    Cell cell = sheet.getCell(i, j, true);
                    sheet.getRange(cell).setStyle(Styles.getSA((ShareStyleAttributes)kdscell.getSSA()), Styles.getEmptySA());
                    String formula = kdscell.getFormula();
                    if (!StringUtil.isEmptyString((String)formula)) {
                        if (formula.charAt(0) != '=') {
                            formula = "=" + formula;
                        }
                        cell.setFormula(formula);
                    }
                    if ((value = kdscell.getValue()) instanceof String) {
                        if (!StringUtil.isEmptyString((String)((String)value))) {
                            String fmt = kdscell.getStyle() == null ? null : kdscell.getStyle().getNumberFormat();
                            boolean parseDate = kdscell.getType() == 6;
                            Variant var = Cell.parseValue((String)value, fmt, parseDate);
                            cell.setValue(var);
                        }
                    } else {
                        Variant var;
                        switch (kdscell.getType()) {
                            case 0: {
                                var = new Variant(new BigDecimal((String)value), 10);
                                break;
                            }
                            case 1: {
                                var = new Variant(value, 11);
                                break;
                            }
                            case 6: {
                                var = new Variant(value, 13);
                                break;
                            }
                            case 4: {
                                var = new Variant(Boolean.valueOf((String)value), 8);
                                break;
                            }
                            default: {
                                var = new Variant(value);
                            }
                        }
                        cell.setValue(var);
                    }
                    if (null == kdscell.getHyperLink()) continue;
                    HyperLink link = new HyperLink();
                    link.setLinkTo(kdscell.getHyperLink().getLinkTo());
                    link.setText(kdscell.getHyperLink().getText());
                    cell.setHyperLink(link);
                    continue;
                }
                KDSCell tempCell = new KDSCell(null, Styles.getEmptySSA(), Styles.getStyle((ShareStyleAttributes)Styles.getEmptySSA()));
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)tempCell.getSSA());
                KDSCell cellFirst = kdssheet.getCell(smb.row, smb.col, false);
                KDSCell cellLast = kdssheet.getCell(smb.getRow2(), smb.getCol2(), false);
                ShareStyleAttributes ssaFirst = cellFirst.getSSA();
                ShareStyleAttributes ssaLast = cellLast.getSSA();
                sa.setBorder(Styles.Position.LEFT, ssaFirst);
                sa.setBorder(Styles.Position.TOP, ssaFirst);
                sa.setBorder(Styles.Position.RIGHT, ssaLast);
                sa.setBorder(Styles.Position.BOTTOM, ssaLast);
                Cell cell = sheet.getCell(i, j, true);
                sheet.getRange(cell).setStyle(sa, Styles.getEmptySA());
            }
        }
    }

    private static void translateMerger(KDSSheet kdssheet, Sheet sheet) {
        MergeBlocks merger = null;
        for (KDSMergeBlock block : kdssheet.getMerges()) {
            if (merger == null) {
                merger = sheet.getSheetOption().getMerger(true);
            }
            merger.insert(CellBlock.getCellBlock(block.row, block.col, block.getRow2(), block.getCol2()));
        }
    }
}

