/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kds;

import com.kingdee.cosmic.ctrl.common.util.SectionByteOutputStream;
import com.kingdee.cosmic.ctrl.kds.io.kds.KDSConstants;
import com.kingdee.cosmic.ctrl.kds.io.kds.SectionJarUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class SectionJarOutputStream {
    ArrayList sections;

    public SectionJarOutputStream() {
        this.sections = new ArrayList();
    }

    public SectionJarOutputStream(int sectionCount) {
        this.sections = new ArrayList(sectionCount);
    }

    public void addSection(byte[] src) {
        if (src == null || src.length <= 0) {
            throw new IllegalArgumentException("scr can not be null, or length <= 0");
        }
        this.sections.add(src);
    }

    public void addSection(SectionByteOutputStream src) throws IOException {
        if (src == null || src.size() <= 0) {
            throw new IllegalArgumentException("scr can not be null, or length <= 0");
        }
        byte[] bytes = SectionJarUtil.zip(src);
        this.addSection(bytes);
    }

    public void addSection(ByteArrayOutputStream src) throws IOException {
        if (src == null || src.size() <= 0) {
            throw new IllegalArgumentException("src can not be null, or length <= 0");
        }
        byte[] bytes = SectionJarUtil.zip(src);
        this.addSection(bytes);
    }

    public byte[] output() {
        int i;
        int sectionCount = this.sections.size();
        int pos = "#kds01#".length();
        int pos2 = "2.0.0.12".length();
        int headLength = pos + pos2 + 4 + 4 * sectionCount;
        byte[] head = new byte[headLength];
        for (i = 0; i < pos; ++i) {
            head[i] = (byte)"#kds01#".charAt(i);
        }
        for (i = 0; i < pos2; ++i) {
            head[pos++] = (byte)"2.0.0.12".charAt(i);
        }
        KDSConstants.intToBytes(sectionCount, head, pos);
        pos += 4;
        int byteCount = 0;
        for (int i2 = 0; i2 < sectionCount; ++i2) {
            int sectionLength = ((byte[])this.sections.get(i2)).length;
            byteCount += sectionLength;
            KDSConstants.intToBytes(sectionLength, head, pos);
            pos += 4;
        }
        byte[] bytes = new byte[byteCount += headLength];
        System.arraycopy(head, 0, bytes, 0, headLength);
        pos = headLength;
        for (int i3 = 0; i3 < sectionCount; ++i3) {
            byte[] sec = (byte[])this.sections.get(i3);
            System.arraycopy(sec, 0, bytes, pos, sec.length);
            pos += sec.length;
        }
        return bytes;
    }
}

