/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kml;

import com.kingdee.cosmic.ctrl.common.util.NumberUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.io.kml.BasicElement;
import com.kingdee.cosmic.ctrl.kds.io.kml.KmlToBook;
import com.kingdee.cosmic.ctrl.kds.io.kml.KmlUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import java.math.BigDecimal;
import java.util.Calendar;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class CellDataElement
extends BasicElement {
    CellDataElement() {
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return "Data".equals(KmlUtil.getLocalName(qName));
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        if (this.isCurrentElement(uri, localName, qName)) {
            this.bufString.delete(0, this.bufString.length());
            String type = attributes.getValue(KmlUtil.getNSName("Type", "ss"));
            if (!StringUtil.isEmptyString((String)type)) {
                dataCache.setCurCellDataType(type);
            } else {
                dataCache.setCurCellDataType("String");
            }
            dataCache.setCurCellTicked(attributes.getValue(KmlUtil.getNSName("Ticked", "x")));
        }
    }

    @Override
    void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        if (ktb.touchModeFlag(FLAG_DATA)) {
            this.bufString.append(ch, start, length);
        }
    }

    @Override
    void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
        if (this.isCurrentElement(uri, localName, qName)) {
            Variant var;
            Cell cell = dataCache.getCurCell();
            if (cell == null) {
                return;
            }
            boolean ticked = dataCache.isCurCellTicked();
            String type = dataCache.getCurCellDataType();
            String str = KmlUtil.toBookString(this.bufString.toString());
            if (ticked) {
                dataCache.getCurCell().setFormula("'" + str);
                return;
            }
            if ("String".equals(type)) {
                var = new Variant(str, 11);
            } else if ("Number".equals(type)) {
                if (dataCache.isFromExcelClipboard()) {
                    var = new Variant(str, 11);
                    try {
                        BigDecimal bigDecimal = var.toBigDecimal();
                        var.setBigDecimal(bigDecimal);
                        BigDecimal bd = bigDecimal;
                        if (bd.scale() > 6) {
                            var.setBigDecimal(new BigDecimal(NumberUtil.double2String((double)Double.parseDouble(str))));
                        }
                    }
                    catch (SyntaxErrorException e) {
                        var.setObject(str, 11);
                    }
                } else {
                    var = new Variant();
                    try {
                        var.setBigDecimal(new BigDecimal(str));
                    }
                    catch (Exception e) {
                        var.setObject(str, 11);
                    }
                }
            } else if ("DateTime".equals(type)) {
                Calendar cal = Calendar.getInstance();
                String[] strs = str.split("[-T:.]");
                cal.set(Integer.parseInt(strs[0]), Integer.parseInt(strs[1]) - 1, Integer.parseInt(strs[2]) + 1, Integer.parseInt(strs[3]), Integer.parseInt(strs[4]), Integer.parseInt(strs[5]));
                if (strs.length > 6) {
                    cal.set(14, Integer.parseInt(strs[6]));
                }
                var = new Variant(cal, 13);
            } else {
                var = "Boolean".equals(type) ? new Variant(str.equals("1") ? Boolean.TRUE : Boolean.FALSE, 8) : Variant.nullVariant;
            }
            cell.setValue(var);
        }
    }
}

