/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kml;

import com.kingdee.cosmic.ctrl.common.util.Password;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectCache;
import com.kingdee.cosmic.ctrl.extcommon.util.SOAUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import com.kingdee.cosmic.ctrl.kds.io.PrintHelper;
import com.kingdee.cosmic.ctrl.kds.io.kml.AbsElement;
import com.kingdee.cosmic.ctrl.kds.io.kml.BasicElement;
import com.kingdee.cosmic.ctrl.kds.io.kml.DefaultElement;
import com.kingdee.cosmic.ctrl.kds.io.kml.KmlToBook;
import com.kingdee.cosmic.ctrl.kds.io.kml.KmlUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Selection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetOption;
import com.kingdee.cosmic.ctrl.kds.model.struct.ViewSplitInfo;
import com.kingdee.cosmic.ctrl.print.printjob.table.PlugablePaginationAdvice;
import com.kingdee.cosmic.ctrl.print.printjob.table.SheetPlugablePaginationAdvice;
import java.util.ArrayList;
import javax.print.attribute.standard.OrientationRequested;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class SheetOptionElement
extends BasicElement {
    private AbsElement poe;
    private AbsElement pse;
    private AbsElement ese;
    private AbsElement panesE;
    private AbsElement tre;
    private AbsElement tce;
    private AbsElement tr2e;
    private AbsElement tc2e;
    private AbsElement she;
    private AbsElement sve;
    private AbsElement ape;
    private AbsElement _pagee;
    private AbsElement _printe;
    private AbsElement _hidee;
    private AbsElement _tabColorE;
    private AbsElement _scaleE;

    SheetOptionElement() {
    }

    private AbsElement getFitParser(String uri, String localName, String qName) {
        if ("Zoom".equals(KmlUtil.getLocalName(qName))) {
            if (this._scaleE == null) {
                this._scaleE = new SheetZoomElement();
            }
            return this._scaleE;
        }
        if ("TabColor".equals(KmlUtil.getLocalName(qName))) {
            if (this._tabColorE == null) {
                this._tabColorE = new TabColorElement();
            }
            return this._tabColorE;
        }
        if ("ProtectObjects".equals(KmlUtil.getLocalName(qName))) {
            if (this.poe == null) {
                this.poe = new ProtectObjectElement();
            }
            return this.poe;
        }
        if ("ProtectScenarios".equals(KmlUtil.getLocalName(qName))) {
            if (this.pse == null) {
                this.pse = new ProtectScenariosElement();
            }
            return this.pse;
        }
        if ("EnableSelection".equals(KmlUtil.getLocalName(qName))) {
            if (this.ese == null) {
                this.ese = new EnableSelectionElement();
            }
            return this.ese;
        }
        if ("Panes".equals(KmlUtil.getLocalName(qName))) {
            if (this.panesE == null) {
                this.panesE = new PanesElement();
            }
            return this.panesE;
        }
        if ("TopRowVisible".equals(KmlUtil.getLocalName(qName))) {
            if (this.tre == null) {
                this.tre = new TopRowElement();
            }
            return this.tre;
        }
        if ("TopRowBottomPane".equals(KmlUtil.getLocalName(qName))) {
            if (this.tr2e == null) {
                this.tr2e = new TopRow2Element();
            }
            return this.tr2e;
        }
        if ("LeftColumnVisible".equals(KmlUtil.getLocalName(qName))) {
            if (this.tce == null) {
                this.tce = new TopColElement();
            }
            return this.tce;
        }
        if ("LeftColumnRightPane".equals(KmlUtil.getLocalName(qName))) {
            if (this.tc2e == null) {
                this.tc2e = new TopCol2Element();
            }
            return this.tc2e;
        }
        if ("SplitHorizontal".equals(KmlUtil.getLocalName(qName))) {
            if (this.she == null) {
                this.she = new SplitHoriElement();
            }
            return this.she;
        }
        if ("SplitVertical".equals(KmlUtil.getLocalName(qName))) {
            if (this.sve == null) {
                this.sve = new SplitVertElement();
            }
            return this.sve;
        }
        if ("ActivePane".equals(KmlUtil.getLocalName(qName))) {
            if (this.ape == null) {
                this.ape = new ActivePaneElement();
            }
            return this.ape;
        }
        if ("PageSetup".equals(KmlUtil.getLocalName(qName))) {
            if (this._pagee == null) {
                this._pagee = new PageSetupElement();
            }
            return this._pagee;
        }
        if ("Print".equals(KmlUtil.getLocalName(qName))) {
            if (this._printe == null) {
                this._printe = new PrintElement();
            }
            return this._printe;
        }
        if ("Visible".equals(KmlUtil.getLocalName(qName))) {
            if (this._hidee == null) {
                this._hidee = new SheetHiddenElement();
            }
            return this._hidee;
        }
        return null;
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return "WorksheetOptions".equals(KmlUtil.getLocalName(qName));
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        Sheet sheet = dataCache.getCurSheet();
        ViewSplitInfo vs = sheet.getSheetOption().getViewSplitInfo();
        int opers = 0;
        if ("Selected".equals(KmlUtil.getLocalName(qName))) {
            sheet.getSheetOption().setSelected(true);
        } else if ("FreezePanes".equals(KmlUtil.getLocalName(qName))) {
            vs.setFreezed(true);
        } else if ("AllowDeleteCols".equals(KmlUtil.getLocalName(qName))) {
            opers += 256;
        } else if ("AllowDeleteRows".equals(KmlUtil.getLocalName(qName))) {
            opers += 512;
        } else if ("AllowFilter".equals(KmlUtil.getLocalName(qName))) {
            opers += 2048;
        } else if ("AllowFormatCells".equals(KmlUtil.getLocalName(qName))) {
            opers += 4;
        } else if ("AllowInsertCols".equals(KmlUtil.getLocalName(qName))) {
            opers += 32;
        } else if ("AllowInsertHyperlinks".equals(KmlUtil.getLocalName(qName))) {
            opers += 128;
        } else if ("AllowInsertRows".equals(KmlUtil.getLocalName(qName))) {
            opers += 64;
        } else if ("AllowSizeCols".equals(KmlUtil.getLocalName(qName))) {
            opers += 8;
        } else if ("AllowSizeRows".equals(KmlUtil.getLocalName(qName))) {
            opers += 16;
        } else if ("AllowSort".equals(KmlUtil.getLocalName(qName))) {
            opers += 1024;
        } else if ("AllowUsePivotTables".equals(KmlUtil.getLocalName(qName))) {
            opers += 4096;
        } else if ("AllowCommont".equals(KmlUtil.getLocalName(qName))) {
            opers += 32768;
        } else if ("Protection".equals(KmlUtil.getLocalName(qName))) {
            String pw = attributes.getValue("Password");
            if (!StringUtil.isEmptyString((String)pw)) {
                pw = KmlUtil.toBookString(pw);
                Protection pro = sheet.getSheetOption().getProtection(true);
                String _bookProFlag = attributes.getValue("BookProtectionFlag");
                if (StringUtil.isEmptyString((String)_bookProFlag)) {
                    pw = Password.base64ToMD5((String)pw);
                }
                pro.startWithEncryptedPassword(pw);
            }
        } else if ("EditBlocks".equals(KmlUtil.getLocalName(qName))) {
            Protection pro = sheet.getSheetOption().getProtection(true);
            Protection.EditableArea ea = pro.createEditableArea(KmlUtil.toBookString(attributes.getValue("Name")));
            String pw = attributes.getValue("Password");
            if (pw == null) {
                pw = "";
            }
            pw = KmlUtil.toBookString(pw);
            String _bookProFlag = attributes.getValue("BookProtectionFlag");
            if (StringUtil.isEmptyString((String)_bookProFlag)) {
                pw = Password.base64ToMD5((String)pw);
            }
            ea.setEncryptedPassword(pw);
            String str = attributes.getValue("RangeSelection");
            if (!StringUtil.isEmptyString((String)str)) {
                ea.addAll(SheetBaseMath.getSortedBlocks(sheet, str, true));
            }
            pro.addEditableArea(ea);
        } else if ("PageView".equals(KmlUtil.getLocalName(qName))) {
            int[] ce = KmlUtil.stringToIntArray(attributes.getValue("ColExtended"));
            int[] re = KmlUtil.stringToIntArray(attributes.getValue("RowExtended"));
            int[] cs = KmlUtil.stringToIntArray(attributes.getValue("ColShrinked"));
            int[] rs = KmlUtil.stringToIntArray(attributes.getValue("RowShrinked"));
            if (ce != null || re != null || cs != null || rs != null) {
                SheetPlugablePaginationAdvice advice = new SheetPlugablePaginationAdvice();
                if (ce != null) {
                    advice.setColExtendedBreaks(SOAUtil.ext2common(this.pack2SortedObjectArray(ce)));
                }
                if (re != null) {
                    advice.setRowExtendedBreaks(SOAUtil.ext2common(this.pack2SortedObjectArray(re)));
                }
                if (cs != null) {
                    advice.setColShrinkedBreaks(SOAUtil.ext2common(this.pack2SortedObjectArray(cs)));
                }
                if (rs != null) {
                    advice.setRowShrinkedBreaks(SOAUtil.ext2common(this.pack2SortedObjectArray(rs)));
                }
                sheet.setPlugablePaginationAdvice((PlugablePaginationAdvice)advice);
            }
        } else {
            AbsElement parser = this.getFitParser(uri, localName, qName);
            if (parser != null) {
                parserCache.push(parser);
                parser.startElement(uri, localName, qName, attributes, parserCache, dataCache, ktb);
            }
        }
        if (opers != 0) {
            sheet.getSheetOption().getProtection(true).appendOperation(opers);
        }
    }

    private SortedObjectArray pack2SortedObjectArray(int[] values) {
        SortedObjectArray soa = new SortedObjectArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            soa.insert(ObjectCache.getInteger(values[i]));
        }
        return soa;
    }

    static class PrintElement
    extends BasicElement {
        private AbsElement fitwe;
        private AbsElement fithe;
        private AbsElement cle;
        private AbsElement pee;
        private AbsElement psie;
        private AbsElement hre;
        private AbsElement vre;
        private AbsElement sce;

        PrintElement() {
        }

        private AbsElement getFitParser(String uri, String localName, String qName) {
            String name = KmlUtil.getLocalName(qName);
            if ("FitWidth".equals(name)) {
                if (this.fitwe == null) {
                    this.fitwe = new FitWidthElement();
                }
                return this.fitwe;
            }
            if ("FitHeight".equals(name)) {
                if (this.fithe == null) {
                    this.fithe = new FitHeightElement();
                }
                return this.fithe;
            }
            if ("CommentsLayout".equals(name)) {
                if (this.cle == null) {
                    this.cle = new CommentLayoutElement();
                }
                return this.cle;
            }
            if ("PrintErrors".equals(name)) {
                if (this.pee == null) {
                    this.pee = new PrintErrorsElement();
                }
                return this.pee;
            }
            if ("PaperSizeIndex".equals(name)) {
                if (this.psie == null) {
                    this.psie = new PaperSizeIndexElement();
                }
                return this.psie;
            }
            if ("HorizontalResolution".equals(name)) {
                if (this.hre == null) {
                    this.hre = new HoriResolutionElement();
                }
                return this.hre;
            }
            if ("VerticalResolution".equals(name)) {
                if (this.vre == null) {
                    this.vre = new VertResolutionElement();
                }
                return this.vre;
            }
            if ("Scale".equals(name)) {
                if (this.sce == null) {
                    this.sce = new ScaleElement();
                }
                return this.sce;
            }
            return null;
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Print".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            PrintSetup ps = dataCache.getCurSheet().getSheetOption().getPrintSetup(true);
            String name = KmlUtil.getLocalName(qName);
            if ("LeftToRight".equals(name)) {
                ps.setRowFirst(true);
            } else if ("BlackAndWhite".equals(name)) {
                ps.setBlackWhite(true);
            } else if (!"DraftQuality".equals(name)) {
                if ("Gridlines".equals(name)) {
                    ps.setHasGrid(true);
                } else if ("RowColHeadings".equals(name)) {
                    ps.setHasColHead(!"False".equalsIgnoreCase(attributes.getValue("ColHead")));
                    ps.setHasRowHead(!"False".equalsIgnoreCase(attributes.getValue("RowHead")));
                } else {
                    AbsElement element = this.getFitParser(uri, localName, qName);
                    if (element != null) {
                        parserCache.push(element);
                        element.startElement(uri, localName, qName, attributes, parserCache, dataCache, ktb);
                    }
                }
            }
        }

        static class VertResolutionElement
        extends DefaultElement {
            VertResolutionElement() {
            }

            @Override
            void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            }
        }

        static class HoriResolutionElement
        extends DefaultElement {
            HoriResolutionElement() {
            }

            @Override
            void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            }
        }

        static class ScaleElement
        extends DefaultElement {
            ScaleElement() {
            }

            @Override
            void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
                PrintSetup ps = dataCache.getCurSheet().getSheetOption().getPrintSetup(true);
                String autoFit = attributes.getValue("AutoFit");
                if ("true".equals(autoFit)) {
                    String width;
                    ps.setAutoFit(true);
                    String height = attributes.getValue("Height");
                    if (!StringUtil.isEmptyString((String)height)) {
                        try {
                            ps.setAutoFitHeight(Integer.parseInt(height));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!StringUtil.isEmptyString((String)(width = attributes.getValue("Width")))) {
                        try {
                            ps.setAutoFitWidth(Integer.parseInt(width));
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    ps.setAutoFit(false);
                }
            }

            @Override
            void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
                PrintSetup ps = dataCache.getCurSheet().getSheetOption().getPrintSetup(true);
                String str = new String(ch, start, length);
                ps.setScale(Integer.parseInt(str));
            }
        }

        static class PaperSizeIndexElement
        extends DefaultElement {
            PaperSizeIndexElement() {
            }

            @Override
            void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
                String py;
                PrintSetup ps = dataCache.getCurSheet().getSheetOption().getPrintSetup(true);
                String px = attributes.getValue("x");
                if (!StringUtil.isEmptyString((String)px)) {
                    ps.setPagesizeX(Float.parseFloat(px));
                }
                if (!StringUtil.isEmptyString((String)(py = attributes.getValue("y")))) {
                    ps.setPagesizeY(Float.parseFloat(py));
                }
            }

            @Override
            void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
                PrintSetup ps = dataCache.getCurSheet().getSheetOption().getPrintSetup(true);
                String str = new String(ch, start, length);
                ps.setPagesizeIndex(Integer.parseInt(str));
            }
        }

        static class PrintErrorsElement
        extends DefaultElement {
            PrintErrorsElement() {
            }

            @Override
            void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            }
        }

        static class CommentLayoutElement
        extends DefaultElement {
            CommentLayoutElement() {
            }

            @Override
            void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            }
        }

        static class FitHeightElement
        extends DefaultElement {
            FitHeightElement() {
            }

            @Override
            void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            }
        }

        static class FitWidthElement
        extends DefaultElement {
            FitWidthElement() {
            }

            @Override
            void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            }
        }
    }

    static class PageSetupElement
    extends BasicElement {
        PageSetupElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "PageSetup".equals(KmlUtil.getLocalName(qName));
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            PrintSetup ps = dataCache.getCurSheet().getSheetOption().getPrintSetup(true);
            if ("Layout".equals(KmlUtil.getLocalName(qName))) {
                String cv;
                String ori = attributes.getValue(KmlUtil.getNSName("Orientation", "x"));
                ps.setLandScape(OrientationRequested.LANDSCAPE.toString().equalsIgnoreCase(ori));
                String ch = attributes.getValue(KmlUtil.getNSName("CenterHorizontal", "x"));
                if (!StringUtil.isEmptyString((String)ch) && ch.equals("1")) {
                    ps.setCenterHorizontal(1);
                }
                if (!StringUtil.isEmptyString((String)(cv = attributes.getValue(KmlUtil.getNSName("CenterVertical", "x")))) && cv.equals("1")) {
                    ps.setCenterVertical(1);
                }
            } else if ("Header".equals(KmlUtil.getLocalName(qName))) {
                String data;
                String mar = attributes.getValue(KmlUtil.getNSName("Margin", "x"));
                if (!StringUtil.isEmptyString((String)mar)) {
                    ps.setHeadMargin(Float.parseFloat(mar));
                }
                if (!StringUtil.isEmptyString((String)(data = attributes.getValue(KmlUtil.getNSName("Data", "x"))))) {
                    ps.setHeadData(PrintHelper.genHeaderFootList(KmlUtil.toBookString(data), dataCache.getStyles(), false));
                }
            } else if ("Footer".equals(KmlUtil.getLocalName(qName))) {
                String data;
                String mar;
                String headAlign;
                String footAlign = attributes.getValue(KmlUtil.getNSName("Align", "x"));
                if (!StringUtil.isEmptyString((String)footAlign)) {
                    ps.setFootAlign(Integer.parseInt(footAlign));
                }
                if (!StringUtil.isEmptyString((String)(headAlign = attributes.getValue(KmlUtil.getNSName("Align2", "x"))))) {
                    ps.setHeadAlign(Integer.parseInt(headAlign));
                }
                if (!StringUtil.isEmptyString((String)(mar = attributes.getValue(KmlUtil.getNSName("Margin", "x"))))) {
                    ps.setFootMargin(Float.parseFloat(mar));
                }
                if (!StringUtil.isEmptyString((String)(data = attributes.getValue(KmlUtil.getNSName("Data", "x"))))) {
                    ps.setFootData(PrintHelper.genHeaderFootList(KmlUtil.toBookString(data), dataCache.getStyles(), false));
                }
            } else if ("PageMargins".equals(KmlUtil.getLocalName(qName))) {
                String mar = attributes.getValue(KmlUtil.getNSName("Bottom", "x"));
                if (!StringUtil.isEmptyString((String)mar)) {
                    ps.setBottomMargin(Float.parseFloat(mar));
                }
                if (!StringUtil.isEmptyString((String)(mar = attributes.getValue(KmlUtil.getNSName("Left", "x"))))) {
                    ps.setLeftMargin(Float.parseFloat(mar));
                }
                if (!StringUtil.isEmptyString((String)(mar = attributes.getValue(KmlUtil.getNSName("Right", "x"))))) {
                    ps.setRightMargin(Float.parseFloat(mar));
                }
                if (!StringUtil.isEmptyString((String)(mar = attributes.getValue(KmlUtil.getNSName("Top", "x"))))) {
                    ps.setTopMargin(Float.parseFloat(mar));
                }
            }
        }
    }

    static class PanesElement
    extends BasicElement {
        private ActiveColElement ace = new ActiveColElement();
        private ActiveRowElement are = new ActiveRowElement();
        private RangeSelectionElement rse = new RangeSelectionElement();
        private boolean hasRangeSel = false;

        PanesElement() {
        }

        @Override
        boolean isCurrentElement(String uri, String localName, String qName) {
            return "Panes".equals(KmlUtil.getLocalName(qName));
        }

        private AbsElement getFitParser(String uri, String localName, String qName) {
            this.hasRangeSel = false;
            if ("ActiveRow".equals(KmlUtil.getLocalName(qName))) {
                return this.are;
            }
            if ("ActiveCol".equals(KmlUtil.getLocalName(qName))) {
                return this.ace;
            }
            if ("RangeSelection".equals(KmlUtil.getLocalName(qName))) {
                this.hasRangeSel = true;
                return this.rse;
            }
            return null;
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            AbsElement element = this.getFitParser(uri, localName, qName);
            if (element != null) {
                parserCache.push(element);
                element.startElement(uri, localName, qName, attributes, parserCache, dataCache, ktb);
            }
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName) && !this.hasRangeSel) {
                Sheet sheet = dataCache.getCurSheet();
                Selection sel = sheet.getSheetOption().getSelection();
                int row = sel.getActiveRow();
                int col = sel.getActiveCol();
                ArrayList<CellBlock> al = new ArrayList<CellBlock>();
                al.add(CellBlock.getCellBlock(row, col));
                sel.setData(al, 0, row, row);
            }
        }

        static class RangeSelectionElement
        extends DefaultElement {
            RangeSelectionElement() {
            }

            @Override
            void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
                this.bufString.append(ch, start, length);
            }

            @Override
            void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
                this.bufString.delete(0, this.bufString.length());
            }

            @Override
            void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
                super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
                if (this.isCurrentElement(uri, localName, qName)) {
                    Sheet sheet = dataCache.getCurSheet();
                    Selection sel = sheet.getSheetOption().getSelection();
                    int row = sel.getActiveRow();
                    int col = sel.getActiveCol();
                    String str = this.bufString.toString();
                    ArrayList<CellBlock> al = SheetBaseMath.getListBlocks(sheet, str, false);
                    if (al != null) {
                        sel.setData(al, 0, row, col);
                    } else {
                        al = new ArrayList<CellBlock>();
                        al.add(CellBlock.getCellBlock(row, col));
                        sel.setData(al, 0, row, row);
                    }
                }
            }
        }

        static class ActiveColElement
        extends DefaultElement {
            ActiveColElement() {
            }

            @Override
            void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
                String str = new String(ch, start, length);
                Selection selection = dataCache.getCurSheet().getSheetOption().getSelection();
                selection.setActiveCell(selection.getActiveRow(), Integer.parseInt(str));
            }
        }

        static class ActiveRowElement
        extends DefaultElement {
            ActiveRowElement() {
            }

            @Override
            void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
                String str = new String(ch, start, length);
                Selection sel = dataCache.getCurSheet().getSheetOption().getSelection();
                sel.setActiveCell(Integer.parseInt(str), sel.getActiveCol());
            }
        }
    }

    static class EnableSelectionElement
    extends DefaultElement {
        EnableSelectionElement() {
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            String str = new String(ch, start, length);
            if ("NoSelection".equals(str)) {
                Protection protection = dataCache.getCurSheet().getSheetOption().getProtection(true);
                protection.deleteOperation(1);
                protection.deleteOperation(2);
            } else if ("UnlockedCells".equals(str)) {
                Protection protection = dataCache.getCurSheet().getSheetOption().getProtection(true);
                protection.deleteOperation(1);
            }
        }
    }

    static class SplitVertElement
    extends DefaultElement {
        SplitVertElement() {
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (length > 0) {
                ViewSplitInfo vs = dataCache.getCurSheet().getSheetOption().getViewSplitInfo();
                String str = new String(ch, start, length);
                int v = Integer.parseInt(str);
                int nv = KmlUtil.toScreenVertSplit(v);
                vs.setColSplit(nv <= 0 || vs.isFreezed() ? v : nv);
            }
        }
    }

    static class SplitHoriElement
    extends DefaultElement {
        SplitHoriElement() {
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (length > 0) {
                ViewSplitInfo vs = dataCache.getCurSheet().getSheetOption().getViewSplitInfo();
                String str = new String(ch, start, length);
                int v = Integer.parseInt(str);
                int nv = KmlUtil.toScreenHoriSplit(v);
                vs.setRowSplit(nv <= 0 || vs.isFreezed() ? v : nv);
            }
        }
    }

    static class TopCol2Element
    extends DefaultElement {
        TopCol2Element() {
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (length > 0) {
                ViewSplitInfo vs = dataCache.getCurSheet().getSheetOption().getViewSplitInfo();
                String str = new String(ch, start, length);
                int v = Integer.parseInt(str);
                vs.setFirstCol2(v);
            }
        }
    }

    static class TopRow2Element
    extends DefaultElement {
        TopRow2Element() {
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (length > 0) {
                ViewSplitInfo vs = dataCache.getCurSheet().getSheetOption().getViewSplitInfo();
                String str = new String(ch, start, length);
                int v = Integer.parseInt(str);
                vs.setFirstRow2(v);
            }
        }
    }

    static class TopColElement
    extends DefaultElement {
        TopColElement() {
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (length > 0) {
                ViewSplitInfo vs = dataCache.getCurSheet().getSheetOption().getViewSplitInfo();
                String str = new String(ch, start, length);
                int v = Integer.parseInt(str);
                vs.setFirstCol(v);
            }
        }
    }

    static class TopRowElement
    extends DefaultElement {
        TopRowElement() {
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (length > 0) {
                ViewSplitInfo vs = dataCache.getCurSheet().getSheetOption().getViewSplitInfo();
                String str = new String(ch, start, length);
                int v = Integer.parseInt(str);
                vs.setFirstRow(v);
            }
        }
    }

    static class ActivePaneElement
    extends DefaultElement {
        ActivePaneElement() {
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (length > 0) {
                ViewSplitInfo vs = dataCache.getCurSheet().getSheetOption().getViewSplitInfo();
                String str = new String(ch, start, length);
                int v = Integer.parseInt(str);
                vs.setActivePane(v);
            }
        }
    }

    static class ProtectScenariosElement
    extends DefaultElement {
        ProtectScenariosElement() {
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            Protection pro;
            String str = new String(ch, start, length);
            if ("False".equals(str) && (pro = dataCache.getCurSheet().getSheetOption().getProtection(false)) != null && pro.isProtected()) {
                pro.appendOperation(16384);
            }
        }
    }

    static class ProtectObjectElement
    extends DefaultElement {
        ProtectObjectElement() {
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            Protection pro;
            String str = new String(ch, start, length);
            if ("False".equals(str) && (pro = dataCache.getCurSheet().getSheetOption().getProtection(false)) != null && pro.isProtected()) {
                pro.appendOperation(8192);
            }
        }
    }

    static class SheetHiddenElement
    extends DefaultElement {
        SheetHiddenElement() {
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                SheetOption so = dataCache.getCurSheet().getSheetOption();
                so.setHide("SheetHidden".equals(this.bufString.toString()));
            }
        }
    }

    static class SheetZoomElement
    extends DefaultElement {
        SheetZoomElement() {
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                SheetOption so = dataCache.getCurSheet().getSheetOption();
                so.setScale(Integer.parseInt(this.bufString.toString()));
            }
        }
    }

    static class TabColorElement
    extends DefaultElement {
        TabColorElement() {
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (this.isCurrentElement(uri, localName, qName)) {
                this.bufString.delete(0, this.bufString.length());
            }
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.append(ch, start, length);
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                SheetOption so = dataCache.getCurSheet().getSheetOption();
                so.setTabColor(StyleParser.hexToColor((String)this.bufString.toString()));
            }
        }
    }
}

