/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kml;

import com.kingdee.cosmic.ctrl.kds.io.kml.BasicElement;
import com.kingdee.cosmic.ctrl.kds.io.kml.KmlToBook;
import com.kingdee.cosmic.ctrl.kds.io.kml.KmlUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Column;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class UserObjectElement
extends BasicElement {
    UserObjectElement() {
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return true;
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        String key = attributes.getValue("Key");
        if (key != null) {
            key = KmlUtil.toBookString(key);
        }
        dataCache.setCurUserObjectKey(key);
        this.bufString.delete(0, this.bufString.length());
    }

    @Override
    void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        if (ktb.touchModeFlag(FLAG_CELL_USEROBJECT)) {
            this.bufString.append(ch, start, length);
        }
    }

    @Override
    void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
        if (this.isCurrentElement(uri, localName, qName)) {
            Object parent = dataCache.getCurUOParent();
            if (parent == null) {
                return;
            }
            if (parent instanceof Cell ? !ktb.touchModeFlag(FLAG_CELL_USEROBJECT) : (parent instanceof Row ? !ktb.touchModeFlag(FLAG_ROW_USEROBJECT) : (parent instanceof Sheet ? !ktb.touchModeFlag(FLAG_SHEET_USEROBJECT) : (parent instanceof Book ? !ktb.touchModeFlag(FLAG_BOOK_USEROBJECT) : parent instanceof Column && !ktb.touchModeFlag(FLAG_COL_USEROBJECT))))) {
                return;
            }
            String key = dataCache.getCurUserObjectKey();
            String str = KmlUtil.toBookString(this.bufString.toString());
            Object uoValue = ktb.getKmlUOTrans() != null ? ktb.getKmlUOTrans().getObject(key, str) : str;
            if (parent instanceof Cell) {
                ((Cell)parent).setUserObject(key, uoValue);
            } else if (parent instanceof Row) {
                ((Row)parent).setUserObject(key, uoValue);
            } else if (parent instanceof Column) {
                ((Column)parent).setUserObject(key, uoValue);
            } else if (parent instanceof Sheet) {
                ((Sheet)parent).setUserObject(key, uoValue);
            } else if (parent instanceof Book) {
                ((Book)parent).setUserObject(key, uoValue);
            }
        }
    }
}

