/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.util;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.util.render.CellBackgroundRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.ISplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.SplitRectTextRender;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class DiagonalHeaderImageUtil {
    private static final Logger logger = LogUtil.getPackageLogger(DiagonalHeaderImageUtil.class);

    public static KDSBook.KDSImage translate(Cell cell) {
        int bottom;
        int top;
        int right;
        int left;
        boolean isMerged;
        Sheet sheet = cell.getSheet();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        BufferedImage bufferedImg = DiagonalHeaderImageUtil.generateImageForDiagonalHeader(sheet, (ISplitRectInfo)cell.getDiagonalHeader(), cell);
        try {
            ImageIO.write((RenderedImage)bufferedImg, "png", bytes);
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        KDSBook.KDSImage image = new KDSBook.KDSImage(bytes.toByteArray(), 6);
        CellBlock mergeBlock = cell.getMerge(false);
        boolean bl = isMerged = mergeBlock != null;
        if (isMerged) {
            left = mergeBlock.getCol();
            right = mergeBlock.getCol2() + 1;
            top = mergeBlock.getRow();
            bottom = mergeBlock.getRow2() + 1;
        } else {
            left = cell.getCol();
            right = left + 1;
            top = cell.getRow();
            bottom = top + 1;
        }
        image.setLeft(left);
        image.setRight(right);
        image.setTop(top);
        image.setBottom(bottom);
        if (bufferedImg != null) {
            image.setWidth(bufferedImg.getWidth());
            image.setHeight(bufferedImg.getHeight());
        }
        image.setSheetName(sheet.getSheetName());
        return image;
    }

    public static boolean isValidSplitRectInfo(ISplitRectInfo o, Cell cell) {
        Sheet sheet = cell.getSheet();
        int row = cell.getRow();
        int col = cell.getCol();
        CellBlock mergeBlock = cell.getMerge(true);
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int width = DiagonalHeaderImageUtil.getCellWidthOrHeight(sheet, colSpans, true, col, mergeBlock);
        int height = DiagonalHeaderImageUtil.getCellWidthOrHeight(sheet, rowSpans, false, row, mergeBlock);
        return width > 0 && height > 0;
    }

    private static BufferedImage generateImageForDiagonalHeader(Sheet sheet, ISplitRectInfo o, Cell cell) {
        if (cell == null || o == null) {
            return null;
        }
        int row = cell.getRow();
        int col = cell.getCol();
        int height = 0;
        int width = 0;
        CellBlock mergeBlock = cell.getMerge(true);
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        width = DiagonalHeaderImageUtil.getCellWidthOrHeight(sheet, colSpans, true, col, mergeBlock);
        height = DiagonalHeaderImageUtil.getCellWidthOrHeight(sheet, rowSpans, false, row, mergeBlock);
        BufferedImage image = new BufferedImage(width, height, 2);
        SplitRectTextRender render = new SplitRectTextRender();
        CellBackgroundRender backgroundRender = new CellBackgroundRender();
        Rectangle cellShape = new Rectangle(width, height);
        backgroundRender.draw(image.getGraphics(), (Shape)cellShape, (Object)cell, cell.getStyle());
        render.draw(image.getGraphics(), (Shape)cellShape, (Object)o, cell.getStyle());
        return image;
    }

    private static int getCellWidthOrHeight(Sheet sheet, SortedAttributeSpanArray spans, boolean gettingWidth, int pos, CellBlock mergedBlock) {
        int length = 0;
        int defaultLength = 0;
        defaultLength = gettingWidth ? sheet.getOriginalDefColWidth() : sheet.getOriginalDefRowHeight();
        if (mergedBlock != null) {
            length = DiagonalHeaderImageUtil.getMergedBlockWidthOrHeight(sheet, spans, mergedBlock, gettingWidth);
            return length;
        }
        if (spans == null || spans.size() == 0) {
            length = defaultLength;
        } else {
            int index = spans.searchSpan(pos);
            if (index < 0) {
                length = defaultLength;
            } else {
                SortedAttributeSpanArray.AttributeSpan span = spans.getAttributeSpan(index);
                length = span.getLength();
            }
        }
        return length;
    }

    private static int getMergedBlockWidthOrHeight(Sheet sheet, SortedAttributeSpanArray spans, CellBlock mergedBlock, boolean gettingWidth) {
        if (sheet == null) {
            return -1;
        }
        int row = mergedBlock.getRow();
        int row2 = mergedBlock.getRow2();
        int col = mergedBlock.getCol();
        int col2 = mergedBlock.getCol2();
        int length = 0;
        if (gettingWidth) {
            for (int i = col; i <= col2; ++i) {
                length += DiagonalHeaderImageUtil.getCellWidthOrHeight(sheet, spans, gettingWidth, i, null);
            }
        } else {
            for (int r = row; r <= row2; ++r) {
                length += DiagonalHeaderImageUtil.getCellWidthOrHeight(sheet, spans, gettingWidth, r, null);
            }
        }
        return length;
    }

    public static Image createScreenShoot(Point p1, Point p2) {
        return DiagonalHeaderImageUtil.createScreenShoot((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
    }

    public static Image createScreenShoot(int x1, int y1, int x2, int y2) {
        try {
            Robot robot = new Robot();
            Rectangle area = new Rectangle(x1, y1, x2 - x1, y2 - y1);
            System.out.println(area);
            return robot.createScreenCapture(area);
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
            return null;
        }
    }
}

