/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.expr;

import com.kingdee.cosmic.ctrl.common.KDToolkit;
import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.immit.IRptRuntimeCallback;
import com.kingdee.cosmic.ctrl.extcommon.util.DateUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectCache;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.ExprErr;
import com.kingdee.cosmic.ctrl.extcommon.variant.IVarReferences;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Util;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.BinaryTree;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SBTree;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.DataConvert;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtGroup;
import com.kingdee.cosmic.ctrl.kds.model.expr.CellIteratorWrap;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprConst;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.Holidays;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprBuffer;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.expr.IInnerFuncProvider;
import com.kingdee.cosmic.ctrl.kds.model.expr.TraceVariant;
import com.kingdee.cosmic.ctrl.kds.model.expr.WorkCalendar;
import com.kingdee.cosmic.ctrl.kds.model.expr.WorkDays;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlock3DNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedIntArray;
import com.kingdee.cosmic.ctrl.kds.model.util.TimeSpan;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ExcelFuncProvider
implements IInnerFuncProvider {
    private static final Logger logger = LogUtil.getPackageLogger(ExcelFuncProvider.class);
    private static final Random _rand = new SecureRandom();
    private static final long _oneHour = 3600000L;
    private static final long _oneDay = 86400000L;
    private static final Calendar _calInst;
    private static MathContext _Decimal15;
    private static final int Sum = 0;
    private static final int Count = 1;
    private static final int Max = 2;
    private static final int Min = 3;
    private static final int Product = 4;
    private static final int Stdev = 5;
    private static final int Stats = 6;

    public Variant ISBLANK(Variant arg) {
        return new Variant((arg = arg.getVariant()).isNull() || arg.isEmpty());
    }

    public Variant ISERROR(Variant arg) {
        arg = arg.getVariant();
        return new Variant(arg.isError());
    }

    public Variant ERROR(int errCode, Object extData) {
        return new Variant(new SyntaxErrorException(errCode, extData), 16);
    }

    public Variant INDIRECT(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Object param = ((TraceVariant)args[0]).getValue();
        Variant ret = null;
        ICalculable owner = ctx.getExprOwner();
        if (param instanceof CellBlockNode) {
            CellBlockNode cbn = (CellBlockNode)param;
            Cell cll = cbn.getSheet().getCell(cbn.getRow(), cbn.getCol(), false);
            ret = owner.getSheet().getExpr(owner, cll.getValue().toString()).execute(ctx, owner);
        } else if (param instanceof String) {
            ret = owner.getSheet().getExpr(owner, (String)param).execute(ctx, owner);
        }
        if (ret != null && (ret.isPending() || ret.isCalcLast())) {
            throw SyntaxErrorException.CALC_LAST;
        }
        return ret;
    }

    public Variant ISERR(Variant arg) {
        if ((arg = arg.getVariant()).isError()) {
            return new Variant(((SyntaxErrorException)arg.getValue()).getErrorCode() != 524288L);
        }
        return new Variant(false);
    }

    public Variant ISNA(Variant arg) {
        if ((arg = arg.getVariant()).isError()) {
            return new Variant(((SyntaxErrorException)arg.getValue()).getErrorCode() == 524288L);
        }
        return new Variant(false);
    }

    public Variant ISLOGICAL(Variant arg) {
        return new Variant((arg = arg.getVariant()).getVt() == 8);
    }

    public Variant ISNUMBER(Variant arg) {
        arg = arg.getVariant();
        return new Variant(arg.isNumber());
    }

    public Variant ISNONTEXT(Variant arg) {
        return new Variant((arg = arg.getVariant()).getVt() != 11);
    }

    public Variant ISTEXT(Variant arg) {
        return new Variant((arg = arg.getVariant()).getVt() == 11);
    }

    public Variant ISREF(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        return new Variant(((Variant)args[0]).isReferences());
    }

    public Variant OR(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, Integer.MAX_VALUE);
        Variant varResult = new Variant(false);
        for (int i = 0; i < args.length; ++i) {
            Variant value = Expr.execute(ctx, (Variant)args[i]);
            if (!value.booleanValue()) continue;
            varResult.setBoolean(true);
            break;
        }
        return varResult;
    }

    public Variant AND(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, Integer.MAX_VALUE);
        Variant varResult = new Variant(true);
        for (int i = 0; i < args.length; ++i) {
            Variant value = Expr.execute(ctx, (Variant)args[i]);
            if (value.booleanValue()) continue;
            varResult.setBoolean(false);
            break;
        }
        return varResult;
    }

    public Variant NOT(Variant arg) throws SyntaxErrorException {
        return new Variant(!arg.booleanValue());
    }

    public Variant TRUE() throws SyntaxErrorException {
        return new Variant(true);
    }

    public Variant FALSE() throws SyntaxErrorException {
        return new Variant(false);
    }

    public Variant IF(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant varResult;
        ExcelFuncProvider.validParamCount(args, 2, 3);
        try {
            Variant bool = Expr.execute(ctx, (Variant)args[0]);
            if (bool.isPending()) {
                return bool;
            }
            boolean isTrue = bool.booleanValue();
            varResult = isTrue ? Expr.execute(ctx, (Variant)args[1]) : (args.length == 3 ? Expr.execute(ctx, (Variant)args[2]) : Variant.nullVariant);
        }
        catch (SyntaxErrorException e) {
            varResult = new Variant(e, 16);
        }
        return varResult;
    }

    private Variant _destDay(Object[] args, boolean bFirst) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Calendar cal = (Calendar)ExcelFuncProvider.timeGet((Variant)args[0]).clone();
        ExcelFuncProvider.justDay(cal);
        int type = 0;
        if (args.length == 2) {
            Variant var = (Variant)args[1];
            ExcelFuncProvider.validNumericParam("Type", var);
            type = var.intValue();
        }
        switch (type) {
            case 1: {
                if (bFirst) {
                    cal.set(5, 1);
                    break;
                }
                cal.set(5, cal.getActualMaximum(5));
                break;
            }
            case 2: {
                if (bFirst) {
                    cal.set(7, 1);
                    break;
                }
                cal.set(7, 7);
                break;
            }
            default: {
                if (bFirst) {
                    cal.set(6, 1);
                    break;
                }
                cal.set(6, cal.getActualMaximum(6));
            }
        }
        return new Variant(cal, 13);
    }

    public Variant FIRSTDAY(Object[] args) throws SyntaxErrorException {
        return this._destDay(args, true);
    }

    public Variant LASTDAY(Object[] args) throws SyntaxErrorException {
        return this._destDay(args, false);
    }

    public Variant MONTHDAYS(Variant time) throws SyntaxErrorException {
        Calendar cal = ExcelFuncProvider.timeGet(time);
        int days = cal.getActualMaximum(5);
        return new Variant(ObjectCache.getInteger(days), 3);
    }

    public Variant NEXTDAY(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 4);
        Calendar cal = (Calendar)ExcelFuncProvider.timeGet((Variant)args[0]).clone();
        ExcelFuncProvider.justDay(cal);
        int argCount = args.length;
        if (argCount > 1) {
            Variant var = (Variant)args[1];
            ExcelFuncProvider.validNumericParam("Day", var);
            double days = var.doubleValue();
            if (!ArrayUtil.isEqual((Double)days, (Double)0.0)) {
                cal.setTimeInMillis(cal.getTimeInMillis() + (long)(days * 8.64E7));
            }
            if (argCount > 2) {
                var = (Variant)args[2];
                ExcelFuncProvider.validNumericParam("Month", var);
                int month = var.intValue();
                if (month != 0) {
                    cal.add(2, month);
                }
                if (argCount > 3) {
                    var = (Variant)args[3];
                    ExcelFuncProvider.validNumericParam("Year", var);
                    int year = var.intValue();
                    if (year != 0) {
                        cal.add(1, year);
                    }
                }
            }
        } else {
            cal.add(6, 1);
        }
        return new Variant(cal, 13);
    }

    public Variant WORKTIME(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant varRet;
        long lUnit;
        long maxDayTime;
        boolean anyWorkTime;
        boolean workInHoliday;
        Variant to;
        Variant from;
        int arraySize;
        Sheet sheet;
        block24: {
            Variant varOutType;
            block25: {
                block26: {
                    double df;
                    block28: {
                        block27: {
                            double d;
                            ExcelFuncProvider.validParamCount(args, 2, 6);
                            sheet = ctx.getExprOwner().getSheet();
                            if (sheet == null) {
                                throw new SyntaxErrorException(2048L, "in Sheet");
                            }
                            arraySize = -1;
                            from = (Variant)args[0];
                            to = (Variant)args[1];
                            if (from.isArray()) {
                                arraySize = ((Variant[])from.getValue()).length;
                            } else if (to.isArray()) {
                                arraySize = ((Variant[])to.getValue()).length;
                            }
                            workInHoliday = false;
                            anyWorkTime = false;
                            lUnit = maxDayTime = 28800000L;
                            if (args.length <= 2) break block24;
                            varOutType = (Variant)args[2];
                            if (args.length <= 3) break block25;
                            Variant var = (Variant)args[3];
                            if (var.isNull()) break block26;
                            df = 0.0;
                            Variant varTmp = Variant.getNewEmptyVariant();
                            if (!var.isNumeric(varTmp)) break block27;
                            df = varTmp.doubleValue();
                            if (!(d > 24.0)) break block28;
                        }
                        ExprErr.goError(16L, "Max DayTime");
                    }
                    maxDayTime = (long)(df * 3600000.0);
                }
                if (args.length > 4) {
                    workInHoliday = ((Variant)args[4]).booleanValue();
                    if (args.length > 5) {
                        anyWorkTime = ((Variant)args[5]).booleanValue();
                    }
                }
            }
            if (!varOutType.isNull()) {
                String strUnit = varOutType.toString();
                if ("d".compareToIgnoreCase(strUnit) == 0) {
                    lUnit = maxDayTime;
                } else if ("h".compareToIgnoreCase(strUnit) == 0) {
                    lUnit = 3600000L;
                } else {
                    ExprErr.goError(16L, "Out Type");
                }
            }
        }
        BigDecimal outUnit = new BigDecimal(lUnit);
        WorkDays workDay = null;
        Holidays holiday = null;
        Calendar[] workTime = null;
        WorkCalendar wcal = sheet.getWorkCalendar();
        if (!workInHoliday) {
            workDay = wcal.getWorkDay();
            holiday = wcal.getHoliday();
        }
        if (!anyWorkTime) {
            workTime = wcal.getWorkTime();
        }
        if (arraySize > 0) {
            Object[] froms = null;
            Object[] tos = null;
            if (from.isArray()) {
                froms = (Variant[])from.getValue();
            } else {
                froms = new Variant[arraySize];
                Arrays.fill(froms, from);
            }
            if (to.isArray()) {
                tos = (Variant[])to.getValue();
            } else {
                tos = new Variant[arraySize];
                Arrays.fill(tos, to);
            }
            if (froms.length != tos.length) {
                ExprErr.goError(16L, "Array Not Match");
            }
            for (int i = 0; i < froms.length; ++i) {
                froms[i] = this._timeDif(ctx, (Variant)froms[i], (Variant)tos[i], workDay, workTime, holiday, maxDayTime, outUnit);
            }
            varRet = from;
        } else {
            varRet = this._timeDif(ctx, from, to, workDay, workTime, holiday, maxDayTime, outUnit);
        }
        return varRet;
    }

    private Variant _timeDif(ExprContext ctx, Variant varFrom, Variant varTo, WorkDays workDay, Calendar[] workTime, Holidays holiday, long maxDayTime, BigDecimal outUnit) throws SyntaxErrorException {
        long timeDif;
        Calendar timeFrom = varFrom.toCalendar();
        Calendar timeTo = varTo.toCalendar();
        long lFrom = timeFrom.getTimeInMillis();
        long lTo = timeTo.getTimeInMillis();
        if (lTo % 86400000L == 0L) {
            lTo += 86400000L;
        }
        if ((timeDif = lTo - lFrom) <= 0L) {
            return Variant.zeroVariant;
        }
        long[] days = ctx.getSepDays();
        days[0] = days[1] = lFrom;
        Calendar tmp = (Calendar)timeFrom.clone();
        tmp.setTimeInMillis(lFrom + 86400000L - lFrom % 86400000L);
        long fromTop = tmp.getTimeInMillis();
        long prev = fromTop - lFrom;
        if (!(holiday != null && holiday.isHoliday(timeFrom) || workDay != null && !workDay.isWorkDay(timeFrom))) {
            days[1] = Math.min(lTo, fromTop);
        }
        days[4] = days[5] = lTo;
        long remainder = lTo % 86400000L;
        if (remainder == 0L) {
            remainder = 86400000L;
        }
        tmp.setTimeInMillis(lTo - remainder);
        long toBottom = tmp.getTimeInMillis();
        long later = lTo - toBottom;
        if (!(holiday != null && holiday.isHoliday(timeTo) || workDay != null && !workDay.isWorkDay(timeTo))) {
            days[4] = Math.max(lFrom, toBottom);
            if (days[4] == days[0]) {
                days[4] = lTo + 1L;
            }
        }
        days[2] = fromTop;
        if (timeDif - prev - later > 0L) {
            days[3] = toBottom;
            if (workDay != null || holiday != null) {
                tmp.setTimeInMillis(fromTop);
                int y1 = tmp.get(1);
                tmp.setTimeInMillis(toBottom);
                int y2 = tmp.get(1);
                if (y1 == y2) {
                    toBottom -= this._timeNotWork(tmp, fromTop, toBottom, workDay, holiday);
                } else {
                    long timeNotWork = 0L;
                    for (int y = y1 + 1; y < y2; ++y) {
                        tmp.set(y, 0, 1);
                        long d1 = tmp.getTimeInMillis();
                        tmp.set(y + 1, 0, 1);
                        timeNotWork += this._timeNotWork(tmp, d1, tmp.getTimeInMillis(), workDay, holiday);
                    }
                    tmp.set(y1 + 1, 0, 1);
                    timeNotWork += this._timeNotWork(tmp, fromTop, tmp.getTimeInMillis(), workDay, holiday);
                    tmp.set(y2, 0, 1);
                    timeNotWork += this._timeNotWork(tmp, tmp.getTimeInMillis(), toBottom, workDay, holiday);
                    toBottom -= timeNotWork;
                }
                days[3] = toBottom;
            }
        } else {
            days[3] = fromTop - 1L;
        }
        long t = this._getWorkTime(workTime, days[0], days[1], maxDayTime, false);
        t += this._getWorkTime(workTime, days[2], days[3], maxDayTime, true);
        BigDecimal bd = new BigDecimal(t += this._getWorkTime(workTime, days[4], days[5], maxDayTime, false));
        Variant varRet = new Variant(bd.divide(outUnit, 19, 4), 10);
        return varRet;
    }

    private long _getWorkTime(Calendar[] workTime, long from, long to, long maxDayTime, boolean allDay) {
        if (from >= to) {
            return 0L;
        }
        long lRet = 0L;
        if (workTime == null) {
            lRet = allDay ? (to - from) / 86400000L * maxDayTime : Math.min(maxDayTime, to - from);
        } else if (allDay) {
            maxDayTime = Math.min(maxDayTime, workTime[8].getTimeInMillis());
            lRet = (to - from) / 86400000L * maxDayTime;
        } else {
            _calInst.setTimeInMillis(from);
            int y = _calInst.get(1);
            int m = _calInst.get(2);
            int d = _calInst.get(5);
            for (int i = 0; i < 8; i += 2) {
                Calendar end = workTime[i + 1];
                if (end == null) continue;
                end.set(y, m, d);
                long tEnd = end.getTimeInMillis();
                if (from > tEnd) continue;
                Calendar start = workTime[i];
                start.set(y, m, d);
                long tStart = start.getTimeInMillis();
                if (to < tStart) continue;
                lRet += Math.min(to, tEnd) - Math.max(from, tStart);
            }
            lRet = Math.min(maxDayTime, lRet);
        }
        return lRet;
    }

    private long _timeNotWork(Calendar calInst, long from, long to, WorkDays workDay, Holidays holiday) {
        long timeNotWork = 0L;
        for (long time = from; time < to; time += 86400000L) {
            calInst.setTimeInMillis(time);
            if (holiday != null && holiday.isHoliday(calInst)) {
                timeNotWork += 86400000L;
                continue;
            }
            if (workDay == null || workDay.isWorkDay(calInst)) continue;
            timeNotWork += 86400000L;
        }
        return timeNotWork;
    }

    public Variant DATETIME(Variant time) throws SyntaxErrorException {
        String str;
        Variant var;
        if (!time.isString()) {
            ExprErr.goError(64L, null);
        }
        if ((var = DataConvert.getTime(str = time.toString())).isNull() && (var = DataConvert.getDateTime(str)).isNull()) {
            ExprErr.goError(64L, null);
        }
        return var;
    }

    public Variant DAYNAME(Variant time) throws SyntaxErrorException {
        String name;
        Calendar cal = ExcelFuncProvider.timeGet(time);
        switch (cal.get(7)) {
            case 1: {
                name = CtrlEXTMessages.getMLS("sunday", "\u661f\u671f\u65e5");
                break;
            }
            case 2: {
                name = CtrlEXTMessages.getMLS("monday", "\u661f\u671f\u4e00");
                break;
            }
            case 3: {
                name = CtrlEXTMessages.getMLS("tuesday", "\u661f\u671f\u4e8c");
                break;
            }
            case 4: {
                name = CtrlEXTMessages.getMLS("wednesday", "\u661f\u671f\u4e09");
                break;
            }
            case 5: {
                name = CtrlEXTMessages.getMLS("thursday", "\u661f\u671f\u56db");
                break;
            }
            case 6: {
                name = CtrlEXTMessages.getMLS("friday", "\u661f\u671f\u4e94");
                break;
            }
            default: {
                name = CtrlEXTMessages.getMLS("saturday", "\u661f\u671f\u516d");
            }
        }
        return new Variant(name, 11);
    }

    public Variant SETWORKDAY(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 8);
        WorkDays workDays = new WorkDays();
        for (int i = 0; i < args.length; ++i) {
            Variant var = (Variant)args[i];
            if (var.isArray()) {
                Object[] array = (Object[])var.getValue();
                for (int j = 0; j < array.length; ++j) {
                    workDays.setSpecialDays(array[j].toString());
                }
                continue;
            }
            if (!var.isNumeric(var)) {
                ExprErr.goError(16L, "Not Number");
            }
            workDays.setWorkDay(var.intValue(), true);
        }
        return new Variant(workDays, 17);
    }

    public Variant SETWORKTIME(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 8);
        if (args.length % 2 != 0) {
            ExprErr.goError(16L, "Odd Params");
        }
        long allDayTime = 0L;
        Calendar[] times = new Calendar[9];
        for (int i = 0; i < args.length; i += 2) {
            Variant var = (Variant)args[i];
            Variant var2 = (Variant)args[i + 1];
            if (!var.isString() || !var2.isString()) {
                ExprErr.goError(16L, "Not String");
            }
            var = DataConvert.getTime((String)var.getValue());
            var2 = DataConvert.getTime((String)var2.getValue());
            if (var.isNull() || var2.isNull()) {
                ExprErr.goError(16L, "Not Time");
            }
            Date t1 = (Date)var.getValue();
            Date t2 = (Date)var2.getValue();
            if (t2.getTime() <= t1.getTime()) {
                ExprErr.goError(16L, "Error Time Span");
            }
            Calendar cal = (Calendar)_calInst.clone();
            cal.setTime(t1);
            times[i] = cal;
            long t = cal.getTimeInMillis();
            cal = (Calendar)_calInst.clone();
            cal.setTime(t2);
            times[i + 1] = cal;
            allDayTime += cal.getTimeInMillis() - t;
        }
        Calendar cal = (Calendar)_calInst.clone();
        cal.setTimeInMillis(allDayTime);
        times[8] = cal;
        return new Variant(times, 17);
    }

    public Variant SETHOLIDAY(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 366);
        Holidays holidays = new Holidays();
        for (int i = 0; i < args.length; ++i) {
            Variant var = (Variant)args[i];
            if (var.isArray()) {
                Object[] array = (Object[])var.getValue();
                for (int j = 0; j < array.length; ++j) {
                    holidays.setSpecialDays(array[j].toString());
                }
                continue;
            }
            if (!var.isString()) {
                ExprErr.goError(16L, "Not String");
            }
            if ((var = DataConvert.getDate((String)var.getValue())).isNull()) {
                ExprErr.goError(16L, "Not Date");
            }
            _calInst.setTime((Date)var.getValue());
            holidays.setHoliday(_calInst.get(6), true);
        }
        return new Variant(holidays, 17);
    }

    public Variant NOW() throws SyntaxErrorException {
        return new Variant(new Date(), 12);
    }

    public static Calendar timeGet(Variant time) throws SyntaxErrorException {
        if (time.isString()) {
            Object[] args = new Object[]{time};
            time = ExcelFuncProvider.DATEVALUE(args);
        }
        return time.toCalendar();
    }

    public static Calendar justDay(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    static Variant timeGet(Variant time, int index) throws SyntaxErrorException {
        Calendar cal = ExcelFuncProvider.timeGet(time);
        return new Variant(ObjectCache.getInteger(cal.get(index)), 3);
    }

    public Variant YEAR(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant time = (Variant)args[0];
        return ExcelFuncProvider.timeGet(time, 1);
    }

    public Variant MONTH(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant time = (Variant)args[0];
        Variant varResult = ExcelFuncProvider.timeGet(time, 2);
        if (varResult.isNumber()) {
            varResult.add(Variant.oneVariant);
        }
        return varResult;
    }

    public Variant DAY(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant time = (Variant)args[0];
        return ExcelFuncProvider.timeGet(time, 5);
    }

    public Variant HOUR(Object[] args) throws SyntaxErrorException {
        Variant time;
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant ret = time = (Variant)args[0];
        if (ret.isString()) {
            Variant days = ExcelFuncProvider.timeSpan(ret, "HOURS");
            days.add(new Variant(25569L));
        }
        Calendar cal = ret.toCalendar();
        return new Variant(ObjectCache.getInteger(cal.get(11)), 3);
    }

    public Variant MINUTE(Object[] args) throws SyntaxErrorException {
        Variant time;
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant ret = time = (Variant)args[0];
        if (ret.isString()) {
            Variant days = ExcelFuncProvider.timeSpan(ret, "MINUTES");
            days.add(new Variant(25569L));
        }
        Calendar cal = ret.toCalendar();
        return new Variant(ObjectCache.getInteger(cal.get(12)), 3);
    }

    public Variant SECOND(Object[] args) throws SyntaxErrorException {
        Variant time;
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant ret = time = (Variant)args[0];
        if (ret.isString()) {
            Variant days = ExcelFuncProvider.timeSpan(ret, "SECONDS");
            days.add(new Variant(25569L));
        }
        Calendar cal = ret.toCalendar();
        return new Variant(ObjectCache.getInteger(cal.get(13)), 3);
    }

    public Variant YEARDAY(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant time = (Variant)args[0];
        return ExcelFuncProvider.timeGet(time, 6);
    }

    public Variant WEEKDAY(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant ret = ExcelFuncProvider.timeGet((Variant)args[0], 7);
        if (args.length == 2) {
            int day = ret.intValue();
            Variant var = (Variant)args[1];
            ExcelFuncProvider.validNumericParam("returnType", var);
            int returnType = var.intValue();
            switch (returnType) {
                case 1: {
                    break;
                }
                case 2: {
                    if (--day == 0) {
                        day = 7;
                    }
                    ret = new Variant(ObjectCache.getInteger(day), 3);
                    break;
                }
                case 3: {
                    if ((day -= 2) < 0) {
                        day = 6;
                    }
                    ret = new Variant(ObjectCache.getInteger(day), 3);
                    break;
                }
                default: {
                    ExprErr.goError(16L, "returnType");
                }
            }
        }
        return ret;
    }

    public Variant DATE(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 3);
        Variant varYear = (Variant)args[0];
        Variant varMonth = (Variant)args[1];
        Variant varDay = (Variant)args[2];
        ExcelFuncProvider.validNumericParam("year", varYear);
        ExcelFuncProvider.validNumericParam("month", varMonth);
        ExcelFuncProvider.validNumericParam("day", varDay);
        Calendar cal = (Calendar)Util.BASE_DATE.clone();
        int year = varYear.intValue();
        if (year < 1900) {
            cal.add(1, year);
        } else {
            cal.set(1, year - 1);
        }
        cal.add(2, varMonth.intValue() - 1);
        cal.add(6, varDay.intValue());
        if (cal.before(Util.BASE_DATE) || year > 9999) {
            ExprErr.goError(4L, null);
        }
        return new Variant(cal.getTime(), 12);
    }

    public static Variant DATEVALUE(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant date = (Variant)args[0];
        if (!date.isString()) {
            date = new Variant(date.getVariant().toString(), 11);
        }
        Variant days = ExcelFuncProvider.timeSpan(date, "DAYS");
        days.add(new Variant(25569L));
        return days;
    }

    public Variant TIME(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 3);
        Variant varHour = (Variant)args[0];
        Variant varMinute = (Variant)args[1];
        Variant varSecond = (Variant)args[2];
        ExcelFuncProvider.validNumericParam("hour", varHour);
        ExcelFuncProvider.validNumericParam("minute", varMinute);
        ExcelFuncProvider.validNumericParam("second", varSecond);
        Calendar cal = (Calendar)Util.BASE_DATE.clone();
        cal.set(11, varHour.intValue() % 24);
        cal.add(12, varMinute.intValue());
        cal.add(13, varSecond.intValue());
        if (cal.before(Util.BASE_DATE)) {
            ExprErr.goError(4L, null);
        }
        BigDecimal ret = BigDecimal.valueOf(cal.getTimeInMillis() - Util.BASE_DATE.getTimeInMillis()).divide(BigDecimal.valueOf(86400000L), 9, 0);
        return new Variant(ret, 10);
    }

    public Variant TIMEVALUE(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant time = (Variant)args[0];
        if (!time.isString()) {
            ExprErr.goError(64L, null);
        }
        Calendar cal = ctx.getBook().getBufferedCalendar(time.toString());
        cal.set(1, 1900);
        cal.set(6, 0);
        BigDecimal bd = Variant.calendarToDecimal(cal).subtract(Variant.oneBigDecimal);
        return new Variant(bd, 10);
    }

    public Variant YEARFRAC(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 3);
        Variant start = (Variant)args[0];
        Variant end = (Variant)args[1];
        double basis = 360.0;
        if (args.length == 3) {
            Variant varBasis = Variant.getNewEmptyVariant();
            ((Variant)args[2]).isNumeric(varBasis);
            switch (varBasis.intValue()) {
                case 0: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    basis = 365.0;
                    break;
                }
                case 1: {
                    basis = ExcelFuncProvider.timeGet(end).getActualMaximum(6);
                    break;
                }
                default: {
                    ExprErr.goError(16L, "Basis");
                }
            }
        }
        BigDecimal bdStart = this.getDateDecimalValue(ctx, start);
        BigDecimal bdEnd = this.getDateDecimalValue(ctx, end);
        bdEnd = bdEnd.subtract(bdStart);
        bdEnd = bdEnd.divide(BigDecimal.valueOf(basis), 15, 4);
        return new Variant(bdEnd, 10);
    }

    public Variant DATEDIF(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 3);
        Calendar c = ((Variant)args[0]).toCalendar();
        Calendar c2 = ((Variant)args[1]).toCalendar();
        boolean neg = false;
        if (c2.before(c)) {
            neg = true;
            Calendar cTmp = c;
            c = c2;
            c2 = cTmp;
        }
        int value = 0;
        String unit = args[2].toString().toUpperCase(Locale.ENGLISH);
        if (unit.equals("Y")) {
            int year2 = c2.get(1);
            int year = c.get(1);
            value = year2 - year;
            int month2 = c2.get(2);
            int month = c.get(2);
            int day2 = c2.get(5);
            int day = c.get(5);
            if (value > 0 && (month2 < month || month2 == month && day2 < day)) {
                --value;
            }
        } else if (unit.equals("M")) {
            value = c2.get(1) * 12 + c2.get(2) - (c.get(1) * 12 + c.get(2));
            if (c2.get(5) < c.get(5)) {
                --value;
            }
        } else if (unit.equals("D")) {
            value = (int)(c2.getTimeInMillis() / 86400000L - c.getTimeInMillis() / 86400000L);
        } else if (unit.equals("MD")) {
            int d = c.get(5);
            int d2 = c2.get(5);
            if (d2 >= d) {
                value = d2 - d;
            } else {
                Calendar c3 = (Calendar)c2.clone();
                c3.set(2, c2.get(2) - 1);
                value = d2 + c3.getActualMaximum(5) - d;
            }
        } else if (unit.equals("YM")) {
            int m = c.get(2);
            int m2 = c2.get(2);
            if (m2 >= m) {
                m2 -= m;
                if (c.get(5) > c2.get(5) && --m2 < 0) {
                    m2 += 12;
                }
            } else {
                m2 += 12 - m;
                if (c.get(5) > c2.get(5)) {
                    --m2;
                }
            }
            value = m2;
        } else if (unit.equals("YD")) {
            int d = c.get(6);
            int d2 = c2.get(6);
            if (c2.get(2) + 1 == 3 && c2.get(5) >= c.get(5) || c2.get(2) + 1 != 3) {
                Calendar c3 = (Calendar)c2.clone();
                c3.set(1, c.get(1));
                d2 = c3.get(6);
                value = d2 - d;
                if (value < 0) {
                    c3.set(1, c.get(1) + 1);
                    d2 = c3.get(6);
                    value = d2 + c3.getActualMaximum(6) - d;
                }
            } else if (c2.get(2) + 1 == 3 && c2.get(5) < c.get(5)) {
                Calendar c3 = (Calendar)c.clone();
                c3.set(1, c2.get(1));
                d = c3.get(6);
                value = d2 - d;
                if (value < 0) {
                    c3.set(1, c2.get(1) - 1);
                    d = c3.get(6);
                    value = d2 + c3.getActualMaximum(6) - d;
                }
            }
        } else {
            ExprErr.goError(16L, unit);
        }
        return new Variant(new BigDecimal(neg ? -value : value), 10);
    }

    private BigDecimal getDateDecimalValue(ExprContext ctx, Variant var) throws SyntaxErrorException {
        int vt = var.getVt();
        BigDecimal bd = vt == 13 ? Variant.calendarToDecimal((Calendar)var.getValue()) : (vt == 12 ? Variant.calendarToDecimal(Variant.localDateToCalendar((Date)var.getValue())) : (vt == 11 ? Variant.calendarToDecimal(ctx.getBook().getBufferedCalendar((String)var.getValue())) : var.toBigDecimal()));
        return bd;
    }

    static Variant timeSpan(Variant time, String strIndex) throws SyntaxErrorException {
        Calendar cal = time.toCalendar();
        TimeSpan ts = new TimeSpan(cal.getTimeInMillis() * 10000L);
        Variant rvarResult = Variant.getNewEmptyVariant();
        if (StringUtil.equals((String)strIndex, (String)"DAYS")) {
            rvarResult.setLong(ts.getDays());
        } else if (StringUtil.equals((String)strIndex, (String)"HOURS")) {
            rvarResult.setLong(ts.getHours());
        } else if (StringUtil.equals((String)strIndex, (String)"MILLISECONDS")) {
            rvarResult.setLong(ts.getMilliseconds());
        } else if (StringUtil.equals((String)strIndex, (String)"MINUTES")) {
            rvarResult.setLong(ts.getMinutes());
        } else if (StringUtil.equals((String)strIndex, (String)"SECONDS")) {
            rvarResult.setLong(ts.getSeconds());
        } else if (StringUtil.equals((String)strIndex, (String)"TICKS")) {
            rvarResult.setLong(ts.getTicks());
        } else if (StringUtil.equals((String)strIndex, (String)"TOTALDAYS")) {
            rvarResult.setDouble(ts.getTotalDays());
        } else if (StringUtil.equals((String)strIndex, (String)"TOTALHOURS")) {
            rvarResult.setDouble(ts.getTotalHours());
        } else if (StringUtil.equals((String)strIndex, (String)"TOTALMILLISECONDS")) {
            rvarResult.setDouble(ts.getTotalMilliseconds());
        } else if (StringUtil.equals((String)strIndex, (String)"TOTALMINUTES")) {
            rvarResult.setDouble(ts.getTotalMinutes());
        } else if (StringUtil.equals((String)strIndex, (String)"TOTALSECONDS")) {
            rvarResult.setDouble(ts.getTotalSeconds());
        } else {
            ExprErr.goError(16L, "ERROR TIMESPAN FUNC");
        }
        return rvarResult;
    }

    public Variant DAYS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "DAYS");
    }

    public Variant DAYS360(Variant start_date, Variant end_date) throws SyntaxErrorException {
        return this.DAYS360(start_date, end_date, false);
    }

    public Variant DAYS360(Variant start_date, Variant end_date, boolean method) throws SyntaxErrorException {
        return DateUtil.days360(start_date, end_date, method);
    }

    public Variant HOURS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "HOURS");
    }

    public Variant MILLISECONDS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "MILLISECONDS");
    }

    public Variant MINUTES(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "MINUTES");
    }

    public Variant SECONDS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "SECONDS");
    }

    public Variant TICKS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "TICKS");
    }

    public Variant TOTALDAYS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "TOTALDAYS");
    }

    public Variant TOTALHOURS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "TOTALHOURS");
    }

    public Variant TOTALMILLISECONDS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "TOTALMILLISECONDS");
    }

    public Variant TOTALMINUTES(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "TOTALMINUTES");
    }

    public Variant TOTALSECONDS(Variant time) throws SyntaxErrorException {
        return ExcelFuncProvider.timeSpan(time, "TOTALSECONDS");
    }

    public Variant EDATE(Variant time, int months) throws SyntaxErrorException {
        Calendar start_date = (Calendar)ExcelFuncProvider.timeGet(time).clone();
        start_date.add(2, months);
        return new Variant(start_date, 13);
    }

    public Variant EOMONTH(Variant time, int months) throws SyntaxErrorException {
        Calendar start_date = (Calendar)ExcelFuncProvider.timeGet(time).clone();
        start_date.add(2, months);
        start_date.set(5, start_date.getActualMaximum(5));
        return new Variant(start_date, 13);
    }

    public static void validNumericParam(String varName, Variant value) throws SyntaxErrorException {
        if (!value.isNumeric()) {
            if (value.isError()) {
                throw (SyntaxErrorException)value.getValue();
            }
            String errMsg = "Parameter [" + varName + "] = " + value + " NOT NUMBER";
            ExprErr.goError(16L, errMsg);
        }
    }

    public static void validParamCount(Object[] args, int min, int max) throws SyntaxErrorException {
        if (args.length < min || args.length > max) {
            ExprErr.goError(8L, args.length + ":[" + min + "," + max + "]");
        }
    }

    public Variant SIGN(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return new Variant(value.compareTo(new Variant(0)));
    }

    public Variant ABS(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return new Variant(value.toBigDecimal().abs(), 10);
    }

    private static Variant decimalValue(double value) {
        return new Variant(BigDecimal.valueOf(value), 10);
    }

    private static Variant decimalValue(Variant value) {
        Variant ret;
        try {
            ret = new Variant(value.toBigDecimal(), 10);
        }
        catch (SyntaxErrorException e) {
            ret = ExcelFuncProvider.decimalValue(0.0);
        }
        return ret;
    }

    private static CellBlockNode cellblockValue(Variant var, String errMsg) throws SyntaxErrorException {
        Object value = null;
        while (true) {
            Variant[] array;
            if (var.isReferences()) {
                value = var.getValue();
                break;
            }
            if (!var.isArray() || (array = (Variant[])var.getValue()).length <= 0) break;
            var = array[0];
        }
        if (!(value instanceof CellBlockNode)) {
            throw new SyntaxErrorException(16L, errMsg);
        }
        return (CellBlockNode)value;
    }

    public Variant ROUND(Variant value, Variant digit) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        ExcelFuncProvider.validNumericParam("digit", digit);
        BigDecimal bd = value.toBigDecimal();
        int iDigit = (int)digit.doubleValue();
        if (iDigit >= 0) {
            return new Variant(bd.setScale(digit.intValue(), 4), 10);
        }
        BigDecimal pow = BigDecimal.valueOf(StrictMath.pow(10.0, -iDigit));
        bd = bd.divide(pow, 0, 4);
        bd = bd.multiply(pow);
        return new Variant(bd, 10);
    }

    public Variant FIX(Object[] args) throws SyntaxErrorException {
        BigDecimal bdValue;
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant value = (Variant)args[0];
        ExcelFuncProvider.validNumericParam("value", value);
        if (args.length == 1) {
            return ExcelFuncProvider.decimalValue(value.toBigDecimal().longValue());
        }
        Variant digit = (Variant)args[1];
        ExcelFuncProvider.validNumericParam("digit", digit);
        Util.reduceScale(value);
        int dfDecimalNum = digit.intValue();
        if (dfDecimalNum < -15) {
            dfDecimalNum = -15;
        } else if (dfDecimalNum > 15) {
            dfDecimalNum = 15;
        }
        if (dfDecimalNum > 0) {
            bdValue = value.toBigDecimal();
            bdValue = bdValue.setScale(dfDecimalNum, 4);
        } else {
            double dfValue = value.doubleValue();
            String str = String.valueOf(dfValue *= StrictMath.pow(10.0, dfDecimalNum));
            dfValue = Math.floor(Double.parseDouble(str));
            bdValue = BigDecimal.valueOf(dfValue *= StrictMath.pow(10.0, -dfDecimalNum));
        }
        return new Variant(bdValue, 10);
    }

    public Variant SQRT(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        double dfValue = value.doubleValue();
        if (dfValue < 0.0) {
            ExprErr.goError(32L, "value");
        }
        return ExcelFuncProvider.decimalValue(StrictMath.sqrt(dfValue));
    }

    public Variant INT(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        Variant varResult = new Variant(value.doubleValue());
        varResult.intpart();
        return ExcelFuncProvider.decimalValue(varResult);
    }

    public Variant LN(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return ExcelFuncProvider.decimalValue(StrictMath.log(value.doubleValue()));
    }

    private static Variant _log(double value, double base) {
        return new Variant(new BigDecimal(StrictMath.log(value) / StrictMath.log(base), _Decimal15), 10);
    }

    public Variant LOG(Object[] args) throws SyntaxErrorException {
        Variant base;
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant value = (Variant)args[0];
        ExcelFuncProvider.validNumericParam("value", value);
        if (args.length == 2) {
            base = (Variant)args[1];
            ExcelFuncProvider.validNumericParam("base", base);
        } else {
            base = new Variant(new Double(10.0), 6);
        }
        return ExcelFuncProvider._log(value.doubleValue(), base.doubleValue());
    }

    public Variant LOG10(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return ExcelFuncProvider._log(value.doubleValue(), 10.0);
    }

    public Variant EXP(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return ExcelFuncProvider.decimalValue(StrictMath.exp(value.doubleValue()));
    }

    public static Variant power_s(double x, double y) throws SyntaxErrorException {
        double d = StrictMath.pow(x, y);
        return new Variant(new BigDecimal(d, _Decimal15), 10);
    }

    public Variant POWER(Variant x, Variant y) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", x);
        ExcelFuncProvider.validNumericParam("value", y);
        return ExcelFuncProvider.power_s(x.doubleValue(), y.doubleValue());
    }

    public Variant MOD(Variant n, Variant d) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", n);
        ExcelFuncProvider.validNumericParam("value", d);
        Variant varResult = new Variant(n.doubleValue());
        Variant newN = new Variant(n);
        newN.divide(d);
        newN.intpart();
        newN.multiply(d);
        varResult.subtract(newN);
        return ExcelFuncProvider.decimalValue(varResult);
    }

    public Variant PI() throws SyntaxErrorException {
        return ExcelFuncProvider.decimalValue(Math.PI);
    }

    public Variant RAND() throws SyntaxErrorException {
        return ExcelFuncProvider.decimalValue(_rand.nextDouble());
    }

    public Variant DEGREES(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return ExcelFuncProvider.decimalValue(value.doubleValue() * 180.0 / Math.PI);
    }

    public Variant RADIANS(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return ExcelFuncProvider.decimalValue(value.doubleValue() * Math.PI / 180.0);
    }

    public Variant SIN(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return ExcelFuncProvider.decimalValue(StrictMath.sin(value.doubleValue()));
    }

    public Variant ASIN(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return ExcelFuncProvider.decimalValue(StrictMath.asin(value.doubleValue()));
    }

    public Variant COS(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return ExcelFuncProvider.decimalValue(StrictMath.cos(value.doubleValue()));
    }

    public Variant ACOS(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return ExcelFuncProvider.decimalValue(StrictMath.acos(value.doubleValue()));
    }

    public Variant TAN(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return ExcelFuncProvider.decimalValue(StrictMath.tan(value.doubleValue()));
    }

    public Variant ATAN(Variant value) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        return ExcelFuncProvider.decimalValue(StrictMath.atan(value.doubleValue()));
    }

    public Variant LEN(Variant value) throws SyntaxErrorException {
        return ExcelFuncProvider.decimalValue(value.toString().length());
    }

    public Variant LOWER(Variant value) throws SyntaxErrorException {
        return new Variant(value.toString().toLowerCase(Locale.ENGLISH), 11);
    }

    public Variant UPPER(Variant value) throws SyntaxErrorException {
        return new Variant(value.toString().toUpperCase(Locale.ENGLISH), 11);
    }

    public Variant TRIM(Variant value) throws SyntaxErrorException {
        return new Variant(value.toString().trim(), 11);
    }

    static Variant stringOP(Variant varStr, Variant varCount, String strOP) throws SyntaxErrorException {
        if (varStr.isCalcLast()) {
            return varStr;
        }
        String str = varStr.toString();
        Variant rvarResult = Variant.getNewEmptyVariant();
        ExcelFuncProvider.validNumericParam("count", varCount);
        int iChars = (int)varCount.doubleValue();
        if (iChars < 0) {
            ExprErr.goError(32L, "count");
        }
        if (StringUtil.equals((String)strOP, (String)"left")) {
            iChars = StrictMath.min(iChars, str.length());
            rvarResult.setObject(str.substring(0, iChars), 11);
        } else if (StringUtil.equals((String)strOP, (String)"right")) {
            iChars = StrictMath.min(iChars, str.length());
            int start = 0;
            if (str.length() > iChars) {
                start = str.length() - iChars;
            } else {
                iChars = str.length();
            }
            rvarResult.setObject(str.substring(start, start + iChars), 11);
        } else {
            long count = str.length() * iChars;
            if (count > 32767L) {
                ExprErr.goError(2048L, "String Length: " + String.valueOf(count));
            }
            StringBuilder sb = new StringBuilder((int)count);
            for (int i = 0; i < iChars; ++i) {
                sb.append(str);
            }
            rvarResult.setObject(sb.toString(), 11);
        }
        return rvarResult;
    }

    public Variant LEFT(Variant value, Variant count) throws SyntaxErrorException {
        return ExcelFuncProvider.stringOP(value, count, "left");
    }

    public Variant RIGHT(Variant value, Variant count) throws SyntaxErrorException {
        return ExcelFuncProvider.stringOP(value, count, "right");
    }

    public Variant REPT(Variant value, Variant count) throws SyntaxErrorException {
        return ExcelFuncProvider.stringOP(value, count, "repeat");
    }

    public Variant REPLACE(Variant old, Variant start, Variant num, Variant newStr) throws SyntaxErrorException {
        int startPos = start.intValue();
        int numChars = num.intValue();
        if (startPos < 1 || numChars < 0) {
            ExprErr.goError(64L, null);
        }
        String newText = newStr.toString();
        StringBuilder sb = new StringBuilder(old.toString());
        int len = sb.length();
        if (startPos >= len) {
            sb.append(newText);
        } else if (numChars == 0) {
            sb.insert(startPos - 1, newText);
        } else {
            sb.replace(startPos - 1, startPos + numChars - 1, newText);
        }
        return new Variant(sb.toString(), 11);
    }

    public Variant MID(Variant value, Variant start, Variant num) throws SyntaxErrorException {
        String str;
        ExcelFuncProvider.validNumericParam("start", start);
        ExcelFuncProvider.validNumericParam("num", num);
        int from = (int)start.doubleValue();
        int end = (int)num.doubleValue();
        if (from < 1 || end < 0) {
            ExprErr.goError(64L, null);
        }
        if (StringUtil.isEmptyString((String)(str = value.toString())) || str.length() < from - 1) {
            return Variant.getNewEmptyVariant();
        }
        end = Math.min(str.length(), from - 1 + end);
        return new Variant(str.substring(from - 1, end), 11);
    }

    public static void platValues(ObjectArray al, Variant var) {
        Object value = var.getValue();
        if (var.isArray()) {
            Variant[] array = (Variant[])value;
            for (int i = 0; i < array.length; ++i) {
                ExcelFuncProvider.platValues(al, array[i]);
            }
        } else if (var.isReferences()) {
            if (value instanceof CellBlockNode) {
                if (value instanceof CellBlock3DNode) {
                    CellBlock3DNode cb3 = (CellBlock3DNode)value;
                    Book book = cb3.getSheet().getBook();
                    int iEnd = cb3.getSheet2().getSheetIndex() + 1;
                    for (int i = cb3.getSheet().getSheetIndex(); i < iEnd; ++i) {
                        Sheet sheet = book.getSheet(i);
                        Sheet.ICellsIterator ci = sheet.getCellsIterator(cb3, false, true);
                        while (ci.hasNext()) {
                            al.append(ci.next().getValue());
                        }
                    }
                } else {
                    Sheet.ICellsIterator ci = ((CellBlockNode)value).getCellsIterator(false, true);
                    while (ci.hasNext()) {
                        al.append(ci.next().getValue());
                    }
                }
            } else {
                ExcelFuncProvider.platValues(al, ((IVarReferences)value).getActualValue());
            }
        } else if (var.isObject()) {
            if (value instanceof ExtGroup) {
                ExtGroup group = (ExtGroup)value;
                al.appendAll(group.getValues(), group.getValueFrom(), group.getValueTo());
            } else {
                al.append(var);
            }
        } else {
            al.append(var);
        }
    }

    public Variant DISTINCTA(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        CellBlockNode cb;
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant var = (Variant)args[0];
        Object obj = var.getValue();
        IExprBuffer buffer = null;
        ObjectArray oa = null;
        if (var.isArray()) {
            oa = new ObjectArray((Object[])obj, ((Object[])obj).length);
        } else if (var.isReferences() && obj instanceof CellBlockNode && ((cb = (CellBlockNode)obj).isSingleRow() || cb.isSingleCol())) {
            buffer = ctx.getBuffer();
            oa = buffer.getObjectArray(-1);
            this._collectBlock(oa, cb);
        }
        if (oa == null) {
            ExprErr.goError(16L, "Not Array");
        }
        boolean ascent = true;
        if (args.length == 2) {
            ascent = ((Variant)args[1]).booleanValue();
        }
        Variant[] array = null;
        SBTree qt = new SBTree();
        if (null != oa) {
            int i;
            for (i = oa.size() - 1; i >= 0; --i) {
                ((BinaryTree)qt).insert(oa.getAt(i));
            }
            array = new Variant[((BinaryTree)qt).size()];
            i = 0;
            Iterator ii = ((BinaryTree)qt).iterator(null, null, !ascent);
            while (ii.hasNext()) {
                array[i++] = (Variant)ii.next();
            }
        }
        if (buffer != null) {
            buffer.recycleArray(oa);
        }
        return new Variant(array, 527);
    }

    public Variant ARRAYTEXT(Object[] args) throws SyntaxErrorException {
        Variant[] array;
        int len;
        String sep;
        ExcelFuncProvider.validParamCount(args, 2, Integer.MAX_VALUE);
        String prefix = sep = "";
        String postfix = sep;
        boolean skipBlank = false;
        boolean trimString = false;
        Variant var = (Variant)args[0];
        if (var.isString()) {
            sep = var.toString();
        } else if (var.isArray() && (len = (array = (Variant[])var.getValue()).length) > 0) {
            sep = array[0].toString();
            if (len > 1) {
                prefix = array[1].toString();
                if (len > 2) {
                    postfix = array[2].toString();
                    if (len > 3) {
                        skipBlank = array[3].booleanValue();
                        if (len > 4) {
                            trimString = array[4].booleanValue();
                        }
                    }
                }
            }
        }
        ObjectArray al = new ObjectArray(args.length);
        for (int i = 1; i < args.length; ++i) {
            if (((Variant)args[i]).isArray()) {
                Variant[] array2 = (Variant[])((Variant)args[i]).getValue();
                for (int j = 0; j < array2.length; ++j) {
                    Object value = array2[j].getValue();
                    if (value instanceof ExtGroup) {
                        ExtGroup group = (ExtGroup)value;
                        al.append(group.getFirstValue());
                        continue;
                    }
                    ExcelFuncProvider.platValues(al, array2[j]);
                }
                continue;
            }
            ExcelFuncProvider.platValues(al, (Variant)args[i]);
        }
        int len2 = al.size();
        StringBuilder sb = new StringBuilder(len2 << 3);
        sb.append(prefix);
        boolean appendSep = false;
        for (int i = 0; i < len2; ++i) {
            String str = al.get(i).toString();
            if (trimString) {
                str = str.trim();
            }
            if (skipBlank && str.length() == 0) continue;
            if (appendSep) {
                sb.append(sep);
            } else {
                appendSep = true;
            }
            sb.append(str);
        }
        sb.append(postfix);
        return new Variant(sb.toString(), 11);
    }

    public Variant CASE(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, Integer.MAX_VALUE);
        Variant ret = null;
        boolean match = false;
        int argCount = args.length;
        int iEnd = argCount - 1;
        for (int i = 0; i < iEnd; i += 2) {
            Variant cond = Expr.execute(ctx, (Variant)args[i]);
            if (!cond.booleanValue()) continue;
            ret = Expr.execute(ctx, (Variant)args[i + 1]);
            match = true;
            break;
        }
        if (!match) {
            if ((argCount & 1) == 1) {
                ret = Expr.execute(ctx, (Variant)args[argCount - 1]);
            } else {
                ExprErr.goError(64L, null);
            }
        }
        return ret;
    }

    public Variant INDEX(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant varSrc;
        Object obj;
        int row2;
        ExcelFuncProvider.validParamCount(args, 2, 6);
        Variant result = Variant.getNewEmptyVariant();
        int col = -1;
        int col2 = -1;
        int area = -1;
        int row = row2 = this._rowcolValue(ctx, (Variant)args[1], result, "rowIndex");
        if (args.length > 2) {
            col = col2 = this._rowcolValue(ctx, (Variant)args[2], result, "colIndex");
            if (args.length > 3) {
                Variant var = Expr.execute(ctx, (Variant)args[3]);
                if (!var.isNull()) {
                    if (!var.isNumeric(result)) {
                        ExprErr.goError(16L, "areaIndex");
                    }
                    if ((area = result.intValue() - 1) < 0) {
                        ExprErr.goError(64L, "areaIndex");
                    }
                }
                if (args.length > 4) {
                    row2 = this._rowcolValue(ctx, (Variant)args[4], result, "rowIndex");
                    if (args.length > 5) {
                        col2 = this._rowcolValue(ctx, (Variant)args[5], result, "colIndex");
                    }
                }
            }
        }
        if (row > row2 || col > col2 || row == -1 && row2 != -1 || col == -1 && col2 != -1) {
            ExprErr.goError(64L, "rowcolIndex");
        }
        if ((obj = (varSrc = Expr.execute(ctx, (Variant)args[0]).getVariant()).getValue()) instanceof CellBlockNode && (varSrc.isReferences() || varSrc.isObject())) {
            if (area > -1) {
                ExprErr.goError(64L, "areaIndex");
            }
            result = this._getArrayDataFromBlock((CellBlockNode)obj, row, col, row2, col2);
        } else if (varSrc.isArray()) {
            Object[] array = (Variant[])obj;
            if (varSrc.isD2Array()) {
                result = this._getArrayData(varSrc, (Variant[])array, row, col);
            } else {
                boolean isArea = false;
                if (area > -1) {
                    if (array.length <= area) {
                        ExprErr.goError(512L, "areaIndex");
                    }
                    Variant varArea = array[area];
                    obj = varArea.getValue();
                    if (varArea.isReferences() && obj instanceof CellBlockNode) {
                        varSrc = varArea;
                        isArea = true;
                    } else if (area != 0) {
                        ExprErr.goError(512L, null);
                    }
                }
                if (isArea) {
                    result = this._getArrayDataFromBlock((CellBlockNode)obj, row, col, row2, col2);
                } else {
                    int index2;
                    int index;
                    if (col < 0) {
                        index = row;
                        index2 = row2;
                    } else {
                        if (row > 0 || row2 > 0) {
                            ExprErr.goError(512L, null);
                        }
                        index = col;
                        index2 = col2;
                    }
                    if (index >= array.length || index2 >= array.length) {
                        ExprErr.goError(512L, null);
                    }
                    if (index != index2) {
                        Object[] a = new Variant[index2 - index + 1];
                        KDToolkit.arraycopy((Object[])array, (int)index, (Object[])a, (int)0, (int)a.length);
                        result = new Variant(a, 527);
                    } else {
                        result = array[index];
                    }
                }
            }
        } else {
            int index2;
            int index;
            if (varSrc.isError()) {
                throw (SyntaxErrorException)varSrc.getValue();
            }
            if (col < 0) {
                index = row;
                index2 = row2;
            } else {
                if (row > 0 || row2 > 0) {
                    ExprErr.goError(512L, null);
                }
                index = col;
                index2 = col2;
            }
            if (index >= 1 || index2 >= 1) {
                ExprErr.goError(512L, null);
            }
            result = varSrc;
        }
        return result;
    }

    public Variant INDEXOF(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant[] varTexts;
        String[] strWithins;
        Variant[] varWithins;
        ExcelFuncProvider.validParamCount(args, 2, 4);
        int start = 1;
        int rept = 1;
        if (args.length > 2) {
            Variant var = (Variant)args[2];
            if (!var.isNull()) {
                ExcelFuncProvider.validNumericParam("start", var);
                start = (int)var.doubleValue();
                if (start < 1) {
                    ExprErr.goError(64L, "start");
                }
            }
            if (args.length > 3 && !(var = (Variant)args[3]).isNull()) {
                ExcelFuncProvider.validNumericParam("rept", var);
                rept = (int)var.doubleValue();
                if (rept < 1) {
                    ExprErr.goError(64L, "rept");
                }
            }
        }
        int pos = -1;
        boolean recyleWithinArray = false;
        boolean recyleTextArray = false;
        IExprBuffer buffer = ctx.getBuffer();
        Variant varIn = (Variant)args[1];
        if (varIn.isArray()) {
            varWithins = (Variant[])varIn.getValue();
            strWithins = new String[varWithins.length];
        } else {
            varWithins = buffer.getOneVariantArray(varIn);
            recyleWithinArray = true;
            strWithins = new String[1];
        }
        Variant varText = (Variant)args[0];
        if (varText.isArray()) {
            varTexts = (Variant[])varText.getValue();
        } else {
            varTexts = buffer.getOneVariantArray(varText);
            recyleTextArray = true;
        }
        for (int t = 0; t < varTexts.length; ++t) {
            String text = varTexts[t].toString().toLowerCase(Locale.ENGLISH);
            block1: for (int in = 0; in < strWithins.length; ++in) {
                String within = strWithins[in];
                if (within == null) {
                    strWithins[in] = within = varWithins[in].toString().toLowerCase(Locale.ENGLISH);
                }
                int p = start - 2;
                for (int r = rept; r > 0; --r) {
                    if ((p = within.indexOf(text, p + 1)) < 0) continue block1;
                }
                pos = p;
                break;
            }
            if (pos > -1) break;
        }
        if (recyleWithinArray) {
            buffer.recycleArray(varWithins);
        }
        if (recyleTextArray) {
            buffer.recycleArray(varTexts);
        }
        if (pos < 0) {
            ExprErr.goError(64L, null);
        }
        return new Variant(pos + 1);
    }

    private int _rowcolValue(ExprContext ctx, Variant var, Variant result, String msg) throws SyntaxErrorException {
        ExcelFuncProvider.numberValue(ctx, var, result, msg);
        int v = result.intValue() - 1;
        if (v < -1) {
            ExprErr.goError(64L, msg);
        }
        return v;
    }

    public static Variant numberValue(ExprContext ctx, Variant var, Variant result, String msg) throws SyntaxErrorException {
        if (!(var = Expr.execute(ctx, var)).isNumeric(result)) {
            ExprErr.goError(16L, msg);
        }
        return result;
    }

    public static Variant numberValue(ExprContext ctx, Variant var, String msg) throws SyntaxErrorException {
        return ExcelFuncProvider.numberValue(ctx, var, new Variant(), msg);
    }

    private Variant _getArrayDataFromBlock(CellBlockNode cb, int row, int col, int row2, int col2) throws SyntaxErrorException {
        Variant result;
        if (col == -1) {
            if (row == -1) {
                result = cb.getVarThis();
            } else {
                if (cb.getHeight() <= row) {
                    ExprErr.goError(512L, "rowIndex");
                }
                CellBlockNode block = (CellBlockNode)cb.clone();
                block.setRow(row + cb.getRow());
                block.setRow2(row2 + cb.getRow());
                result = block.getVarThis();
            }
        } else if (row == -1) {
            if (cb.getWidth() <= col) {
                ExprErr.goError(512L, "colIndex");
            }
            CellBlockNode block = (CellBlockNode)cb.clone();
            block.setCol(col + cb.getCol());
            block.setCol2(col2 + cb.getCol());
            result = block.getVarThis();
        } else {
            int size = cb.getHeight();
            if (size <= row || size <= row2) {
                ExprErr.goError(512L, "rowIndex");
            } else {
                size = cb.getWidth();
                if (size <= col || size <= col2) {
                    ExprErr.goError(512L, "colIndex");
                }
            }
            int baseRow = cb.getRow();
            int baseCol = cb.getCol();
            if (row == row2 && col == col2) {
                Cell cll = cb.getSheet().getCell(baseRow + row, baseCol + col, false);
                result = cll == null ? Variant.nullVariant : cll.getValue();
            } else {
                CellBlockNode block = (CellBlockNode)cb.clone();
                block.setRowCol(baseRow + row, baseCol + col, baseRow + row2, baseCol + col2);
                result = block.getVarThis();
            }
        }
        return result;
    }

    private Variant _getArrayData(Variant varSrc, Variant[] array, int row, int col) throws SyntaxErrorException {
        Variant result;
        if (col == -1) {
            if (row == -1) {
                result = varSrc;
            } else {
                if (array.length <= row) {
                    ExprErr.goError(512L, "rowIndex");
                }
                result = array[row];
            }
        } else if (row == -1) {
            Variant[] dstArray = new Variant[array.length];
            for (int r = 0; r < array.length; ++r) {
                Variant varRow = array[r];
                if (varRow.isArray()) {
                    Variant[] rowArray = (Variant[])varRow.getValue();
                    if (rowArray.length <= col) {
                        ExprErr.goError(512L, "dataArray");
                    }
                    dstArray[r] = rowArray[col];
                    continue;
                }
                if (col != 0) {
                    ExprErr.goError(512L, "colIndex");
                }
                dstArray[r] = varRow;
            }
            result = new Variant(dstArray, 527);
        } else {
            Variant varRow;
            if (array.length <= row) {
                ExprErr.goError(512L, "rowIndex");
            }
            if ((varRow = array[row]).isArray()) {
                Variant[] rowArray = (Variant[])varRow.getValue();
                if (rowArray.length <= col) {
                    ExprErr.goError(512L, "dataArray");
                }
                result = rowArray[col];
            } else {
                if (col != 0) {
                    ExprErr.goError(512L, "colIndex");
                }
                result = varRow;
            }
        }
        return result;
    }

    public Variant CHOOSE(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, Integer.MAX_VALUE);
        int index = Expr.execute(ctx, (Variant)args[0]).intValue();
        if (index < 1 || index > args.length) {
            ExprErr.goError(64L, null);
        }
        return Expr.execute(ctx, (Variant)args[index - 1]);
    }

    public Variant SEARCH(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 3);
        int start = 1;
        if (args.length == 3) {
            Variant var = (Variant)args[2];
            ExcelFuncProvider.validNumericParam("start", var);
            start = (int)var.doubleValue();
            if (start <= 0) {
                ExprErr.goError(64L, null);
            }
        }
        String text = args[0].toString().toLowerCase(Locale.ENGLISH);
        String within = args[1].toString().toLowerCase(Locale.ENGLISH);
        int pos = within.indexOf(text, start - 1);
        if (pos < 0) {
            ExprErr.goError(64L, null);
        }
        return new Variant(pos + 1);
    }

    public Variant SUBSTITUTE(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 4);
        String within = args[0].toString();
        String oldText = args[1].toString();
        String newText = args[2].toString();
        int iNum = Integer.MAX_VALUE;
        if (args.length == 4) {
            ExcelFuncProvider.validNumericParam("num", (Variant)args[3]);
            iNum = (int)((Variant)args[3]).doubleValue();
            if (iNum <= 0) {
                ExprErr.goError(64L, null);
            }
        }
        String ret = oldText;
        int fromIndex = 0;
        if (iNum == Integer.MAX_VALUE) {
            int pos;
            fromIndex = within.length();
            while ((pos = within.lastIndexOf(oldText, fromIndex)) >= 0) {
                fromIndex = pos + oldText.length();
                within = within.substring(0, pos) + newText + within.substring(fromIndex);
            }
            ret = within;
        } else {
            int pos;
            while ((pos = within.indexOf(oldText, fromIndex)) >= 0) {
                fromIndex = pos + oldText.length();
                if (--iNum != 0) continue;
                ret = within.substring(0, pos) + newText + within.substring(fromIndex);
                break;
            }
        }
        return new Variant(ret, 11);
    }

    public Variant CONCATENATE(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, Integer.MAX_VALUE);
        Variant result = null;
        StringBuilder sb = new StringBuilder(args.length * 10);
        for (int i = 0; i < args.length; ++i) {
            result = (Variant)args[i];
            Object obj = result.getValue();
            if (obj instanceof CellBlockNode) {
                Cell cll;
                CellBlockNode cb = (CellBlockNode)obj;
                if (!cb.isSingleCell()) {
                    ExprErr.goError(64L, null);
                }
                if ((cll = cb.getSheet().getFirstCell(cb, false)) == null) continue;
                result = cll.getValue2();
                if (result.isPending()) break;
                sb.append(cll.getText());
                continue;
            }
            if (obj instanceof IVarReferences) {
                sb.append(((IVarReferences)obj).getActualValue());
                continue;
            }
            if (result.isPending()) break;
            if (obj == null) continue;
            sb.append(obj);
        }
        if (null != result && !result.isPending()) {
            result = new Variant(sb.toString(), 11);
        }
        return result;
    }

    public Variant TEXT(ExprContext ctx, Variant value, Variant format) throws SyntaxErrorException {
        if (value.isCalcLast()) {
            throw SyntaxErrorException.CALC_LAST;
        }
        String formatString = format.toString();
        if (StringUtil.isEmptyString((String)formatString)) {
            return Variant.getNewEmptyVariant();
        }
        return new Variant(ctx.getBook().getFormat(formatString).format(value).toString(), 11);
    }

    public Variant FIND(Object[] args) throws SyntaxErrorException {
        int pos;
        Variant varTrans;
        Variant var;
        ExcelFuncProvider.validParamCount(args, 2, 3);
        String find = args[0].toString();
        if (StringUtil.isEmptyString((String)find)) {
            return new Variant(1);
        }
        String in = args[1].toString();
        if (StringUtil.isEmptyString((String)in)) {
            ExprErr.goError(64L, null);
        }
        int offset = 0;
        if (!(args.length != 3 || (var = (Variant)args[2]).isNumeric(varTrans = Variant.getNewEmptyVariant()) && (offset = varTrans.intValue() - 1) >= 0)) {
            ExprErr.goError(64L, null);
        }
        if ((pos = in.indexOf(find, offset)) < 0) {
            ExprErr.goError(64L, null);
        }
        return ExcelFuncProvider.decimalValue(pos + 1);
    }

    public static ICalculable calcLast(ExprContext ctx) throws SyntaxErrorException {
        ICalculable exprOwner = ctx.getExprOwner();
        if (ctx.isCalcLastMode() && exprOwner instanceof Cell) {
            throw SyntaxErrorException.CALC_LAST;
        }
        return exprOwner;
    }

    public Variant ROW(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.calcLast(ctx);
        CellBlock cb = this._getPosition(ctx, args);
        return new Variant(cb.getRow() + 1, 3);
    }

    public Variant RGB(int r, int g, int b) {
        int value = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        return new Variant(value);
    }

    public Variant COLUMN(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.calcLast(ctx);
        CellBlock cb = this._getPosition(ctx, args);
        return new Variant(cb.getCol() + 1);
    }

    private CellBlock _getPosition(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        CellBlock cb;
        Variant var = null;
        if (args.length > 1) {
            ExprErr.goError(8L, null);
        }
        if (args.length == 1) {
            if (!(args[0] instanceof Variant)) {
                ExprErr.goError(16L, null);
            }
            if ((var = (Variant)args[0]).getVt() != 18 || !(var.getValue() instanceof CellBlock)) {
                ExprErr.goError(16L, null);
            }
        }
        if (args.length > 0 && null != var) {
            cb = (CellBlock)var.getValue();
        } else {
            ICalculable exprOwner = ctx.getExprOwner();
            if (exprOwner instanceof Cell) {
                Cell cll = (Cell)exprOwner;
                cb = CellBlock.getCellBlock(cll.getRow(), cll.getCol());
            } else {
                Sheet sheet = exprOwner.getSheet();
                cb = CellBlock.getCellBlock(sheet.getActiveRow(), sheet.getActiveCol());
            }
        }
        return cb;
    }

    public Variant DEC2HEX(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant value = (Variant)args[0];
        ExcelFuncProvider.validNumericParam("value", value);
        double dfValue = value.doubleValue();
        if (!ArrayUtil.isEqual((Double)(dfValue - (double)((long)dfValue)), (Double)0.0)) {
            ExprErr.goError(16L, "VALUE SHOULD BE INTEGER");
        }
        if (args.length == 1) {
            return new Variant(Integer.toHexString((int)dfValue), 11);
        }
        Variant len = (Variant)args[1];
        ExcelFuncProvider.validNumericParam("len", len);
        int digit = (int)len.doubleValue();
        if (digit < 0) {
            ExprErr.goError(32L, "LEN");
        }
        String str = Integer.toHexString((int)dfValue);
        StringBuilder sb = new StringBuilder(str);
        int count = digit - str.length();
        for (int i = 0; i < count; ++i) {
            sb.insert(0, '0');
        }
        return new Variant(sb.toString(), 11);
    }

    private Variant lookup(Object[] args, boolean bV) throws SyntaxErrorException {
        class CellValue
        implements Comparable {
            private final Variant _value;
            private final Cell _cll;

            CellValue(Variant value, Cell cll) {
                this._value = value;
                this._cll = cll;
            }

            public int compareTo(Object obj) {
                if (this == obj) {
                    return 0;
                }
                if (obj instanceof CellValue) {
                    return this._value.compareTo((Object)((CellValue)obj)._value);
                }
                if (obj instanceof Variant) {
                    return this._value.compareTo(obj);
                }
                return -1;
            }
        }
        int pos;
        int valueIndex;
        ExcelFuncProvider.validParamCount(args, 3, 4);
        Variant searchValue = (Variant)args[0];
        if (searchValue.isNull()) {
            ExprErr.goError(524288L, "search");
        } else if (searchValue.getValue() instanceof CellBlockNode) {
            CellBlockNode node = (CellBlockNode)searchValue.getValue();
            Cell cell = node.getSheet().getCell(node.getRow(), node.getCol(), false);
            searchValue = cell == null ? Variant.nullVariant : cell.getValue();
        }
        Object obj = ((Variant)args[1]).getValue();
        if (!(obj instanceof CellBlockNode)) {
            ExprErr.goError(16L, "range");
        }
        CellBlockNode range = (CellBlockNode)obj;
        Variant varIndex = (Variant)args[2];
        Variant varTrans = Variant.getNewEmptyVariant();
        if (!varIndex.isNumeric(varTrans)) {
            ExprErr.goError(16L, "Value Index");
        }
        if ((valueIndex = varTrans.intValue()) < 1 || valueIndex > (bV ? range.getWidth() : range.getHeight())) {
            ExprErr.goError(262144L, null);
        }
        boolean exact = false;
        if (args.length == 4) {
            exact = !((Variant)args[3]).booleanValue();
        }
        int row = range.getRow();
        int col = range.getCol();
        SortedObjectArray so = new SortedObjectArray();
        Sheet.ICellsIterator ci = range.getSheet().getCellsIterator(row, col, bV ? range.getRow2() : row, bV ? col : range.getCol2(), false, true);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            so.insert(new CellValue(cll.getValue(), cll));
        }
        if (so.size() == 0) {
            ExprErr.goError(524288L, null);
        }
        if ((pos = so.search(searchValue)) < 0 && !exact) {
            pos = Math.max(0, -(pos + 1) - 1);
        }
        if (pos < 0) {
            ExprErr.goError(524288L, null);
        }
        CellValue cv = (CellValue)so.get(pos);
        if (!exact && searchValue.compareTo(cv._value) < 0) {
            ExprErr.goError(524288L, null);
        }
        row = cv._cll.getRow();
        col = cv._cll.getCol();
        Cell cll = range.getSheet().getCell(bV ? row : row + valueIndex - 1, bV ? col + valueIndex - 1 : col, false);
        return cll == null ? Variant.getNewEmptyVariant() : cll.getValue();
    }

    public Variant VLOOKUP(Object[] args) throws SyntaxErrorException {
        return this.lookup(args, true);
    }

    public Variant HLOOKUP(Object[] args) throws SyntaxErrorException {
        return this.lookup(args, false);
    }

    private static void stat(Object[] objs, Variant[] stats, boolean excludeHidden, boolean onlyNumber, boolean excludeSubTotal) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(objs, 1, Integer.MAX_VALUE);
        boolean statCount = stats[1] != null;
        Variant number = Variant.getNewEmptyVariant();
        Variant one = statCount ? ExcelFuncProvider.decimalValue(1.0) : null;
        int i = 0;
        while (i < objs.length) {
            CellBlockNode cb;
            Variant arg;
            if ((arg = (Variant)objs[i++]).isError()) {
                throw (SyntaxErrorException)arg.getValue();
            }
            Object obj = arg.getValue();
            Book book = null;
            int sht = 0;
            int shtEnd = -1;
            if (obj instanceof CellBlock3DNode) {
                cb = (CellBlock3DNode)obj;
                book = cb.getSheet().getBook();
                sht = cb.getSheet().getSheetIndex();
                shtEnd = ((CellBlock3DNode)cb).getSheet2().getSheetIndex();
            } else if (obj instanceof CellBlockNode) {
                cb = (CellBlockNode)obj;
                book = cb.getSheet().getBook();
                sht = shtEnd = cb.getSheet().getSheetIndex();
            }
            Variant sum = stats[0];
            Variant count = stats[1];
            Variant max = stats[2];
            Variant min = stats[3];
            Variant product = stats[4];
            Variant stdev = stats[5];
            if (book != null) {
                while (sht <= shtEnd) {
                    Sheet sheet = book.getSheet(sht);
                    CellBlock cb2 = (CellBlock)obj;
                    if (cb2.isSingleCell()) {
                        Cell cll = sheet.getFirstCell(cb2, false);
                        if (!(cll == null || excludeHidden && cll.isHidden() || excludeSubTotal && cll.hasSubTotalMethod())) {
                            ExcelFuncProvider.statCell(cll, sum, count, max, min, product, stdev, number, one, onlyNumber, statCount);
                        }
                    } else {
                        Sheet.ICellsIterator ci = sheet.getCellsIterator(cb2, false, true);
                        while (ci.hasNext()) {
                            Cell cll = ci.next();
                            if (excludeHidden && cll.isHidden() || excludeSubTotal && cll.hasSubTotalMethod()) continue;
                            ExcelFuncProvider.statCell(cll, sum, count, max, min, product, stdev, number, one, onlyNumber, statCount);
                        }
                    }
                    ++sht;
                }
                continue;
            }
            if (arg.isArray()) {
                ExcelFuncProvider.statArrayVar(arg, stats, excludeHidden, onlyNumber);
                continue;
            }
            if (arg.isObject() && arg.getValue() instanceof ExtGroup) {
                ExtGroup group = (ExtGroup)arg.getValue();
                Variant[] values = group.getValues();
                if (values == null) continue;
                ExcelFuncProvider.statArray(values, group.getValueFrom(), group.getValueTo(), stats, excludeHidden, onlyNumber);
                continue;
            }
            boolean isNumber = arg.isNumeric(number);
            if (isNumber && !arg.isNull()) {
                ExcelFuncProvider.statOne(arg, number, sum, count, max, min, product, stdev, one, isNumber);
                continue;
            }
            if (onlyNumber) continue;
            ExcelFuncProvider.statOne(arg, arg, sum, count, max, min, product, stdev, one, isNumber);
        }
    }

    private void sumProduct(Object[] objs, Variant[] stats, boolean excludeHidden, boolean onlyNumber, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant number = Variant.getNewEmptyVariant();
        Variant sum = stats[0];
        boolean isBlock = false;
        int wBlock = 0;
        int hBlock = 0;
        block0: for (int i = 0; i < objs.length; ++i) {
            Variant arg = (Variant)objs[i];
            if (arg.isError()) {
                throw (SyntaxErrorException)arg.getValue();
            }
            Object obj = arg.getValue();
            while (true) {
                if (obj instanceof CellBlock) {
                    CellBlock cb = (CellBlock)obj;
                    if (i == 0) {
                        isBlock = true;
                        wBlock = cb.getWidth();
                        hBlock = cb.getHeight();
                        continue block0;
                    }
                    if (isBlock && wBlock == cb.getWidth() && hBlock == cb.getHeight()) continue block0;
                    ExprErr.goError(16L, null);
                    continue block0;
                }
                if (!(obj instanceof Variant[])) break;
                arg = ((Variant[])obj)[0];
                objs[i] = arg;
                obj = arg.getValue();
            }
            if (i == 0) {
                isBlock = false;
            } else if (isBlock) {
                ExprErr.goError(16L, null);
            }
            if (!arg.isNumeric(number)) continue;
            ExcelFuncProvider.statOne(arg, number, sum, null, null, null, null, null, null, true);
        }
        if (!isBlock) {
            return;
        }
        CellIteratorWrap[] cells = new CellIteratorWrap[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            CellBlockNode cb = (CellBlockNode)((Variant)objs[i]).getValue();
            Book book = cb.getSheet().getBook();
            Sheet sheet = book.getSheet(cb.getSheet().getSheetIndex());
            cells[i] = new CellIteratorWrap(sheet.getCellsIterator(cb, false, true), cb);
        }
        CellIteratorWrap curCells = cells[0];
        while (curCells.hasNext()) {
            Cell cell = curCells.next();
            Variant value = cell.getValue();
            Variant product = stats[4];
            value.isNumeric(product);
            int pos = curCells.getCellPosition();
            for (int i = 1; i < objs.length; ++i) {
                cell = cells[i].getCell(pos);
                if (cell == null) {
                    product = null;
                    break;
                }
                value = cell.getValue();
                if (value.isNull()) {
                    product = null;
                    break;
                }
                if (!value.isNumeric(number)) {
                    product = null;
                    break;
                }
                ExcelFuncProvider.statOne(value, number, null, null, null, null, product, null, null, true);
            }
            if (product == null || !product.isNumeric(number)) continue;
            ExcelFuncProvider.statOne(product, number, sum, null, null, null, null, null, null, true);
        }
    }

    private static void statCell(Cell cll, Variant sum, Variant count, Variant max, Variant min, Variant product, Variant stdev, Variant number, Variant one, boolean onlyNumber, boolean statCount) throws SyntaxErrorException {
        Variant value = ExcelFuncProvider._getValidCellValue(cll);
        if (value.isNumeric(number) && !value.isNull()) {
            ExcelFuncProvider.statOne(value, number, sum, count, max, min, product, stdev, one, true);
        } else if (!onlyNumber) {
            if (value.getVt() == 8 && value.booleanValue()) {
                if (sum != null) {
                    sum.add(one);
                }
                if (max != null && one.compareTo(max) > 0) {
                    max.setVariant(one);
                }
                if (min != null && one.compareTo(min) < 0) {
                    min.setVariant(one);
                }
                if (stdev != null) {
                    stdev.add(one);
                }
            }
            if (statCount && !value.isNull()) {
                count.add(one);
            }
        }
    }

    private static void statArrayVar(Variant var, Variant[] stats, boolean excludeHidden, boolean onlyNumber) throws SyntaxErrorException {
        Variant[] vars = (Variant[])var.getValue();
        ExcelFuncProvider.statArray(vars, 0, vars.length, stats, excludeHidden, onlyNumber);
    }

    private static void statArray(Variant[] vars, int from, int to, Variant[] stats, boolean excludeHidden, boolean onlyNumber) throws SyntaxErrorException {
        Object[] objOne = new Object[]{null};
        for (int i = from; i < to; ++i) {
            Variant v = vars[i];
            Object obj = v.getValue();
            if (obj instanceof ExtGroup) {
                ExtGroup grp = (ExtGroup)obj;
                if (grp.isNullGroup()) continue;
                objOne[0] = grp.getFirstValue();
            } else {
                objOne[0] = v;
            }
            ExcelFuncProvider.stat(objOne, stats, excludeHidden, onlyNumber, false);
        }
    }

    private static void statOne(Variant oriValue, Variant var, Variant sum, Variant count, Variant max, Variant min, Variant product, Variant stdev, Variant one, boolean isNumber) throws SyntaxErrorException {
        if (isNumber) {
            if (sum != null) {
                sum.add(var);
            }
            if (product != null) {
                product.multiply(var);
            }
            if (count != null && !oriValue.isNull()) {
                count.add(one);
            }
            if (max != null && var.compareTo(max) > 0) {
                max.setVariant(var);
            }
            if (min != null && var.compareTo(min) < 0) {
                min.setVariant(var);
            }
            if (stdev != null) {
                Variant tmp = Variant.getNewEmptyVariant();
                var.multiply(var, tmp);
                stdev.add(tmp);
            }
        } else {
            if (var.getVt() == 8 && var.booleanValue()) {
                if (sum != null) {
                    sum.add(one);
                }
                if (max != null && one.compareTo(max) > 0) {
                    max.setVariant(one);
                }
                if (min != null && one.compareTo(min) < 0) {
                    min.setVariant(one);
                }
                if (stdev != null) {
                    stdev.add(one);
                }
            }
            if (count != null) {
                count.add(one);
            }
        }
    }

    private Variant sum(Object[] args, boolean hidden, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant sum;
        Variant[] stats = new Variant[6];
        stats[0] = sum = ExcelFuncProvider.decimalValue(0.0);
        ExcelFuncProvider.stat(args, stats, hidden, true, excludeSubTotal);
        ExcelFuncProvider.reduceScale(sum);
        return sum;
    }

    private static void reduceScale(Variant var) {
        if (var.getVt() == 10) {
            BigDecimal bd = (BigDecimal)var.getValue();
            if (bd.scale() > 16) {
                bd = bd.setScale(16, 4);
                var.setObject(bd, 10);
            }
            Util.reduceScale(var);
        }
    }

    public Variant SUM(Object[] args) throws SyntaxErrorException {
        return this.sum(args, false, false);
    }

    public Variant SumProduct(Object[] args) throws SyntaxErrorException {
        Variant sum;
        Variant[] stats = new Variant[6];
        stats[0] = sum = ExcelFuncProvider.decimalValue(0.0);
        stats[4] = Variant.getNewEmptyVariant();
        this.sumProduct(args, stats, false, true, false);
        return sum;
    }

    private static Variant max(Object[] args, boolean hidden, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant max;
        Variant[] stats = new Variant[6];
        stats[2] = max = new Variant(-1.7976931348623157E308);
        ExcelFuncProvider.stat(args, stats, hidden, true, excludeSubTotal);
        if (ArrayUtil.isEqual((Double)max.doubleValue(), (Double)-1.7976931348623157E308)) {
            max.setDouble(0.0);
        }
        return ExcelFuncProvider.decimalValue(max);
    }

    public static Variant MAX(Object[] args) throws SyntaxErrorException {
        return ExcelFuncProvider.max(args, false, false);
    }

    private static Variant min(Object[] args, boolean hidden, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant min;
        Variant[] stats = new Variant[6];
        stats[3] = min = new Variant((double)Double.MAX_VALUE);
        ExcelFuncProvider.stat(args, stats, hidden, true, excludeSubTotal);
        if (ArrayUtil.isEqual((Double)min.doubleValue(), (Double)Double.MAX_VALUE)) {
            min.setDouble(0.0);
        }
        return ExcelFuncProvider.decimalValue(min);
    }

    public static Variant MIN(Object[] args) throws SyntaxErrorException {
        return ExcelFuncProvider.min(args, false, false);
    }

    private Variant count(Object[] args, boolean hidden, boolean onlyNumber, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant count;
        Variant[] stats = new Variant[6];
        stats[1] = count = ExcelFuncProvider.decimalValue(0.0);
        ExcelFuncProvider.stat(args, stats, hidden, onlyNumber, excludeSubTotal);
        return count;
    }

    public Variant COUNT(Object[] args) throws SyntaxErrorException {
        return this.count(args, false, true, false);
    }

    public Variant COUNTA(Object[] args) throws SyntaxErrorException {
        return this.count(args, false, false, false);
    }

    private Variant average(Object[] args, boolean hidden, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant[] stats = new Variant[6];
        Variant count = ExcelFuncProvider.decimalValue(0.0);
        Variant sum = ExcelFuncProvider.decimalValue(0.0);
        stats[1] = count;
        stats[0] = sum;
        ExcelFuncProvider.stat(args, stats, hidden, true, excludeSubTotal);
        if (count.longValue() == 0L) {
            return count;
        }
        sum.divide(count);
        return sum;
    }

    public Variant AVERAGE(Object[] args) throws SyntaxErrorException {
        return this.average(args, false, false);
    }

    public Variant AMAX(Object[] args) throws SyntaxErrorException {
        return this._arrayStat(args, true);
    }

    public Variant AMIN(Object[] args) throws SyntaxErrorException {
        return this._arrayStat(args, false);
    }

    private Variant _arrayStat(Object[] args, boolean bMax) throws SyntaxErrorException {
        Object[] array;
        Variant var;
        int i;
        ExcelFuncProvider.validParamCount(args, 2, Integer.MAX_VALUE);
        int stdArraySize = -1;
        for (i = 0; i < args.length; ++i) {
            var = (Variant)args[i];
            if (!var.isArray()) continue;
            array = (Variant[])var.getValue();
            if (stdArraySize < 0) {
                stdArraySize = array.length;
                continue;
            }
            if (array.length == stdArraySize) continue;
            ExprErr.goError(16L, "Array Size Not Equal");
        }
        if (stdArraySize < 0) {
            ExprErr.goError(16L, "No Array");
        } else {
            for (i = 0; i < args.length; ++i) {
                var = (Variant)args[i];
                if (var.isArray()) continue;
                array = new Variant[stdArraySize];
                Arrays.fill(array, var);
                args[i] = new Variant(array, 527);
            }
        }
        if (stdArraySize <= 0) {
            return Variant.nullVariant;
        }
        Variant varRet = (Variant)args[0];
        Variant[] first = (Variant[])varRet.getValue();
        Object[] params = new Object[args.length];
        for (int i2 = 0; i2 < stdArraySize; ++i2) {
            for (int j = 0; j < params.length; ++j) {
                params[j] = ((Variant[])((Variant)args[j]).getValue())[i2];
            }
            first[i2] = bMax ? ExcelFuncProvider.MAX(params) : ExcelFuncProvider.MIN(params);
        }
        return varRet;
    }

    public Variant MEDIAN(Object[] args) throws SyntaxErrorException {
        Variant ret;
        ObjectArray values = this._collectD1Numbers(args, 0, args.length, 0, true);
        if (values.isEmpty()) {
            ExprErr.goError(64L, null);
        }
        Arrays.sort(values.getArray(), 0, values.size());
        int len = values.size();
        Object[] array = values.getArray();
        if ((len & 1) != 0) {
            ret = (Variant)array[len >> 1];
        } else {
            int i = len >> 1;
            ret = Variant.getNewEmptyVariant();
            ((Variant)array[i]).add((Variant)array[i - 1], ret);
            ret.divide(Variant.twoVariant);
        }
        return ret;
    }

    private ObjectArray _collectD1Numbers(Object[] args, int from, int to, int rowcol, boolean skipNotNumber) throws SyntaxErrorException {
        ObjectArray array = new ObjectArray(to - from);
        Variant number = null;
        for (int i = from; i < to; ++i) {
            CellBlockNode cb;
            Variant arg = (Variant)args[i];
            if (arg.isError()) {
                throw (SyntaxErrorException)arg.getValue();
            }
            Object obj = arg.getValue();
            Book book = null;
            int sht = 0;
            int shtEnd = -1;
            if (obj instanceof CellBlock3DNode) {
                cb = (CellBlock3DNode)obj;
                book = cb.getSheet().getBook();
                sht = cb.getSheet().getSheetIndex();
                shtEnd = ((CellBlock3DNode)cb).getSheet2().getSheetIndex();
            } else if (obj instanceof CellBlockNode) {
                cb = (CellBlockNode)obj;
                book = cb.getSheet().getBook();
                sht = shtEnd = cb.getSheet().getSheetIndex();
            }
            if (book != null) {
                while (sht <= shtEnd) {
                    Sheet sheet = book.getSheet(sht);
                    CellBlock cb2 = (CellBlock)obj;
                    if (cb2.isSingleCell()) {
                        Cell cll = sheet.getFirstCell(cb2, false);
                        if (cll == null) {
                            throw new SyntaxErrorException(64L, null);
                        }
                        number = this._appendNumber(array, ExcelFuncProvider._getValidCellValue(cll), number, skipNotNumber);
                    } else {
                        CellBlock block;
                        if (rowcol == 0) {
                            block = cb2;
                        } else {
                            block = (CellBlock)cb2.clone();
                            if (rowcol == 1) {
                                block.setRow2(block.getRow());
                            } else {
                                block.setCol2(block.getCol());
                            }
                        }
                        if (skipNotNumber) {
                            Sheet.ICellsIterator ci = sheet.getCellsIterator(block, false, true);
                            while (ci.hasNext()) {
                                number = this._appendNumber(array, ExcelFuncProvider._getValidCellValue(ci.next()), number, skipNotNumber);
                            }
                        } else {
                            int cStart = block.getCol();
                            int cEnd = block.getCol2() + 1;
                            int rEnd = block.getRow2() + 1;
                            for (int r = block.getRow(); r < rEnd; ++r) {
                                Row rowObj = sheet.getRow(r, false);
                                if (rowObj == null) {
                                    throw new SyntaxErrorException(64L, null);
                                }
                                for (int c = cStart; c < cEnd; ++c) {
                                    Cell cll = rowObj.getCell(c, false);
                                    if (cll == null) {
                                        throw new SyntaxErrorException(64L, null);
                                    }
                                    number = this._appendNumber(array, ExcelFuncProvider._getValidCellValue(cll), number, skipNotNumber);
                                }
                            }
                        }
                    }
                    ++sht;
                }
                continue;
            }
            if (arg.isArray()) {
                Variant[] vars = (Variant[])arg.getValue();
                for (int j = 0; j < vars.length; ++j) {
                    number = this._appendNumber(array, vars[j], number, skipNotNumber);
                }
                continue;
            }
            if (arg.isObject() && arg.getValue() instanceof ExtGroup) {
                ExtGroup group = (ExtGroup)arg.getValue();
                Variant[] values = group.getValues();
                int jEnd = group.getValueTo();
                for (int j = group.getValueFrom(); j < jEnd; ++j) {
                    number = this._appendNumber(array, values[j], number, skipNotNumber);
                }
                continue;
            }
            number = this._appendNumber(array, arg, number, skipNotNumber);
        }
        return array;
    }

    public static Variant[][] collectD2Numbers(Variant arg, boolean skipNotNumber) throws SyntaxErrorException {
        return ExcelFuncProvider.collectD2Numbers(arg, skipNotNumber, true);
    }

    public static Variant[][] collectD2Numbers(Variant arg, boolean skipNotNumber, boolean nullToZero) throws SyntaxErrorException {
        Variant[][] array;
        if (arg.isError()) {
            throw (SyntaxErrorException)arg.getValue();
        }
        Object obj = arg.getValue();
        CellBlockNode cb = null;
        if (obj instanceof CellBlockNode) {
            cb = (CellBlockNode)obj;
        }
        if (cb != null) {
            int height = cb.getHeight();
            int width = cb.getWidth();
            array = new Variant[height][width];
            Sheet sheet = cb.getSheet();
            int colStart = cb.getCol();
            int r = cb.getRow();
            int i = 0;
            while (i < height) {
                Variant[] line = array[i];
                Row rowObj = sheet.getRow(r, false);
                if (rowObj != null) {
                    int c = colStart;
                    int j = 0;
                    while (j < width) {
                        Cell cll = rowObj.getCell(c, false);
                        line[j] = ExcelFuncProvider.getCellNumber(cll, skipNotNumber, nullToZero);
                        ++j;
                        ++c;
                    }
                } else if (skipNotNumber) {
                    int j;
                    if (nullToZero) {
                        for (j = 0; j < width; ++j) {
                            line[j] = new Variant(Variant.zeroVariant);
                        }
                    } else {
                        for (j = 0; j < width; ++j) {
                            line[j] = new Variant(Variant.emptyVariant);
                        }
                    }
                } else {
                    ExprErr.goError(64L, null);
                }
                ++i;
                ++r;
            }
        } else if (arg.isArray()) {
            if (obj instanceof Variant[][]) {
                Variant[][] src = (Variant[][])obj;
                int rows = src.length;
                int cols = src[0].length;
                array = new Variant[rows][cols];
                for (int i = 0; i < rows; ++i) {
                    Variant[] srcLine = src[i];
                    Variant[] dstLine = array[i];
                    for (int j = 0; j < cols; ++j) {
                        dstLine[j] = ExcelFuncProvider.getNumber(srcLine[j], skipNotNumber, nullToZero);
                    }
                }
            } else {
                Variant[] src = (Variant[])obj;
                int rows = src.length;
                Variant varLine = src[0];
                if (varLine.isArray()) {
                    int cols = ((Variant[])varLine.getValue()).length;
                    array = new Variant[rows][cols];
                    for (int i = 0; i < rows; ++i) {
                        Variant[] srcLine = (Variant[])src[i].getValue();
                        Variant[] dstLine = array[i];
                        for (int j = 0; j < cols; ++j) {
                            dstLine[j] = ExcelFuncProvider.getNumber(srcLine[j], skipNotNumber, nullToZero);
                        }
                    }
                } else {
                    array = new Variant[rows][1];
                    for (int i = 0; i < rows; ++i) {
                        array[i][0] = ExcelFuncProvider.getNumber(src[i], skipNotNumber, nullToZero);
                    }
                }
            }
        } else if (arg.isObject() && obj instanceof ExtGroup) {
            ExtGroup group = (ExtGroup)arg.getValue();
            Variant[] values = group.getValues();
            int rows = values.length;
            array = new Variant[rows][1];
            for (int i = 0; i < rows; ++i) {
                array[i][0] = ExcelFuncProvider.getNumber(values[i], skipNotNumber, nullToZero);
            }
        } else {
            array = new Variant[][]{{ExcelFuncProvider.getNumber(arg, skipNotNumber, nullToZero)}};
        }
        return array;
    }

    public static Variant getCellNumber(Cell cll, boolean skipNotNumber) throws SyntaxErrorException {
        return ExcelFuncProvider.getCellNumber(cll, skipNotNumber, true);
    }

    public static Variant getCellNumber(Cell cll, boolean skipNotNumber, boolean nullToZero) throws SyntaxErrorException {
        return cll == null ? ExcelFuncProvider.getNumber(null, skipNotNumber, nullToZero) : ExcelFuncProvider.getNumber(ExcelFuncProvider._getValidCellValue(cll), skipNotNumber, nullToZero);
    }

    public static Variant getNumber(Variant value, boolean skipNotNumber) throws SyntaxErrorException {
        return ExcelFuncProvider.getNumber(value, skipNotNumber, true);
    }

    public static Variant getNumber(Variant value, boolean skipNotNumber, boolean nullToZero) throws SyntaxErrorException {
        Variant number = null;
        if (value == null) {
            if (skipNotNumber) {
                number = nullToZero ? new Variant(Variant.zeroVariant) : new Variant(Variant.emptyVariant);
            } else {
                ExprErr.goError(64L, null);
            }
        } else {
            number = new Variant();
            if (!value.isNumeric(number)) {
                if (skipNotNumber) {
                    number = nullToZero ? new Variant(Variant.zeroVariant) : new Variant(Variant.emptyVariant);
                } else {
                    ExprErr.goError(64L, null);
                }
            }
        }
        return number;
    }

    private Variant _appendNumber(ObjectArray array, Variant value, Variant number, boolean skipNotNumber) throws SyntaxErrorException {
        if (number == null) {
            number = Variant.getNewEmptyVariant();
        }
        if (value.isNumeric(number)) {
            array.append(number);
            number = null;
        } else if (!skipNotNumber) {
            ExprErr.goError(64L, null);
        }
        return number;
    }

    private static Variant _getValidCellValue(Cell cll) throws SyntaxErrorException {
        Variant value;
        if (cll.isQueueLast()) {
            throw SyntaxErrorException.CALC_LAST;
        }
        if (cll.isNeedRecalc() || !cll.isHasValue()) {
            cll.getSheet().getDeps().calcReferTo(null, cll);
        }
        if ((value = cll.getValue()).isError()) {
            throw (SyntaxErrorException)value.getValue();
        }
        return value;
    }

    private Variant product(Object[] args, boolean hidden, boolean excludeSubTotal) throws SyntaxErrorException {
        Variant[] stats = new Variant[6];
        Variant count = ExcelFuncProvider.decimalValue(0.0);
        Variant product = ExcelFuncProvider.decimalValue(1.0);
        stats[1] = count;
        stats[4] = product;
        ExcelFuncProvider.stat(args, stats, hidden, true, excludeSubTotal);
        if (count.longValue() == 0L) {
            return count;
        }
        return product;
    }

    public Variant PRODUCT(Object[] args) throws SyntaxErrorException {
        return this.product(args, false, false);
    }

    public Variant STDEV(Object[] args) throws SyntaxErrorException {
        Variant stdev = this.var(args, false, true, false);
        return ExcelFuncProvider.decimalValue(Math.sqrt(stdev.doubleValue()));
    }

    public Variant STDEVP(Object[] args) throws SyntaxErrorException {
        Variant stdev = this.var(args, false, true, true);
        return ExcelFuncProvider.decimalValue(Math.sqrt(stdev.doubleValue()));
    }

    private Variant var(Object[] args, boolean hidden, boolean onlyNumber, boolean varp) throws SyntaxErrorException {
        Variant[] stats = new Variant[6];
        Variant count = ExcelFuncProvider.decimalValue(0.0);
        Variant sum = ExcelFuncProvider.decimalValue(0.0);
        Variant stdev = ExcelFuncProvider.decimalValue(0.0);
        stats[1] = count;
        stats[0] = sum;
        stats[5] = stdev;
        ExcelFuncProvider.stat(args, stats, hidden, onlyNumber, false);
        stdev.multiply(count);
        sum.multiply(sum);
        stdev.subtract(sum);
        stdev.divide(count);
        if (!varp) {
            count.subtract(ExcelFuncProvider.decimalValue(1.0));
        }
        stdev.divide(count);
        return stdev;
    }

    public Variant VAR(Object[] args) throws SyntaxErrorException {
        return this.var(args, false, true, false);
    }

    public Variant VARA(Object[] args) throws SyntaxErrorException {
        return this.var(args, false, false, false);
    }

    public Variant VARP(Object[] args) throws SyntaxErrorException {
        return this.var(args, false, false, true);
    }

    public Variant COVAR(Object[] args) throws SyntaxErrorException {
        Object[] rets = new Object[4];
        this._vars(args, rets);
        Variant[] array = (Variant[])rets[0];
        Variant[] array2 = (Variant[])rets[1];
        Variant u = (Variant)rets[2];
        Variant u2 = (Variant)rets[3];
        Variant x = Variant.getNewEmptyVariant();
        Variant y = Variant.getNewEmptyVariant();
        Variant sum = ExcelFuncProvider.decimalValue(0.0);
        for (int i = 0; i < array.length; ++i) {
            array[i].subtract(u, x);
            array2[i].subtract(u2, y);
            x.multiply(y);
            sum.add(x);
        }
        sum.divide(ExcelFuncProvider.decimalValue(array.length));
        return sum;
    }

    public Variant CORREL(Object[] args) throws SyntaxErrorException {
        Object[] rets = new Object[4];
        this._vars(args, rets);
        Variant[] array = (Variant[])rets[0];
        Variant[] array2 = (Variant[])rets[1];
        Variant u = (Variant)rets[2];
        Variant u2 = (Variant)rets[3];
        Variant x = Variant.getNewEmptyVariant();
        Variant y = Variant.getNewEmptyVariant();
        Variant d = Variant.getNewEmptyVariant();
        Variant sumD = ExcelFuncProvider.decimalValue(0.0);
        Variant sumX = ExcelFuncProvider.decimalValue(0.0);
        Variant sumY = ExcelFuncProvider.decimalValue(0.0);
        for (int i = 0; i < array.length; ++i) {
            array[i].subtract(u, x);
            array2[i].subtract(u2, y);
            x.multiply(y, d);
            sumD.add(d);
            x.multiply(x);
            sumX.add(x);
            y.multiply(y);
            sumY.add(y);
        }
        sumX.multiply(sumY);
        double df = Math.sqrt(sumX.doubleValue());
        sumX = ExcelFuncProvider.decimalValue(df);
        sumD.divide(sumX);
        return sumD;
    }

    public Variant PEARSON(Object[] args) throws SyntaxErrorException {
        Object[] rets = new Object[4];
        this._vars(args, rets);
        Variant[] array = (Variant[])rets[0];
        Variant[] array2 = (Variant[])rets[1];
        Variant u = (Variant)rets[2];
        Variant u2 = (Variant)rets[3];
        Variant x = Variant.getNewEmptyVariant();
        Variant y = Variant.getNewEmptyVariant();
        Variant xy = Variant.getNewEmptyVariant();
        Variant sumXY = ExcelFuncProvider.decimalValue(0.0);
        Variant sumX = ExcelFuncProvider.decimalValue(0.0);
        Variant sumY = ExcelFuncProvider.decimalValue(0.0);
        for (int i = 0; i < array.length; ++i) {
            array[i].subtract(u, x);
            array2[i].subtract(u2, y);
            x.multiply(y, xy);
            sumXY.add(xy);
            x.multiply(x);
            sumX.add(x);
            y.multiply(y);
            sumY.add(y);
        }
        sumX.multiply(sumY);
        sumX = ExcelFuncProvider.decimalValue(Math.sqrt(sumX.doubleValue()));
        sumXY.divide(sumX);
        return sumXY;
    }

    public Variant RSQ(Object[] args) throws SyntaxErrorException {
        Variant x = this.PEARSON(args);
        x.multiply(x);
        return x;
    }

    public Variant SUMX2MY2(Object[] args) throws SyntaxErrorException {
        Object[] rets = new Object[4];
        this._vars(args, rets);
        Variant[] array = (Variant[])rets[0];
        Variant[] array2 = (Variant[])rets[1];
        Variant x = Variant.getNewEmptyVariant();
        Variant y = Variant.getNewEmptyVariant();
        Variant sum = ExcelFuncProvider.decimalValue(0.0);
        for (int i = 0; i < array.length; ++i) {
            array[i].multiply(array[i], x);
            array2[i].multiply(array2[i], y);
            x.subtract(y);
            sum.add(x);
        }
        return sum;
    }

    private void _vars(Object[] args, Object[] rets) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 2);
        Object[] array = null;
        Object[] array2 = null;
        Object var = (Variant)args[0];
        Variant var2 = (Variant)args[1];
        if (((Variant)var).isNull() || var2.isNull()) {
            ExprErr.goError(2L, null);
        }
        rets[0] = array = this._getArrayData((Variant)var);
        rets[1] = array2 = this._getArrayData(var2);
        if (array == null || array2 == null || array.length == 0 || array2.length == 0) {
            throw new SyntaxErrorException(64L, null);
        }
        if (array.length != array2.length) {
            ExprErr.goError(524288L, null);
        }
        Variant x = Variant.getNewEmptyVariant();
        Variant y = Variant.getNewEmptyVariant();
        if (array.length > 1) {
            int count = 0;
            for (int i = 0; i < array.length; ++i) {
                if (!((Variant)array[i]).isNumeric(x) || !((Variant)array2[i]).isNumeric(y)) {
                    array[i] = null;
                    continue;
                }
                array[i] = x;
                array2[i] = y;
                x = Variant.getNewEmptyVariant();
                y = Variant.getNewEmptyVariant();
                ++count;
            }
            if (count < array.length) {
                Variant[] newArray = new Variant[count];
                Variant[] newArray2 = new Variant[count];
                int n = 0;
                for (int i = 0; i < array.length; ++i) {
                    var = array[i];
                    if (var == null) continue;
                    newArray[n] = var;
                    newArray2[n++] = array2[i];
                }
                array = newArray;
                rets[0] = newArray;
                array2 = newArray2;
                rets[1] = newArray2;
            }
        }
        if (array.length > 1) {
            rets[2] = this.AVERAGE(array);
            rets[3] = this.AVERAGE(array2);
        } else {
            if (!array[0].isNumeric(x) || !array2[0].isNumeric(y)) {
                ExprErr.goError(64L, null);
            }
            rets[2] = x;
            rets[3] = y;
        }
    }

    private Variant[] _getArrayData(Variant var) throws SyntaxErrorException {
        Variant[] array = null;
        if (var.isReferences()) {
            Object obj = var.getValue();
            if (obj instanceof CellBlockNode) {
                CellBlockNode cb = (CellBlockNode)obj;
                Sheet sheet = cb.getSheet();
                int height = cb.getHeight();
                int width = cb.getWidth();
                if (height > sheet.getMaxRowIndex() || width > sheet.getMaxColIndex()) {
                    ExprErr.goError(1024L, null);
                }
                array = new Variant[height * width];
                int rEnd = cb.getRow2() + 1;
                int i = 0;
                for (int r = cb.getRow(); r < rEnd; ++r) {
                    Row rowObj = sheet.getRow(r, false);
                    int cEnd = cb.getCol2() + 1;
                    for (int c = cb.getCol(); c < cEnd; ++c) {
                        Variant value;
                        Cell cll = sheet.getCell(rowObj, c, false);
                        array[i++] = cll == null || (value = cll.getValue()).isNull() ? Variant.emptyVariant : value;
                    }
                }
            }
        } else {
            Variant number;
            array = var.isArray() ? (Variant[])var.getValue() : (var.isNumeric(number = Variant.getNewEmptyVariant()) ? new Variant[]{number} : new Variant[]{});
        }
        return array;
    }

    public Variant VALUE(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant ret;
        ExcelFuncProvider.validParamCount(args, 0, 1);
        if (args.length == 0) {
            return ctx.getExprOwner().getValue();
        }
        Variant var = (Variant)args[0];
        Object obj = var.getValue();
        if (var.isReferences() && obj instanceof CellBlockNode) {
            ret = var.getVariant();
            if (ret.isObject() && (obj = ret.getValue()) instanceof CellBlockNode) {
                CellBlockNode cb = (CellBlockNode)obj;
                Cell cll = cb.getFirstCell(false);
                ret = cll == null ? Variant.nullVariant : cll.getValue();
            }
        } else {
            BigDecimal bd = new BigDecimal(var.toString());
            ret = new Variant(bd, 10);
        }
        return ret;
    }

    public Variant SUBTOTAL(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant var;
        int fnNum;
        ExcelFuncProvider.validParamCount(args, 2, 64);
        boolean excludeHidden = false;
        Variant var2 = (Variant)args[0];
        Variant varTrans = Variant.getNewEmptyVariant();
        if (!var2.isNumeric(varTrans)) {
            ExprErr.goError(16L, "Function Number");
        }
        if ((fnNum = varTrans.intValue()) < 1 || fnNum > 11 && fnNum < 101 || fnNum > 111) {
            ExprErr.goError(16L, "Function Number");
        }
        if (fnNum > 11) {
            excludeHidden = true;
            fnNum -= 100;
        }
        excludeHidden |= ctx.isExcludeHidden();
        for (int i = 1; i < args.length; ++i) {
            Object obj = ((Variant)args[i]).getValue();
            if (obj instanceof CellBlockNode && !(obj instanceof CellBlock3DNode)) continue;
            ExprErr.goError(16L, "Not Range");
        }
        Object[] pureArgs = new Object[args.length - 1];
        System.arraycopy(args, 1, pureArgs, 0, pureArgs.length);
        switch (fnNum) {
            case 1: {
                var = this.average(pureArgs, excludeHidden, true);
                break;
            }
            case 2: {
                var = this.count(pureArgs, excludeHidden, true, true);
                break;
            }
            case 3: {
                var = this.count(pureArgs, excludeHidden, false, true);
                break;
            }
            case 4: {
                var = ExcelFuncProvider.max(pureArgs, excludeHidden, true);
                break;
            }
            case 5: {
                var = ExcelFuncProvider.min(pureArgs, excludeHidden, true);
                break;
            }
            case 6: {
                var = this.product(pureArgs, excludeHidden, true);
                break;
            }
            case 7: 
            case 8: {
                var = this.var(pureArgs, excludeHidden, true, fnNum == 8);
                double df = var.doubleValue();
                var.setObject(BigDecimal.valueOf(Math.sqrt(df)), 10);
                break;
            }
            case 9: {
                var = this.sum(pureArgs, excludeHidden, true);
                break;
            }
            case 10: {
                var = this.var(pureArgs, excludeHidden, true, false);
                break;
            }
            default: {
                var = this.var(pureArgs, excludeHidden, true, true);
            }
        }
        return var;
    }

    public Variant SUMIF(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 3);
        Variant sum = ExcelFuncProvider.decimalValue(0.0);
        Object sumRange = args.length == 3 ? args[2] : args[0];
        this._statif(ctx, sumRange, args, 0, 2, sum, null);
        return sum;
    }

    public Variant COUNTIF(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 2);
        Variant count = ExcelFuncProvider.decimalValue(0.0);
        this._statif(ctx, args[0], args, 0, args.length, null, count);
        return count;
    }

    public Variant SUMIFS(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 3, 255);
        Variant sum = ExcelFuncProvider.decimalValue(0.0);
        this._statif(ctx, args[0], args, 1, args.length, sum, null);
        return sum;
    }

    public Variant COUNTIFS(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, 255);
        Variant count = ExcelFuncProvider.decimalValue(0.0);
        this._statif(ctx, args[0], args, 0, args.length, null, count);
        return count;
    }

    private void _statif(ExprContext ctx, Object sumRangeObj, Object[] args, int start, int end, Variant varSum, Variant varCount) throws SyntaxErrorException {
        int criterias = end - start;
        if ((criterias & 1) == 1) {
            ExprErr.goError(8L, "Param odd");
        }
        CellBlockNode sumRange = ExcelFuncProvider.cellblockValue((Variant)sumRangeObj, "range");
        Sheet[] criteriaSheet = new Sheet[criterias / 2];
        int sheetIndex = 0;
        int[] criteriaOffsets = new int[criterias];
        int width = sumRange.getWidth();
        int height = sumRange.getHeight();
        int row = sumRange.getRow();
        int col = sumRange.getCol();
        int off = 0;
        for (int i = start; i < end; i += 2) {
            CellBlockNode range = ExcelFuncProvider.cellblockValue((Variant)args[i], "range");
            if (width != range.getWidth() || height != range.getHeight()) {
                throw new SyntaxErrorException(16L, "range shape");
            }
            criteriaSheet[sheetIndex++] = range.getSheet();
            criteriaOffsets[off++] = range.getCol() - col;
            criteriaOffsets[off++] = range.getRow() - row;
        }
        String strNode = SheetBaseMath.getBlockA1Name(1048575, 65535, true, true);
        Sheet sheet = sumRange.getSheet();
        Sheet formulaSheet = null;
        String criteria = null;
        boolean isMatchEmpty = true;
        Object[] criteriaExprs = new Object[criterias];
        int e = 0;
        for (int i = start + 1; i < end; i += 2) {
            int compareString = 0;
            Object obj = ((Variant)args[i]).getValue();
            if (obj instanceof CellBlockNode) {
                Cell cll;
                CellBlockNode cb = (CellBlockNode)obj;
                if (!cb.isSingleCell()) {
                    ExprErr.goError(16L, cb.getBlockName(true, (Cell)null) + " not cell");
                }
                if ((cll = cb.getFirstCell(false)) != null) {
                    String tempCri;
                    criteria = cll.getFormula();
                    formulaSheet = cll.getSheet();
                    if (!StringUtil.isEmptyString((String)criteria) && !criteria.equals(tempCri = this.parseCriteria(criteria, true))) {
                        compareString = 1;
                        criteria = tempCri;
                    }
                }
            } else if (obj instanceof Variant[]) {
                Variant[] array = (Variant[])obj;
                StringBuilder builder = new StringBuilder();
                builder.append(strNode).append(',');
                for (int n = 0; n < array.length; ++n) {
                    String temp = array[n].toString();
                    builder.append('\"');
                    builder.append(temp);
                    builder.append('\"');
                    if (n >= array.length - 1) continue;
                    builder.append(',');
                }
                builder.append(")");
                builder.insert(0, "=IN(");
                criteria = builder.toString();
                compareString = 2;
            } else {
                criteria = obj.toString();
                if (!StringUtil.isEmptyString((String)criteria)) {
                    if (!StringUtil.isNumber((String)criteria) && this.isRegex(this.transfer2ExcelRegex(criteria))) {
                        compareString = 3;
                        criteria = "=REGEX(" + strNode + ",\"" + this.transfer2ExcelRegex(criteria) + "\")";
                    } else {
                        String tempCri = this.parseCriteria(criteria, false);
                        if (!criteria.equals(tempCri)) {
                            compareString = 1;
                            criteria = tempCri;
                        }
                    }
                } else {
                    compareString = 1;
                    criteria = "=\"\"";
                }
            }
            if (StringUtil.isEmptyString((String)criteria)) {
                return;
            }
            String formula = compareString == 1 ? "LOWER(" + strNode + ")" + criteria : (compareString == 0 ? strNode + criteria : criteria);
            Expr expr = null;
            expr = formulaSheet != null ? formulaSheet.getExpr(null, formula) : sheet.getExpr(null, formula);
            if (expr.isSyntaxError()) {
                return;
            }
            if (null != varCount) {
                Expr pr = null;
                pr = formulaSheet != null ? formulaSheet.getExpr(null, formula) : sheet.getExpr(null, formula);
                pr.getExprParams().getNodes()[0] = ExprConst.NULL;
                Variant cond = pr.execute(ctx, null);
                if (cond.booleanValue()) {
                    isMatchEmpty = isMatchEmpty;
                } else {
                    if (isMatchEmpty) {
                        // empty if block
                    }
                    isMatchEmpty = false;
                }
            }
            boolean findThisNode = false;
            IExprNode[] nodes = expr.getExprParams().getNodes();
            for (int n = 0; n < nodes.length; ++n) {
                CellBlockNode cb;
                IExprNode node = nodes[n];
                if (node.getExprType() != 4 || !(cb = (CellBlockNode)node).isSingleCell() || cb.getRow() != 1048575 || cb.getCol() != 65535) continue;
                criteriaExprs[e++] = expr;
                criteriaExprs[e++] = n;
                findThisNode = true;
                break;
            }
            if (findThisNode) continue;
            ExprErr.goError(16L, "no MAX CELL");
        }
        Variant number = Variant.getNewEmptyVariant();
        int count = 0;
        int notNullNum = 0;
        Sheet.ICellsIterator it = sheet.getCellsIterator(sumRange, false, true, false);
        int paramPos = 0;
        while (it.hasNext()) {
            boolean calcSum;
            ++notNullNum;
            if (StringUtil.isEmptyString((String)criteria)) {
                it.next();
                continue;
            }
            Cell cllSum = it.next();
            boolean bl = calcSum = varSum != null;
            if (!calcSum && varCount == null) continue;
            int row2 = cllSum.getRow();
            int col2 = cllSum.getCol();
            boolean pass = true;
            sheetIndex = 0;
            for (int i = 0; i < criterias; i += 2) {
                int c = col2 + criteriaOffsets[i];
                int r = row2 + criteriaOffsets[i + 1];
                Sheet cSheet = criteriaSheet[sheetIndex++];
                CellBlockNode cb = CellBlockNode.getCellBlockNode(cSheet, r, c, r, c, 15);
                paramPos = (Integer)criteriaExprs[i + 1];
                Expr expr = (Expr)criteriaExprs[i];
                expr.getExprParams().getNodes()[paramPos] = cb;
                Variant cond = expr.execute(ctx, null);
                if (cond.booleanValue()) continue;
                pass = false;
                break;
            }
            if (!pass) continue;
            Variant value = cllSum.getValue();
            if (value.isError()) {
                throw (SyntaxErrorException)value.getValue();
            }
            if (calcSum && value.isNumeric(number)) {
                varSum.add(number);
            }
            if (varCount == null) continue;
            ++count;
        }
        if (varCount != null) {
            int row1 = sumRange.getRow();
            int row2 = sumRange.getRow2();
            int col1 = sumRange.getCol();
            int col2 = sumRange.getCol2();
            int sumCell = (row2 - row1 + 1) * (col2 - col1 + 1);
            int outRangeSize = sumCell - notNullNum;
            if (outRangeSize > 0 && isMatchEmpty) {
                count += outRangeSize;
            }
            varCount.setInt(count);
        }
    }

    private String parseCriteria(String criteria, boolean isFormual) {
        char ch = criteria.charAt(0);
        if (!isFormual) {
            if (criteria.startsWith("<>") || criteria.startsWith("<=") || criteria.startsWith(">=")) {
                String text = criteria.substring(2, criteria.length());
                try {
                    Double.valueOf(text);
                }
                catch (NumberFormatException nfe) {
                    if (!text.startsWith("\"") && !text.endsWith("\"")) {
                        criteria = criteria.substring(0, 2) + "\"" + text.toLowerCase(Locale.ENGLISH) + "\"";
                    }
                }
            } else if (ch == '=' || ch == '>' || ch == '<') {
                String text = criteria.substring(1, criteria.length());
                try {
                    Double.valueOf(text);
                }
                catch (NumberFormatException nfe) {
                    if (!text.startsWith("\"") && !text.endsWith("\"")) {
                        criteria = criteria.charAt(0) + "\"" + text.toLowerCase(Locale.ENGLISH) + "\"";
                    }
                }
            } else if (ch != '-' && ch != '+') {
                criteria = !criteria.startsWith("\"") && !criteria.endsWith("\"") ? "=\"" + criteria.toLowerCase(Locale.ENGLISH) + '\"' : "=" + criteria.toLowerCase(Locale.ENGLISH);
            }
        } else if (ch != '=' && ch != '>' && ch != '<' && ch != '-' && ch != '+') {
            criteria = "=\"" + criteria.toLowerCase(Locale.ENGLISH) + '\"';
        }
        return criteria;
    }

    public Variant RANK(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        final class VarCount
        extends Variant
        implements Comparable {
            private static final long serialVersionUID = 8610304049829344756L;
            int _rank;

            VarCount(Variant var) {
                super(var);
                this._rank = 1;
            }

            @Override
            public int compareTo(Object right) {
                return super.compareTo(right);
            }

            void insert(SortedObjectArray array) {
                int pos = array.search(this);
                if (pos >= 0) {
                    ++((VarCount)array.get((int)pos))._rank;
                } else {
                    array.insert(pos, this);
                }
            }

            void insertBlock(SortedObjectArray array, CellBlockNode cb) throws SyntaxErrorException {
                Sheet.ICellsIterator i = cb.getCellsIterator(false, true);
                while (i.hasNext()) {
                    Variant value = i.next().getValue();
                    if (value.isNumber()) {
                        new VarCount(value).insert(array);
                        continue;
                    }
                    if (!value.isCalcLast()) continue;
                    throw SyntaxErrorException.CALC_LAST;
                }
            }
        }
        int pos;
        int rank;
        ExcelFuncProvider.validParamCount(args, 2, 3);
        Variant number = (Variant)args[0];
        ExcelFuncProvider.validNumericParam("value", number);
        Variant ref = (Variant)args[1];
        SortedObjectArray values = (SortedObjectArray)ctx.getBuffer().getRankBuffer().get(ref);
        if (values == null) {
            if (ref.isCalcLast()) {
                return ref;
            }
            VarCount op = new VarCount(null);
            if (ref.isArray()) {
                Variant value;
                int i;
                values = new SortedObjectArray();
                Variant[] aVar = (Variant[])ref.getValue();
                if (aVar[0].getValue() instanceof CellBlockNode) {
                    for (i = 0; i < aVar.length; ++i) {
                        value = aVar[i];
                        op.insertBlock(values, (CellBlockNode)value.getValue());
                    }
                } else {
                    for (i = 0; i < aVar.length; ++i) {
                        value = aVar[i];
                        if (!value.isNumber()) continue;
                        new VarCount(value).insert(values);
                    }
                }
            } else {
                Object obj = ref.getValue();
                if (obj instanceof CellBlockNode) {
                    values = new SortedObjectArray();
                    op.insertBlock(values, (CellBlockNode)obj);
                }
            }
            if (values == null || values.isEmpty()) {
                throw new SyntaxErrorException(524288L, "");
            }
            rank = 0;
            int iEnd = values.size();
            for (int i = 0; i < iEnd; ++i) {
                VarCount var = (VarCount)values.get(i);
                var._rank = rank += var._rank;
            }
            ctx.getBuffer().getRankBuffer().put(ref, values);
        }
        if ((pos = values.search(number)) < 0) {
            ExprErr.goError(524288L, "");
        }
        VarCount varRank = (VarCount)values.get(pos);
        boolean desc = true;
        if (args.length == 3) {
            desc = ((Variant)args[2]).intValue() == 0;
        }
        rank = varRank._rank;
        if (desc) {
            varRank = (VarCount)values.get(values.size() - 1);
            rank = varRank._rank - rank + 1;
        }
        return new Variant(rank);
    }

    private void _insertBlock(SortedObjectArray array, CellBlockNode cb) {
        Sheet.ICellsIterator i = cb.getCellsIterator(false, true);
        while (i.hasNext()) {
            Variant value = i.next().getValue();
            array.insert(value);
        }
    }

    private void _collectBlock(ObjectArray array, CellBlockNode cb) {
        Sheet.ICellsIterator i = cb.getCellsIterator(false, true);
        while (i.hasNext()) {
            Variant value = i.next().getValue();
            array.append(value);
        }
    }

    public Variant MATCH(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        int pos;
        ExcelFuncProvider.validParamCount(args, 2, 3);
        Variant lookup = (Variant)args[0];
        int matchType = 1;
        if (args.length == 3) {
            Variant type = (Variant)args[2];
            ExcelFuncProvider.validNumericParam("value", type);
            matchType = type.intValue();
        }
        Variant ref = (Variant)args[1];
        if (matchType != 0) {
            SortedObjectArray values = (SortedObjectArray)ctx.getBuffer().getMatchBuffer().get(ref);
            if (values == null) {
                if (ref.isCalcLast()) {
                    return ref;
                }
                values = new SortedObjectArray();
                if (ref.isArray()) {
                    Variant[] aVar = (Variant[])ref.getValue();
                    if (aVar[0].getValue() instanceof CellBlockNode) {
                        for (int i = 0; i < aVar.length; ++i) {
                            Variant value = aVar[i];
                            this._insertBlock(values, (CellBlockNode)value.getValue());
                        }
                    } else {
                        for (int i = 0; i < aVar.length; ++i) {
                            Variant value = aVar[i];
                            values.insert(value);
                        }
                    }
                } else {
                    Object obj = ref.getValue();
                    if (obj instanceof CellBlockNode) {
                        this._insertBlock(values, (CellBlockNode)obj);
                    } else {
                        values.insert(ref);
                    }
                }
                if (values == null || values.isEmpty()) {
                    ExprErr.goError(524288L, "");
                }
                ctx.getBuffer().getMatchBuffer().put(ref, values);
            }
            if ((pos = values.search(lookup)) < 0) {
                boolean bError = false;
                pos = -(pos + 1);
                if (matchType > 0) {
                    bError = --pos < 0;
                } else {
                    boolean bl = bError = pos >= values.size();
                }
                if (bError) {
                    ExprErr.goError(524288L, "");
                }
            }
        } else {
            if (ref.isCalcLast()) {
                return ref;
            }
            ObjectArray values = new ObjectArray();
            values = new SortedObjectArray();
            if (ref.isArray()) {
                Variant value;
                int i;
                Variant[] aVar = (Variant[])ref.getValue();
                if (aVar[0].getValue() instanceof CellBlockNode) {
                    for (i = 0; i < aVar.length; ++i) {
                        value = aVar[i];
                        this._collectBlock(values, (CellBlockNode)value.getValue());
                    }
                } else {
                    for (i = 0; i < aVar.length; ++i) {
                        value = aVar[i];
                        values.append(value);
                    }
                }
            } else {
                Object obj = ref.getValue();
                if (obj instanceof CellBlockNode) {
                    this._collectBlock(values, (CellBlockNode)obj);
                } else {
                    values.append(ref);
                }
            }
            pos = -1;
            int iEnd = values.size();
            for (int i = 0; i < iEnd; ++i) {
                if (!values.get(i).equals(lookup)) continue;
                pos = i;
                break;
            }
            if (pos < 0) {
                ExprErr.goError(524288L, "");
            }
        }
        return new Variant(ObjectCache.getInteger(pos + 1), 3);
    }

    public Variant DVAR(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.var(data, false, true, false);
    }

    public Variant DVARP(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.var(data, false, true, true);
    }

    public Variant DCOUNT(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.count(data, false, true, false);
    }

    public Variant DCOUNTA(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.count(data, false, false, false);
    }

    public Variant DMAX(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return ExcelFuncProvider.max(data, false, false);
    }

    public Variant DMIN(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return ExcelFuncProvider.min(data, false, false);
    }

    public Variant DSUM(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.sum(data, false, false);
    }

    public Variant DPRODUCT(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.product(data, false, false);
    }

    public Variant DAVERAGE(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        return this.average(data, false, false);
    }

    public Variant DSTDEV(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        Variant stdev = this.var(data, false, true, false);
        return ExcelFuncProvider.decimalValue(Math.sqrt(stdev.doubleValue()));
    }

    public Variant DSTDEVP(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] data = this._dData(ctx, args);
        Variant stdev = this.var(data, false, true, true);
        return ExcelFuncProvider.decimalValue(Math.sqrt(stdev.doubleValue()));
    }

    public Variant DGET(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant[] data = this._dData(ctx, args);
        if (data.length == 0) {
            ExprErr.goError(64L, null);
        } else if (data.length > 1) {
            ExprErr.goError(1024L, null);
        }
        return data[0];
    }

    private Variant[] _dData(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Object[] aRet;
        Object[] ors;
        ExcelFuncProvider.validParamCount(args, 3, 3);
        CellBlockNode cbData = ExcelFuncProvider.cellblockValue((Variant)args[0], null);
        Sheet sheet = cbData.getSheet();
        int width = cbData.getWidth();
        SortedObjectArray fields = new SortedObjectArray(width);
        SortedIntArray aPos = new SortedIntArray(width);
        int row = cbData.getRow();
        int col = cbData.getCol();
        int col2 = cbData.getCol2();
        Sheet.ICellsIterator ci = sheet.getCellsIterator(row, col, row, col2, false, true);
        while (ci.hasNext()) {
            Object fieldName;
            int pos;
            Cell cll = ci.next();
            Variant value = cll.getValue();
            if (!value.isString() || (pos = fields.search(fieldName = value.getValue())) >= 0) continue;
            pos = -(pos + 1);
            fields.insert(pos, fieldName);
            aPos.insert(pos, cll.getCol() - col);
        }
        if (fields.isEmpty()) {
            ExprErr.goError(16L, "Field Name");
        }
        int field = this._dField(fields, aPos, width, true, (Variant)args[1]);
        ObjectArray aCriteria = new ObjectArray();
        CellBlockNode cbCriteria = ExcelFuncProvider.cellblockValue((Variant)args[2], "criteria");
        int row2 = cbCriteria.getRow();
        int row22 = cbCriteria.getRow2();
        int col3 = cbCriteria.getCol();
        int col22 = cbCriteria.getCol2();
        int height = cbCriteria.getHeight();
        if (height < 2) {
            ExprErr.goError(64L, "criteria");
        }
        Sheet.ICellsIterator ci2 = sheet.getCellsIterator(row2, col3, row2, col22, false, true);
        while (ci2.hasNext()) {
            Cell cll = ci2.next();
            int fld = this._dField(fields, aPos, width, false, cll.getValue());
            if (fld <= -1 || fld >= width) continue;
            ors = null;
            int c = cll.getCol();
            Sheet.ICellsIterator cr = sheet.getCellsIterator(row2 + 1, c, row22, c, false, true);
            while (cr.hasNext()) {
                cll = cr.next();
                Variant value = cll.getValue();
                if (value.isString()) {
                    String formula = (String)value.getValue();
                    if (StringUtil.isEmptyString((String)formula)) continue;
                    char ch = formula.charAt(0);
                    if (ch != '=' && ch != '>' && ch != '<' && ch != '-' && ch != '+') {
                        formula = "=\"" + formula + '\"';
                    }
                    if (ors == null) {
                        ors = new Object[height];
                    }
                    ors[cll.getRow() - row2] = formula;
                    continue;
                }
                if (value.isNull()) continue;
                if (ors == null) {
                    ors = new Object[height];
                }
                ors[cll.getRow() - row2] = value;
            }
            if (ors == null) continue;
            ors[0] = ObjectCache.getInteger(fld);
            aCriteria.append(ors);
        }
        IExprBuffer buffer = ctx.getBuffer();
        ObjectArray aOR = buffer.getObjectArray(0);
        Expr exprEqual = null;
        ICalculable exprOwner = ctx.getExprOwner();
        if (!aCriteria.isEmpty()) {
            int andCount = aCriteria.size();
            for (int i = 1; i < height; ++i) {
                ObjectArray aAnd = null;
                for (int j = 0; j < andCount; ++j) {
                    ors = (Object[])aCriteria.get(j);
                    Object cObj = ors[i];
                    if (cObj == null) continue;
                    if (aAnd == null) {
                        aAnd = buffer.getObjectArray(0);
                    }
                    aAnd.append(ors[0]);
                    if (cObj instanceof String) {
                        Expr expr = sheet.getExpr(exprOwner, "$Data$ " + cObj);
                        aAnd.append(expr);
                        continue;
                    }
                    if (exprEqual == null) {
                        exprEqual = sheet.getExpr(exprOwner, "$Data$ = $Value$");
                    }
                    aAnd.append(cObj);
                }
                if (aAnd == null) continue;
                aOR.append(aAnd);
            }
        }
        ObjectArray array = buffer.getObjectArray(0);
        int row3 = cbData.getRow();
        int row23 = cbData.getRow2();
        int col4 = cbData.getCol();
        int fleldCol = col4 + field;
        if (aOR.isEmpty()) {
            Sheet.ICellsIterator ci3 = sheet.getCellsIterator(row3 + 1, fleldCol, row23, fleldCol, false, true);
            while (ci3.hasNext()) {
                array.append(ci3.next().getValue());
            }
        } else {
            NamedObjectNode noData = sheet.getNamedObject("$Data$", false);
            NamedObjectNode noValue = sheet.getNamedObject("$Value$", false);
            int aORCount = aOR.size();
            for (int r = row3 + 1; r <= row23; ++r) {
                Variant fldValue;
                Row rowObj = sheet.getRow(r, false);
                Cell cll = sheet.getCell(rowObj, fleldCol, false);
                if (cll == null || (fldValue = cll.getValue()).isNull()) continue;
                boolean isTrue = false;
                block7: for (int i = 0; i < aORCount; ++i) {
                    ObjectArray aAnd = (ObjectArray)aOR.get(i);
                    int jEnd = aAnd.size();
                    for (int j = 0; j < jEnd; j += 2) {
                        int fld = (Integer)aAnd.get(j);
                        cll = sheet.getCell(rowObj, col4 + fld, false);
                        Variant value = cll == null ? Variant.nullVariant : cll.getValue();
                        noData.setValue(value);
                        Expr expr = exprEqual;
                        Object obj = aAnd.get(j + 1);
                        if (obj instanceof Expr) {
                            expr = (Expr)obj;
                        } else {
                            noValue.setValue((Variant)obj);
                        }
                        if (null != expr && !expr.execute(ctx, exprOwner).booleanValue()) continue block7;
                    }
                    isTrue = true;
                    break;
                }
                if (!isTrue) continue;
                array.append(fldValue);
            }
            if (noData != null) {
                sheet.getNames().remove(noData);
            }
            if (noValue != null) {
                sheet.getNames().remove(noValue);
            }
            for (int i = 0; i < aORCount; ++i) {
                buffer.recycleArray((ObjectArray)aOR.get(i));
            }
            buffer.recycleArray(aOR);
        }
        if (array.isEmpty()) {
            aRet = new Variant[]{};
        } else {
            aRet = new Variant[array.size()];
            array.toArray(aRet, 0);
        }
        buffer.recycleArray(array);
        return aRet;
    }

    private int _dField(SortedObjectArray fields, SortedIntArray aPos, int width, boolean bValid, Variant var) throws SyntaxErrorException {
        int field = -1;
        if (var.isString()) {
            int pos = fields.search(var.getValue());
            if (pos >= 0) {
                field = aPos.getAt(pos);
            }
        } else {
            Variant number = Variant.getNewEmptyVariant();
            if (bValid && !var.isNumeric(number)) {
                ExprErr.goError(16L, "Field");
            }
            field = number.intValue() - 1;
        }
        if (bValid && (field < 0 || field >= width)) {
            ExprErr.goError(16L, "Field");
        }
        return field;
    }

    public Variant LINEST(Object[] args) throws SyntaxErrorException {
        return new Variant(this._trend(args, true, false, null), 527);
    }

    public Variant TREND(Object[] args) throws SyntaxErrorException {
        Object[] ret = new Object[1];
        Variant[] factors = this._trend(args, true, true, ret);
        ObjectArray aXs = (ObjectArray)ret[0];
        int xsCount = aXs.size();
        Object[] newXs = aXs.getArray();
        Variant m = factors[0];
        Variant b = factors[1];
        Variant[] array = new Variant[xsCount];
        for (int i = 0; i < xsCount; ++i) {
            Variant v = new Variant();
            m.multiply((Variant)newXs[i], v);
            v.add(b);
            array[i] = v;
        }
        return new Variant(array, 527);
    }

    public Variant LOGEST(Object[] args) throws SyntaxErrorException {
        return new Variant(this._trend(args, false, false, null), 527);
    }

    public Variant GROWTH(Object[] args) throws SyntaxErrorException {
        Object[] ret = new Object[1];
        Variant[] factors = this._trend(args, false, true, ret);
        ObjectArray aXs = (ObjectArray)ret[0];
        int xsCount = aXs.size();
        Object[] newXs = aXs.getArray();
        double dfm = factors[0].doubleValue();
        Variant b = factors[1];
        Variant[] array = new Variant[xsCount];
        for (int i = 0; i < xsCount; ++i) {
            Variant v = new Variant();
            double df = StrictMath.pow(dfm, ((Variant)newXs[i]).doubleValue());
            b.multiply(ExcelFuncProvider.decimalValue(df), v);
            array[i] = v;
        }
        return new Variant(array, 527);
    }

    private Variant[] _trend(Object[] args, boolean linest, boolean getData, Object[] newXs) throws SyntaxErrorException {
        ObjectArray Xs;
        ExcelFuncProvider.validParamCount(args, 1, getData ? 3 : 2);
        ObjectArray Ys = this._collectD1Numbers(args, 0, 1, 0, false);
        int len = Ys.size();
        if (len == 0) {
            ExprErr.goError(64L, null);
        }
        if (args.length > 1) {
            Variant var = (Variant)args[1];
            if (var.isNull()) {
                Xs = this._createDefaultXs(len, getData, newXs);
            } else {
                Xs = this._collectD1Numbers(args, 1, 2, 0, false);
                if (Xs.size() != len) {
                    ExprErr.goError(512L, null);
                }
                if (getData) {
                    newXs[0] = Xs;
                }
            }
            if (args.length > 2) {
                newXs[0] = this._collectD1Numbers(args, 2, 3, 0, false);
            }
        } else {
            Xs = this._createDefaultXs(len, getData, newXs);
        }
        return this._trendFactor(Ys.getArray(), Xs.getArray(), len, linest);
    }

    private ObjectArray _createDefaultXs(int len, boolean getData, Object[] newXs) {
        ObjectArray Xs = new ObjectArray(len);
        for (int i = 1; i <= len; ++i) {
            Xs.append(new Variant(new BigDecimal(i), 10));
        }
        if (getData) {
            newXs[0] = Xs;
        }
        return Xs;
    }

    private Variant[] _trendFactor(Object[] Ys, Object[] Xs, int count, boolean linest) throws SyntaxErrorException {
        double df;
        if (count == 1) {
            return new Variant[]{Variant.zeroVariant, (Variant)Ys[0]};
        }
        Variant X2 = new Variant(Variant.zeroBigDecimal, 10);
        Variant Y2 = new Variant(Variant.zeroBigDecimal, 10);
        Variant XY = new Variant(Variant.zeroBigDecimal, 10);
        Variant X22 = new Variant(Variant.zeroBigDecimal, 10);
        Variant y = new Variant();
        Variant x = new Variant();
        Variant x2 = new Variant();
        Variant xy = new Variant();
        for (int i = 0; i < count; ++i) {
            y = (Variant)Ys[i];
            if (!linest) {
                double df2 = y.doubleValue();
                y.setObject(new BigDecimal(String.valueOf(Math.log(df2))), 10);
            }
            Y2.add(y);
            x = (Variant)Xs[i];
            X2.add(x);
            x.multiply(x, x2);
            X22.add(x2);
            y.multiply(x, xy);
            XY.add(xy);
        }
        Variant c = new Variant(count);
        Variant den = new Variant(X22);
        den.multiply(c);
        Variant tmp = new Variant(X2);
        tmp.multiply(tmp);
        den.subtract(tmp);
        Variant m = new Variant(XY);
        m.multiply(c);
        Variant tmp2 = new Variant(X2);
        tmp2.multiply(Y2);
        m.subtract(tmp2);
        if (ArrayUtil.isEqual((Double)den.doubleValue(), (Double)0.0)) {
            m = new Variant(Variant.zeroBigDecimal, 10);
        } else {
            m.divide(den);
            if (!linest) {
                df = Math.exp(m.doubleValue());
                m.setObject(new BigDecimal(String.valueOf(df)), 10);
            }
        }
        Variant b = new Variant(Y2);
        if (linest) {
            b.divide(c);
            X2.divide(c);
            X2.multiply(m);
            b.subtract(X2);
        } else {
            b.multiply(X22);
            tmp2 = new Variant(X2);
            tmp2.multiply(XY);
            b.subtract(tmp2);
            b.divide(den);
            df = Math.exp(b.doubleValue());
            b.setObject(new BigDecimal(String.valueOf(df)), 10);
        }
        return new Variant[]{m, b};
    }

    public Variant MINVERSE(Variant array) throws SyntaxErrorException {
        int n;
        Variant[][] src = ExcelFuncProvider.collectD2Numbers(array, false);
        if (src[0].length != (n = src.length)) {
            ExprErr.goError(16L, "Not Square");
        }
        Variant[][] result = new Variant[n][n];
        for (int i = 0; i < n; ++i) {
            int j;
            Variant[] line = result[i];
            for (j = 0; j < i; ++j) {
                line[j] = new Variant(Variant.zeroVariant);
            }
            line[i] = new Variant(Variant.oneVariant);
            for (j = i + 1; j < n; ++j) {
                line[j] = new Variant(Variant.zeroVariant);
            }
        }
        this._calCol(src, result, 0);
        this._calColBack(src, result, n - 1);
        this._reInit(src, result);
        Variant[] vars = new Variant[n];
        for (int i = 0; i < n; ++i) {
            vars[i] = new Variant(result[i], 527);
        }
        return new Variant(vars, 527);
    }

    public Variant MMULT(Variant array1, Variant array2) throws SyntaxErrorException {
        Variant[][] a2;
        Variant[][] a1 = ExcelFuncProvider.collectD2Numbers(array1, false);
        int a1Cols = a1[0].length;
        if (a1Cols != (a2 = ExcelFuncProvider.collectD2Numbers(array2, false)).length) {
            ExprErr.goError(64L, null);
        }
        int rows = a1.length;
        int cols = a2[0].length;
        Variant[][] result = new Variant[rows][cols];
        Variant v = new Variant();
        for (int i = 0; i < rows; ++i) {
            Variant[] a1Line = a1[i];
            Variant[] resultLine = result[i];
            for (int j = 0; j < cols; ++j) {
                Variant sum = new Variant(Variant.zeroVariant);
                for (int k = 0; k < a1Cols; ++k) {
                    a1Line[k].multiply(a2[k][j], v);
                    sum.add(v);
                }
                resultLine[j] = sum;
            }
        }
        Variant[] vars = new Variant[rows];
        for (int i = 0; i < rows; ++i) {
            vars[i] = new Variant(result[i], 527);
        }
        return new Variant(vars, 527);
    }

    private void _calCol(Variant[][] src, Variant[][] result, int col) throws SyntaxErrorException {
        Variant[] srcLineCol = src[col];
        Variant[] resultLineCol = result[col];
        int n = src.length;
        Variant coefficient = new Variant();
        Variant v = new Variant();
        for (int i = col + 1; i < n; ++i) {
            Variant[] srcLineI = src[i];
            srcLineI[col].negate(coefficient);
            coefficient.divide(srcLineCol[col]);
            Variant[] resultLineI = result[i];
            for (int z = 0; z < n; ++z) {
                coefficient.multiply(srcLineCol[z], v);
                srcLineI[z].add(v);
                coefficient.multiply(resultLineCol[z], v);
                resultLineI[z].add(v);
            }
        }
        if (col + 1 < n) {
            this._calCol(src, result, col + 1);
        }
    }

    private void _calColBack(Variant[][] src, Variant[][] result, int col) throws SyntaxErrorException {
        Variant[] srcLineCol = src[col];
        Variant[] resultLineCol = result[col];
        int n = src.length;
        Variant coefficient = new Variant();
        Variant v = new Variant();
        for (int i = col - 1; i > -1; --i) {
            Variant[] srcLineI = src[i];
            srcLineI[col].negate(coefficient);
            coefficient.divide(srcLineCol[col]);
            Variant[] resultLineI = result[i];
            for (int z = 0; z < n; ++z) {
                coefficient.multiply(srcLineCol[z], v);
                srcLineI[z].add(v);
                coefficient.multiply(resultLineCol[z], v);
                resultLineI[z].add(v);
            }
        }
        if (col > 0) {
            this._calColBack(src, result, col - 1);
        }
    }

    private void _reInit(Variant[][] src, Variant[][] result) throws SyntaxErrorException {
        Variant coefficient = new Variant();
        int n = src.length;
        for (int i = 0; i < n; ++i) {
            Variant.oneVariant.divide(src[i][i], coefficient);
            Variant[] resultLineI = result[i];
            for (int j = 0; j < n; ++j) {
                resultLineI[j].multiply(coefficient);
            }
        }
    }

    public Variant REF(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant var;
        ExcelFuncProvider.validParamCount(args, 1, 4);
        boolean shrinkRow = true;
        boolean shrinkCol = false;
        CellBlock3DNode cbSheets = null;
        if (args.length > 1) {
            var = (Variant)args[1];
            Object obj = var.getValue();
            if (!(obj instanceof CellBlock3DNode) && !((obj = var.getVariant().getValue()) instanceof CellBlock3DNode)) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("notValid", "\u975e\u6709\u6548") + "CB3 Sheets");
            }
            cbSheets = (CellBlock3DNode)obj;
            if (args.length > 2) {
                shrinkRow = ((Variant)args[2]).booleanValue();
                if (args.length > 3) {
                    shrinkCol = ((Variant)args[3]).booleanValue();
                }
            }
        }
        var = (Variant)args[0];
        Variant varRet = null;
        if (var.isReferences()) {
            Object obj = var.getValue();
            if (!(obj instanceof CellBlockNode)) {
                ExprErr.goError(16L, CtrlEXTMessages.getMLS("nonCellAreaReference", "\u975e\u5355\u5143\u533a\u57df\u5f15\u7528"));
            }
            varRet = var;
            if (args.length > 1 && null != cbSheets) {
                CellBlock3DNode cb3 = (CellBlock3DNode)cbSheets.clone();
                cb3.setRowCol((CellBlockNode)obj);
                varRet = new Variant(cb3, 18);
            }
        } else {
            String formula = var.getVariant().toString();
            Expr[] exprRet = new Expr[]{null};
            if (args.length < 2) {
                CellBlockNode cb = this._getCellBlockValue(ctx.getExprOwner().getSheet(), formula, exprRet);
                if ((shrinkRow || shrinkCol) && exprRet[0].isSingleNamedObject()) {
                    cb = (CellBlockNode)cb.clone();
                    cb.offset(0, 0, shrinkRow ? -1 : 0, shrinkCol ? -1 : 0);
                }
                varRet = cb.getVarThis();
            } else if (null != cbSheets) {
                Sheet sheet = cbSheets.getSheet();
                Book book = sheet.getBook();
                int shStart = sheet.getIndex();
                int shEnd = cbSheets.getSheet2().getIndex() + 1;
                String sheetName = sheet.getSheetName();
                Variant[] varCBs = new Variant[shEnd - shStart];
                int i = shStart;
                int sh = 0;
                while (i < shEnd) {
                    sheet = book.getSheet(i);
                    String sheetName2 = sheet.getSheetName();
                    sheet.setName(sheetName);
                    CellBlockNode cb = this._getCellBlockValue(sheet, formula, exprRet);
                    sheet.setName(sheetName2);
                    if ((shrinkRow || shrinkCol) && exprRet[0].isSingleNamedObject()) {
                        cb = (CellBlockNode)cb.clone();
                        cb.offset(0, 0, shrinkRow ? -1 : 0, shrinkCol ? -1 : 0);
                    }
                    varCBs[sh] = cb.getVarThis();
                    ++i;
                    ++sh;
                }
                varRet = varCBs.length == 1 ? ((CellBlockNode)varCBs[0].getValue()).getVarThis() : new Variant(varCBs, 527);
            }
        }
        return varRet;
    }

    private CellBlockNode _getCellBlockValue(Sheet sheet, String formula, Expr[] exprRet) throws SyntaxErrorException {
        Variant var = sheet.calcFormula(formula, null, exprRet);
        Object obj = var.getValue();
        if (!var.isReferences() || !(obj instanceof CellBlockNode) || var.isCalcLast()) {
            ExprErr.goError(16L, CtrlEXTMessages.getMLS("namedObjectValueNotSingleCell", "'#1'\u547d\u540d\u5bf9\u8c61\u503c\u975e\u5355\u5143\u533a\u57df:#2").replace("#1", sheet.getSheetName()).replace("#2", formula));
        }
        return (CellBlockNode)obj;
    }

    public Variant NPV(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, Integer.MAX_VALUE);
        IExprBuffer buffer = ctx.getBuffer();
        ObjectArray oa = buffer.getObjectArray(-1);
        for (int i = 0; i < args.length; ++i) {
            ExcelFuncProvider.platValues(oa, (Variant)args[i]);
        }
        double rate = 1.0;
        Variant vRate = (Variant)oa.get(0);
        if (!vRate.isNumeric()) {
            ExprErr.goError(64L, "rate");
        }
        rate += vRate.doubleValue();
        int valueCount = oa.size();
        int actualCount = 1;
        double[] values = new double[valueCount];
        for (int i = 1; i < valueCount; ++i) {
            Variant v = (Variant)oa.get(i);
            if (!v.isNumeric()) continue;
            values[actualCount++] = v.doubleValue();
        }
        buffer.recycleArray(oa);
        if (actualCount < 2) {
            ExprErr.goError(64L, "values");
        }
        return new Variant(this._npv(rate, values, actualCount));
    }

    private double _npv(double rate, double[] values, int valueCount) throws SyntaxErrorException {
        double result = 0.0;
        double rolledRate = rate;
        for (int i = 1; i < valueCount; ++i) {
            result += values[i] / rolledRate;
            rolledRate *= rate;
        }
        return result;
    }

    public Variant IRR(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 2);
        Variant varValues = (Variant)args[0];
        if (!(varValues.isArray() || varValues.isReferences() && varValues.getValue() instanceof CellBlockNode)) {
            ExprErr.goError(4L, "values");
        }
        double guess = 1.1;
        if (args.length == 2) {
            Variant varGuess = (Variant)args[1];
            if (!varGuess.isNumeric()) {
                ExprErr.goError(4L, "guess");
            }
            guess = varGuess.doubleValue() + 1.0;
        }
        IExprBuffer buffer = ctx.getBuffer();
        ObjectArray oa = buffer.getObjectArray(-1);
        ExcelFuncProvider.platValues(oa, varValues);
        int valueCount = oa.size();
        int actualCount = 0;
        int posneg = 0;
        double[] values = new double[valueCount];
        for (int i = 0; i < valueCount; ++i) {
            Variant v = (Variant)oa.get(i);
            if (!v.isNumeric()) continue;
            double d = v.doubleValue();
            if (d > 0.0) {
                posneg |= 1;
            } else if (d < 0.0) {
                posneg |= 2;
            }
            values[actualCount++] = d;
        }
        buffer.recycleArray(oa);
        if (posneg != 3) {
            ExprErr.goError(4L, "values");
        }
        double cost = values[0];
        double npv = cost + this._npv(guess, values, actualCount);
        double step = 0.1;
        posneg = 0;
        boolean bOK = false;
        boolean bInterpolate = false;
        for (int i = 0; i < 20; ++i) {
            double prevNpv = npv;
            double prevGuess = guess;
            if (npv > 0.0) {
                posneg |= 1;
                guess += Math.abs(guess) * step;
            } else if (npv < 0.0) {
                posneg |= 2;
                guess -= Math.abs(guess) * step;
            } else {
                bOK = true;
                break;
            }
            npv = cost + this._npv(guess, values, actualCount);
            if (npv > 0.0) {
                if ((posneg & 2) != 0) {
                    bInterpolate = true;
                }
            } else if (npv < 0.0 && (posneg & 1) != 0) {
                bInterpolate = true;
            }
            if (!bInterpolate) continue;
            double d = Math.abs(prevNpv) * (guess - prevGuess) / (Math.abs(prevNpv) + Math.abs(npv));
            guess = prevGuess + d;
            npv = cost + this._npv(guess, values, actualCount);
            if (Math.abs(d) > 1.0E-7) {
                step /= 2.0;
                posneg = 0;
                continue;
            }
            bOK = true;
            break;
        }
        if (!bOK) {
            ExprErr.goError(64L, "");
        }
        return new Variant(guess - 1.0);
    }

    public Variant RPTREF(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 4);
        ArrayList<String> refList = new ArrayList<String>();
        refList.add("ref(\"" + args[0] + "\",\"" + args[1] + "\",\"" + args[2] + "\",\"" + args[3] + "\")");
        String returnVar = "";
        IRptRuntimeCallback rptRunCallback = ctx.getBook().getDataSetManager().getExecutionContext().getRptRuntimeCallback();
        if (rptRunCallback != null) {
            returnVar = rptRunCallback.setRPTREF(refList, ctx.getBook()).toString();
        }
        Variant variant = new Variant(returnVar);
        return variant;
    }

    public Variant IFERROR(Variant value, Variant value_iferror) throws SyntaxErrorException {
        if (value.isError()) {
            return value_iferror;
        }
        return value;
    }

    public Variant QUARTER(Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 1, 1);
        Variant date = (Variant)args[0];
        Calendar cal = (Calendar)date.toCalendar().clone();
        int month = cal.get(2);
        int quarter = 0;
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                quarter = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                quarter = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                quarter = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                quarter = 4;
                break;
            }
        }
        return new Variant(quarter);
    }

    public Variant ROUNDUP(Variant value, Variant digit) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        ExcelFuncProvider.validNumericParam("digit", digit);
        BigDecimal bd = value.toBigDecimal();
        int iDigit = (int)digit.doubleValue();
        if (iDigit >= 0) {
            return new Variant(bd.setScale(digit.intValue(), 0), 10);
        }
        BigDecimal newValue = bd.setScale(0, 0);
        BigDecimal pow = BigDecimal.valueOf(StrictMath.pow(10.0, -iDigit));
        newValue = newValue.divide(pow, 0, 0);
        newValue = newValue.multiply(pow);
        return new Variant(newValue, 10);
    }

    public Variant ROUNDDOWN(Variant value, Variant digit) throws SyntaxErrorException {
        ExcelFuncProvider.validNumericParam("value", value);
        ExcelFuncProvider.validNumericParam("digit", digit);
        BigDecimal bd = value.toBigDecimal();
        int iDigit = (int)digit.doubleValue();
        if (iDigit >= 0) {
            return new Variant(bd.setScale(digit.intValue(), 1), 10);
        }
        BigDecimal newValue = bd.setScale(0, 1);
        BigDecimal pow = BigDecimal.valueOf(StrictMath.pow(10.0, -iDigit));
        newValue = newValue.divide(pow, 0, 1);
        newValue = newValue.multiply(pow);
        return new Variant(newValue, 10);
    }

    public Variant IN(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        ExcelFuncProvider.validParamCount(args, 2, args.length);
        boolean pass = false;
        Object value = args[0];
        ArrayList<String> criterias = new ArrayList<String>();
        for (int i = 1; i < args.length; ++i) {
            Variant var = (Variant)args[i];
            if (var.getValue() instanceof CellBlockNode) {
                CellBlockNode node = (CellBlockNode)var.getValue();
                Sheet.ICellsIterator iterator = node.getCellsIterator(true, true);
                while (iterator.hasNext()) {
                    Cell cell = iterator.next();
                    if (!cell.isHasValue()) continue;
                    criterias.add(cell.getValue().toString());
                }
            } else {
                criterias.add(var.getValue().toString());
            }
            for (String criteria : criterias) {
                if (!StringUtil.isEmptyString((String)criteria)) {
                    char ch = criteria.charAt(0);
                    if (ch != '=' && ch != '>' && ch != '<' && ch != '-' && ch != '+') {
                        criteria = "=\"" + criteria.toLowerCase(Locale.ENGLISH) + '\"';
                    }
                } else {
                    criteria = "=";
                }
                String formula = "=\"" + value + '\"' + criteria;
                Expr expr = ctx.getExprOwner().getSheet().getExpr(null, formula);
                Variant cond = expr.execute(ctx, null);
                if (cond.isPending()) {
                    throw (SyntaxErrorException)cond.getValue();
                }
                if (!cond.booleanValue()) continue;
                pass = true;
                break;
            }
            criterias.clear();
            if (pass) break;
        }
        return pass ? Variant.trueVariant : Variant.falseVariant;
    }

    public Variant REGEX(Variant value, Variant pattern) throws SyntaxErrorException {
        String valueStr = value.toString();
        String patternStr = pattern.toString();
        if (StringUtil.isEmptyString((String)patternStr)) {
            ExprErr.goError(16L, "pattern parma must not null");
        }
        if (null == valueStr) {
            valueStr = "";
        }
        if (valueStr.matches(patternStr)) {
            return Variant.trueVariant;
        }
        return Variant.falseVariant;
    }

    private boolean isRegex(String str) {
        char ch = str.charAt(0);
        if (ch == '=' || ch == '<' || ch == '>' || ch == '!' || str.indexOf(42) == -1 && str.indexOf(63) == -1) {
            return false;
        }
        try {
            Pattern.compile(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String transfer2ExcelRegex(String pattern) {
        return pattern.replace("*", "[\\S\\s]*").replace("?", "[\\S\\s]?");
    }

    public Variant WORKDAYINT(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        int loop;
        ExcelFuncProvider.validParamCount(args, 2, 2);
        Variant startDate = (Variant)args[0];
        Variant lengthVar = (Variant)args[1];
        if (!lengthVar.isNumber()) {
            ExprErr.goError(16L, "date length parma must be number");
        }
        int length = lengthVar.intValue();
        Variant endDate = new Variant(length);
        endDate = endDate.add(startDate);
        if (length == 0) {
            return startDate;
        }
        if (length < 0) {
            Variant temp = startDate;
            startDate = endDate;
            endDate = temp;
        }
        Variant plainLength = null;
        int differ = 1;
        for (loop = 0; differ > 0 && loop < 20; ++loop) {
            Object[] tempArgs = new Object[]{startDate, endDate};
            plainLength = this.WORKTIME(ctx, tempArgs);
            differ = Math.abs(length) - plainLength.intValue();
            if (differ == 0) continue;
            if (length < 0) {
                startDate = startDate.subtract(new Variant(differ));
                continue;
            }
            endDate = endDate.add(new Variant(differ));
        }
        if (differ > 0) {
            ExprErr.goError(1L, "workday may invaild or length too large.");
        }
        if (length >= 0) {
            endDate = endDate.add(new Variant(1));
        } else {
            startDate = startDate.subtract(new Variant(1));
        }
        WorkDays workDay = null;
        Holidays holiday = null;
        Sheet sheet = ctx.getExprOwner().getSheet();
        WorkCalendar wcal = sheet.getWorkCalendar();
        workDay = wcal.getWorkDay();
        holiday = wcal.getHoliday();
        if (length >= 0) {
            Calendar end = endDate.toCalendar();
            for (loop = 0; loop < 20 && (null != workDay && !workDay.isWorkDay(end) || null != holiday && holiday.isHoliday(end)); ++loop) {
                endDate = endDate.add(new Variant(1));
                end = endDate.toCalendar();
            }
        } else {
            Calendar start = startDate.toCalendar();
            while (loop < 20 && (null != workDay && !workDay.isWorkDay(start) || null != holiday && holiday.isHoliday(start))) {
                startDate = startDate.subtract(new Variant(1));
                start = startDate.toCalendar();
                ++loop;
            }
        }
        return length >= 0 ? endDate : startDate;
    }

    public Variant WORKDAY(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        return new Variant(Variant.decimalToCalender(this.WORKDAYINT(ctx, args).toBigDecimal()), 13);
    }

    public Variant HYPERLINK(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        return this.hyperlink(ctx, args);
    }

    private Variant hyperlink(ExprContext ctx, Object[] args) throws SyntaxErrorException {
        Variant result = null;
        ExcelFuncProvider.validParamCount(args, 2, 2);
        try {
            Cell cell = (Cell)ctx.getExprOwner();
            String link = args[1].toString();
            String linkTo = args[0].toString();
            if (StringUtil.isEmptyString((String)linkTo) || linkTo.startsWith("http")) {
                // empty if block
            }
            HyperLink hyperLink = new HyperLink(link, linkTo);
            cell.setHyperLink(hyperLink);
            ShareStyleAttributes ssa = cell.getSSA();
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
            if (sa.getFontColor() == null || sa.getFontColor() == Color.BLACK) {
                sa.setFontColor(Color.blue);
            }
            sa.setUnderline(true);
            cell.setSSA(ctx.getBook().getSSA(sa));
            result = new Variant(link);
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return result;
    }

    static {
        _Decimal15 = new MathContext(15, RoundingMode.HALF_EVEN);
        _calInst = Calendar.getInstance();
        _calInst.set(14, 0);
    }
}

