/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExcelFuncProvider;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprConst;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprMethod;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprOps;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprUnknownMethod;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BookFormulaHelper {
    public static String Sheet_Count = "Sheet_Count";
    public static String Cell_Count = "Cell_Count";
    public static String All_Expr = "All_Expr";
    public static String All_Function = "All_Function";
    public static String Excel_Function = "Excel_Function";
    public static String Biz_Function = "Biz_Function";

    public static boolean isExcelFunction(Book book, Sheet sheet, String formula) {
        ObjectArray al;
        if (StringUtil.isEmptyString((String)formula)) {
            return false;
        }
        Expr expr = sheet.getExpr(null, formula);
        if (expr.hasMethod()) {
            if (expr.hasExternMethod() || expr.isExtensible()) {
                return false;
            }
            IExprNode[] nodes = expr.getAllNodes();
            for (int i = 0; i < nodes.length; ++i) {
                IExprNode node = nodes[i];
                if (node instanceof ExprUnknownMethod) {
                    return false;
                }
                if (!(node instanceof ExprMethod) || ((ExprMethod)node).getMethod().getDeclaringClass().isAssignableFrom(ExcelFuncProvider.class)) continue;
                return false;
            }
        }
        if (expr.getParamExprs(al = new ObjectArray(), true) > 0) {
            int size = al.size();
            for (int ai = 0; ai < size; ++ai) {
                IExprNode[] nodes = ((Expr)al.get(ai)).getExprParams().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    Variant v;
                    IExprNode node = nodes[i];
                    if (node instanceof NamedObjectNode) {
                        return false;
                    }
                    if (!(node instanceof ExprConst) || (v = ((ExprConst)node).getValue()) == null || !v.isError()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static StatResult statBook(Book book) {
        StatResult result = new StatResult();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int cellCount = 0;
        int cellHasContentCount = 0;
        int allExpr = 0;
        int excelFunction = 0;
        int bizFunction = 0;
        ObjectArray al = new ObjectArray();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            Sheet.ICellsIterator cells = sheet.getCellsIterator(null, true, true);
            while (cells.hasNext()) {
                ++cellHasContentCount;
                Cell cell = cells.next();
                if (!cell.hasFormula()) continue;
                ++allExpr;
                Expr expr = cell.getExpr();
                al.clear();
                expr.getAllExprOps(al);
                int size = al.size();
                for (int ai = 0; ai < size; ++ai) {
                    IExprNode[] nodes = ((ExprOps)al.get(ai)).getNodes();
                    for (int j = 0; j < nodes.length; ++j) {
                        boolean isBizFunction = true;
                        String functionName = null;
                        IExprNode node = nodes[j];
                        if (node instanceof ExprUnknownMethod) {
                            functionName = ((ExprUnknownMethod)node).getMethodName();
                        } else if (node instanceof ExprMethod) {
                            if (((ExprMethod)node).isExcelMethod()) {
                                isBizFunction = false;
                            }
                            functionName = ((ExprMethod)node).getName();
                        }
                        if (functionName == null) continue;
                        Object obj = map.get(functionName);
                        if (obj != null) {
                            int count = (Integer)obj + 1;
                            map.put(functionName, count);
                        } else {
                            map.put(functionName, 1);
                        }
                        if (isBizFunction) {
                            ++bizFunction;
                            continue;
                        }
                        ++excelFunction;
                    }
                }
            }
            cellCount += (sheet.getMaxRowIndex() + 1) * (sheet.getMaxColIndex() + 1);
        }
        result.setSheetCount(book.getSheetCount());
        result.setCellCount(cellCount);
        result.setCellHasContentCount(cellHasContentCount);
        result.setExprCount(allExpr);
        result.setFunctionCount(bizFunction + excelFunction);
        result.setBizFunctionCount(bizFunction);
        result.setExcelFunctionCount(excelFunction);
        result.setFunctionMap(map);
        return result;
    }

    public static List statBookToList(Book book) {
        StatResult result = BookFormulaHelper.statBook(book);
        HashMap map = result.getFunctionMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(CtrlEXTMessages.getMLS("pageCount", "\u8868\u9875\u4e2a\u6570: ") + result.getSheetCount());
        list.add(CtrlEXTMessages.getMLS("cellCount", "\u5355\u5143\u683c\u4e2a\u6570: ") + result.getCellCount());
        list.add(CtrlEXTMessages.getMLS("nonEmptyCellCount", "\u6709\u5185\u5bb9\u5355\u5143\u683c\u4e2a\u6570: ") + result.getCellHasContentCount());
        list.add(CtrlEXTMessages.getMLS("totalFormulaCount", "\u603b\u516c\u5f0f\u4e2a\u6570: ") + result.getExprCount());
        list.add(CtrlEXTMessages.getMLS("totalFunctionCount", "\u603b\u51fd\u6570\u4e2a\u6570: ") + result.getFunctionCount());
        list.add(CtrlEXTMessages.getMLS("internalFunctionCount", "\u5185\u90e8\u51fd\u6570\u4e2a\u6570: ") + result.getExcelFunctionCount());
        list.add(CtrlEXTMessages.getMLS("businessFunctionCount", "\u4e1a\u52a1\u51fd\u6570\u4e2a\u6570: ") + result.getBizFunctionCount());
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            if (All_Expr == key || All_Function == key || Biz_Function == key || Excel_Function == key) continue;
            Integer value = (Integer)entry.getValue();
            list.add(key.toString() + ": " + value);
        }
        return list;
    }

    static class StatResult {
        private int sheetCount;
        private int cellCount;
        private int cellHasContentCount;
        private int exprCount;
        private int functionCount;
        private int excelFunctionCount;
        private int bizFunctionCount;
        private HashMap functionMap;

        StatResult() {
        }

        public int getBizFunctionCount() {
            return this.bizFunctionCount;
        }

        public void setBizFunctionCount(int bizFunctionCount) {
            this.bizFunctionCount = bizFunctionCount;
        }

        public int getCellCount() {
            return this.cellCount;
        }

        public void setCellCount(int cellCount) {
            this.cellCount = cellCount;
        }

        public int getCellHasContentCount() {
            return this.cellHasContentCount;
        }

        public void setCellHasContentCount(int cellHasContentCount) {
            this.cellHasContentCount = cellHasContentCount;
        }

        public int getExcelFunctionCount() {
            return this.excelFunctionCount;
        }

        public void setExcelFunctionCount(int excelFunctionCount) {
            this.excelFunctionCount = excelFunctionCount;
        }

        public int getExprCount() {
            return this.exprCount;
        }

        public void setExprCount(int exprCount) {
            this.exprCount = exprCount;
        }

        public int getFunctionCount() {
            return this.functionCount;
        }

        public void setFunctionCount(int functionCount) {
            this.functionCount = functionCount;
        }

        public HashMap getFunctionMap() {
            return this.functionMap;
        }

        public void setFunctionMap(HashMap functionMap) {
            this.functionMap = functionMap;
        }

        public int getSheetCount() {
            return this.sheetCount;
        }

        public void setSheetCount(int sheetCount) {
            this.sheetCount = sheetCount;
        }
    }
}

