/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import java.util.Arrays;

public class DiagonalHeader
extends AbstractTableSplitRectInfo {
    private Sheet _sheet;

    public DiagonalHeader() {
    }

    public DiagonalHeader(Sheet sheet) {
        this.setSheet(sheet);
    }

    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
    }

    public double[] getXSplitOffs() {
        if (this._xOffs == null) {
            this._xOffs = new double[this._xSplitNum];
        }
        int col = this._col;
        for (int i = 0; i < this._xSplitNum; ++i) {
            this._xOffs[i] = SheetBaseMath.getColInterval(this._sheet, col, col + this._colOffs[i]);
            col += this._colOffs[i];
        }
        return this._xOffs;
    }

    public double[] getYSplitOffs() {
        if (this._yOffs == null) {
            this._yOffs = new double[this._ySplitNum];
        }
        int row = this._row;
        for (int i = 0; i < this._ySplitNum; ++i) {
            this._yOffs[i] = SheetBaseMath.getRowInterval(this._sheet, row, row + this._rowOffs[i]);
            row += this._rowOffs[i];
        }
        return this._yOffs;
    }

    public boolean checkValid(int row, int col, int row2, int col2) {
        if (row == this._row && col == this._col && row2 == this._row2 && col2 == this._col2) {
            return true;
        }
        if (row - this._row == row2 - this._row2 && col - this._col == col2 - this._col2) {
            this._row = row;
            this._row2 = row2;
            this._col = col;
            this._col2 = col2;
            return true;
        }
        return false;
    }

    public String toString() {
        return CtrlEXTMessages.getMLS("diagonalHeader", "\u659c\u7ebf\u8868\u5934");
    }

    public boolean equals(Object o) {
        if (o instanceof DiagonalHeader) {
            DiagonalHeader ai = (DiagonalHeader)((Object)o);
            boolean b = this._row == ai._row && this._col == ai._col && this._row2 == ai._row2 && this._col2 == ai._col2;
            b = b && Arrays.equals(this._rowOffs, ai._rowOffs);
            b = b && Arrays.equals(this._colOffs, ai._colOffs);
            int size = this.size();
            int size2 = ai.size();
            boolean bl = b = b && size == size2;
            if (b) {
                for (int i = 0; i < size && (b = this.compareTriangleInfo(this.getTriangleInfo(i), ai.getTriangleInfo(i))); ++i) {
                }
            }
            return b;
        }
        return false;
    }

    private boolean compareTriangleInfo(TriangleInfo info1, TriangleInfo info2) {
        boolean b;
        boolean bl = b = info1 != null && info2 != null;
        if (b) {
            b = b && info1.isAutoZoom() == info2.isAutoZoom();
            b = b && info1.isDrawBackground() == info2.isDrawBackground();
            b = b && info1.isLean() == info2.isLean();
            boolean bl2 = b = b && StringUtil.equals((String)info1.getText(), (String)info2.getText());
            b = info1.getStyle() == null ? b && info2.getStyle() == null : b && info1.getStyle().equals((Object)info2.getStyle());
        }
        return b;
    }
}

