/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.kds.io.clipboard.StringWalker;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetAction;
import com.kingdee.cosmic.ctrl.kds.model.struct.URState;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeEvent;

public class SheetAction_StringPaste
extends SheetAction {
    private String _text;

    public SheetAction_StringPaste(Range rg, String text) {
        super(rg, SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Resize);
        this._text = text;
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        if (StringUtil.isEmptyString((String)this._text)) {
            return;
        }
        StringWalker.SeperateResult sr = StringWalker.separate2Array(this._text);
        int rows = sr.getRowCount();
        int cols = sr.getColCount();
        int row = cb.getRow();
        int col = cb.getCol();
        if (row + rows > 1048575 || col + cols > 65535) {
            return;
        }
        for (int i = 0; i < rows; ++i) {
            Row rowObj = sheet.getRow(row + i, false);
            for (int j = 0; j < cols; ++j) {
                this.setCellString(state, sheet, rowObj, row + i, col + j, col + j, sr.getValueAt(i, j));
            }
        }
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        ObjectArray clls = (ObjectArray)state.get("CELL_OBJ");
        if (clls != null) {
            ObjectArray values = (ObjectArray)state.get("CELL_VALUE");
            int size = clls.size();
            for (int i = 0; i < size; ++i) {
                Cell cll = (Cell)clls.get(i);
                cll.setVar(values.get(i));
            }
        }
    }

    private Row setCellString(URState state, Sheet sheet, Row rowObj, int row, int col, int col2, String txt) {
        block8: {
            boolean isEmptyText;
            block7: {
                isEmptyText = StringUtil.isEmptyString((String)txt);
                if (rowObj != null) break block7;
                if (isEmptyText) break block8;
                rowObj = this.getStateRow(state, sheet, row);
                for (int c = col; c <= col2; ++c) {
                    this.getStateCell(state, sheet, rowObj, c).setFormula(txt);
                }
                break block8;
            }
            int pos2 = rowObj.getProperPos(col2, true);
            if (isEmptyText) {
                for (int pos = rowObj.getProperPos(col, false); pos <= pos2; ++pos) {
                    Cell cll = rowObj.getAt(pos);
                    this.setCellState(state, cll, cll.getFormula(), cll.getValue());
                    cll.setFormula(txt);
                }
            } else {
                for (int c = col; c <= col2; ++c) {
                    Cell cll = rowObj.getCell(c, false);
                    if (cll != null) {
                        this.setCellState(state, cll, cll.getFormula(), cll.getValue());
                    } else {
                        cll = this.getStateCell(state, sheet, rowObj, c);
                    }
                    cll.setFormula(txt);
                }
            }
        }
        return rowObj;
    }

    @Override
    public String getPresentationName() {
        return CtrlEXTMessages.getMLS("paste", "\u7c98\u8d34") + super.getPresentationName();
    }
}

