/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Util;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.PartNumberString;
import com.kingdee.cosmic.ctrl.kds.model.struct.UDFSerials;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class TrendFactor {
    private int _type;
    private Variant _a;
    private Variant _b;
    private int _from;
    private int _count;
    private int _index;

    public TrendFactor(int type, Variant a, Variant b, int from, int count, int index) {
        this._type = type;
        this._a = a;
        this._b = b;
        this._from = from;
        this._count = count;
        this._index = index;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    public int getFrom() {
        return this._from;
    }

    public int getCount() {
        return this._count;
    }

    public int getIndex() {
        return this._index;
    }

    public Variant getA() {
        return this._a;
    }

    public Variant getB() {
        return this._b;
    }

    public Variant getNext(int step) {
        Variant value = null;
        try {
            switch (this._type) {
                case 4: {
                    value = new Variant(step);
                    value.multiply(this._b);
                    value.add(this._a);
                    break;
                }
                case 2: {
                    String str = this._a.toString();
                    UDFSerials.UDFSerial serial = UDFSerials.getSerial(str);
                    int index = (UDFSerials.getSerialIndex(serial, str) + step * (Integer)this._b.getValue()) % serial.size();
                    if (index < 0) {
                        index += serial.size();
                    }
                    Object next = serial.get(index);
                    if (Character.isLowerCase(str.charAt(0))) {
                        next = ((String)next).toLowerCase(Locale.ENGLISH);
                    }
                    value = new Variant(next, 11);
                    break;
                }
                case 6: {
                    value = new Variant(step);
                    value.multiply(this._b);
                    PartNumberString pns = (PartNumberString)this._a.getValue();
                    value.add(pns.getA());
                    long number = value.longValue();
                    String partStr = pns.getNext(number);
                    value.setObject(partStr, 11);
                    break;
                }
                case 16: {
                    long ms = this._b.getVt() == 4 || this._b.getVt() == 10 ? this._b.longValue() * (long)step : Util.getMillis((Calendar)this._b.getValue()) * (long)(--step);
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(ms);
                    cal.set(1, cal.get(1) - 70);
                    cal.set(10, 0);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    value = new Variant(cal, 13);
                    Calendar oldCal = (Calendar)this._a.getValue();
                    int hours = oldCal.get(11);
                    int mins = oldCal.get(12);
                    int secs = oldCal.get(13);
                    int milis = oldCal.get(14);
                    value.add(this._a);
                    ((Calendar)value.getValue()).set(11, hours);
                    ((Calendar)value.getValue()).set(10, hours);
                    ((Calendar)value.getValue()).set(12, mins);
                    ((Calendar)value.getValue()).set(13, secs);
                    ((Calendar)value.getValue()).set(14, milis);
                    ((Calendar)value.getValue()).set(11, hours);
                    break;
                }
                case 64: 
                case 128: {
                    Calendar cal = (Calendar)this._a.getValue();
                    Calendar newCal = Calendar.getInstance();
                    newCal.setTime(cal.getTime());
                    newCal.add(this._type == 64 ? 2 : 1, step);
                    if (cal.get(5) == cal.getActualMaximum(5)) {
                        newCal.set(5, newCal.getActualMaximum(5));
                    }
                    value = new Variant(newCal, 13);
                    break;
                }
                case 32: {
                    if (this._a.isDate()) {
                        int day = ((Calendar)this._a.getValue()).get(7) - 1;
                        Calendar cl = Calendar.getInstance();
                        cl.setTimeInMillis((long)day * this._b.longValue());
                        Variant firstDay = new Variant(cl, 13);
                        this._a.subtract(firstDay, firstDay);
                        int index = (day + step) % 5;
                        if (index <= 0) {
                            index += 5;
                        }
                        value = new Variant(index + (day + step + (step > 0 ? -1 : -5)) / 5 * 7);
                        value.multiply(this._b);
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(new Date((Long)value.getValue()));
                        value.setObject(cal, 13);
                        value.add(firstDay);
                        break;
                    }
                    String str = this._a.toString();
                    UDFSerials.UDFSerial serial = UDFSerials.getSerial(str);
                    int index = (UDFSerials.getSerialIndex(serial, str) + step * (Integer)this._b.getValue()) % 5;
                    if (index <= 0) {
                        index += 5;
                    }
                    Object next = serial.get(index);
                    if (Character.isLowerCase(str.charAt(0))) {
                        next = ((String)next).toLowerCase(Locale.ENGLISH);
                    }
                    value = new Variant(next, 11);
                    break;
                }
                case 8: {
                    value = new Variant(Math.pow(this._b.doubleValue(), step));
                    value.multiply(this._a);
                    break;
                }
            }
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        return value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("type:").append(this._type).append('\t').append("from:").append(this._from).append('\t').append("count:").append(this._count).append('\t').append("index").append(this._index).append('\t').append('A').append(this._a).append('\t').append('B').append(this._b);
        return builder.toString();
    }
}

