/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.bos.qing.common.i18n.untrans.QingConstellationUntrans;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class UDFSerials {
    private static HashMap _serials = new HashMap();

    public static boolean addSerial(String[] strs, boolean isWeek) {
        return UDFSerials.addSerial(new ArrayList<String>(Arrays.asList(strs)), isWeek);
    }

    public static boolean addSerial(ArrayList serial, boolean isWeek) {
        int i;
        if (serial == null || serial.size() == 0) {
            return false;
        }
        serial = new UDFSerial(serial, isWeek);
        for (i = serial.size() - 1; i >= 0; --i) {
            if (!StringUtil.isEmptyString((String)((String)serial.get(i)))) continue;
            serial.remove(i);
        }
        if (serial.size() == 0 || _serials.containsValue(serial)) {
            return false;
        }
        for (i = serial.size() - 1; i >= 0; --i) {
            _serials.put(serial.get(i), serial);
        }
        return true;
    }

    public static boolean removeSerial(UDFSerial serial) {
        if (serial == null || serial.size() == 0) {
            return false;
        }
        boolean bRet = false;
        for (int i = serial.size() - 1; i >= 0; --i) {
            bRet |= _serials.remove(serial.get(i)) != null;
        }
        serial.clear();
        UDFSerials.restruct();
        return bRet;
    }

    private static void restruct() {
        HashMap oldSerials = _serials;
        _serials = new HashMap();
        for (Map.Entry e : oldSerials.entrySet()) {
            ArrayList al = (ArrayList)e.getValue();
            for (int i = al.size() - 1; i >= 0; --i) {
                Object key = al.get(i);
                oldSerials.remove(key);
                _serials.put(key, al);
            }
        }
    }

    public static UDFSerial getSerial(String str) {
        UDFSerial al = (UDFSerial)_serials.get(str);
        if (al == null) {
            for (Map.Entry e : _serials.entrySet()) {
                if (str.compareToIgnoreCase((String)e.getKey()) != 0) continue;
                al = (UDFSerial)e.getValue();
                break;
            }
        }
        return al;
    }

    public static int getSerialIndex(UDFSerial serial, String str) {
        int index = serial.lastIndexOf(str);
        if (index < 0) {
            for (int i = serial.size() - 1; i >= 0; --i) {
                if (str.compareToIgnoreCase((String)serial.get(i)) != 0) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static String getNext(UDFSerial serial, int srcIndex, int step) {
        int index = (srcIndex + step) % serial.size();
        return (String)serial.get(index);
    }

    static {
        UDFSerials.addSerial(new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"}, true);
        UDFSerials.addSerial(new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"}, true);
        UDFSerials.addSerial(new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"}, false);
        UDFSerials.addSerial(new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"}, false);
        UDFSerials.addSerial(QingConstellationUntrans.DAYS_OF_WEEK, true);
        UDFSerials.addSerial(QingConstellationUntrans.FULL_DAYS_OF_WEEK, true);
        UDFSerials.addSerial(QingConstellationUntrans.MONTHS, false);
        UDFSerials.addSerial(QingConstellationUntrans.LUNAR_MONTHS, false);
        UDFSerials.addSerial(QingConstellationUntrans.SEASONS, false);
        UDFSerials.addSerial(QingConstellationUntrans.ZODIAC_SIGNS, false);
        UDFSerials.addSerial(QingConstellationUntrans.HEAVENLY_STEMS, false);
    }

    static class UDFSerial
    extends ArrayList {
        private static final long serialVersionUID = 7918245459376064633L;
        private boolean _isWeek;

        public UDFSerial(ArrayList al, boolean isWeek) {
            super(al);
            this._isWeek = isWeek;
        }

        public boolean isWeek() {
            return this._isWeek;
        }
    }
}

