/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Column;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedColumnArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedRowArray;
import com.kingdee.cosmic.ctrl.kds.model.util.AbstractIntMarkArray;

public class URState {
    public static final URState EMPTY_State = new URState(null);
    private Sheet _sheet;
    private SortedObjectArray _state;

    public URState(Sheet sheet) {
        this._sheet = sheet;
        this._state = new SortedObjectArray(6);
    }

    public boolean isEmpty() {
        return this._state.isEmpty();
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    private void put(String key, Object value) {
        this._state.insert(new Node(key, value));
    }

    public Object get(String key) {
        int pos = this.searchString(key);
        return pos >= 0 ? ((Node)this._state.get((int)pos))._value : null;
    }

    private int searchString(String key) {
        if (this._state.isEmpty()) {
            return -1;
        }
        Object[] array = this._state.getArray();
        int low = 0;
        int high = this._state.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = array[mid];
            int cmp = ((Node)midVal)._key.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public Object getData(String key, Class dstClass, Object defaultInst) {
        Object obj = this.get(key);
        if (obj == null) {
            obj = defaultInst;
            if (obj == null) {
                try {
                    obj = dstClass.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setData(key, obj);
        }
        return obj;
    }

    public boolean setData(String key, Object obj) {
        if (obj == null) {
            return false;
        }
        this.put(key, obj);
        return true;
    }

    public Row getRow(int row) {
        Row rowObj = this._sheet.getRow(row, false);
        if (rowObj == null) {
            rowObj = this._sheet.getRow(row, true);
            ObjectArray rows = (ObjectArray)this.getData("ROW_CREATED", ObjectArray.class, null);
            rows.append(rowObj);
        }
        return rowObj;
    }

    public Column getCol(int col) {
        Column colObj = this._sheet.getColumn(col, false);
        if (colObj == null) {
            colObj = this._sheet.getColumn(col, true);
            ObjectArray cols = (ObjectArray)this.getData("COL_CREATED", ObjectArray.class, null);
            cols.append(colObj);
        }
        return colObj;
    }

    public Cell getCell(Row rowObj, int col) {
        this.getCol(col);
        Cell cll = rowObj.getCell(col, false);
        if (cll == null) {
            cll = rowObj.getCell(col, true);
            ObjectArray clls = (ObjectArray)this.getData("CELL_CREATED", ObjectArray.class, null);
            clls.append(cll);
        }
        return cll;
    }

    public Cell getCell(int row, int col) {
        return this.getCell(this.getRow(row), col);
    }

    public static void collectEmptyObjects(Sheet sheet, int row, int col, int row2, int col2) {
        Sheet.ICellsIterator ci = sheet.getCellsIterator(sheet.getValidRow(row), sheet.getValidCol(col), sheet.getValidRow(row2), sheet.getValidCol(col2), true, false);
        if (ci.hasNext()) {
            while (ci.hasNext()) {
                Cell cll = ci.next();
                if (!cll.isEmpty()) continue;
                cll.getRowObject().remove(cll.getCol());
            }
        }
        SortedRowArray rows = sheet.getRows();
        int pos = rows.getProperPos(row, false);
        int pos2 = rows.getProperPos(row2, true);
        if (pos2 >= pos) {
            for (int p = pos2; p >= pos; --p) {
                if (!rows.getAt(p).isEmptyContent()) continue;
                rows.removeByPos(p);
            }
        }
        SortedColumnArray cols = sheet.getCols();
        pos = cols.getProperPos(col, false);
        pos2 = cols.getProperPos(col2, true);
        if (pos2 >= pos) {
            for (int p = pos2; p >= pos; --p) {
                if (!cols.getAt(p).isEmptyContent()) continue;
                cols.removeByPos(p);
            }
        }
    }

    public void collectEmptyObjects(int row, int col, int row2, int col2) {
        Sheet.ICellsIterator ci = this._sheet.getCellsIterator(this._sheet.getValidRow(row), this._sheet.getValidCol(col), this._sheet.getValidRow(row2), this._sheet.getValidCol(col2), true, false);
        if (ci.hasNext()) {
            ObjectArray deletedClls = null;
            while (ci.hasNext()) {
                Cell cll = ci.next();
                if (!cll.isEmpty()) continue;
                if (deletedClls == null) {
                    deletedClls = (ObjectArray)this.getData("CELL_DELETED", ObjectArray.class, null);
                }
                deletedClls.append(cll.getRowObject().remove(cll.getCol()));
            }
        }
        SortedRowArray rows = this._sheet.getRows();
        int pos = rows.getProperPos(row, false);
        int pos2 = rows.getProperPos(row2, true);
        if (pos2 >= pos) {
            SortedRowArray deletedRows = null;
            for (int p = pos2; p >= pos; --p) {
                if (!rows.getAt(p).isEmptyContent()) continue;
                if (deletedRows == null) {
                    deletedRows = (SortedRowArray)this.getData("ROW_DELETED", SortedRowArray.class, null);
                }
                deletedRows.insert(rows.removeByPos(p));
            }
        }
        SortedColumnArray cols = this._sheet.getCols();
        pos = cols.getProperPos(col, false);
        pos2 = cols.getProperPos(col2, true);
        if (pos2 >= pos) {
            AbstractIntMarkArray deletedCols = null;
            for (int p = pos2; p >= pos; --p) {
                if (!cols.getAt(p).isEmptyContent()) continue;
                if (deletedCols == null) {
                    deletedCols = (SortedColumnArray)this.getData("COL_DELETED", SortedColumnArray.class, null);
                }
                deletedCols.insert(cols.removeByPos(p));
            }
        }
    }

    void resumeDeleted() {
        Boolean updateColIdx;
        SortedRowArray deletedRows;
        Boolean updateRowIdx = (Boolean)this.get("ROW_IDX_UPDATE");
        if (updateRowIdx != null && !updateRowIdx.booleanValue() && (deletedRows = (SortedRowArray)this.get("ROW_DELETED")) != null) {
            SortedRowArray rows = this._sheet.getRows();
            int size = deletedRows.size();
            for (int i = 0; i < size; ++i) {
                Row rowObj = deletedRows.getAt(i);
                if (rowObj.getRow() < 0) continue;
                rows.insert(rowObj);
            }
        }
        if ((updateColIdx = (Boolean)this.get("COL_IDX_UPDATE")) != null && !updateColIdx.booleanValue()) {
            ObjectArray deletedClls;
            int i;
            SortedColumnArray deletedCols = (SortedColumnArray)this.get("COL_DELETED");
            if (deletedCols != null) {
                SortedColumnArray cols = this._sheet.getCols();
                int size = deletedCols.size();
                for (i = 0; i < size; ++i) {
                    Column colObj = deletedCols.getAt(i);
                    if (colObj.getCol() < 0) continue;
                    cols.insert(colObj);
                }
            }
            if ((deletedClls = (ObjectArray)this.get("CELL_DELETED")) != null) {
                for (i = deletedClls.size() - 1; i >= 0; --i) {
                    Cell cll = (Cell)deletedClls.get(i);
                    cll.getRowObject().insert(cll);
                }
            }
        }
    }

    void resumeCreated() {
        ObjectArray colsCreated;
        ObjectArray rowsCreated;
        ObjectArray cllsCreated = (ObjectArray)this.get("CELL_CREATED");
        if (cllsCreated != null) {
            for (int i = cllsCreated.size() - 1; i >= 0; --i) {
                Cell cll = (Cell)cllsCreated.get(i);
                int col = cll.getCol();
                cll.getRowObject().remove(col, col, false, false);
            }
        }
        if ((rowsCreated = (ObjectArray)this.get("ROW_CREATED")) != null) {
            SortedRowArray rows = this._sheet.getRows();
            for (int i = rowsCreated.size() - 1; i >= 0; --i) {
                int row = ((Row)rowsCreated.get(i)).getRow();
                rows.remove(row, row, false, false);
            }
        }
        if ((colsCreated = (ObjectArray)this.get("COL_CREATED")) != null) {
            SortedColumnArray cols = this._sheet.getCols();
            for (int i = colsCreated.size() - 1; i >= 0; --i) {
                int col = ((Column)colsCreated.get(i)).getCol();
                cols.remove(col, col, false, false);
            }
        }
    }

    static class Node
    implements Comparable {
        String _key;
        Object _value;

        Node(String key, Object value) {
            this._key = key;
            this._value = value;
        }

        public int compareTo(Object o) {
            return this._key.compareTo(((Node)o)._key);
        }

        public String toString() {
            return this._key + " " + this._value;
        }
    }
}

