/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.cformat;

import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.cformat.ConditionalFormat;
import com.kingdee.cosmic.ctrl.kds.model.struct.cformat.util.Condition;
import com.kingdee.cosmic.ctrl.kds.model.util.IntArray;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import java.util.ArrayList;

public class ConditionalFormatList {
    private static final SortedCellBlockArray compResult = new SortedCellBlockArray();
    private static final SortedCellBlockArray remainResult = new SortedCellBlockArray();
    private ArrayList _conditionalFormats = new ArrayList();

    public ConditionalFormatList getClippedCopy(int left, int top, int right, int bottom) {
        ArrayList<ConditionalFormat> clippedConditionalFormats = new ArrayList<ConditionalFormat>();
        for (int i = 0; i < this._conditionalFormats.size(); ++i) {
            ConditionalFormat cf = ((ConditionalFormat)this._conditionalFormats.get(i)).getClippedCopy(left, top, right, bottom);
            if (cf == null) continue;
            clippedConditionalFormats.add(cf);
        }
        if (clippedConditionalFormats.size() == 0) {
            return null;
        }
        ConditionalFormatList cfl = new ConditionalFormatList();
        cfl._conditionalFormats = clippedConditionalFormats;
        return cfl;
    }

    public void merge(ConditionalFormatList clippedCopy, int offsetY, int offsetX) {
        if (clippedCopy == null) {
            return;
        }
        ArrayList clippedConditionalFormats = clippedCopy._conditionalFormats;
        for (int i = 0; i < clippedConditionalFormats.size(); ++i) {
            ConditionalFormat cf = (ConditionalFormat)clippedConditionalFormats.get(i);
            SortedCellBlockArray scba = cf.getBlocks();
            SortedCellBlockArray newBlocks = new SortedCellBlockArray();
            int size = scba.size();
            for (int j = 0; j < size; ++j) {
                newBlocks.insert(CellBlock.getCellBlock(scba.getBlock(j)));
            }
            int size2 = newBlocks.size();
            for (int j = 0; j < size2; ++j) {
                CellBlock cb = newBlocks.getBlock(j);
                cb.offset(offsetY, offsetX);
            }
            this.insertConditionalFormat(cf.getConditions(), cf.getSSAs(), newBlocks);
        }
    }

    public int size() {
        return this._conditionalFormats == null ? 0 : this._conditionalFormats.size();
    }

    public ConditionalFormat getConditionalFormat(int index) {
        return (ConditionalFormat)this._conditionalFormats.get(index);
    }

    public ConditionalFormat getConditionalFormat(int row, int col) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ConditionalFormat cf = this.getConditionalFormat(i);
            SortedCellBlockArray sa = cf.getBlocks();
            int vIndex = sa.searchBlockIndex(row, col);
            if (vIndex < 0) continue;
            return cf;
        }
        return null;
    }

    public int isMatched(Sheet sheet, int row, int col, Variant var) {
        ConditionalFormat cf = this.getConditionalFormat(row, col);
        if (cf == null) {
            return -1;
        }
        Condition[] conditions = cf.getConditions();
        if (conditions == null) {
            return -1;
        }
        for (int i = 0; i < conditions.length; ++i) {
            if (!conditions[i].isMatched(sheet, var)) continue;
            return i;
        }
        return -1;
    }

    public void addConditionalFormat(ConditionalFormat cf) {
        this._conditionalFormats.add(cf);
    }

    public void insertConditionalFormat(Condition[] conditions, ShareStyleAttributes[] atts, SortedCellBlockArray sa) {
        IntArray intersects = new IntArray();
        this.calcIntersects(sa, intersects);
        this.insertConditionalFormat(conditions, atts, sa, intersects);
    }

    public boolean calcIntersects(SortedCellBlockArray sa, IntArray intersects) {
        int size = this.size();
        if (size <= 0) {
            return false;
        }
        compResult.copyFrom(sa);
        for (int i = 0; i < size; ++i) {
            ConditionalFormat cf = this.getConditionalFormat(i);
            SortedCellBlockArray thisBlocks = cf.getBlocks();
            remainResult.clear();
            boolean split = thisBlocks.split(compResult, remainResult);
            if (split) {
                intersects.add(i);
            }
            if (remainResult.isEmpty()) {
                return true;
            }
            compResult.copyFrom(remainResult);
        }
        return false;
    }

    private void insertConditionalFormat(Condition[] conditions, ShareStyleAttributes[] atts, SortedCellBlockArray sa, IntArray intersects) {
        int size = intersects.size();
        for (int i = 0; i < size; ++i) {
            ConditionalFormat cf = this.getConditionalFormat(intersects.get(i));
            SortedCellBlockArray thisBlocks = cf.getBlocks();
            remainResult.clear();
            sa.split(thisBlocks, remainResult);
            thisBlocks.copyFrom(remainResult);
        }
        if (conditions.length > 0) {
            boolean insert = false;
            int size2 = this.size();
            for (int i = 0; i < size2; ++i) {
                ConditionalFormat cf = this.getConditionalFormat(i);
                if (!this.isConditionsEqual(conditions, cf.getConditions()) || !this.isSSAsEqual(atts, cf.getSSAs())) continue;
                SortedCellBlockArray thisBlocks = cf.getBlocks();
                thisBlocks.addAll(sa);
                insert = true;
            }
            if (!insert) {
                if (this._conditionalFormats == null) {
                    this._conditionalFormats = new ArrayList();
                }
                ConditionalFormat cf = new ConditionalFormat();
                cf.setBlocks(sa);
                cf.setConditions(conditions);
                cf.setSSAs(atts);
                for (int i = 0; i < conditions.length; ++i) {
                    conditions[i].setOwner(cf);
                }
                this._conditionalFormats.add(cf);
            }
        }
        this.reduceImpl();
    }

    public void reduce() {
        this.reduceImpl();
    }

    private void reduceImpl() {
        for (int i = this.size() - 1; i >= 0; --i) {
            ConditionalFormat cf = this.getConditionalFormat(i);
            SortedCellBlockArray thisBlocks = cf.getBlocks();
            if (thisBlocks.isEmpty()) {
                this._conditionalFormats.remove(i);
                Condition[] cons = cf.getConditions();
                if (cons != null) {
                    for (int j = 0; j < cons.length; ++j) {
                        if (cons[j] == null) continue;
                        cons[j].dissociate();
                    }
                }
            }
            if (cf.getConditions() != null && cf.getConditions().length != 0) continue;
            this._conditionalFormats.remove(i);
        }
    }

    private boolean isConditionsEqual(Condition[] c1, Condition[] c2) {
        if (c1.length != c2.length) {
            return false;
        }
        for (int i = 0; i < c1.length; ++i) {
            if (c1[i].equals(c2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isSSAsEqual(ShareStyleAttributes[] sas1, ShareStyleAttributes[] sas2) {
        if (sas1.length != sas2.length) {
            return false;
        }
        for (int i = 0; i < sas1.length; ++i) {
            if (sas1[i] != null && sas1[i].equals((Object)sas2[i])) continue;
            return false;
        }
        return true;
    }
}

