/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.util;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.DataLabelUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.dataset.AbstractChartKindOf;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.dataset.ChartKindOfXY;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Category;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.CategoryScatter;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.ICategory;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.dataset.Series;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class ChartUtil {
    public static final String ZERO = "0";
    public static final String ONE = "1";
    public static final String TWO = "2";

    private static final String getTransferChartMessage() {
        return CtrlEXTMessages.getMLS("advancedChartUpdatedToEChartsQuestion", "\u9ad8\u7ea7\u56fe\u8868\u5df2\u66f4\u65b0\u4e3aECharts\u56fe\u8868\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5347\u7ea7\uff0c\u4e00\u65e6\u5347\u7ea7\u540e\u5c06\u4e0d\u53ef\u56de\u9000\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f");
    }

    private static final String getTransferChartMessageDetail() {
        return CtrlEXTMessages.getMLS("selectYesToAutoConvert", "\u9009\u62e9\u662f\uff0c\u81ea\u52a8\u8f6c\u6362\u4e3aECharts\u56fe\u8868\uff0c\u4fdd\u5b58\u62a5\u8868\u540e\u751f\u6548\uff1b\u9009\u62e9\u5426\uff0c\u4e0d\u8f6c\u6362\u3002\u5982\u9700\u5173\u95ed\u63d0\u793a\u529f\u80fd\u53ef\u4ee5\u5728\u3010\u62a5\u8868\u663e\u793a\u5c5e\u6027\u3011\u52fe\u9009\u3010\u4e0d\u63d0\u793a\u65e7\u56fe\u8868\u5207\u6362\u3011\u3002");
    }

    public static IXmlElement toXml(DataFromDataset fromDataset, FlashChartType chartType) {
        if (fromDataset == null) {
            return null;
        }
        IXmlElement dataSet = XmlUtil.createNode((String)"DataFromDataset");
        ChartUtil.setAttribute(dataSet, "DatasetId", fromDataset.getDatasetId());
        ChartUtil.setAttribute(dataSet, "DatasetName", fromDataset.getDatasetName());
        ChartUtil.setAttribute(dataSet, "Category", fromDataset.getCategory());
        List<Series> seriesList = fromDataset.getSeries();
        if (seriesList == null || seriesList.isEmpty()) {
            return dataSet;
        }
        for (int i = 0; i < seriesList.size(); ++i) {
            Series iSeries;
            IXmlElement seriesElement = XmlUtil.createNode((String)"Series");
            Series series = iSeries = seriesList.get(i);
            ChartUtil.setAttribute(seriesElement, "SeriesNameType", series.getSeriesNameType());
            ChartUtil.setAttribute(seriesElement, "ChartType", series.getChartShowType());
            ChartUtil.setAttribute(seriesElement, "YAxisPosition", series.getYAxisPosition());
            List<ICategory> categories = series.getCategories();
            if (categories != null && !categories.isEmpty()) {
                for (int j = 0; j < categories.size(); ++j) {
                    IXmlElement categoryElement = XmlUtil.createNode((String)"Category");
                    ICategory iCategory = categories.get(j);
                    if (iCategory instanceof Category) {
                        Category category = (Category)iCategory;
                        ChartUtil.setAttribute(categoryElement, "SeriesName", category.getSeriesName());
                        ChartUtil.setAttribute(categoryElement, "SeriesValue", category.getSeriesValue());
                        ChartUtil.setAttribute(categoryElement, "SummaryType", category.getSummaryType());
                    } else if (iCategory instanceof CategoryScatter) {
                        CategoryScatter categoryScatter = (CategoryScatter)iCategory;
                        ChartUtil.setAttribute(categoryElement, "SeriesName", categoryScatter.getSeriesName());
                        ChartUtil.setAttribute(categoryElement, "SeriesX", categoryScatter.getSeriesX());
                        ChartUtil.setAttribute(categoryElement, "SeriesY", categoryScatter.getSeriesY());
                        ChartUtil.setAttribute(categoryElement, "SeriesSize", categoryScatter.getSeriesSize());
                    }
                    seriesElement.addChild(categoryElement);
                }
            }
            dataSet.addChild(seriesElement);
        }
        return dataSet;
    }

    public static DataFromDataset parseXml(IXmlElement elementRoot, FlashChartType chartType) {
        if (elementRoot == null) {
            return null;
        }
        AbstractChartKindOf chartKindOf = DataLabelUtil.getChartKindOf(chartType);
        DataFromDataset fromDataset = new DataFromDataset();
        List elements = elementRoot.getChildren();
        fromDataset.setDatasetId(elementRoot.getAttribute("DatasetId"));
        fromDataset.setDatasetName(elementRoot.getAttribute("DatasetName"));
        fromDataset.setCategory(elementRoot.getAttribute("Category"));
        ArrayList<Series> seriesList = new ArrayList<Series>(elements.size());
        fromDataset.setSeries(seriesList);
        for (IXmlElement element2 : elements) {
            Series series = new Series();
            series.setSeriesNameType(element2.getAttribute("SeriesNameType"));
            series.setChartShowType(element2.getAttribute("ChartType"));
            series.setYAxisPosition(element2.getAttribute("YAxisPosition"));
            ArrayList<ICategory> categoryList = new ArrayList<ICategory>();
            series.setCategories(categoryList);
            List elementCategory = element2.getChildren();
            for (IXmlElement element2 : elementCategory) {
                if (chartKindOf instanceof ChartKindOfXY) {
                    CategoryScatter categoryScatter = new CategoryScatter();
                    categoryScatter.setSeriesName(element2.getAttribute("SeriesName"));
                    categoryScatter.setSeriesX(element2.getAttribute("SeriesX"));
                    categoryScatter.setSeriesY(element2.getAttribute("SeriesY"));
                    categoryScatter.setSeriesSize(element2.getAttribute("SeriesSize"));
                    categoryList.add(categoryScatter);
                    continue;
                }
                Category category = new Category();
                category.setSeriesName(element2.getAttribute("SeriesName"));
                category.setSeriesValue(element2.getAttribute("SeriesValue"));
                category.setSummaryType(element2.getAttribute("SummaryType"));
                categoryList.add(category);
            }
            seriesList.add(series);
        }
        return fromDataset;
    }

    private static void setAttribute(IXmlElement element, String name, String value) {
        if (!StringUtil.isEmptyString((String)value)) {
            element.setAttribute(name, value);
        }
    }

    public static boolean hasChart(Book book, ChartFrameWorkType type) {
        boolean hasChart = false;
        block0: for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            EmbedhLayer layper = sheet.getEmbedments(false);
            if (hasChart || null == layper) continue;
            for (int j = 0; j < layper.size(); ++j) {
                EmbedObject obj = layper.getEmbed(j);
                if (!(obj instanceof ChartRectEmbedment) || ((ChartRectEmbedment)obj).getModel().getFrameWorkType() != type) continue;
                hasChart = true;
                continue block0;
            }
        }
        return hasChart;
    }

    public static boolean processTransferCharts(Component parent, Book book) {
        boolean flag = false;
        if (MessageUtil.msgboxYesNo(parent, ChartUtil.getTransferChartMessage(), ChartUtil.getTransferChartMessageDetail())) {
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                EmbedhLayer layper = sheet.getEmbedments(false);
                if (null == layper) continue;
                for (int j = 0; j < layper.size(); ++j) {
                    EmbedObject obj = layper.getEmbed(j);
                    if (!(obj instanceof FlashChart)) continue;
                    obj = ChartUtil.transferChartRectEmbedment((FlashChart)obj, ChartFrameWorkType.ECHART);
                    layper.setEmbed(j, obj);
                    flag = true;
                }
            }
        }
        return flag;
    }

    public static ChartRectEmbedment transferChartRectEmbedment(ChartRectEmbedment chart, ChartFrameWorkType chartFrameWorkType) {
        FlashChartModel srcModel = chart.getModel();
        if (chartFrameWorkType == srcModel.getFrameWorkType()) {
            return chart;
        }
        srcModel.setFrameWorkType(chartFrameWorkType);
        ChartRectEmbedment cb = null;
        cb = ChartFrameWorkType.ECHART == chartFrameWorkType ? new EChart(chart.getSheet(), srcModel) : new FlashChart(chart.getSheet(), srcModel);
        cb.setBounds(chart.getBounds());
        cb.setAnchorMode(chart.getAnchorMode());
        if (chart.getAnchorMode() == 0) {
            cb.setAnchorCellLT(chart.getAnchorCellLT());
            cb.setAnchorCellRB(chart.getAnchorCellRB());
        } else if (chart.getAnchorMode() == 1) {
            cb.setAnchorCellLT(chart.getAnchorCellLT());
        }
        cb.setName(chart.getName());
        return cb;
    }
}

