/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts;

import chrriis.dj.nativeswing.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserFunction;
import com.github.abel533.echarts.Option;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.IExecuteableDisplayPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.INativeEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.BrowserType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.IExecutePanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.djbrowser.KDNativeBrowserPanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.jfx.KDWebViewPanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.browser.jfx.PageModeWebViewPanel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.DebugResourceProvider;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsRenderType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.DefaultChartFinishedFunction;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.DefaultEChartsMouseClickFunction;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.DocumentReadyFunction;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.IChartFinishedFunction;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.IChartReadyFunction;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.IEChartsClickEventHandler;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.manager.DefaultChartReadyManager;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferMapper;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModelUtils;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDPopupMenu;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.util.Uuid;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;
import org.apache.log4j.Logger;

public class EChartDisplayPanel
extends KDPanel
implements INativeEmbedment,
IExecuteableDisplayPanel {
    private static final long serialVersionUID = 464546482374913379L;
    private IExecutePanel webBrowser;
    private FusionGraphicsModel model;
    private boolean showPopMenu = false;
    private boolean debug = false;
    private boolean showDemoData;
    private boolean pageMode;
    private transient DefaultChartReadyManager readyFunctionManager = new DefaultChartReadyManager();
    private transient DefaultEChartsMouseClickFunction clickHandlerManager = new DefaultEChartsMouseClickFunction("echartClickFunction");
    private transient DefaultChartFinishedFunction finishedHandlerManager = new DefaultChartFinishedFunction();
    private boolean loadingCompleted = false;
    private EChartsRenderType renderType;
    private String chartID = Uuid.create().toString();
    private BrowserType browserType;
    private static final Logger LOGGER = Logger.getLogger(EChartDisplayPanel.class);
    private Queue<String> scriptQueue = new LinkedList<String>();
    private AtomicBoolean inited = new AtomicBoolean(false);
    private transient DocumentReadyFunction documentReadyFunction = new DocumentReadyFunction("ready", this.readyFunctionManager);

    @Override
    public Component getNativeComponent() {
        if (this.webBrowser instanceof INativeEmbedment) {
            return ((INativeEmbedment)((Object)this.webBrowser)).getNativeComponent();
        }
        return this.webBrowser.getMainComponent();
    }

    private EChartDisplayPanel(EChartsRenderType rType, BrowserType type, IChartReadyFunction function, FusionGraphicsModel model, boolean showPopMenu, boolean showDemoData, boolean debug, boolean pageMode) {
        this.model = model;
        this.debug = debug;
        this.showDemoData = showDemoData;
        this.showPopMenu = showPopMenu;
        this.browserType = type;
        this.setLayout(new BorderLayout());
        this.readyFunctionManager.registeFunction(new DisplayPanelReadyInitializer());
        this.readyFunctionManager.registeFunction(function);
        this.renderType = rType;
        this.pageMode = pageMode;
        this.initcomponents();
    }

    public EChartDisplayPanel(IChartReadyFunction function, FusionGraphicsModel model, boolean showPopMenu, boolean showDemoData, boolean debug) {
        this(EChartsRenderType.SVG, BrowserType.WEBVIEW, function, model, showPopMenu, showDemoData, debug, false);
    }

    public EChartDisplayPanel(IChartReadyFunction function) {
        this(function, null, false, false, false);
    }

    public EChartDisplayPanel(boolean showPopMenu, boolean debug) {
        this(null, null, showPopMenu, false, debug);
    }

    public EChartDisplayPanel() {
        this(null, null, false, false, false);
    }

    public EChartDisplayPanel(boolean showDemoData) {
        this(null, null, false, showDemoData, false);
    }

    public static EChartDisPlayPanelBuidler getBuidler() {
        return EChartDisPlayPanelBuidler.instance;
    }

    private void initDJBrowser() {
        this.webBrowser = new KDNativeBrowserPanel(WebServer.getDefaultWebServer().getClassPathResourceURL(this.getClass().getName(), "./chart.html"), null, this.debug);
        JWebBrowser browser = ((KDNativeBrowserPanel)this.webBrowser).getBrowser();
        browser.registerFunction((WebBrowserFunction)new DocumentReadyFunction("readyfunction", this.readyFunctionManager, this.webBrowser));
    }

    public DefaultChartFinishedFunction getFinishedHandlerManager() {
        return this.finishedHandlerManager;
    }

    private void initWebView(boolean pMode) {
        WebServer server = WebServer.getDefaultWebServer();
        String url = server.getClassPathResourceURL(this.getClass().getName(), "./chart.html") + "?t=" + System.currentTimeMillis();
        String debugID = DebugResourceProvider.genDebugID();
        if (pMode) {
            LOGGER.debug((Object)"start record js mod.");
            url = server.getDynamicContentURL("com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.DebugResourceProvider", debugID);
            this.webBrowser = new PageModeWebViewPanel(url, f -> {
                JSObject window = JSUtils.getWindow(this.webBrowser);
                Object ready = window.getMember("isReady");
                LOGGER.debug((Object)("document is ready: " + ready));
                if (Boolean.TRUE.equals(ready)) {
                    LOGGER.debug((Object)"register click function.");
                    this.registerOnClickFunction(this.webBrowser);
                }
            }, this.debug, true, true);
            LOGGER.debug((Object)"pagemode execute readyFunctionManager.");
            SwingUtilities.invokeLater(() -> this.readyFunctionManager.onReady(this.webBrowser));
        } else {
            this.webBrowser = new KDWebViewPanel(url, f -> {
                JSObject window = JSUtils.getWindow(this.webBrowser);
                LOGGER.debug((Object)"regist webView initor.");
                this.documentReadyFunction.setPanel(this.webBrowser);
                window.setMember("initor", this.documentReadyFunction);
                Object ready = window.getMember("isReady");
                LOGGER.debug((Object)("document is ready: " + ready));
                if (Boolean.TRUE.equals(ready)) {
                    LOGGER.debug((Object)"document is ready execute script.");
                    this.readyFunctionManager.onReady(this.webBrowser);
                    LOGGER.debug((Object)"register click function.");
                    this.registerOnClickFunction(this.webBrowser);
                }
            }, this.debug, true, this.debug);
        }
        if (this.debug || this.pageMode) {
            this.readyFunctionManager.registeFunction(b -> Platform.runLater(() -> {
                KDWebViewPanel webViewPanel = (KDWebViewPanel)b;
                webViewPanel.setDebugID(debugID);
                webViewPanel.setDebugURL(server.getDynamicContentURL("com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.DebugResourceProvider", debugID));
                String js = webViewPanel.getRecordJS();
                if (null != js) {
                    DebugResourceProvider.addJS(debugID, js);
                }
                webViewPanel.resetRecorder();
            }));
        }
    }

    private void initcomponents() {
        if (BrowserType.DJNATIVEBROWSER == this.browserType) {
            this.initDJBrowser();
            this.add(this.webBrowser.getMainComponent(), "Center");
        } else if (BrowserType.WEBVIEW == this.browserType) {
            this.initWebView(this.pageMode);
            this.add(this.webBrowser.getMainComponent(), "Center");
            SwingUtilities.invokeLater(() -> {
                KDWebViewPanel webViewPanel = (KDWebViewPanel)this.webBrowser;
                webViewPanel.reload();
            });
        }
        if (this.showPopMenu) {
            this.getNativeComponent().addMouseListener(new EChartRefreshListener());
        }
    }

    public void registerClickHandler(IEChartsClickEventHandler handler) {
        this.clickHandlerManager.registerHandler(handler);
    }

    public void registerFinishHandler(IChartFinishedFunction handler) {
        this.finishedHandlerManager.addFunction(handler);
    }

    public boolean removeFinishHandler(IChartFinishedFunction handler) {
        return this.finishedHandlerManager.removeFunction(handler);
    }

    public boolean removeClickHandler(IEChartsClickEventHandler handler) {
        return this.clickHandlerManager.removeHandler(handler);
    }

    public boolean isLoadingCompleted() {
        return this.loadingCompleted;
    }

    public boolean isShowPopMenu() {
        return this.showPopMenu;
    }

    public void setShowPopMenu(boolean showPopMenu) {
        if (!this.showPopMenu && showPopMenu) {
            this.showPopMenu = showPopMenu;
            EChartRefreshListener refreshListener = new EChartRefreshListener();
            this.getNativeComponent().addMouseListener(refreshListener);
        }
    }

    @Override
    public void setModel(FusionGraphicsModel model) {
        this.model = model;
    }

    @Override
    public boolean execute() {
        if (null == this.model) {
            return false;
        }
        List<String> script = TransferMapper.transfer2ExecuteScript(FlashChartModelUtils.conevert2FlashModel(this.model), this.showDemoData);
        if (!script.isEmpty()) {
            int w = this.model.getBean().getChartWidth() == 0 ? 691 : this.model.getBean().getChartWidth() + 10;
            int h = this.model.getBean().getChartHeight() == 0 ? 240 : this.model.getBean().getChartHeight() + 6;
            this.execute(script);
            this.chartResize(w, h);
        }
        return true;
    }

    public void execute(Option p, boolean refresh) {
        if (null == p) {
            return;
        }
        StringBuilder builder = new StringBuilder("var option =");
        builder.append(p);
        builder.append(';');
        builder.append("myChart.setOption(option,").append(refresh).append(");");
        this.execute(builder.toString());
    }

    private void execute(List<String> scripts) {
        for (String s : scripts) {
            this.execute(s);
        }
    }

    public void execute(String script) {
        LOGGER.debug((Object)("EChartDisplayPanel execute: " + script));
        if (BrowserType.WEBVIEW == this.browserType) {
            if (!this.inited.get()) {
                LOGGER.debug((Object)"echart initing not compeleted script queued.");
                this.scriptQueue.add(script);
                return;
            }
            Platform.runLater(() -> this.webBrowser.execute(script));
        } else {
            this.webBrowser.execute(script);
        }
    }

    public Object executeResult(String script) {
        LOGGER.debug((Object)("EChartDisplayPanel executeResult: " + script));
        return this.webBrowser.executeResult(script);
    }

    public boolean isChartFinished() {
        return this.finishedHandlerManager.isFinished();
    }

    private void registerOnClickFunction(IExecutePanel browser) {
        String script = null;
        if (BrowserType.DJNATIVEBROWSER == this.browserType) {
            JWebBrowser jWebBrowser = ((KDNativeBrowserPanel)browser).getBrowser();
            jWebBrowser.registerFunction((WebBrowserFunction)this.clickHandlerManager);
            script = String.format(JSUtils.REGISTER_LEFT_MOUSE_FUNCTION_SCRIPT_FUNCTION, "echartClickFunction");
        } else if (BrowserType.WEBVIEW == this.browserType) {
            LOGGER.debug((Object)"regist click function.");
            JSObject window = JSUtils.getWindow(this.webBrowser);
            window.setMember("eClick", this.clickHandlerManager);
            script = String.format(JSUtils.REGISTER_LEFT_MOUSE_FUNCTION_SCRIPT_FUNCTION, "eClick.echartClickFunction");
        }
        this.executeResult(script);
    }

    public void chartResize(int width, int height) {
        String resizeScript = String.format("var div=chartDiv; div.style.width=%d+\"px\"; div.style.height=%d+\"px\";myChart.resize();", width, height);
        this.execute(resizeScript);
    }

    public void setAutoResize() {
        this.execute("var div=chartDiv; div.style.width=100%\"; div.style.height=100%\";");
    }

    public boolean isChartInited() {
        return this.readyFunctionManager.isDocumentReady();
    }

    public BrowserType getBrowserType() {
        return this.browserType;
    }

    public String getChartID() {
        return this.chartID;
    }

    @Override
    public JComponent getDisplayPanel() {
        return this;
    }

    public void close() {
        LOGGER.debug((Object)"browser close.");
    }

    private class EChartRefreshListener
    extends MouseAdapter {
        private KDPopupMenu popMenu = new KDPopupMenu();

        public EChartRefreshListener() {
            KDMenuItem menuItem = new KDMenuItem();
            menuItem.setUI(null);
            KDWorkButton btnBefresh = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Refresh.gif"));
            btnBefresh.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    EChartDisplayPanel.this.execute();
                    e.consume();
                }
            });
            btnBefresh.setToolTipText(CtrlEXTMessages.getMLS("refresh", "\u5237\u65b0"));
            menuItem.add((Component)btnBefresh);
            this.popMenu.add((JMenuItem)menuItem);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.popMenu.isVisible()) {
                this.showMenu();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.popMenu.isVisible()) {
                this.showMenu();
            }
        }

        public void showMenu() {
            Component p = EChartDisplayPanel.this.getNativeComponent();
            int y = p.getY();
            int x = p.getX() + p.getWidth() - 30;
            this.popMenu.show(p, x, y);
            this.popMenu.setVisible(true);
        }
    }

    private class DisplayPanelReadyInitializer
    implements IChartReadyFunction {
        private DisplayPanelReadyInitializer() {
        }

        @Override
        public void onReady(IExecutePanel browser) {
            this.executeInitScripts(browser);
            this.registerChartID(browser);
            if (!EChartDisplayPanel.this.pageMode) {
                this.registerChartFinishFunction(browser);
            }
            LOGGER.debug((Object)"echart inited successful");
            EChartDisplayPanel.this.inited.set(true);
            LOGGER.debug((Object)("echart excute scriptQueue:" + EChartDisplayPanel.this.scriptQueue.size()));
            EChartDisplayPanel.this.scriptQueue.forEach(EChartDisplayPanel.this::execute);
            EChartDisplayPanel.this.scriptQueue.clear();
        }

        private void executeInitScripts(IExecutePanel browser) {
            browser.execute(String.format("var chartDiv = document.getElementById('main');myChart = echarts.init(chartDiv,null,{renderer:'%s'});", EChartDisplayPanel.this.renderType.name().toLowerCase()));
            browser.execute("window.onresize = myChart.resize;");
            browser.execute("document.oncontextmenu = function () { return false; };");
        }

        private void registerChartID(IExecutePanel browser) {
            browser.execute("chartID='" + EChartDisplayPanel.this.chartID + "';");
        }

        private void registerChartFinishFunction(IExecutePanel browser) {
            LOGGER.debug((Object)"regist finished function.");
            JSObject window = JSUtils.getWindow(EChartDisplayPanel.this.webBrowser);
            EChartDisplayPanel.this.finishedHandlerManager.setBrowser(EChartDisplayPanel.this.webBrowser);
            window.setMember("eFinish", EChartDisplayPanel.this.finishedHandlerManager);
            browser.execute(String.format("myChart.on('finished', function () { %s(); });", "eFinish.finish"));
        }
    }

    public static class EChartDisPlayPanelBuidler {
        private BrowserType bType = BrowserType.WEBVIEW;
        private boolean showp = false;
        private boolean pdebug = false;
        private IChartReadyFunction f;
        private FusionGraphicsModel m;
        private boolean showdemo = false;
        private boolean pMode = false;
        private EChartsRenderType rType = EChartsRenderType.SVG;
        private static EChartDisPlayPanelBuidler instance = new EChartDisPlayPanelBuidler();

        private EChartDisPlayPanelBuidler() {
        }

        public EChartDisPlayPanelBuidler browserType(BrowserType bType) {
            this.bType = bType;
            return this;
        }

        public EChartDisPlayPanelBuidler showPopMenu(boolean showp) {
            this.showp = showp;
            return this;
        }

        public EChartDisPlayPanelBuidler charReadyFunction(IChartReadyFunction f) {
            this.f = f;
            return this;
        }

        public EChartDisPlayPanelBuidler panelDebug(boolean pdebug) {
            this.pdebug = pdebug;
            return this;
        }

        public EChartDisPlayPanelBuidler fusionGraphicsModel(FusionGraphicsModel m) {
            this.m = m;
            return this;
        }

        public EChartDisPlayPanelBuidler showDemoData(boolean showdemo) {
            this.showdemo = showdemo;
            return this;
        }

        public EChartDisPlayPanelBuidler renderType(EChartsRenderType rType) {
            this.rType = rType;
            return this;
        }

        public EChartDisPlayPanelBuidler pageMode(boolean p) {
            this.pMode = p;
            return this;
        }

        public EChartDisplayPanel build() {
            return new EChartDisplayPanel(this.rType, this.bType, this.f, this.m, this.showp, this.showdemo, this.pdebug, this.pMode);
        }
    }
}

