/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.handler;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.ChartLinkRequestHandler;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.exec.ChartInnerLinkExec;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.ChartDataItemInfo;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.EChartsClickEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.function.IEChartsClickEventHandler;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.swing.KDMenuItem;
import javax.swing.JPopupMenu;

public class EChartHyperLinkHandler
implements IEChartsClickEventHandler {
    private SpreadContext context;

    public EChartHyperLinkHandler(SpreadContext ctx) {
        this.context = ctx;
    }

    @Override
    public void onClick(EChartsClickEvent e) {
        if (this.context == null) {
            return;
        }
        ChartDataItemInfo dataItemInfo = new ChartDataItemInfo();
        dataItemInfo.setCategoryName(e.getName());
        dataItemInfo.setSeriesName(e.getSeriesName());
        if (e.getValue() instanceof JSONArray) {
            if (this.isNotSupportedLink(e.getSeriesType())) {
                return;
            }
            JSONArray v = (JSONArray)e.getValue();
            dataItemInfo.setSeriesValue(v.get(0).toString());
        } else {
            if ("markLine".equals(e.getComponentType()) || "markArea".equals(e.getComponentType())) {
                return;
            }
            dataItemInfo.setSeriesValue(e.getValue().toString());
        }
        Sheet sheet = this.context.getBook().getActiveSheet();
        EmbedhLayer layer = sheet.getEmbedments(false);
        if (layer == null) {
            return;
        }
        EmbedObject embed = null;
        for (int i = 0; i < layer.size(); ++i) {
            EmbedObject embedObject = layer.getEmbed(i);
            if (!(embedObject instanceof EChart) || !((EChart)embedObject).getEmbedId().equals(e.getEchartID())) continue;
            embed = embedObject;
            break;
        }
        if (embed == null) {
            return;
        }
        EChart fChart = (EChart)embed;
        FlashChartModel chartModel = fChart.getModel();
        if (chartModel.getExtTargets() != null) {
            JPopupMenu popMenu = ChartLinkRequestHandler.getChartLinkPopMenu(fChart, this.context, dataItemInfo);
            if (popMenu != null) {
                int count = popMenu.getComponentCount();
                if (count == 1) {
                    ((KDMenuItem)popMenu.getComponent(0)).doClick();
                } else if (count > 1) {
                    popMenu.show(fChart.getDisplayPanel().getNativeComponent(), fChart.getWidth() / 2 - 70, fChart.getHeight() / 2 - 30 * (count / 2));
                }
            }
        } else {
            ChartInnerLinkExec innerLinkExec = (ChartInnerLinkExec)this.context.getHyperLinkHandler().getLinkExec("fsChartInner:");
            if (innerLinkExec != null) {
                innerLinkExec.setDataItemInfo(dataItemInfo);
                innerLinkExec.setChartModel(chartModel);
                innerLinkExec.execute(null);
            }
        }
    }

    private boolean isNotSupportedLink(String typeName) {
        return FlashChartType.FLASH_CT_GANTT.getName().equals(typeName) || FlashChartType.FLASH_CT_DASHBOARD.getName().equals(typeName) || FlashChartType.FLASH_CT_BUBBLE.getName().equals(typeName) || FlashChartType.FLASH_CT_SCATTER.getName().equals(typeName) || FlashChartType.FLASH_CT_AREA2D.getName().equals(typeName) || FlashChartType.FLASH_CT_MS_AREA2D.getName().equals(typeName) || FlashChartType.FLASH_CT_SCROLL_AREA2D.getName().equals(typeName) || FlashChartType.FLASH_CT_ST_AREA2D.getName().equals(typeName);
    }
}

