/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls;

import com.github.abel533.echarts.AbstractData;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.code.LineType;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl.DefaultXYSeriesBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractAxisTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.List;

public abstract class AbstractXYTransfer<B extends DefaultXYSeriesBean>
extends AbstractAxisTransfer<B> {
    protected String[] groupNames;
    protected double dminX = 0.0;
    protected double dmaxX = 0.0;
    protected double dminY = 0.0;
    protected double dmaxY = 0.0;
    private String axisXmin = "0";
    private String axisXmax;

    public AbstractXYTransfer(EChartsType type, String desc) {
        super(type, desc);
        this.setyValueAxis(true);
        this.setxValueAxis(true);
    }

    @Override
    protected void configreTrendAsLine(Option p, String labelOnRight, String isDotted, String nameStr, String colorStr, String trendLineMin, String trendLineMax) {
        List series = p.getSeries();
        ((Series)series.get(0)).markLine().label().position((Object)"start");
        ((Series)series.get(0)).markLine().symbol((Object)"none");
        if (TransferUtils.is3DChart(p)) {
            ((Series)series.get(0)).markLine().tooltip().formatter((Object)"{c}");
        } else {
            ((Series)series.get(0)).markLine().tooltip().formatter((Object)"{b}");
        }
        ((Series)series.get(0)).markLine().itemStyle().color((Object)colorStr);
        TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markLine(), "[{name:'%s', coord:[%s,%s]},{coord:[%s,%s]}]", nameStr, this.axisXmin, trendLineMin, this.axisXmax, trendLineMax);
        if ("1".equals(isDotted)) {
            for (int i = 0; i < series.size(); ++i) {
                ((Series)series.get(i)).markLine().lineStyle().type(LineType.dotted);
            }
        } else {
            ((Series)series.get(0)).markLine().lineStyle().type(LineType.solid);
        }
        if ("1".equals(labelOnRight)) {
            ((Series)series.get(0)).markLine().label().position((Object)"end");
        }
    }

    @Override
    public String initScript(B bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        if ("dataset".equals(dataNode.getDataFrom())) {
            this.groupNames = dataNode.getGroupKeys();
            if (this.dataValues == null || this.dataValues.length == 0) {
                throw new RuntimeException(CtrlEXTMessages.getMLS("dataEmpty", "\u6570\u636e\u4e3a\u7a7a"));
            }
        } else {
            Variant[][] variantArray;
            Object obj = dataNode.getData(FusionChartDataNode.XY_Group);
            Variant[][] group = obj == null ? (Variant[][])null : (Variant[][])((Object[])obj)[0];
            this.groupNames = ((DefaultXYSeriesBean)bean).parseString(group);
            obj = dataNode.getData(FusionChartDataNode.XY_Series);
            if (obj == null) {
                Variant[][] variantArray2 = new Variant[1][];
                variantArray = variantArray2;
                variantArray2[0] = new Variant[]{Variant.nullVariant};
            } else {
                variantArray = (Variant[][])((Object[])obj)[0];
            }
            Variant[][] series = variantArray;
            this.seriesNames = ((DefaultXYSeriesBean)bean).parseString(series);
            Object[] data = (Object[])dataNode.getData(FusionChartDataNode.XY_X);
            if (data == null) {
                throw new RuntimeException(CtrlEXTMessages.getMLS("dataEmpty", "\u6570\u636e\u4e3a\u7a7a"));
            }
            Variant[][] values = (Variant[][])data[0];
            this.dataValues = new Object[]{TransferUtils.convertVariantToDouble(values)};
        }
        return s;
    }

    @Override
    protected void configureValueAxisXY(Chart chart, FusionChartDataNode data, String trendLineMin, String trendLineMax, List<Axis> axis, boolean isX) {
        if (!isX) {
            String temp = null;
            if (null != trendLineMin && null != trendLineMax && Integer.parseInt(trendLineMin) > Integer.parseInt(trendLineMax)) {
                temp = trendLineMin;
                trendLineMin = trendLineMax;
                trendLineMax = temp;
            }
            if (!axis.isEmpty()) {
                Double interval;
                double n;
                double m;
                Axis ax = axis.get(0);
                Object[] values = (Object[])data.getData(FusionChartDataNode.XY_MAX_MIN);
                if (values == null || values.length == 0) {
                    return;
                }
                Variant[][] vt = (Variant[][])values[2];
                Double dataMax = this.dmaxY;
                if (vt != null && vt.length > 0 && vt[0][0].isNumber()) {
                    String value = vt[0][0].getValue().toString();
                    Double max = TransferUtils.getMax(value, trendLineMax);
                    if (null != max) {
                        ax.setMax((Object)max);
                    }
                } else if (null != trendLineMax && !isX) {
                    if (null != dataMax && Double.parseDouble(trendLineMax) > dataMax) {
                        ax.setMax((Object)trendLineMax);
                    }
                } else if (null != dataMax && !ArrayUtil.isEqual((Double)(m = TransferUtils.ceil(dataMax)), (Double)dataMax)) {
                    ax.setMax((Object)m);
                }
                vt = (Variant[][])values[3];
                Double dataMin = this.dminY;
                if (vt != null && vt.length > 0 && vt[0][0].isNumber()) {
                    String value = vt[0][0].getValue().toString();
                    Double min = TransferUtils.getMin(value, trendLineMin);
                    if (null != min) {
                        ax.setMin((Object)min);
                    }
                } else if (null != trendLineMin) {
                    if (null != dataMin && Double.parseDouble(trendLineMin) < dataMin) {
                        ax.setMin((Object)trendLineMin);
                    }
                } else if (null != dataMin && !ArrayUtil.isEqual((Double)(n = TransferUtils.ceil(dataMin)), (Double)dataMin)) {
                    ax.setMin((Object)n);
                }
                if ("0".equals(chart.showYAxisValues2)) {
                    ax.axisLabel().show(Boolean.FALSE);
                }
                if (null != (interval = TransferUtils.getInterval(chart))) {
                    ax.setInterval((Object)interval);
                }
            }
        } else if (!axis.isEmpty()) {
            Double interval;
            double n;
            Double dataMin;
            double m;
            Axis ax = axis.get(0);
            Object[] values = (Object[])data.getData(FusionChartDataNode.XY_MAX_MIN);
            if (values == null || values.length == 0) {
                return;
            }
            Variant[][] vt = (Variant[][])values[0];
            Double dataMax = this.dmaxX;
            if (vt != null && vt.length > 0 && vt[0][0].isNumber()) {
                String value = vt[0][0].getValue().toString();
                Double max = TransferUtils.getMax(value, trendLineMax);
                if (null != max) {
                    ax.setMax((Object)max);
                }
            } else if (null != trendLineMax) {
                if (null != dataMax && Double.parseDouble(trendLineMax) > dataMax) {
                    ax.setMax((Object)trendLineMax);
                }
            } else if (null != dataMax && !ArrayUtil.isEqual((Double)(m = TransferUtils.ceil(dataMax)), (Double)dataMax)) {
                ax.setMax((Object)m);
            }
            if (isX) {
                vt = (Variant[][])values[1];
                dataMin = this.dminX;
            } else {
                vt = (Variant[][])values[3];
                dataMin = this.dminY;
            }
            if (vt != null && vt.length > 0 && vt[0][0].isNumber()) {
                String value = vt[0][0].getValue().toString();
                Double min = TransferUtils.getMin(value, trendLineMin);
                if (null != min) {
                    ax.setMin((Object)min);
                }
            } else if (null != trendLineMin) {
                if (null != dataMin && Double.parseDouble(trendLineMin) < dataMin) {
                    ax.setMin((Object)trendLineMin);
                }
            } else if (null != dataMin && !ArrayUtil.isEqual((Double)(n = TransferUtils.ceil(dataMin)), (Double)dataMin)) {
                ax.setMin((Object)n);
            }
            if ("0".equals(chart.showYAxisValues2)) {
                ax.axisLabel().show(Boolean.FALSE);
            }
            if (null != (interval = TransferUtils.getInterval(chart))) {
                ax.setInterval((Object)interval);
            }
            if (ax.getMin() != null) {
                this.axisXmin = ax.getMin().toString();
            }
            if (ax.getMax() != null) {
                this.axisXmax = ax.getMax().toString();
            }
        }
        if (StringUtil.isEmptyString((String)this.axisXmax)) {
            this.axisXmax = this.dmaxX + "";
        }
    }

    @Override
    protected void configureTrendLineValue(Option p, String colorStr, String trendLineMin, String trendLineMax, String showMarkLineValue) {
        List series = p.getSeries();
        if ("1".equals(showMarkLineValue)) {
            ((Series)series.get(0)).markPoint().symbol((Object)"pin");
            ((Series)series.get(0)).markPoint().symbolSize((Object)1);
            ((Series)series.get(0)).markPoint().tooltip().formatter((Object)"{c}");
            ((Series)series.get(0)).markPoint().label().color(colorStr);
            ((Series)series.get(0)).markPoint().label().position((Object)"top");
            if (Double.parseDouble(trendLineMin) < Double.parseDouble(trendLineMax)) {
                TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markPoint(), "{value:'%s', coord:[%s,%s], symbolOffset:[%s,%s]},{value:'%s', coord:[%s,%s], symbolOffset:[%s,%s]}", trendLineMin, this.axisXmin, trendLineMin, "0", "25", trendLineMax, this.axisXmax, trendLineMax, "0", "0");
            } else {
                TransferUtils.setTrendLineValue((AbstractData)((Series)series.get(0)).markPoint(), "{value:'%s', coord:[%s,%s], symbolOffset:[%s,%s]},{value:'%s', coord:[%s,%s], symbolOffset:[%s,%s]}", trendLineMin, this.axisXmin, trendLineMin, "0", "0", trendLineMax, this.axisXmax, trendLineMax, "0", "25");
            }
        }
    }
}

