/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.area;

import com.github.abel533.echarts.DataZoom;
import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.DataZoomType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Symbol;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.Series;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.editor.ChartFillColorComboBoxEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.area.ScrollArea2DBean;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractSrollableTransfer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.util.EChartUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class ScrollMSArea2DBeanTransferImpl
extends AbstractSrollableTransfer<ScrollArea2DBean> {
    public ScrollMSArea2DBeanTransferImpl() {
        super(EChartsType.LINE, CtrlEXTMessages.getMLS("scrollMultiSeriesAreaChart2D", "\u5e26\u6eda\u52a8\u6761\u7684\u591a\u7cfb\u52172D\u9762\u79ef\u56fe"));
        this.setyValueAxis(true);
        this.setXScrollable(true);
    }

    @Override
    public String initScript(ScrollArea2DBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        EChartUtils.checkChartDataIsNull((Object[])((double[][])dataNode.getData()), dataNode.getGroupKeys(), (String[])dataNode.getSeriesKeys());
        return s;
    }

    @Override
    public Option transfer2Opiton(ScrollArea2DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        String[] labels = dataNode.getGroupKeys();
        double[][] data = (double[][])dataNode.getData();
        Object[] series = (String[])dataNode.getSeriesKeys();
        if (null != p.getLegend()) {
            p.legend().data(series);
        }
        ValueAxis valueAxis = new ValueAxis();
        valueAxis.name(bean.getChart().yScaleUnit);
        p.yAxis().add(valueAxis);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setBoundaryGap((Object)Boolean.FALSE);
        for (String label : labels) {
            caxis.data().add(label);
        }
        for (int i = 0; i < data.length; ++i) {
            Line line = new Line();
            line.areaStyle();
            line.name((String)series[i]);
            for (int j = 0; j < data[i].length; ++j) {
                line.data().add(data[i][j]);
            }
            p.series().add(line);
        }
        p.xAxis().add(caxis);
        return p;
    }

    @Override
    public Option mockOption(ScrollArea2DBean bean) {
        Option p = super.mockOption(bean);
        EChartUtils.configPlotGradientColor(bean, p);
        Var tooltipFormatter = JSUtils.getTooltipFormatterVar(true, true, true, null);
        p.tooltip().formatter((Object)tooltipFormatter);
        CategoryAxis caxis = new CategoryAxis();
        caxis.setData(Arrays.asList("Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"));
        EChartUtils.configAxisText(bean, (Axis)caxis);
        caxis.setBoundaryGap((Object)Boolean.FALSE);
        p.xAxis().add(caxis);
        DataZoom xZoom = new DataZoom();
        xZoom.start(Integer.valueOf(0));
        xZoom.type(DataZoomType.slider);
        xZoom.end(Integer.valueOf(40));
        xZoom.handleSize(Integer.valueOf(20));
        xZoom.height(Integer.valueOf(20));
        xZoom.show(Boolean.TRUE);
        xZoom.xAxisIndex((Object)new Integer[]{0});
        xZoom.bottom(Integer.valueOf(40));
        DataZoom xZoomInline = new DataZoom();
        xZoomInline.type(DataZoomType.inside);
        xZoomInline.show(Boolean.TRUE);
        xZoomInline.start(Integer.valueOf(0));
        xZoomInline.end(Integer.valueOf(60));
        xZoomInline.xAxisIndex((Object)new Integer[]{0});
        xZoomInline.bottom(Integer.valueOf(40));
        p.dataZoom(new DataZoom[]{xZoom, xZoomInline});
        p.tooltip().trigger(Trigger.axis);
        CategoryAxis yAxis = new CategoryAxis();
        yAxis.type(AxisType.value);
        EChartUtils.configAxisLucency(bean, (Axis)yAxis, true);
        p.yAxis().add(yAxis);
        p.legend().data(Arrays.asList(CtrlEXTMessages.getMLS("year2020", "2020\u5e74"), CtrlEXTMessages.getMLS("year2021", "2021\u5e74")));
        Line line1 = new Line();
        line1.name(CtrlEXTMessages.getMLS("year2020", "2020\u5e74"));
        line1.areaStyle();
        line1.setData(Arrays.asList(820, 932, 901, 934, 1290, 1330, 1320));
        Line line2 = new Line();
        line2.name(CtrlEXTMessages.getMLS("year2021", "2021\u5e74"));
        line2.areaStyle();
        line2.setData(Arrays.asList(600, 1000, 800, 600, 1400, 1000, 1320));
        EChartUtils.configShowValue(bean, (Series)line1);
        EChartUtils.configTrendline(bean, (Series)line1);
        EChartUtils.configShowValue(bean, (Series)line2);
        line1.symbol(Symbol.emptyCircle);
        line2.symbol(Symbol.emptyCircle);
        EChartUtils.configPlotBorder(bean, (Series)line1);
        EChartUtils.configPlotBorder(bean, (Series)line2);
        EChartUtils.configTrendLineOnTop(bean, (Series)line2);
        p.series().add(line1);
        p.series().add(line2);
        EChartUtils.configMaxMinValue(bean, p, 1400.0, 0.0);
        EChartUtils.configBorder(bean, p);
        return p;
    }

    @Override
    public String initMockScript(ScrollArea2DBean bean) {
        if (ChartFillColorComboBoxEditor.getGradient().equals(bean.getChart_plotGradientColor())) {
            return super.initMockScript(bean) + EChartUtils.getPlotGradientColor(this.isyValueAxis(), this.isxValueAxis(), this.getColorList());
        }
        return super.initMockScript(bean);
    }
}

